#ifndef __LLIST__
#define __LLIST__

#include "config.h"

struct tlist_node {
    void* payload;
    struct tlist_node* next;
};

struct tlist {
    struct tlist_node* head;
    int count;
};

struct tlist_iterator {
  struct tlist_node* entry;
};

typedef struct tlist tList;
typedef struct tlist_node tListNode;
typedef struct tlist_iterator tListIterator;

tList*		LLIST_Create_List	();
int		LLIST_DestroyList	(tList* thelist);

int		LLIST_AddAtHead		(tList* thelist, void* npayload);
int		LLIST_AddAtTail		(tList* thelist, void* npayload);
int		LLIST_Remove		(tList* thelist, void* npayload);

tListIterator*	LLIST_FindFirst		(tList* thelist);
tListIterator*	LLIST_FindNext		(tList* thelist, tListIterator* iterator);

void*		LLIST_ElementAt		(tList* thelist, int index);
int		LLIST_RemoveAt		(tList* thelist, int index);

int		LLIST_Size		(tList* thelist);
#endif 
