#include "config.h"
/* 
 * @doc MODULE 
 * @module natives.c | 
 * 
 * This file contains an array of native methods that get added to classes 
 * when they are initialised. It also contains the function that adds the 
 * native methods to the classes. 
 * 
 */ 
 
#include <stdlib.h> 
#include <string.h> 
#include "vm/jni.h" 
#include "vm/natives.h" 

#include "vm/global.h" 

jobject java_lang_Thread_nativeCurrentThread(JNIEnv* env, jclass thisclass);

#include "extra/classpath_missing.h"

#ifndef USE_SHARED_CP_LIBS
#include "lib/classpath/java.lang/java_lang_Object.h" 
#include "lib/classpath/java.io/java_io_ObjectInputStream.h"
#include "lib/indigenous/java.util/java_util_TimeZone.h"
#include "lib/classpath/java.lang/java_lang_Math.h"
#include "lib/classpath/java_lang_VMFloat.h"
#ifdef NETWORKING
#ifdef CLASSPATH_NETWORKING
#include "lib/classpath/java.net/java_net_PlainSocketImpl.h"
#include "lib/classpath/java.net/java_net_InetAddress.h"
#include "lib/classpath/java.net/java_net_PlainDatagramSocketImpl.h"

#endif 
#endif

#ifdef CLASSPATH_FILE_IO

//Stuff from classpath
#include "lib/classpath/java.io/javaio.h"
#include "lib/classpath/java.io/java_io_FileDescriptor.h"
#include "lib/classpath/java.io/java_io_File.h"
#include "lib/classpath/java.io/java_io_FileInputStream.h"
#include "lib/classpath/java.io/java_io_FileOutputStream.h"
#include "lib/classpath/java.io/java_io_RandomAccessFile.h"
#endif
#endif


#include "lib/indigenous/java.lang/VMObject.h" 
#include "lib/indigenous/java.lang/VMClass.h"
#include "vm/thread.h" 
#include "lib/indigenous/java.lang/Thread.h" 

#include "include/java_lang_System.h"
#include "lib/indigenous/java.lang/UnixProcess.h"
#include "lib/indigenous/java.lang/VMSystem.h"
#include "lib/indigenous/java.lang/VMClassLoader.h"
#include "lib/indigenous/java.lang/VMThrowable.h" 

//Reflection stuff

#include "lib/indigenous/java.lang.reflect/Field.h"
#include "lib/indigenous/java.lang.reflect/Array.h" 
#include "lib/indigenous/java.lang.reflect/Constructor.h" 
#include "lib/indigenous/java.lang.reflect/Method.h" 

#include "lib/indigenous/java.io/VMObjectStreamClass.h" 

#include "lib/indigenous/java.util/ResourceBundle.h"
#include "lib/indigenous/java.lang/VMSecurityManager.h"

#ifdef TEASEME
#include "lib/indigenous/jos.system/machine.h"    
#endif

#include "lib/indigenous/java.lang/java_lang_Runtime.h"

#ifdef CURSES_CONSOLE
#include "lib/curses/teaseme_console_curses_CursesConsole.h"
#endif

#include "lib/indigenous/plava/PStore.h"

#ifdef JOSPROCESS
#include "lib/indigenous/teaseme.system/System.h"    
#include "lib/indigenous/teaseme.system.servers.process/JOSProcess.h"    
#include "lib/indigenous/teaseme.system.servers.process/ProcessServer.h"    
 #endif
 
tNewNativeLookup pstNewNativeLookupTable[] = 
{
  #include "java_lang_VMObject_natives.h"
  #include "java_lang_VMSystem_natives.h"
  #include "java_lang_VMClass_natives.h"
  #include "java_lang_VMClassLoader_natives.h"
  #include "java_lang_Thread_natives.h"
  #include "java_lang_Runtime_natives.h"
  //  #include "java_lang_Double_natives.h"
  //  #include "java_lang_VMDouble_natives.h"
  #include "java_lang_VMThrowable_natives.h"

  #include "java_lang_UnixProcess_natives.h"

  #include "java_lang_VMSecurityManager_natives.h"

#ifndef USE_SHARED_CP_LIBS
  #include "java_lang_Object_natives.h"
  #include "java_lang_Math_natives.h"
  #include "java_lang_System_natives.h"
  #include "java_lang_VMFloat_natives.h"
  #include "java_util_ResourceBundle_natives.h"
  #include "java_util_TimeZone_natives.h"
  #include "java_io_FileDescriptor_natives.h"
  #include "java_io_File_natives.h"
  #include "java_io_FileInputStream_natives.h"
  #include "java_io_FileOutputStream_natives.h"
  #include "java_io_RandomAccessFile_natives.h"

  #include "java_io_ObjectInputStream_natives.h"

#ifdef KISSME_LINUX_USER
  #include "java_net_InetAddress_natives.h"
  #include "java_net_PlainDatagramSocketImpl_natives.h"
  #include "java_net_PlainSocketImpl_natives.h"
#endif
#endif

  #include "java_lang_reflect_Method_natives.h"
  #include "java_lang_reflect_Array_natives.h"
  #include "java_lang_reflect_Constructor_natives.h"
  #include "java_lang_reflect_Field_natives.h"

  #include "java_io_VMObjectStreamClass_natives.h"

  #include "plava_PStore_natives.h"

#ifdef CURSES_CONSOLE
#include "teaseme_console_curses_CursesConsole_natives.h"
#endif

  #ifdef TEASEME
  #include "jos_system_machine_natives.h"
  #include "teasme_system_servers_process_ProcessServer_natives.h"
  #endif
  /* end */ 
  {"---","end of list","---", NULL} 
};

int32 i32NumTableEntries = sizeof(pstNewNativeLookupTable) / sizeof(pstNewNativeLookupTable[0]); 

 
