/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the kissme project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "config.h"
#include "vm/jni.h"
#include "vm/newobject.h"
#include "vm/oom_exception_object.h"
#include "vm/interp_methods.h"

extern jobject OOMExceptionObject;

/* Now preallocate the OOMExceptionObject
 */

int STARTUP_createOOMExceptionObject(JNIEnv* env)
    {
#ifdef PREALLOCATE_OOM 
    jobject cstring;
    jmethodID cid;
    jclass clazz = (*env)->FindClass(env, "java/lang/OutOfMemoryError");

    assert(clazz);
    cid = (*env)->GetMethodID(env, clazz, "<init>", "(Ljava/lang/String;)");
    assert(cid);
	
    cstring = INTERP_NewStringFromAsciz(env, "The Virtual Machine ran out of memory");
    assert(cstring);
    
    OOMExceptionObject = (*env)->NewObject(env, clazz, cid, cstring);

    if(OOMExceptionObject == NULL)
      {
	eprintf("Couldn't preallocate OutOfMemoryError exception object\n");
	shutdown_machine(NULL, 0 , -1);
	return -4;
      }
#endif
    return 0;
    }
