/*
 * @doc MODULE
 * @module stdtypes.h |
 *
 * Standard type definitions for portable types.
 *
 */


#ifndef __STDTYPES_H__
#define __STDTYPES_H__



#include <limits.h>
/* We include this to simplify the definition of bool */
/*#include "irdeto.h"*/

/* signed integers */

#if SCHAR_MAX != 0x7f
#error Change the int8 definition in stdtypes.h to give 8 signed bits
#else
/*
 * @doc TYPE
 * @type int8 | very short signed integer
 *
 */
typedef signed char        int8;
#endif

#if SHRT_MAX != 0x7fff
#error Change the int16 definition in stdtypes.h to give 16 signed bits
#else
/*
 * @doc TYPE
 * @type int16 | short signed integer
 *
 */
typedef signed short int   int16;
#endif

#if LONG_MAX != 0x7fffffffL
#error Change the int32 definition in stdtypes.h to give 32 signed bits
#else
/*
 * @doc TYPE
 * @type int32 | signed integer
 *
 */
typedef signed long int    int32;
#endif

/*
 * @doc TYPE
 * @type int64 | signed integer
 *
 */
typedef signed long long int    int64;

/* unsigned integers */

#if UCHAR_MAX != 0xff
#error Change the uint8 definition in stdtypes.h to give 8 unsigned bits
#else
/*
 * @doc TYPE
 * @type uint8 | very short unsigned integer
 *
 */
typedef unsigned char      uint8;
#endif

#if USHRT_MAX != 0xffff
#error Change the uint16 definition in stdtypes.h to give 16 unsigned bits
#else
/*
 * @doc TYPE
 * @type uint16 | short unsigned integer
 *
 */
typedef unsigned short int uint16;
#endif

#if ULONG_MAX != 0xffffffffUL
#error Change the uint32 definition in stdtypes.h to give 32 unsigned bits
#else
/*
 * @doc TYPE
 * @type uint32 | unsigned integer
 *
 */
#ifndef GOOGLE_PROX
#ifndef _Included_GNU_GNOME_ZVTTERM
typedef unsigned long int  uint32;
#endif
#endif
#endif

/*
 * @doc TYPE
 * @type uint64 | unsigned integer
 *
 */
#ifndef GOOGLE_PROX
#ifndef _Included_GNU_GNOME_ZVTTERM
typedef unsigned long long int  uint64;
#endif
#endif

/* just a byte */

/*
 * @doc TYPE
 * @type byte | used for storing 8-bit quantities of data
 *
 */
typedef uint8 byte;

typedef unsigned char BOOL;
#ifndef PJSLREAL
#define USEBOOL
#endif
#ifdef USEBOOL
 #ifndef TRUE
  #define  TRUE    (BOOL) (1)
 #endif

 #ifndef FALSE
  #define  FALSE   (BOOL) /*lint -e506 */ (!TRUE ) /*lint -restore */
 #endif
#endif

#ifndef __cplusplus
#define bool BOOL
#endif

#endif

/* end of stdtypes.h */
