#ifndef __STRUCT_TCLASSFIL_H__
#define __STRUCT_TCLASSFIL_H__

/*
 * @doc TYPE
 * @struct
 * This structure contains all the information that needs to be stored
 * about classes.
 *
 */
struct tclass
{
#ifdef PERSIST
  PID persIndex;               /* @field PID of this class's string in 
				  persistent store */
#endif
#ifdef DEBUG_CLASS_FOR_GC
  int magic1;
#endif
  uint16 u16MajorVersion;      /* @field Major version of compiler used */
  uint16 u16MinorVersion;      /* @field Minor version of compiler used */
  uint16 u16ConstPoolCount;    /* @field Number of items in const pool
				  including dummy items */
  uint32* pu32ConstPool;       /* @field Pointer to constant pool data */
  byte* pbConstTags;           /* @field Pointer to array of const pool tags */

  tClassLoaderTuple* pstSuperClass;
                               /* @field Pointer to the class's superclass */

  uint16 u16AccessFlags;       /* @field The class's access flags */
  uint16 u16InterfacesCount;   /* @field Number of interfaces the class
				  implements */
  tClassLoaderTuple** ppstInterfaces;    
                               /* @field Array of pointers to the interface
				  classes that this class implements */

  uint16 u16InnerClassesCount; /* @field Number of inner classes / interfaces
				  that this class (directly) contains */
  tInnerClass *pstInnerClasses;/* @field Array of inner class descriptors */
  
  tMethod* pstMethods;         /* @field Array of class's methods */
  uint16 u16MethodsCount;      /* @field Number of methods in class */

  uint16 u16SourceFile;        /* @field Index of name of source file in 
				  constant pool */

#ifdef DEBUG_CLASS_FOR_GC
  int magic2;
#endif

  uint16 u16InstCount;         /* @field Number of instance fields */
  uint16 u16InstSize;          /* @field Number of 32-bit slots needed for 
				  instance fields */
  tField* pstInstOffsets;      /* @field Array of information structures for 
				  instance fields */
  
  uint16 u16StatCount;         /* @field Number of static fields */
  uint16 u16StatSize;          /* @field Number of 32-bit slots needed for
				  static fields */

  tField* pstStatOffsets;      /* @field Array of information structures 
				  for static fields */

  uint16 u16VTSize;            /* @field Size of virtual table */
  uint16 u16NumNatives;        /* @field The number of native methods in 
				  this class */

  tMethod** ppstVT;            /* @field Virtual table of method pointers */

#ifdef QUICK2
  uint16 u16CTSize;            /* @field Size of class table */
  tClass** ppstCT;             /* @field Class table of class pointers */
#endif

  InternalNativeMethod* pstNativeMethods; 
                               /* @field Pointer to native method table */

  byte bInitialised;           /* @field Remember if this class is
				  initialised */
  byte bHasFinalizer;          /* @field If non-zero, an instance of this
				  class requires non-trivial finalization */
  byte bIsInnerClass;          /* @field If non-zero, this class is nested */

#ifdef DEBUG_CLASS_FOR_GC
  int magic3;
#endif
};


//
// A class with member classes or interfaces has a 'tinnerclass' 
// for each member class.  In addition, a class that is a member
// of another class has a 'tinnerclass' that relates it to its
// enclosing class.  This mirrors the info in the classfile.
//
// Note: the pstInnerClass and pstOuterClass fields can only be resolved
// after the classes tClassLoaderTuple has been added to the CPlist.
// 
struct tinnerclass {
  uint16 u16InnerClassInfo;    /* @field index of the inner class 
				  in the constant pool. */
  uint16 u16OuterClassInfo;    /* @field index of the outer class 
				  in the constant pool. */
  uint16 u16AccessFlags;       /* @field the inner class access flags
				  relative to the outer class. */
  tClassLoaderTuple* pstInnerClass; 
                               /* @field the resolved inner class. */
  tClassLoaderTuple* pstOuterClass; 
                               /* @field the resolved outer class. */
};

#endif

