#include <config.h>
#include <stdio.h>

#include "vm/stdtypes.h"
#include "vm/loading_errors.h"

const char* loadingErrorMessage(uint32 errcode)
{
  switch(errcode) {
  case 0:
    return "No error";
  case LOADING_ERROR_NO_FILE:
    return "Could not find a .class file for this class";
  case LOADING_ERROR_BAD_MAGIC:
    return "The .class file for this class had an invalid magic number. Are you sure this is a valid class file?";
  case LOADING_ERROR_NO_SUPERCLASS:
    return "The superclass for this class could not be created";
  case LOADING_ERROR_BAD_FIELDS:
    return "An error ocurred while processing the field structures for this class";
  case LOADING_ERROR_BAD_METHODS:
    return "An error ocurred while processing the method structures for this class";
  case LOADING_ERROR_BAD_ATTRIBUTES:
    return "An error ocurred while processing the attributes structures for this class";
  case LOADING_ERROR_OUT_OF_MEMORY:
    return "Out of memory";
  case LOADING_ERROR_NO_CLASSPATH:
    return "No classpath specified. Try kissme --help";
  case LOADING_ERROR_BAD_CLASS_NAME:
    return "The class loaded has the wrong name";
  case LOADING_ERROR_NOT_ZIPFILE:
    return "The specified zip file is not a valid zip file";
  case LOADING_ERROR_ZIP_ERROR:
    return "An error occurred accessing the zip file";
  default:
    return "Unknown loading error code, please contact program author";
  }
}
