#ifndef __THREADINFO_H__
#define __THREADINFO_H__

tThreadNode* THREADINFO_CreateNewNodeForThread(pthread_t pthread, 
					       void* nstackBottom);
void THREADINFO_addInitialStackFrameToNode(tThreadNode* node,
					   tStackFrame* initial_frame);
void THREADINFO_removeInitialStackFrameFromNode(tThreadNode* node, 
						tStackFrame* initial_frame);
void THREADINFO_addThreadNodeToList(tThreadNode* node);

int THREADINFO_IncrementThreadCount();
int THREADINFO_DecrementThreadCount();

void THREADINFO_SetNodeInfo(tThreadNode* node, tOBREF obj, void* stackBottom);
void THREADINFO_SetNodeInfoForCurrentThread(tOBREF obj, void* stackBottom);

tStackFrame* THREADINFO_getInitialStackFrameFromNode(tThreadNode* node, 
						     int index);
int THREADINFO_countInitialStackFramesFromNode(tThreadNode* node);

#endif
