/****************************************************************************
** Form implementation generated from reading ui file 'klamdoptions.ui'
**
** Created: Sun Mar 6 14:20:47 2005
**      by: The User Interface Compiler ($Id: qt/main.cpp   3.3.3   edited Nov 24 2003 $)
**
** WARNING! All changes made in this file will be lost!
****************************************************************************/

#include "klamdoptions.h"

#include <qvariant.h>
#include <qpushbutton.h>
#include <kpushbutton.h>
#include <kdialog.h>
#include <kmessagebox.h>
#include <qgroupbox.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <kconfig.h>
#include <klocale.h>

const char *check_desc3[] = {
    "1",
    "2",
    "3",
    "4",
    "5",
    0
};

/*
 *  Constructs a KlamdOptions as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
KlamdOptions::KlamdOptions( QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "KlamdOptions" );
    setModal( TRUE );

    OK = new KPushButton( this, "OK" );
    OK->setGeometry( QRect( 80, 220, 86, 31 ) );
    OK->setDefault( TRUE );

    connect( OK, SIGNAL(clicked()),
		SLOT(updateSettings()) );

    Cancel = new KPushButton( this, "Cancel" );
    Cancel->setGeometry( QRect( 180, 220, 86, 31 ) );
    Cancel->setDefault( FALSE );

    connect( Cancel, SIGNAL(clicked()),
		SLOT(close()) );

    AdvOptions = new KDialog( this, "AdvOptions" );
    AdvOptions->setGeometry( QRect( 590, 470, 20, 20 ) );

    QWidget* privateLayoutWidget = new QWidget( this, "layout7" );
    privateLayoutWidget->setGeometry( QRect( 10, 10, 333, 200 ) );
    layout7 = new QGridLayout( privateLayoutWidget, 1, 1, 11, 6, "layout7"); 

    Archives = new QGroupBox( privateLayoutWidget, "Archives" );

    MaxSize = new QComboBox( FALSE, Archives, "MaxSize" );
    MaxSize->insertStrList(check_desc3);
    MaxSize->adjustSize();

    MaxSize->setGeometry( QRect( 170, 20, 40, 21 ) );

    ScanArchives = new QCheckBox( Archives, "ScanArchives" );
    ScanArchives->setGeometry( QRect( 20, 20, 150, 21 ) );
    connect( ScanArchives, SIGNAL(toggled(bool)),MaxSize,
		SLOT(setEnabled(bool)) );

    textLabel1 = new QLabel( Archives, "textLabel1" );
    textLabel1->setGeometry( QRect( 230, 20, 70, 21 ) );

    layout7->addWidget( Archives, 1, 0 );

    ScanFilesWhen = new QGroupBox( privateLayoutWidget, "ScanFilesWhen" );

    QWidget* privateLayoutWidget_2 = new QWidget( ScanFilesWhen, "layout6" );
    privateLayoutWidget_2->setGeometry( QRect( 20, 20, 140, 60 ) );
    layout6 = new QGridLayout( privateLayoutWidget_2, 1, 1, 11, 6, "layout6"); 

    Created = new QCheckBox( privateLayoutWidget_2, "Created" );

    layout6->addWidget( Created, 0, 0 );
    connect( Created, SIGNAL(clicked()),
		SLOT(warn()) );

    Executed = new QCheckBox( privateLayoutWidget_2, "Executed" );

    layout6->addWidget( Executed, 2, 0 );

    QWidget* privateLayoutWidget_3 = new QWidget( ScanFilesWhen, "layout7" );
    privateLayoutWidget_3->setGeometry( QRect( 181, 20, 90, 60 ) );
    layout7_2 = new QGridLayout( privateLayoutWidget_3, 1, 1, 11, 6, "layout7_2"); 

    Opened = new QCheckBox( privateLayoutWidget_3, "Opened" );

    layout7_2->addWidget( Opened, 0, 0 );

    Closed = new QCheckBox( privateLayoutWidget_3, "Closed" );

    layout7_2->addWidget( Closed, 1, 0 );

    connect( Created, SIGNAL(toggled(bool)),Opened,
		SLOT(setDisabled(bool)) );
    connect( Created, SIGNAL(toggled(bool)),Closed,
		SLOT(setDisabled(bool)) );

    layout7->addWidget( ScanFilesWhen, 0, 0 );
    languageChange();
    resize( QSize(351, 270).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );
    
    fetchSettings();
}

/*
 *  Destroys the object and frees any allocated resources
 */
KlamdOptions::~KlamdOptions()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void KlamdOptions::languageChange()
{
    setCaption( tr( "Advanced Options" ) );
    OK->setText( tr( "OK" ) );
    Cancel->setText( tr( "Cancel" ) );
    Archives->setTitle( tr( "Archives" ) );
    ScanArchives->setText( tr( "Scan Archives up to" ) );
    textLabel1->setText( tr( "MB in size" ) );
    ScanFilesWhen->setTitle( tr( "Scan Files When They Are:" ) );
    Created->setText( tr( "Created/Modified" ) );
    Executed->setText( tr( "Executed" ) );
    Opened->setText( tr( "Opened" ) );
    Closed->setText( tr( "Closed" ) );
}

void KlamdOptions::updateSettings()
{
	KConfig* config = KGlobal::config();
	config->setGroup("Klamd");

	config->writeEntry("Enabled", "No");

	if (Created->isChecked())
		config->writeEntry("Created", "Yes");
	else
		config->writeEntry("Created", "No");

	if (Executed->isChecked())
		config->writeEntry("Executed", "Yes");
	else
		config->writeEntry("Executed", "No");
	
	if (Opened->isChecked())
		config->writeEntry("Opened", "Yes");
	else
		config->writeEntry("Opened", "No");
	
	if (Closed->isChecked())
		config->writeEntry("Closed", "Yes");
	else
		config->writeEntry("Closed", "No");
	
	if (ScanArchives->isChecked()){
		config->writeEntry("ScanArchives", "Yes");
		config->writeEntry("MaxSize", MaxSize->currentText());
	}else
		config->writeEntry("ScanArchives", "No");
	
	config->sync();
	close();
}

void KlamdOptions::fetchSettings()
{
	config = KGlobal::config();
	config->setGroup("Klamd");


	if (config->readEntry("Executed") == "Yes")
		Executed->setChecked(true);
	else
		Executed->setChecked(false);

	if (config->readEntry("Opened") == "Yes")
		Opened->setChecked(true);
	else
		Opened->setChecked(false);

	if (config->readEntry("Closed") == "Yes")
		Closed->setChecked(true);
	else
		Closed->setChecked(false);

	if (config->readEntry("Created") == "Yes"){
		Created->setChecked(true);
		Opened->setEnabled(false);
		Closed->setEnabled(false);
	}else
		Created->setChecked(false);
		
	if (config->readEntry("ScanArchives") == "Yes"){
		ScanArchives->setChecked(true);
		MaxSize->setEnabled(true);
		MaxSize->setCurrentText(config->readEntry("MaxSize"));
	}else{
		ScanArchives->setChecked(false);
		MaxSize->setEnabled(false);
	
	}

	
}

void KlamdOptions::warn()
{

	if (Created->isChecked()){
		KMessageBox::information (this,i18n("<p>This option allows for faster, more usable auto-scanning. It is experimental, however, and there are some potential security risks. For more information, see http://klamav.sourceforge.net/index.php?content=ka_security_notes</p>"),"Warning","show");
	}
	

}

#include "klamdoptions.moc"
