/*
 *  Copyright (C) 2002 Tomasz Kojm <zolw@konarski.edu.pl>
 *
 *  Modified slightly by Robert Hogan <robert@roberthogan.net> as part of
 *  clamdmail package. 2003.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <errno.h>


#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <dirent.h>

//#include "others.h"
#include "cfgparser.h"
#include "memory.h"
#include "options.h"
#include "defaults.h"
//#include "shared.h"
#include <clamav.h>

int client(const char *dirname, struct optstruct *opt, char **virname)
{
	char buff[4096], cwd[200], *file, *scancmd;
	struct sockaddr_un server;
        struct sockaddr_in server2;
	struct cfgstruct *copt, *cpt;
	int sockd, bread;
	/*const char *clamav_conf = getargl(opt, "config-file");*/
	const char *clamav_conf;
	FILE *fd;
	DIR *dd;
	struct dirent *dent;
	struct stat statbuf;
	char *fname;
	int scanret = 0;

/*
    if(!clamav_conf)
	clamav_conf = DEFAULT_CFG;

    if((copt = parsecfg(clamav_conf)) == NULL) {
	mprintf("@Can't parse configuration file.\n");
	return 2;
    }

    if(cfgopt(copt, "TCPSocket") && cfgopt(copt, "LocalSocket")) {
	mprintf("@Clamd is not configured properly.\n");
	return 2;
    } else if((cpt = cfgopt(copt, "LocalSocket"))) {
*/
	server.sun_family = AF_UNIX;
	strncpy(server.sun_path, "/tmp/KlamMailSock", sizeof(server.sun_path));

	if((sockd = socket(AF_UNIX, SOCK_STREAM, 0)) < 0) {
	    //perror("socket()");
	    //mprintf("@Can't create the socket.\n");
	    return 2;
	}

	if(connect(sockd, (struct sockaddr *) &server, sizeof(struct sockaddr_un)) < 0) {
	    close(sockd);
	    //perror("connect()");
	    //mprintf("@Can't connect to clamd.\n");
	    return 2;
	}
/*
    } else if((cpt = cfgopt(copt, "TCPSocket"))) {

#ifdef PF_INET
	if((sockd = socket(PF_INET, SOCK_STREAM, 0)) < 0) {
#else
	if((sockd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
#endif
	    perror("socket()");
	    mprintf("@Can't create the socket.\n");
	    return 0;
	}

	server2.sin_family = AF_INET;
	server2.sin_addr.s_addr = inet_addr("127.0.0.1");
	server2.sin_port = htons(cpt->numarg);

	if(connect(sockd, (struct sockaddr *) &server2, sizeof(struct sockaddr_in)) < 0) {
	    close(sockd);
	    perror("connect()");
	    mprintf("@Can't connect to clamd.\n");
	    return 0;
	}

    } else {
	mprintf("@Clamd is not configured properly.\n");
	return 2;
    }
*/


	scanret = passfile(dirname, sockd, virname);


    return scanret;
}

int passfile(const char *file, int sockd, char **virname)
{

	char buff[4096];
	char *fullpath, cwd[200];
	char *scancmd;
	FILE *fd;
	
// 	fullpath = mcalloc(200 + strlen(file) + 10, sizeof(char));
// 
// 	if(!getcwd(cwd, 200)) {
// 		mprintf("@Can't get absolute pathname of current working directory.\n");
// 		return 0;
// 	}
// 	sprintf(fullpath, "%s/%s", cwd, file);

	scancmd = (char *) mcalloc(strlen(file) + 20, sizeof(char));
	sprintf(scancmd, "CONTSCAN %s", file);
	
	if(write(sockd, scancmd, strlen(scancmd)) < 0) {
	mprintf("@Can't write to the socket.\n");
	close(sockd);
	return 2;
	}
	
	if((fd = fdopen(sockd, "r")) == NULL) {
	mprintf("@Can't open descriptor %d to read.\n", sockd);
	return 2;
	}
	
	while(fgets(buff, sizeof(buff), fd)) {
	if(strstr(buff, "FOUND\n")) {
		strtok(buff, " ");
		*virname = strtok(NULL, " ");
		return 1;
	}
	}
	
	fclose(fd);

}
