/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#ifndef _ABOUTKLAMAV_H_
#define _ABOUTKLAMAV_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>



class KPrinter;
class KToggleAction;
class KURL;
class QLineEdit;
class QComboBox;
class QCheckBox;
class QListBox;
class QPushButton;
class QLabel;
class KProcess;
class KConfig;
class KURLRequester;

namespace KlamAV
{
    class TabWidget;
    class PageViewer;
}


/**
 * This class serves as the main window for Aboutklamav.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class Aboutklamav :  public QWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Aboutklamav(QWidget *parent, const char *name=0);

    /**
     * Default Destructor
     */
    virtual ~Aboutklamav();

    /**
     * Use this method to load whatever file/URL you have
     */
    void load(const KURL& url);
    void  setDirName(QString);

protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */
    /*virtual void dragEnterEvent(QDragEnterEvent *event);
    virtual void dropEvent(QDropEvent *event);*/

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    //void saveProperties(KConfig *);

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    //void readProperties(KConfig *);


private slots:
/*    void fileNew();
    void fileOpen();
    void fileSave();
    void fileSaveAs();
    void filePrint();
    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void optionsPreferences();
    void newToolbarConfig();
*/
    //void changeStatusbar(const QString& text);
    //void changeCaption(const QString& text);

private:
    void setupAccel();
    void setupActions();

private:
    //AboutklamavView *m_view;

  /*  KPrinter   *m_printer;
    KToggleAction *m_toolbarAction;
    KToggleAction *m_statusbarAction;*/
    KlamAV::PageViewer* homepage;
    KlamAV::TabWidget* tabBrowser;
signals:
    void itemSelected(QString abs_filename, int line);

public slots:

private slots:

protected slots:
            void slotOpenTabPlain(const KURL& url, bool background = false);
            void slotTabCaption(const QString &capt);

private:

    QPushButton *about_button;
    KConfig *config;
    QComboBox *check_combo;
    QLabel *notes_label;
};

#endif // _Aboutklamav_H_
