/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#ifndef _KLAMAV_H_
#define _KLAMAV_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>
#include <qtabwidget.h>

#include <stdlib.h>

class KPrinter;
class KToggleAction;
class KURL;
class QLineEdit;
class QComboBox;
class QCheckBox;
class QListBox;
class QPushButton;
class QLabel;
class KProcess;
class KConfig;
class KURLRequester;
class Freshklam;
class Sigtool;
class Klamscan;
class Klamd;
class KlamavDock;
class Kuarantine;
class Activityviewer;
class Aboutklamav;
class KlamDB;
class KSystemTray;

/**
 * This class serves as the main window for Klamav.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class Klamav : public KMainWindow
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Klamav();

    /**
     * Default Destructor
     */
    virtual ~Klamav();

    /**
     * Use this method to load whatever file/URL you have
     */
    void  setDirName(QString);

    KlamavDock *m_dock;
    KSystemTray *_tray;
    KAction *EnableKlamd;
    KAction *DisableKlamd;
    KAction *EnableFreshklam;
    KAction *DisableFreshklam;
    Klamd *klamd;
    Freshklam *freshklam;
    bool firstDownload;
    bool downloadDBForWizard;
    bool downloadClamAVForWizard;
    Kuarantine *kuarantine;
    KlamDB *klamdb;
    Klamscan *klamscan;
    Activityviewer *activityviewer;
    void showVirusBrowser();
    void resetAutoScan();
    QTabWidget *tab;


protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */
    /*virtual void dragEnterEvent(QDragEnterEvent *event);
    virtual void dropEvent(QDropEvent *event);*/
	virtual bool queryClose();


protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    //void saveProperties(KConfig *);

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    //void readProperties(KConfig *);

public slots:
	void contextDisable();
    void clamdStopped();
	void slotConfigKlamav( const QCString& page );
private slots:
	void contextEnable();
	void contextEnableFK();
        void contextUpdateFK();
	void contextDisableFK();

private:
    void setupAccel();
    void setupActions();
    void firstRunWizard();
    void createDefaultKlamAVDir(QString type);
    void checkDir(QString path);

private:
    //KlamavView *m_view;



signals:
    void itemSelected(QString abs_filename, int line);

public slots:
private slots:
    void shuttingDown();
private:
    void processOutput();
    void finish();
    void getout();

    QLineEdit *template_edit;
    QComboBox *files_combo, *pattern_combo/*, *dir_combo*/;
    KURLRequester *dir_combo;
    QCheckBox *recursive_box;
    QListBox *resultbox;
    QPushButton *search_button, *cancel_button;
    QLabel *status_label, *matches_label;
    KProcess *childproc;
    QString buf;
    KConfig* config;
    QStringList lastSearchItems;
    QStringList lastSearchPaths;
    Sigtool *sigtool;
    Aboutklamav *aboutklamav;
    
};

extern Klamav *kmain;

#endif // _KLAMAV_H_
