/*
 * Fluidness exercise
 */
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "support.h"
#include "main.h"
#include "translation.h"
#include "tutor.h"
#include "velocity.h"
#include "fluidness.h"

/*
 * Variables
 */
extern GtkWidget *window_tutor_;

typedef struct
{
  gchar *buffer;
  gint len;
  gchar name[21];
} Paragraph;

Paragraph par = { NULL, 0, "" };

/*******************************************************************************
 * Interface functions
 */
gchar *
fluid_get_paragraph_name ()
{
  return par.name;
}

void
fluid_reset_paragraph ()
{
  g_free (par.buffer);
  par.buffer = NULL;
  par.len = 0;
  par.name[0] = '\0';
}

/*
 * Get from the structure 'par' the paragraph defined by 'index'
 *
 */
gchar *
get_par (gint index)
{
  gint i;
  gint size;
  gchar *par_1;
  gchar *par_2;
  gchar *par_i;

  par_1 = par.buffer;
  par_2 = strchr (par.buffer, '\n') + 1;
  for (i = 0; i < index && i < par.len; i++)
    {
      par_1 = par_2;
      par_2 = strchr (par_2, '\n') + 1;
    }
  size = par_2 - par_1;
  if (size < 1)
    {
      g_warning ("internal error while picking the paragraph %i.", index);
      return (NULL);
    }
  par_i = g_malloc (size + 1);
  memmove (par_i, par_1, size);
  par_i[size] = '\0';

  return (par_i);
}

/**********************************************************************
 * Initialize the fluid exercise window.
 */
void
fluid_init ()
{
  gchar *tmp_name;
  gchar *tmp_str;
  FILE *fh;

  if (par.len == 0)
    {
      if (g_key_file_has_key (main_preferences_get (), "tutor", "paragraph_list", NULL))
	{
          tmp_str = g_key_file_get_string (main_preferences_get (), "tutor", "paragraph_list", NULL);
	  tmp_name =
	    g_strconcat (main_get_user_dir (), tmp_str, ".paragraphs", NULL);
	  if ((fh = (FILE*) g_fopen (tmp_name, "r")))
	    {
	      fluid_init_paragraph_list (tmp_str);
	      fclose (fh);
	    }
	  g_free (tmp_str);
          g_free (tmp_name);
	}
    }
  if (par.len == 0)
    fluid_init_paragraph_list (NULL);
}

/**********************************************************************
 * Reads paragraphs from the text file.
 */
void
fluid_init_paragraph_list (gchar * list_name)
{
  gint len;
  gchar *tmp_name;
  gchar tmp_code[16];
  gchar str_1000[1001];
  FILE *fh;

  if (list_name && strcmp (list_name, _("--> Default")) != 0)
    {
      g_key_file_set_string (main_preferences_get (), "tutor", "paragraph_list", list_name);
      tmp_name = g_strconcat (main_get_user_dir (),
			      list_name, ".paragraphs", NULL);
      g_message ("loading text file: %s.paragraphs", list_name);
      strncpy (par.name, list_name, 20);
      par.name[20] = '\0';
    }
  else
    {
      g_key_file_remove_key (main_preferences_get (), "tutor", "paragraph_list", NULL);

      trans_get_lang_env (tmp_code);
      tmp_name =
	g_strconcat (main_get_data_path (), tmp_code, ".paragraphs", NULL);
      g_message ("loading text file: %s.paragraphs", tmp_code);
      strcpy (par.name, "Default");
    }

  if ((fh = (FILE*) g_fopen (tmp_name, "r")))
    {
      g_free (par.buffer);
      par.buffer = g_strconcat ("", NULL);
      par.len = 0;
      while (fgets (str_1000, 1001, fh))
	{
	  len = strlen (str_1000);
	  if (len < 3)
	    continue;
	  if (!g_ascii_ispunct (str_1000[len - 2]))
	    str_1000[len - 2] = '.';
	  if (str_1000[len - 1] != '\n')
	    str_1000[len - 1] = '\n';
	  par.buffer = g_strconcat (par.buffer, str_1000, NULL);
	  par.len++;
	}
      fclose (fh);
      g_message ("text file loaded!\n");
    }
  else
    {
      g_message ("could not open the file: <%s>", tmp_name);
      g_free (tmp_name);
      trans_get_lang_env (tmp_code);
      if (strcmp (tmp_code, "C") == 0)
	g_error ("so, we must quit!");
      trans_set_language_env ("C");
      fluid_init_paragraph_list (list_name);
      trans_set_language_env (tmp_code);
      return;
    }
  g_free (tmp_name);
}

/**********************************************************************
 * Draw random sentences selected from a '.paragraphs' file
 */
void
fluid_draw_random_paragraphs ()
{
  gint i, j;
  gint rand_i[3];
  gchar *text;

  for (i = 0; (i < 3) && (i < par.len); i++)
    {
      do
	{
	  rand_i[i] = rand () % par.len;
	  for (j = 0; j < i; j++)
	    {
	      if (rand_i[i] == rand_i[j])
		rand_i[i] = par.len;
	    }
	}
      while (rand_i[i] == par.len);

      text = get_par (rand_i[i]);
      tutor_draw_paragraph (text);
      g_free (text);
    }
}

/**********************************************************************
 * Copy the file 'file_name' so that it can be used as a customized
 * exercise.
 */
void
fluid_copy_text_file (gchar * file_name)
{
  gint tmp_chr;
  gint np;
  gchar *pars_path;
  gchar *pars_name;
  FILE *fh_source;
  FILE *fh_destiny;

  if (!file_name)
    {
      gdk_beep ();
      g_warning ("fluid_copy_text_file(): null file name as argument.");
      return;
    }

  if (!(fh_source = (FILE*) g_fopen (file_name, "r")))
    {
      gdk_beep ();
      g_warning ("couldn't open the file:\n %s\n", file_name);
      return;
    }

  pars_name = g_strdup (strrchr (file_name, DIRSEP) + 1);
  pars_path =
    g_strconcat (main_get_user_dir (), pars_name, ".paragraphs", NULL);

  assert_user_dir ();
  if (!(fh_destiny = (FILE*) g_fopen (pars_path, "w")))
    {
      gdk_beep ();
      g_warning ("couldn't create the file:\n %s\n", pars_path);
      fclose (fh_source);
      g_free (pars_path);
      g_free (pars_name);
      return;
    }
  g_free (pars_path);

  np = 0;
  while ((tmp_chr = fgetc (fh_source)) != EOF)
  {
    if (tmp_chr == '\n')
      np++;
    fputc (tmp_chr, fh_destiny);
  }
  for (;np < 3; np++)
    fprintf (fh_destiny, "%i.\n\n", rand () % 1000);

  fclose (fh_source);
  fclose (fh_destiny);

  fluid_init_paragraph_list (pars_name);
  tutor_set_query (QUERY_INTRO);
  tutor_process_touch ('\0');

  velo_create_dict (file_name, FALSE);
  g_free (pars_name);
}

/**********************************************************************
 * Put on the screen the final comments
 */
void
fluid_comment (gdouble accuracy, gdouble velocity, gdouble fluidness)
{
  gchar str[1000];
  GtkWidget *wg;
  GtkTextBuffer *buf;

  /*
   * Comments
   */
  if (accuracy < 98)
    sprintf (str,
	     _(" Your accuracy rate is too low.\n"
	       " I want it greater than 98 %%.\n"));
  else if (velocity < 50)
    sprintf (str, _(" You type accurately but not fast.\n"
		    " Can you reach 50 WPM?\n"));
  else if (fluidness < 70)
    sprintf (str,
	     _(" Your rhythm is not so constant. Calm down.\n"
	       " For now, try to make the fluidness greater than 70 %%.\n"));
  else if (fluidness < 90)
    sprintf (str,
	     _(" You are almost getting there. Type more fluently.\n"
	       " I want a fluidness greater than 90 %%.\n"));
  else if (velocity < 80)
    sprintf (str,
	     _(" Congratulations!\n"
	       " It seems to me that you are a professional.\n"
	       " You don't need this program (me) anymore.\n"
	       " Hope you have enjoyed. Thanks and be happy!\n"));
  else
    sprintf (str,
	     _(" How can you type so fast?\n"
	       " You have exceeded all my expectations.\n"
	       " Are you a machine? Could you teach me?\n"
	       " I can not help you anymore. Go to an expert!\n"));

  wg = lookup_widget (window_tutor_, "text_tutor");
  buf = gtk_text_view_get_buffer (GTK_TEXT_VIEW (wg));
  gtk_text_buffer_insert_at_cursor (buf, str, strlen (str));
}
