/*
 * Typing tutor and exercise program. It is very flexible and
 * customizable regarding to keyboard, language and lessons.
 * And it also has a simple learning progress logging.
 */
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

#include "support.h"
#include "interface.h"
#include "translation.h"
#include "keyboard.h"
#include "tutor.h"
#include "main.h"

/*
 * Variables
 */
GtkWidget *window_main_;

GKeyFile *preferences = NULL;

struct
{
  gchar *user_dir;
  gchar *data_path;
}general;


/*******************************************************************************
 * Interface functions
 */
gchar *
main_get_data_path ()
{
  return (general.data_path);
}

void
main_set_data_path (gchar * path)
{
  g_free (general.data_path);
  general.data_path = g_strdup (path);
}

gchar *
main_get_user_dir ()
{
  return (general.user_dir);
}

GKeyFile *
main_preferences_get ()
{
	return (preferences);
}

/*******************************************************************************
 * Program
 */
int
main (int argc, char *argv[])
{
#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  g_message ("initial locale: %s", gtk_set_locale ());
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR DIRSEP_S PACKAGE DIRSEP_S "pixmaps");
  add_pixmap_directory (".." DIRSEP_S "pixmaps");

  main_initialize_global_variables ();
  window_main_ = create_window_main ();
  main_window_init ();

  gtk_widget_show (window_main_);

  gtk_main ();

  return 0;
}

/*******************************************************************************
 * Temp function to keep compatibility
 */
void
main_retrieve_old_prefs ()
{
  gchar *tmp_name;
  gchar tmp_string[64];
  FILE *fh;
  gint tmp_value;

  /*
   * basic_lesson
   */
  tmp_name = g_strconcat (general.user_dir, "last_basic_lesson", NULL);
  if ((fh = (FILE*) g_fopen (tmp_name, "r")) != NULL)
  {
	  if (fscanf (fh, "%i", &tmp_value) == 1)
	    g_key_file_set_integer (preferences, "tutor", "basic_lesson", tmp_value);
	  fclose (fh);
	  g_unlink (tmp_name);
  }
  g_free (tmp_name);

  /*
   * keyboard
   */
  tmp_name = g_strconcat (general.user_dir, "last_keyboard", NULL);
  if ((fh = (FILE*) g_fopen (tmp_name, "r")) != NULL)
  {
	  if (fscanf (fh, "%s", tmp_string) == 1)
	    g_key_file_set_string (preferences, "tutor", "keyboard", tmp_string);
	  fclose (fh);
	  g_unlink (tmp_name);
  }
  g_free (tmp_name);

  /*
   * word_list
   */
  tmp_name = g_strconcat (general.user_dir, "last_word_list", NULL);
  if ((fh = (FILE*) g_fopen (tmp_name, "r")) != NULL)
  {
	  if (fscanf (fh, "%s", tmp_string) == 1)
	    g_key_file_set_string (preferences, "tutor", "word_list", tmp_string);
	  fclose (fh);
	  g_unlink (tmp_name);
  }
  g_free (tmp_name);

  /*
   * paragraph_list
   */
  tmp_name = g_strconcat (general.user_dir, "last_paragraph_list", NULL);
  if ((fh = (FILE*) g_fopen (tmp_name, "r")) != NULL)
  {
	  if (fscanf (fh, "%s", tmp_string) == 1)
	    g_key_file_set_string (preferences, "tutor", "paragraph_list", tmp_string);
	  fclose (fh);
	  g_unlink (tmp_name);
  }
  g_free (tmp_name);

}

/**********************************************************************
 * Initialize the value of the global variables
 */
void
main_initialize_global_variables ()
{
  gchar *tmp_name;
  FILE *fh;

  /*
   * Set the home user dir 
   */
  general.user_dir =
    g_strconcat (g_get_home_dir (), DIRSEP_S ".klavaro" DIRSEP_S, NULL);

  /*
   * Get a valid data path.
   * First searches the path at the source directory.
   */
  general.data_path = g_strconcat (".." DIRSEP_S "data" DIRSEP_S, NULL);
  tmp_name = g_strconcat (general.data_path, "basic_lessons.txt", NULL);
  fh = (FILE*) g_fopen (tmp_name, "r");
  if (fh == NULL)
    {
      g_free (general.data_path);
      g_free (tmp_name);
      general.data_path = g_strdup (PACKAGE_DATA_DIR DIRSEP_S PACKAGE DIRSEP_S);
      tmp_name = g_strconcat (general.data_path, "basic_lessons.txt", NULL);
      fh = (FILE*) g_fopen (tmp_name, "r");
    }
  if (fh == NULL)
    g_error ("couldn't find the file at data path:\n %s", tmp_name);
  fclose (fh);
  g_free (tmp_name);

  /*
   * Retrieve initial or saved preferences
   */
  preferences = g_key_file_new ();
  tmp_name = g_strconcat (general.user_dir, "preferences.desktop", NULL);
  if ((fh = (FILE*) g_fopen (tmp_name, "r")) == NULL)
  	g_key_file_load_from_file (preferences, "/etc/klavaro_preferences.desktop", G_KEY_FILE_NONE, NULL); 
  else
  {
  	g_key_file_load_from_file (preferences, tmp_name, G_KEY_FILE_NONE, NULL); 
	fclose (fh);
  }
  g_free (tmp_name);

  main_retrieve_old_prefs ();

  /*
   * Apply the language environmental value
   */
  trans_init_language_env ();

  /*
   * Other initializations
   */
  srand (time (0));

  tutor_init_timers ();
}

/*******************************************************************************
 * Initialize keyboard entry and language combo 
 */
void
main_window_init ()
{
  gchar *tmp_str;
  GtkWidget *wg;

  /*
   * Set the initial keyboard to use
   */
  wg = lookup_widget (window_main_, "entry_keyboard");
  if (!g_key_file_has_key (preferences, "tutor", "keyboard", NULL))
  {
    gtk_entry_set_text (GTK_ENTRY (wg), DEFAULT_KEYBOARD);
    g_key_file_set_string (preferences, "tutor", "keyboard", DEFAULT_KEYBOARD);
  }
  else
    {
      tmp_str = g_key_file_get_string (preferences, "tutor", "keyboard", NULL);
      gtk_entry_set_text (GTK_ENTRY (wg), tmp_str);
      g_free (tmp_str);
    }

  keyb_init_name (gtk_entry_get_text (GTK_ENTRY (wg)));
  keyb_get_layout ();

  /*
   * Set the language
   */
  trans_set_combo_language ();
}

/*******************************************************************************
 * Quit the application
 */
void
main_window_pass_away ()
{
  gchar *tmp_name;
  FILE *fh;

  /*
   * Save preferences
   */
  assert_user_dir ();
  tmp_name = g_strconcat (general.user_dir , "preferences.desktop", NULL);
  fh = (FILE*) g_fopen (tmp_name, "w");
  if (fh == NULL)
    g_warning ("couldn't save your preferences on the user folder:\n %s", tmp_name);
  else
  {
    g_free (tmp_name);
    tmp_name = NULL;
    tmp_name = g_key_file_to_data (preferences, NULL, NULL);
    if (tmp_name != NULL)
      fputs (tmp_name, fh);
    fclose (fh);
  }
  g_free (tmp_name);

  /*
   * Good bye
   */
  g_message ("adiaux!");
  gtk_exit (0);
}

