/*
 * This file contains the set of languages configured for
 * internationalization.
 * The letters in parenthesis must agree with LL_CC,
 * where LL is the language code
 * and CC is the country code.
 * The only one exception is for the US English,
 * which uses the 'C' code.
 *
 * If you add any language, do not forget to update
 * the definition of N_LANGS above.
 * It MUST agree with the number of language entries!
 */

#define N_LANGS 10

#define LANG_SET \
"Čeština (cs_CZ)\n" \
"English (C)\n" \
"Español (es_ES)\n" \
"Esperanto (eo_EO)\n" \
"Deutsch (de_DE)\n" \
"Français (fr_FR)\n" \
"Magyar (hu_HU)\n" \
"Polski (pl_PL)\n" \
"Português - Brasil (pt_BR)\n" \
"Svenska (sv_SE)";


void trans_get_lang_env (gchar *);

void trans_set_language_env (gchar * code);

void trans_set_lang_name_code (void);

gboolean trans_estas_Esperanto (void);

void trans_init_language_env (void);

void trans_set_combo_language (void);

void trans_change_language (void);

void trans_read_text (gchar *, gint, const gchar *);
