/**************************************************************************/
/*  Klavaro - a flexible touch typing tutor                               */
/*  Copyright (C) 2005 - 2007  Felipe Castro                              */
/*                                                                        */
/*  This program is free software, licensed under the terms of the GNU    */
/*  General Public License as published by the Free Software Foundation,  */
/*  which is also included in this package, in a file named "COPYING".    */
/**************************************************************************/

#define DEFAULT_KEYBOARD "dvorak_br"

#define MAX_KEYBOARDS 200
#define KEY_LINE_LEN (14+1)	/* 14 keys + 1 NULL char */

#define UPSYM ((gunichar) 182)

/*
 * Interface
 */
gchar *keyb_get_name (void);

void keyb_set_name (const gchar * name);

void keyb_init_name (const gchar * name);

gunichar keyb_get_lochars (gint i, gint j);

gunichar keyb_get_upchars (gint i, gint j);

gboolean keyb_get_modified_status (void);

void keyb_set_modified_status (gboolean new_status);

/*
 * Auxiliar
 */
void keyb_get_layout (void);

gboolean keyb_is_vowel (gunichar chr);

gint keyb_get_vowels (gunichar * vows);

gint keyb_get_consonants (gunichar * consonants);

gint keyb_get_symbols (gunichar * symbols);

void keyb_save_new_layout (void);

void keyb_remove_user_layout (void);

void keyb_update_virtual_layout (void);

void keyb_fill_layout_list (gint entry_type);

void keyb_edit_key (GtkButton * button);

void keyb_change_key (gunichar real_key);

gchar *keyb_get_utf8_paragraph_symbol (void);

gboolean keyb_force_edit_tab (gpointer data);

/*
 * Hints
 */
void hints_init (void);

gchar *hints_string_from_charcode (gchar charcode);

void hints_set_tips (void);

void hints_get_from_char (gchar * file_name, gunichar character);

void hints_get_from_label (gchar * file_name, gchar * label);

void hints_update_from_char (gunichar character);
