/*
 *  Klavier : Virtual keyboard for K Destop Environement
 *
 *  This program (klavier) is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 *  This program (klavier) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 * License along with this program (klavier); if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA. 
 *
 * Author : Sebastien HUSS <sebastien.huss@laposte.net>
 *
 */

#include <qcheckbox.h>

// for i18n
#include <klocale.h>
//
#include <kconfig.h>
// for kapp
#include <kapplication.h>


#include "klavier.h"
#include "sendkey.h"
#include "klavierwidget.h"
#include "keyboardwidget.h"
#include "trayicon.h"
// config stuff
#include "configdialog.h"

#include <netwm.h>


klavier::klavier()
    : KMainWindow( 0, "klavier" )
{
	// set the shell's ui resource file
	setXMLFile("klavierui.rc");

	this->wire	= new sendKey(qt_xdisplay());
	this->kw	= new KlavierWidget(this->wire, this, "MainWidget");
	this->setCentralWidget(this->kw);

	XWMHints	*wm_hints;

	// set the border the kde way
	unsigned long props = NET::WMWindowType;
	NETWinInfo winfo(qt_xdisplay(), winId(), qt_xrootwin(), props);
	winfo.setWindowType(NET::Utility);
	//winfo.setWindowType(NET::Toolbar);

	//this seems to don't work and I haven't find the real kde way
	//this->setFocusPolicy(NoFocus);
	// nofocus the X way
	wm_hints = XAllocWMHints();
	wm_hints->input = False;
	wm_hints->flags = InputHint;
	XSetWMHints (qt_xdisplay(), winId(), wm_hints);

	hide();show();
	
	// Tray Icon Stuff
	tray	= new TrayIcon(this, "klavier");
	
	// configuration Dlg stuff
	this->configDlg	= new ConfigDialog(this);
	connect( this->configDlg, SIGNAL(applied(ConfigDialog *)), this, SLOT(applyPrefs(ConfigDialog *)) );
	connect( kapp, SIGNAL( aboutToQuit()), SLOT( saveConfig()) );
	this->loadConfig();
}

klavier::~klavier()
{
	delete	this->wire;
}

void	klavier::applyPrefs(ConfigDialog* cfgDlg)
{
	this->cfgUseMajLimit	= cfgDlg->useMajLimit->isChecked();
	this->kw->getKeyboard()->setUseMajLimit(this->cfgUseMajLimit);
}

void	klavier::loadConfig()
{
	KConfig *config = kapp->config();
	config->setGroup(0);

	this->configDlg->useMajLimit->setChecked(config->readBoolEntry("UseMajHack", false));
	this->applyPrefs(this->configDlg);
}

void	klavier::saveConfig()
{
	KConfig *config = kapp->config();
	config->setGroup(0);

	config->writeEntry("UseMajHack", this->cfgUseMajLimit);
}

void	klavier::showConfig()
{
	this->configDlg->show();
}

bool	klavier::queryClose()
{
	if (!kapp->sessionSaving() )
	{
		this->hide();
		return false;
	}

	return true;
}

void	klavier::quit()
{
	kapp->quit();
}

void	klavier::toggleVisibility()
{
	if (this->isVisible())
		this->hide();
	else
		this->show();
}

#include "klavier.moc"
