/*
 *  Klavier : Virtual keyboard for K Destop Environement
 *
 *  This program (klavier) is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 *  This program (klavier) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 * License along with this program (klavier); if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA. 
 *
 * Author : Sebastien HUSS <sebastien.huss@laposte.net>
 *
 */
#include "klavierwidget.h"
#include "keyboardwidget.h"
#include "hwlhandler.h"
#include <qwidgetstack.h>
#include <kglobal.h>
#include <kiconloader.h>

KlavierWidget::KlavierWidget(sendKey * wire, QWidget *parent, const char *name)
	: QWidget(parent, name)
{
	this->topLayout		= new QHBoxLayout(this, 3);
//	this->leftLayout	= new QVBoxLayout(this->topLayout, 5);
//	this->rightLayout	= new QVBoxLayout(this->topLayout, 3);
	this->keyboard		= new KeyboardWidget(wire, this, "keyboard");
//	this->hwletter		= new HwlHandler(wire, this, "HandwrittingLetter");
	this->stack		= new QWidgetStack(this, "stack");
//	this->kbButton		= new QPushButton(this, "Keyboard");
//	this->hwlButton		= new QPushButton(this, "HwLetter");

//	this->topLayout->insertWidget(0, (QWidget*)this->leftLayout, 0);
// 	this->topLayout->insertWidget(1, (QWidget*)this->stack, 10);
	this->topLayout->insertWidget(0, (QWidget*)this->stack, 10);
//	this->topLayout->insertWidget(2, (QWidget*)this->rightLayout, 0);

//	this->leftLayout->addStretch(10);
//	this->leftLayout->addWidget(this->kbButton);
//	this->leftLayout->addWidget(this->hwlButton);
// 	this->leftLayout->addStretch(10);

	this->stack->addWidget((QWidget*)this->keyboard);
// 	this->stack->addWidget((QWidget*)this->hwletter);
	this->stack->setLineWidth(1);
	this->stack->setMidLineWidth(0);
	this->stack->setFrameShape(QFrame::GroupBoxPanel);
	this->stack->setFrameShadow(QFrame::Sunken);
// 	this->stack->raiseWidget(this->hwletter);

// 	this->kbButton->setText("K");
// 	this->kbButton->setFixedSize(16, 16);
// 	this->hwlButton->setText("L");
// 	this->hwlButton->setFixedSize(16, 16);
/*
	this->kbButton->setPixmap( KGlobal::iconLoader()->loadIcon("win" , KIcon::NoGroup, KIcon::SizeSmall ) );

	but = new QPushButton((QWidget*)this, "toto");
	this->rightLayout->addWidget(but);
	but = new QPushButton((QWidget*)this, "toto");
	this->rightLayout->addWidget(but);
	this->rightLayout->addStretch(10);
*/
// 	connect( this->kbButton, SIGNAL( clicked() ), this, SLOT( kbButtonClicked() ) );
// 	connect( this->hwlButton, SIGNAL( clicked() ), this, SLOT( hwlButtonClicked() ) );

}


KlavierWidget::~KlavierWidget()
{
}

void	KlavierWidget::kbButtonClicked()
{
	this->stack->raiseWidget(this->keyboard);
}

void	KlavierWidget::hwlButtonClicked()
{
	this->stack->raiseWidget(this->hwletter);
}

#include "klavierwidget.moc"
