/*
 *  Klavier : Virtual keyboard for K Destop Environement
 *
 *  This program (klavier) is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 *  This program (klavier) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 * License along with this program (klavier); if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA. 
 *
 * Author : Sebastien HUSS <sebastien.huss@laposte.net>
 *
 */
#include "klavier.h"
#include "trayicon.h"

#include <qpixmap.h>
#include <kaction.h>
#include <kpopupmenu.h>
#include <kapplication.h>
#include <klocale.h>

TrayIcon::TrayIcon(klavier *parent, const char *name)
	: KSystemTray((QWidget*)parent, name)
{
	this->mainWindow = parent;
	this->setPixmap(loadIcon("icon22-klavier"));
	this->show();
	
	// actions related stuff
	KPopupMenu *popupMenu = contextMenu();

	(void)new KAction( I18N_NOOP("Configuration"), 0,this->mainWindow, SLOT(showConfig()), actionCollection(),  "showConfig");
	KAction *a = actionCollection()->action( "showConfig" );
	if ( a ) a->plug( popupMenu );
	
	connect(this, SIGNAL(quitSelected()), kapp, SLOT(quit()));
}


TrayIcon::~TrayIcon()
{
}

void TrayIcon::mousePressEvent(QMouseEvent *me)
{
	if (me->button() == LeftButton)
	{
		this->mainWindow->toggleVisibility();
	}
	else
		KSystemTray::mousePressEvent(me);
}
void TrayIcon::mouseReleaseEvent(QMouseEvent *me)
{
	KSystemTray::mouseReleaseEvent(me);	
}


#include "trayicon.moc"
