/*
 * This file is a part of KleanSweep.
 *
 * Copyright (C) 2005 Pawel Stolowski <pawel.stolowski@wp.pl>
 *
 * KleanSweep is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "summarylabel.h"
#include <qlabel.h>
#include <qframe.h>
#include <klocale.h>

SummaryLabel::SummaryLabel(QWidget *parent): QHBox(parent), selsize(-1), selitems(-1), totsize(-1), totitems(-1)
{
	setSpacing(5);
	setMargin(5);
	setFrameStyle(QFrame::Panel | QFrame::Sunken);

	new QLabel(i18n("Found") + ":", this);
	l_totitems = new QLabel(this);
	l_totitems->setAlignment(Qt::AlignRight);
	l_totsize = new QLabel(this);
	l_totsize->setAlignment(Qt::AlignRight);
	new QLabel(i18n("Selected") + ":", this);
	l_selitems = new QLabel(this);
	l_selitems->setAlignment(Qt::AlignRight);
	l_selsize = new QLabel(this);
	l_selsize->setAlignment(Qt::AlignRight);

	reset();
}

SummaryLabel::~SummaryLabel()
{
}

void SummaryLabel::reset()
{
	setSelectedItems(0);
	setSelectedSize(0);
	setTotalSize(0);
	setTotalItems(0);
}

QString SummaryLabel::formatSize(int n)
{
	static const float mb = 1.0f/(1024.0f*1024.0f);
	static const float kb = 1.0f/1024.0f;
	float x = n;
	char *p;
	if (n >= 1024*1024)
	{
		x *= mb;
		p = "(%1 M)";
	}
	else if (n >= 1024)
	{
		x *= kb;
		p = "(%1 K)";
	}
	else
	{
		return QString("(%1 b)").arg(n);
	}
	return QString(p).arg(x, 0, 'f', 2);
}

void SummaryLabel::setTotalItems(int n)
{
	if (totitems != n)
	{
		totitems = n;
		l_totitems->setText(QString::number(n));
	}
}

void SummaryLabel::setSelectedItems(int n)
{
	if (selitems != n)
	{
		selitems = n;
		l_selitems->setText(QString::number(selitems));
	}
}

void SummaryLabel::setSelectedSize(int size)
{
	if (selsize != size)
	{
		selsize = size;
		l_selsize->setText(formatSize(selsize));
	}
}

void SummaryLabel::updateSelectedInfo(int d, unsigned int size)
{
	selitems += d;
	if (size != 0)
	{
		if (d<0)
			selsize -= size;
		else
			selsize += size;
		l_selsize->setText(formatSize(selsize));
	}
	l_selitems->setText(QString::number(selitems));
}

void SummaryLabel::setTotalSize(int size)
{
	if (totsize != size)
	{
		totsize = size;
		l_totsize->setText(formatSize(totsize));
	}
}

void SummaryLabel::setTotals(int n, unsigned int size)
{
	setTotalItems(n);
	setTotalSize(size);
}

#include "summarylabel.moc"
