/*
 * This file is a part of KleanSweep.
 *
 * Copyright (C) 2005 Pawel Stolowski <pawel.stolowski@wp.pl>
 *
 * KleanSweep is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __SWEEPSCANNER_H
#define __SWEEPSCANNER_H

#include <qobject.h>
#include <qmap.h>
#include <qptrlist.h>

class KProcess;
class SweepFileInfo;
class QTextStream;

class SweepScanner: public QObject
{
        Q_OBJECT
                        
        public:
                enum FileType
                {
                        EMPTY_FILE = 0,
                        EMPTY_DIR,
                        BACKUP_FILE,
			BROKEN_SYMLINK,
                        DUPLICATED_FILE,
			ORPHAN_FILE,
			UNUSED_LOCALE,
                        DEAD_MENUENTRY,
			DEAD_THUMBNAIL,
			BROKEN_EXEC,
			OLD_FILE,
			NONE /* for internal purposes */
                };
                        
        protected:
                char *line;
                int lineptr;
		int totalitems;
		unsigned int totalsize;
		bool ftypes[NONE];
		QMap<long, SweepFileInfo *> filemap;
		QPtrList<SweepFileInfo> files;
		QString last_path;
		bool writable;
		KProcess *proc;
                
                void extractFileInfo();
                
        signals:
                void newFileEntry(SweepScanner::FileType, SweepFileInfo *);
		void newFileEntry(SweepScanner::FileType, SweepFileInfo *, SweepFileInfo *);
		void updateTotals(int, unsigned int);
		void currentPath(const QString &);
		void finished(bool);
                
        protected slots:
                void onProcessData(KProcess *proc, char *buf, int len);
		void helperExited(KProcess *proc);
                                
        public:
                SweepScanner();
                virtual ~SweepScanner();
		void enableFileType(FileType fe, bool enable);
		void setOnlyWritable(bool f);
		bool getOnlyWritable() const;
		bool isEnabled(FileType f);
		bool isRunning();
		bool stop();
		QString lastScanPath() const;
		QPtrList<SweepFileInfo> getFilesForRemoval();
		void writeLog(QTextStream &str);
                
        public slots:
                bool start(const QString &path);
		void clear();
};

#endif
