/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "addform.h"
#include <qdir.h>
#include <qfileinfo.h>
#include <qcheckbox.h>
#include "globals.h"
#include <qtabwidget.h>
#include <kmessagebox.h>
#include "catman.h"
#include <kcombobox.h>

AddForm::AddForm(QString ngName, QString saveDir, QStringList _cats, Group * _g, QWidget* parent, const char* name, bool modal, WFlags fl)
	: addFormDlg(parent,name, modal,fl), cats(_cats), g(_g)
{
	buttonSelectDir->setIconSet(KGlobal::iconLoader()->loadIcon("fileopen", KIcon::Small, 0, false));
	buttonOk->setIconSet(KGlobal::iconLoader()->loadIcon("button_ok", KIcon::Small, 0, false));
	buttonCancel->setIconSet(KGlobal::iconLoader()->loadIcon("button_cancel", KIcon::Small, 0, false));
	connect(buttonSelectDir, SIGNAL(clicked()), this, SLOT(selectDir()));
	connect(m_appendCheck, SIGNAL(clicked()), this, SLOT(checkSelected()));
	connect(m_addCatBtn, SIGNAL(clicked()), this, SLOT(slotAddClicked()));
	m_name->setReadOnly(true);
	m_name->setText(ngName);
	m_alias->setText(ngName);
	m_catCombo->insertStringList(cats);
	m_catCombo->setCurrentText("None");
	m_saveDir->setText(saveDir);
	tabWidget->setTabEnabled(tabWidget->page(1), false);
	
}

AddForm::AddForm( NewsGroup * _ng, Servers *_servers, QStringList _cats, QWidget * parent, const char * name, bool modal, WFlags fl ) : addFormDlg(parent, name, modal, fl) , cats(_cats), servers(_servers),  ng(_ng) 
{
	buttonSelectDir->setIconSet(KGlobal::iconLoader()->loadIcon("fileopen", KIcon::Small, 0, false));
	buttonOk->setIconSet(KGlobal::iconLoader()->loadIcon("button_ok", KIcon::Small, 0, false));
	buttonCancel->setIconSet(KGlobal::iconLoader()->loadIcon("button_cancel", KIcon::Small, 0, false));
	connect(buttonSelectDir, SIGNAL(clicked()), this, SLOT(selectDir()));
	connect(m_appendCheck, SIGNAL(clicked()), this, SLOT(checkSelected()));
	connect(m_addCatBtn, SIGNAL(clicked()), this, SLOT(slotAddClicked()));
	m_name->setReadOnly(true);
	m_name->setText(ng->getName() );
	//New: set the alias
	m_alias->setText(ng->getAlias());
	//New and TODO: load categories into the combobox.
	//set the current category active
	m_catCombo->insertStringList(cats);
	m_catCombo->setCurrentText(ng->getCategory());
	
	m_saveDir->setText(ng->getSaveDir());
	m_resetBtn->setIconSet(KGlobal::iconLoader()->loadIcon("locationbar_erase", KIcon::Small, 0, false));
	m_resetBtn->setEnabled(false);
	m_enableBtn->setEnabled(false);
	m_serverList->setSorting(-1);
	m_serverList->setAllColumnsShowFocus(true);
	m_serverList->setColumnAlignment(2, Qt::AlignRight);
	m_serverList->setColumnAlignment(3, Qt::AlignRight);
	m_serverList->setColumnAlignment(4, Qt::AlignRight);
	connect(m_serverList, SIGNAL(selectionChanged()), this, SLOT(slotSelectionChanged()));
	connect(m_enableBtn, SIGNAL(clicked()), this, SLOT(slotEnableClicked()));
	connect(m_resetBtn, SIGNAL(clicked()), this, SLOT(slotResetClicked()));
	
	
	QMap<int, NntpHost*>::iterator it;
	KListViewItem *serverItem;
	for (it=servers->begin() ; it != servers->end() ; ++it) {
		NntpHost *nh=*it;
		
		serverItem=new KListViewItem(m_serverList, m_serverList->lastChild());
		serverItem->setText(0,QString::number( nh->id));
		serverItem->setText(1, nh->name);
		if ( (ng->high.contains(nh->id)) && (ng->high[nh->id] != -1)) {
			serverItem->setText(2, QString::number(ng->low[nh->id]));
			serverItem->setText(3, QString::number(ng->high[nh->id]));
			serverItem->setText(4, "Enabled");
		} else {
			serverItem->setText(2, "N/A");
			serverItem->setText(3, "N/A");
			serverItem->setText(4, "Disabled");
		}
		
		
	
	}
	
}



AddForm::~AddForm()
{
}

/*$SPECIALIZATION$*/
void AddForm::reject()
{
  QDialog::reject();
}


void AddForm::accept( )
{
	if (m_name->text().stripWhiteSpace().isEmpty() ) {
		KMessageBox::error(this, i18n("The group name can not be null"), i18n("Error"));
	} else if ((m_saveDir->text().stripWhiteSpace().isEmpty()) ) {
		KMessageBox::error(this, i18n("The directory name can not be empty"), i18n("Error"));
	} else if (!checkAndCreateDir(m_saveDir->text())) {
		KMessageBox::error(this, i18n("Cannot create %1 or directory not writable").arg(m_saveDir->text())  , i18n("Error"));
	} else if (m_alias->text().stripWhiteSpace().isEmpty()) {
		//Allow empty alias, setting it to the ng name
		m_alias->setText(m_name->text());
	}
	else {
		entries.append(m_name->text());
		entries.append(QDir::cleanDirPath(m_saveDir->text()));
		entries.append(m_alias->text());
		entries.append(m_catCombo->currentText());
		emit newGroup(entries, g);
		QDialog::accept();
	}
}

void AddForm::selectDir( )
{
	KURL uri = KDirSelectDialog::selectDirectory(m_saveDir->text()  , true, this, "Please select a directory");
	if (!uri.isEmpty())
		m_saveDir->setText(uri.path());
}

void AddForm::checkSelected( )
{
	if (m_appendCheck->isChecked()) {
		m_saveDir->setReadOnly(true);
		m_saveDir->setText(Config().decodeDir + '/' + m_name->text());
	} else {
		m_saveDir->setReadOnly(false);
	}
		
	
}


//Duplicate code!

bool AddForm::mkDeepDir( QString dirName )
{
	QDir d;
	
	QString newDir=dirName.mid(0, dirName.findRev('/'));
// 	qDebug("Dir: %s", newDir.latin1());
	if (d.exists(newDir)) 
		return true;
	if (mkDeepDir(newDir)) {
// 		qDebug("create dir: %s", (const char *) newDir);
		if (d.mkdir(newDir))
			return true;
		else return false;
	} else return false;
	
}

bool AddForm::checkAndCreateDir( QString dirName )
{
	QString dir=QDir::cleanDirPath(dirName);
	dir+='/';
	if (QDir::isRelativePath(dir) ) {
		KMessageBox::error(this, i18n("Please enter only absolute paths"), i18n("Error"));
		return false;
	}
	if (!mkDeepDir(dir))
		return false;
	else { 
		//check if the dir is writable
		QFileInfo fi(dir);
		if (fi.isWritable())
			return true;
		else return false;
		
		
		
	}
}

void AddForm::slotSelectionChanged()
{
	QListViewItem *item=m_serverList->selectedItem();
	if (!item) {
		//Disable the buttons...
		m_enableBtn->setEnabled(false);
		m_resetBtn->setEnabled(false);
		return;
	} 
	//item selected
	m_enableBtn->setEnabled(true);
	if (item->text(4) == "Disabled") {
		m_enableBtn->setText("Enable");
		
		m_resetBtn->setEnabled(false);
	} else {
		m_enableBtn->setText("Disable");
		m_resetBtn->setEnabled(true);
	}
	
	
	
	
	
}

void AddForm::slotResetClicked( )
{
	if (KMessageBox::questionYesNo(this, i18n("This action will delete all the selected server's articles in the group and reset the counters. Do you want to continue?"), i18n("question")) == KMessageBox::No )
		return;
	//Deletes all articles in groups..
	QListViewItem *item=m_serverList->selectedItem();
	int serverId=item->text(0).toInt();
	emit resetServerInGroup(ng, serverId);
	
	//now zero the watermarks...
	ng->high[serverId]=0;
	ng->low[serverId]=0;
	item->setText(2, "0");
	item->setText(3, "0");
	//now save the server...
	emit saveGroup(ng);
	if (ng->getView() != NULL)
		ng->getView()->reload();
}

void AddForm::slotEnableClicked( )
{
	//first, we got to know if it's an enable or a disable...
	QListViewItem* item=m_serverList->selectedItem();
	int serverId=item->text(0).toInt();
	if (item->text(4) == "Disabled") {
		//Enable the group
		ng->high[serverId]=0;
		ng->low[serverId]=0;
		item->setText(2, "0");
		item->setText(3, "0");
		item->setText(4, "Enabled");
		m_enableBtn->setText("Disable");
	} else {
		//Disable the group...
		emit resetServerInGroup(ng, serverId);
		
		ng->high[serverId]=-1;
		ng->low.remove(serverId);
		item->setText(2, "N/A");
		item->setText(3, "N/A");
		item->setText(4, "Disabled");
		m_enableBtn->setText("Enable");
		
	}
	//save the server...
	emit saveGroup(ng);
	if (ng->getView() != NULL)
		ng->getView()->reload();
	
	
}

void AddForm::slotAddClicked( )
{
	CatMan *catMan = new CatMan(this);
	connect(catMan, SIGNAL(newCat(QString)), this, SLOT(slotNewCat(QString)));
	catMan->exec();
}

void AddForm::slotNewCat( QString cat)
{
	if (!cats.contains(cat) && cat != "None") {
// 		qDebug("New cat: %s", cat.latin1());
		emit addCat(cat);
		cats.append(cat);
		m_catCombo->insertItem(cat);
		m_catCombo->setCurrentText(cat);
	} else {
		KMessageBox::error(this, i18n("Duplicate category"), i18n("Error"));
	}
	
}





#include "addform.moc"

