/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "addserver.h"

addServer::addServer(QWidget* parent, const char* name, bool modal, WFlags fl)
: serverDlg(parent,name, modal,fl)
{
	buttonOk->setIconSet(KGlobal::iconLoader()->loadIcon("button_ok", KIcon::Small, 0, false));
	buttonCancel->setIconSet(KGlobal::iconLoader()->loadIcon("button_cancel", KIcon::Small, 0, false));
	m_priorityInput->setRange(1,10,1,false);
	m_threadInput->setRange(1,10,1,false);
	m_timeoutInput->setRange(60,600,5,false);
	m_threadTimeoutInput->setRange(1,30,1,false);
	validator=new QIntValidator(1,65535,this);
	m_portEdit->setValidator(validator);
}

addServer::~addServer()
{
	delete validator;
}

/*$SPECIALIZATION$*/
void addServer::slotLoginRequired(bool b)
{
	m_userEdit->setEnabled(b);
	m_passEdit->setEnabled(b);
	
}

void addServer::reject()
{
  QDialog::reject();
}

void addServer::accept()
{
	//Check input fields
	
	if (m_addrEdit->text().isEmpty() || m_nameEdit->text().isEmpty() || m_portEdit->text().isEmpty())
		KMessageBox::error(this, i18n("Please fill all the fields"), i18n("Error"));
	
	else {
		host=new NntpHost;
		host->hostName=m_addrEdit->text().stripWhiteSpace();
		host->maxThreads=m_threadInput->value();
		host->name=m_nameEdit->text().stripWhiteSpace();
		
		host->port=m_portEdit->text().toInt();
		host->priority=m_priorityInput->value();
		host->timeout=m_timeoutInput->value();
		host->threadTimeout=m_threadTimeoutInput->value();
		host->retries=m_retriesInput->value();
		if (m_logCheck->isChecked()) {
			host->userName=m_userEdit->text().stripWhiteSpace();
			host->pass=m_passEdit->text().stripWhiteSpace();
		} else {
			host->userName="";
			host->pass="";
		}
		emit newServer(host);
		
		QDialog::accept();
	}	
}

addServer::addServer( NntpHost *host, QWidget * parent, const char * name, bool modal, WFlags fl ) : serverDlg(parent,name, modal,fl)
{
	buttonOk->setIconSet(KGlobal::iconLoader()->loadIcon("button_ok", KIcon::Small, 0, false));
	buttonCancel->setIconSet(KGlobal::iconLoader()->loadIcon("button_cancel", KIcon::Small, 0, false));
	m_priorityInput->setRange(1,10,1,false);
	m_threadInput->setRange(1,10,1,false);
	m_timeoutInput->setRange(60,600,5,false);
	m_threadTimeoutInput->setRange(1,30,1,false);
	validator=new QIntValidator(1,1023,this);
	m_portEdit->setValidator(validator);
	m_addrEdit->setText(host->hostName);
	m_threadInput->setValue(host->maxThreads);
	m_nameEdit->setText(host->name);
	m_passEdit->setText(host->pass);
	m_portEdit->setText(QString::number(host->port));
	m_priorityInput->setValue(host->priority);
	m_timeoutInput->setValue(host->timeout);
	m_threadTimeoutInput->setValue(host->threadTimeout);
	m_retriesInput->setValue(host->retries);
	
	if (!(host->userName.isEmpty())) {
		m_logCheck->setChecked(true);
		m_userEdit->setText(host->userName);
		m_passEdit->setText(host->pass);
	}
	
}



#include "addserver.moc"


