/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "fileviewer.h"
#include <kmessagebox.h>
#include <ktrader.h>
#include <klocale.h>
#include <kiconloader.h>
#include <qfile.h>
#include <qfileinfo.h>
#include "globals.h"

FileViewer::FileViewer( KURL _url, QWidget * parent ) : KMdiChildView(parent), url(_url)
{
	setIcon(KGlobal::iconLoader()->loadIcon("viewmag1",KIcon::Small, KIcon::SizeSmall, false));
// 	top_layout = new QHBoxLayout(this);
// 	top_layout->setAutoAdd(true);
// 	QFileInfo fi(url.fileName() );
	
	top_layout = new QHBoxLayout(this);
	top_layout->setAutoAdd(true);

	if ( !url.isEmpty()  )
		load();
	else {
		m_view = 0;
		factory = 0;
		setTabCaption("File Viewer");
		setIcon(KGlobal::iconLoader()->loadIcon("viewmag1",KIcon::Small, KIcon::SizeSmall, false));
	}
	
	
		
	
}

FileViewer::~ FileViewer( )
{
	
	
	kdDebug() << "FileViewer::~ FileViewer( )\n";
	if (!url.isEmpty() && Config().dViewed == Configuration::Yes)
		QFile::remove(url.path());
	
}

void FileViewer::closeEvent( QCloseEvent * e )
{	
	
	int dViewed=Config().dViewed;
	if (dViewed == Configuration::Yes  ) {
		if (! url.isEmpty())
			QFile::remove(url.path());
// 		ce->accept();
		KMdiChildView::closeEvent(e);
	} else if ( dViewed == Configuration::Ask) {
		 switch(KMessageBox::questionYesNoCancel(this, i18n("Do you want to delete the downloaded file?"), i18n("question"))) {
			case KMessageBox::Yes:
				QFile::remove(url.path()  );
				
			case KMessageBox::No:
// 				ce->accept();
				KMdiChildView::closeEvent(e);
				
				break;
			case KMessageBox::Cancel:
				break;
			
		}
	} else KMdiChildView::closeEvent(e);
	
	
}

bool FileViewer::load( )
{
	setTabCaption(url.fileName());
	
	
// 	QString mimetype=KMimeType::findByFileContent(url.fileName())->name();
	QString mimetype=KMimeType::findByURL(url)->name();
	
	//For some reason, sometimes .nfo files are confused with diff files
	if (mimetype == "text/x-diff")
		mimetype="text/plain";
	//For testing purposes...
// 	mimetype="application/octect-stream";
	KTrader::OfferList offers = KTrader::self()->query(mimetype, "'KParts/ReadOnlyPart' in ServiceTypes");
	factory = 0;
	m_view=0;
    // in theory, we only care about the first one.. but let's try all
    // offers just in case the first can't be loaded for some reason
	KTrader::OfferList::Iterator it(offers.begin());
	
	for( ; it != offers.end(); ++it)
	{
		KService::Ptr ptr = (*it);
		

		
		library=ptr->library();
		factory = KLibLoader::self()->factory( ptr->library() );
		
		if (factory)
		{
// 			top_layout = new QHBoxLayout(this);
// 			top_layout->setAutoAdd(true);
			m_view = static_cast<KParts::ReadOnlyPart *>(factory->create(this, ptr->name(), "KParts::ReadOnlyPart"));
			
// 			qDebug("part found");
			break;
		}
	}

    // if our factory is invalid, then we never found our component
    // and we might as well just exit now
	if (!factory)
	{
// 		KMessageBox::error(this, i18n("Could not find a suitable component to view %1").arg(mimetype));
		int result=KMessageBox::questionYesNo(this, i18n("File %1 has an unknown mime type %2. Do you want to show it as plain text?").arg(url.fileName()).arg(mimetype), i18n("question"));
		switch (result) {
			case KMessageBox::No:
				return false;
				break;
			case KMessageBox::Yes:
				//load the library and open the part...
				offers = KTrader::self()->query("text/plain", "'KParts/ReadOnlyPart' in ServiceTypes");
				it=offers.begin();
				KService::Ptr ptr = (*it);
				factory = KLibLoader::self()->factory( ptr->library() );
				if (factory)
				{
					m_view = static_cast<KParts::ReadOnlyPart *>(factory->create(this, ptr->name(), "KParts::ReadOnlyPart"));
					m_view->openURL(url);
					
				}
				
			
		}
		
	} else {
		kdDebug() << "Opening url\n";
		m_view->openURL(url);
		kdDebug() << "URL opened\n";
	}
	return true;
}


void FileViewer::reload( KURL _url )
{
	
	if (m_view) {
	
		kdDebug() << "m_view deleted\n";
		delete m_view;
		m_view = 0;
	
	}
	if (Config().dViewed == Configuration::Yes)
		QFile::remove(url.path());
	
	url=_url;
	

	
	if (load())
		m_view->widget()->show();
	
	
}

