/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KLIBIDO_H_
#define _KLIBIDO_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <kmdimainfrm.h>
#include <kmainwindow.h>
#include <kapplication.h>
#include <kiconloader.h>
#include <grouplist.h>
#include <serverslist.h>
#include <kstatusbar.h>
#include "headerlist.h"
#include "qmgr.h"
#include "prefdialog.h"
#include <kconfig.h>

#ifndef GLOBALS_H
#include "globals.h"
#endif

#include <kaccel.h>



/**
 * @short Application Main Window
 * @author Alessandro Bonometti <bauno@inwind.it>
 * @version 0.1
 */

class GroupList; 
class ServersList;
class AvailableGroups;
class FileViewer;
//Toolbar...


class QToolbarWidget : public QWidget {
	
	Q_OBJECT
	private:
		QLabel *tLabel;
		QLabel *pLabel;
		QPixmap *tIcon;
		
	public:
		QToolbarWidget(QWidget* parent = 0, const char* name = 0, WFlags fl = 0);
	public slots:
			
			void slotQueueInfo(unsigned long long count, unsigned long long size);
		
};


class klibido : public KMdiMainFrm
{
    Q_OBJECT
private:
	GroupList *groupList;
	ServersList *serversList;
	KToggleAction *actionToggleQ;
	Servers servers;
	KMdiToolViewAccessor* groupToolWindow;
	KMdiToolViewAccessor *serverToolWindow;
	DbEnv *dbenv;
	Db* groupDb;
	Db* serversDb;
	QMgr *qMgr;
	FileViewer *fViewer;
	KAccel *accel;
	
	
	//Statusbar widget
// 	QLabel *tLabel;
// 	QLabel *pLabel;
// 	QPixmap *tIcon;
	QToolbarWidget *qTWidget;
	
	
	
	AvailableGroups* aGroups;
	KAction *viewArticle;
	KAction *dSelected;
	KAction *dSelectedFirst;
	KAction *dSelectedTo;
	KAction *markAsRead;
	KAction *markAsUnread;
	KAction *serverMenu;
	KToggleAction *showOnlyComplete;
	KToggleAction *showOnlyNew;
	
	NntpHost *libero, *airnews, *astraweb;
	
	int ret;
	void setupActions();
	
	void setupDbEnv(QString dir);
	void enable(bool);
	void migrateDbs();
	virtual void closeEvent(QCloseEvent*e);



	
	
public:
    /**
     * Default Constructor
     */
    klibido();
	

    /**
     * Default Destructor
     */
    virtual ~klibido();

public slots:
	void openNewWindow();
	void slotOpenNewsGroup(NewsGroup *ng);
	void slotActivateNewsGroup(KMdiChildView*pWnd) {activateView(pWnd);};
	void slotGroupSelection(bool);
	void slotServerSelection(bool);
    virtual void quit();
	virtual void closeWindow( KMdiChildView * pWnd, bool layoutTaskBar = true);
	void slotUpdateFinished(NewsGroup *ng);
	void slotHaveGroups(bool);
	void slotViewFile(KURL);
	void slotQPaused(bool);
	void slotHaveServers(bool);
	void closeView(KMdiChildView*);
	void slotCompactDbs();

	
private slots:
	void optionsShowToolbar();
	void optionsShowStatusbar();
	void slotGroupActivated(KMdiChildView*);
	void slotGroupDeactivated(KMdiChildView*);
	void slotUpdateNewsGroup(NewsGroup*, int);
	void slotShowQueue();
	void slotSettingsConfigure();
	void slotPauseQ();
	void slotPopupGroupMenu(const QPoint&);
	void slotPopupCatMenu(const QPoint&);
	void slotPopupServerMenu(const QPoint&);
	void slotPopupThreadMenu(ThreadStatus, const QPoint&);
	void slotPopupArticleMenu(const QPoint &);
	void slotPopupQueueMenu(const QPoint &);
	void slotPopupFailedMenu(const QPoint &);
	void slotPopupFinishedMenu(const QPoint &);
	void slotQueueItemsSelected(bool);
	void slotGetGroups();
	void slotShowGroups();
	void slotViewActivated(KMdiChildView*);
	void slotDeleteServer();
	void slotCloseActiveView();
	void slotShortcutsConfigure();
	void slotUpdateCurrent();

signals:
	void getGroups(AvailableGroups*);
	void sigOkToDeleteServer();
	void sigCompact();
	
	
};

#endif // _KLIBIDO_H_
