/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef NEWSGROUP_H
#define NEWSGROUP_H

#include "globals.h"
// #include <kmdimainfrm.h>
#include <klistview.h>
#include "headerlist.h"
#include <qmutex.h>




/**
@author Alessandro Bonometti
*/

class NewHeaderList;
class NGListViewItem;

class NewsGroup{
	//if low[server]=-1, the group doesn't exist on the server!
	friend class QMgr;
	friend class NntpThreadSocket;
	friend class UpdateDbThread;
	friend class GroupList;
	friend class AddForm;
	friend class NGListViewItem;
	
	QMap<int, int> high; //holds serverId - lowWatermark
	QMap<int, int> low; //holds serverId-HighWatermark
	QMap<int, int>::iterator it;
	
	bool updating;
	NGListViewItem *listItem;
	uint totalArticles;
	uint unreadArticles;
	bool showOnlyUnread;
	bool showOnlyComplete;
	
	NewHeaderList *view; //tab where this group is displayed, if any
    
	QString ngName;
	QString alias;
	QString category;
    QString saveDir;  //Savedir...
    QString dbName;   //sometimes=ngName, sometimes not...(at least while debugging :)
	Db *db;
#if INDEXDB_VERSION != 0
	QMap<int, Db*> sdb;
	QMap<int, int> oldLow; //Old watermark, for expiring with secondary index.
#endif
    DbEnv *dbEnv;
	char* insert(QString s, char* p);
	char* retrieve(char* i,QString &s);
	

public:
    
	
	QMutex ngLock;
	NewsGroup(DbEnv *_dbEnv, QString _ngName, QString _saveDir); // Opens? yes!
	NewsGroup(DbEnv *, char *, uint version=GROUPDB_VERSION); //un-marshal and open
	
	~NewsGroup(); //closes the db
	int open(); //Maybe not needed...maybe needed :)
	int close();
	Db* getDb() {return db;}
#if INDEXDB_VERSION != 0
	Db* getSDb(int i) {return sdb[i];}
#endif
	void setDb(Db* d) {db=d;}
	char *data(); //marshal (and close?....hmmm...no)
	uint getRecordSize();
	bool isUpdating() {return updating;};
	void stopUpdating() {updating=false;};
	void startUpdating();
	bool isOpened() {return (view!=0);};
	QString getName() {return ngName;};
	uint getTotal() {return totalArticles;};	
	void setListItem(NGListViewItem *i) { listItem=i;};
	void setView(NewHeaderList *v) {view=v;};
	QString getSaveDir() {return saveDir;};
	NewHeaderList *getView() {return view;};
	QString name() {return ngName;};
	uint unread() {return unreadArticles;};
	void setUnread(uint u) {unreadArticles=u; };
	void incUnread() {unreadArticles++;};
	void decUnread();
	void setAlias(QString s);
	void setCategory(QString c);
	QString& getAlias() {return alias;};
	QString& getCategory() {return category;};
	uchar *getBinHeader(QString index);
	void setTotal(uint t) {totalArticles = t;}
	void resetSettings();
	bool onlyComplete() {return showOnlyComplete;}
	bool onlyUnread() {return showOnlyUnread;}
#ifndef NDEBUG
	void validate();
#endif
			
	

};

#endif
