/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "queueparts.h"
#include <qfileinfo.h>

 
 void QUpdItem::update( int partId,  int partial, int total, int  )
{
	if (total == 0)
		return;
// 	parts[partId]->listItem->setText(3, QString::number(uint((float(partial)/float(total))*100)) + '%');
	parts[partId]->listItem->setText(3, QString::number( (partial*100)/total ) + '%');
}

QItem::QItem( KListView * parent, int id, int _type, NewsGroup *_ng)
{
	qItemId=id;
	type=_type;
	status=QItem::Queued_Item;
	partsToDo=0;
	failedParts=0;
	totalParts=0;
	workingThreads=0;
	
// 	listItem=new KListViewItem(parent, QString::number(id), "Update " + _ng->dbName);
	listItem=new KListViewItem(parent, parent->lastChild());
	listItem->setText(0, QString::number(id));
	listItem->setText(1, "Update " + _ng->getName());
	listItem->setText(2, "Queued");
// 	listItem=new QUListViewItem(parent, this, ng);
	
	
	
	
	
	
}

QItem::QItem(KListView *parent, int id, int _type, QString subj, bool first)
{
	qItemId=id;
	type=_type;
	status=QItem::Queued_Item;
	partsToDo=0;
	totalParts=0;
	failedParts=0;
	workingThreads=0;
	
	if (!first) {
		listItem=new KListViewItem(parent, parent->lastChild());
		listItem->setText(0, QString::number(id));
		listItem->setText(1, subj);
	} else listItem=new KListViewItem(parent, QString::number(id), subj);
	listItem->setText(2, "Queued");
	
}


QItem::QItem( KListView * parent, int id, int _type, BinHeader *bh, bool first)
{
	qItemId=id;
	type=_type;
	status=QItem::Queued_Item;
	partsToDo=0;
	totalParts=0;
	failedParts=0;
	workingThreads=0;
// 	if (!parent->childCount()) {
// 		listItem=new KListViewItem(parent, QString::number(id), bh->getSubj());
// 		
// 	} else {
// 	
	if (!first) {
			listItem=new KListViewItem(parent, parent->lastChild());
			listItem->setText(0, QString::number(id));
			listItem->setText(1, bh->getSubj());
	} else listItem=new KListViewItem(parent, QString::number(id), bh->getSubj());
	listItem->setText(2, "Queued");
		
		
	
	
// 	listItem=new QUListViewItem(parent, this, ng);
	
}

QItem::QItem( KListView * parent, int id, int _type )
{
	qItemId=id;
	type=_type;
	status=QItem::Queued_Item;
	partsToDo=0;
	failedParts=0;
	workingThreads=0;
	listItem=new KListViewItem(parent, parent->lastChild());
	listItem->setText(0, QString::number(id));
	listItem->setText(1, "Get list of all groups");
}



bool QUpdItem::finished(int partId) {
// 	qDebug("QUpdItem::finished");

	parts[partId]->job->ng->stopUpdating();
	return QItem::finished(partId);
	
}

bool QListItem::finished( int partId )
{
// 	parts[partId]->job->ag->stopUpdating();
	return QItem::finished(partId);
}



bool QItem::finished(int partId) {
	
	//WTF?????
// 	status=QItem::Finished_Item;
	parts[partId]->status=QItem::Finished_Part;
	parts[partId]->listItem->setText(2, "Finished");
	parts[partId]->listItem->setText(3, "100%");
	workingThreads--;

	partsToDo--;
	if (partsToDo == 0) {
		listItem->setText(2, "Finished");
		status=QItem::Finished_Item;
		return true;
	} else {
		if (workingThreads == 0)
			listItem->setText(2, "Queued");
		else listItem->setText(2, "Processing (" + QString::number(workingThreads) + ")");
		return false;
	}
	
	
	
	
}


void QItem::canceled( int partId )
{
	status=QItem::Canceled_Item;
	parts[partId]->status=QItem::Canceled_Part;
	partsToDo--;
// 	workingThreads--;
	
	//Not useful anymore
	if (partsToDo == 0) {
		listItem->setText(2, "Canceled");
		status=QItem::Canceled_Item;
	}
	parts[partId]->listItem->setText(2, "Canceled");
	parts[partId]->listItem->setText(3, "");
}

/*
void QItem::error(int partId, QString &error) {
	parts[partId]->status=QItem::Failed_Part;
	parts[partId]->job->status=Job::Failed_Job;
	count--;
	if (count == 0) {
		listItem->setText(2, "Finished!");
		status=QItem::Finished_Item;
	}
		parts[partId]->listItem->setText(2, "Failed");
		parts[partId]->listItem->setText(3, error);
	
	
	
}
*/

QPostItem::QPostItem( KListView * parent, int id, QString subj, QString rfn, QString _savePath, bool first, bool _view ) : QItem(parent, id, Job::GetPost, subj, first)
{
	rootFName=rfn;
	savePath=_savePath;
	post=NULL;
	view=_view;
	etaTimeout=5;
	etaTimer=NULL;
	
// 	qDebug("TotalLines: %d", totalPostLines);
	curPostLines=0;
	intervalPostLines=0;
	partialLines=0;
	overwriteExisting=Config().overwriteExisting;
	deleteFailed=Config().deleteFailed;
	
}


QPostItem::QPostItem( KListView * parent, int id, BinHeader * bh, QString rfn, QString _savePath, bool first, bool _view ) :QItem(parent, id, Job::GetPost, bh, first)
{
	rootFName=rfn;
	savePath=_savePath;
// 	totalPostLines=bh->getLines();
	totalPostLines=bh->getSize();
	post=bh;
	view=_view;
	etaTimeout=5;
	etaTimer=NULL;
	
// 	qDebug("TotalLines: %d", totalPostLines);
	curPostLines=0;
	intervalPostLines=0;
	partialLines=0;
	overwriteExisting=Config().overwriteExisting;
	deleteFailed=Config().deleteFailed;
// 	qDebug("Created QPostItem with id %d, listItem: %d", id, listItem);
	
	
	
}

void QUpdItem::addJobPart( int jobId, int partId, Part * part )
{
// 	jobPart.insert(jobId, partId);
	parts.insert(partId, part);
	if (listItem->childCount() == 0)
		part->listItem=new KListViewItem(listItem, QString::number(jobId), part->desc, "Queued");
	else {
		QMap<int, Part*>::iterator it=parts.end();
		--it;
		--it;
		part->listItem=new KListViewItem(listItem, it.data()->listItem);
		part->listItem->setText(0, QString::number(jobId));
		part->listItem->setText(1, part->desc);
		part->listItem->setText(2, "Queued");
	}
	++partsToDo;
	part->listItem->setSelectable(false);
	
	
}

void QListItem::addJobPart( int jobId, int partId, Part * part )
{
	parts.insert(partId, part);
	if (listItem->childCount() == 0)
		part->listItem=new KListViewItem(listItem, QString::number(jobId), part->desc, "Queued");
	else {
		QMap<int, Part*>::iterator it=parts.end();
		--it;
		--it;
		part->listItem= new KListViewItem(listItem, it.data()->listItem);
		part->listItem->setText(0, QString::number(jobId));
		part->listItem->setText(1, part->desc);
		part->listItem->setText(2, "Queued");
	}
	part->listItem->setSelectable(false);
	++partsToDo;
}




void QPostItem::addJobPart( int jobId, int partId, Part * part )
{
	
// 	jobPart.insert(jobId, partId);
	
	
	parts.insert(partId, part);

	if (listItem->childCount() == 0)
			part->listItem=new KListViewItem(listItem,QString::number(jobId), part->desc, "Queued article");
	else {
		QMap<int, Part*>::iterator it=parts.end();
		--it;
		--it;
// 		part->listItem=new KListViewItem(listItem, parts[partId-1]->listItem);
		part->listItem=new KListViewItem(listItem, it.data()->listItem);
		part->listItem->setText(0, QString::number(jobId));
		part->listItem->setText(1, part->desc);
		part->listItem->setText(2, "Queued article");
	// 	qDebug("JobId: %d, PartId: %d", jobId, partId);
	}
	part->listItem->setSelectable(false);
	++partsToDo;
	++totalParts;
	listItem->setText(3, "0/0/" + QString::number(totalParts));
// 	qDebug("Added jobId %d to listItem %d, qItemId: %d", jobId, listItem, qItemId);
	
	
}

void QPostItem::addJobPartWithStatus( int jobId, int partId, Part * part, int status )
{
	//First, normally add the part...
// 	qDebug("Status: %d", status);
	addJobPart(jobId, partId, part);
	QString err="Failed from previous session";
	//Then simulate what happened...
	switch (status) {
		case QItem::Queued_Part:
			//Nothing to do...
			break;
		case QItem::Failed_Part:
			partsToDo--;
			failedParts++;
			parts[partId]->job->status=Job::Failed_Job;
			parts[partId]->listItem->setText(2, "Failed");
			parts[partId]->listItem->setText(3, err);
			
			
			break;
		case QItem::Finished_Part:
			parts[partId]->status=QItem::Finished_Part;
			parts[partId]->listItem->setText(2, "Finished");
			parts[partId]->listItem->setText(3, "100%");
			parts[partId]->job->status=Job::Finished_Job;
			partsToDo--;
			
			
			break;
	}
}


QUpdItem::QUpdItem( KListView * parent, int id, NewsGroup * ng ) : QItem(parent, id, Job::UpdHead, ng)
{
}

QListItem::QListItem( KListView * parent, int id, Db * gdb ) : QItem(parent, id, Job::GetList) ,    groupsDb(gdb)
{
	
}


//Bleach! :-P
void QPostItem::update( int partId, int partial, int total, int lastIntervalLines )
{
	if (total == 0)
		return;
	uint percentage=uint((float(partial)/float(total))*100);
	if ( (percentage <= 100) )
		parts[partId]->listItem->setText(3, QString::number(percentage) + '%');
	else parts[partId]->listItem->setText(3, QString::number(partial) + " lines");
	
	curPostLines+=lastIntervalLines;
	listItem->setText(2, "Processing (" + QString::number(workingThreads) + ") " + \
			QString::number(uint(float(curPostLines)/float(totalPostLines)*100)) + '%');
	
// 	etaCount++;
// 	if (etaCount >=etaTimeout) {
// 		etaCount=0;
// 		
// 		updateEta();
// 		
// 	}
	
	
	
	
	
}


bool QPostItem::finished( int partId )
{
	QItem::finished(partId);
	partialLines=0;
	

	
	if (partsToDo == 0) {
		//send the item to the decoder thread...
// 		decode();
		if (etaTimer) {
			etaTimer->stop();
			delete etaTimer;
			etaTimer=0;
		}
		listItem->setText(2, "Decoding");
		listItem->setText(3, "");
		listItem->setText(4, "");
		
		
		
		emit decodeMe(this);
		return true;
	}else  {
		if (workingThreads == 0)
			etaTimer->stop();
		
		listItem->setText(3, QString::number(totalParts - partsToDo) + '/' + QString::number(failedParts) + '/' + QString::number(totalParts) );
		
		return false;
	}
}




Thread::Thread(uint _serverId, uint _threadId, uint to, uint rc, QWidget * p ) : serverId(_serverId), threadId(_threadId), threadTimeout(rc)
{
	retryCount=0;
	timeout=to*1000;
	threadBytes=new uint;
	



	
	
	*threadBytes=0;
	prevBytes=0;
// 	status=NntpThreadSocket::Ready;
	

	nt=new NntpThreadSocket(p, threadBytes);
	nt->setId(serverId, threadId);
	speedTimer=new QTimer(this);
	idleTimer=new QTimer(this);
	retryTimer=new QTimer(this);
	connect(speedTimer, SIGNAL(timeout()), this, SLOT(slotSpeedTimeout()));
	connect(idleTimer, SIGNAL(timeout()), this, SLOT(slotIdleTimeout()));
	connect(retryTimer, SIGNAL(timeout()), this, SLOT(slotRetryTimeout()));
	

	
	
}

/*
void Thread::setJob( Job * j )
{
	
 	if (nt->running()) {
		//Should never be here, 'coz now I wait for the thread to finish in the Thread::stop()
 		qDebug("Thread::setJob(): trying to add a job to a running thread!");
		qDebug("ServerId: %d, id: %d", serverId, threadId);
		nt->wait();
		qDebug("ok, thread stopped");
 	}
	
	
	if (nt->addJob(j)) {
			
		nt->start();
// 		status=NntpThreadSocket::Working;
	} else qDebug("Failed to add job");
// 	qDebug("Added job to thread %d,%d", serverId, threadId);
// 	qDebug("Status: %d", status);
		
	
// 	nt->start();
	
}
*/


bool Thread::stop( )
{
// 	qDebug("About to lock %d,%d", serverId, threadId);

// 	qDebug("Locked");
/*	if ( nt->running() )
		nt->wait();*/
	
// 	retryCount=0;
// 	qDebug("%d,%d: Stopping retry Timer inside Thread::stop()", serverId, threadId);
// 	retryTimer->stop();
	speedTimer->stop();
	if (nt->isConnected()) {
		idleTimer->start(timeout, true);
		
		return true;
	} else {
		
		return false;
	}


	
	
	return false;
	
	

}

void Thread::slotSpeedTimeout( )
{
	
	emit sigThreadSpeedChanged(serverId, threadId, (int)((*threadBytes-prevBytes)/1024));
	prevBytes = *threadBytes;
	
}

void Thread::error( )
{
// 	retryCount=0;
	
}

void Thread::slotRetryTimeout()
{
	//Unpause the job
	qDebug("%d, %d: Thread::slotRetryTimeout", serverId, threadId);
// 	status=NntpThreadSocket::Ready;
// 	nt->setStatus(NntpThreadSocket::Ready);
	//No need to stop the timer as it's single shot...

// 	nt->tStart();
	nt->tResume();
	emit sigThreadResumed();
	speedTimer->start(1000,false);
	idleTimer->stop();
	
}


void Thread::comError( )
{
	//Now I'm paused...
// 	status=NntpThreadSocket::Paused;
	speedTimer->stop();
	idleTimer->stop();
	
// 	qDebug("%d, %d: retrycount: %d", serverId, threadId, retryCount);
	
	if (retryCount < RETRYCOUNT) {
// 		qDebug("Starting %d,%d retry Timer", serverId, threadId);
		retryTimer->start(retryTimeouts[retryCount]*1000, true);
		emit sigThreadPaused(serverId, threadId, retryTimeouts[retryCount]);
		retryCount++;
	}
	else if (retryCount  > (RETRYCOUNT + threadTimeout+1)) {
		//Pause the thread!!!
		emit sigThreadPaused(serverId, threadId, 0); 
	} else {
		retryTimer->start(60000, true);
		retryCount++;
		
		emit sigThreadPaused(serverId, threadId, 60);
	}
	
	
	
	
	
}

void Thread::paused( )
{
	speedTimer->stop();
	
	idleTimer->start(timeout, true);
// 	qDebug("Thread Paused");
	
}



/*
DecodeThread::DecodeThread(QWidget *p, QMutex *mutex, QValueList< QPostItem * > *decodeList) : QThread()
{
	parent=p;
	items=decodeList;
	listLock=mutex;
	
	
}*/

DecodeThread::DecodeThread(QWidget *p, QMutex *mutex, QValueList< QPostItem * > *decodeList) : DecoderThread(p, mutex, decodeList) {}

void DecodeThread::run( )
{
	

// 	qDebug("DecodeThread::run(): Items in queue: %d", items->count());
	
	while(!items->isEmpty()) {
		
		if (decode(items->first())) {
			listLock->lock();
			items->remove(items->first());
			listLock->unlock();
		} else break;

	}
// 	qDebug("Decoding done");

	
}


bool DecodeThread::decode(QPostItem *postItem )
{
// 	qDebug("DecodeThread::decode()");
	uulist *item;
	int res;
	
	QTime start, end;
	start = QTime::currentTime();
	
	DecodeThreadEvent *dte;
	UUInitialize();
	UUSetOption(UUOPT_FAST, 1, NULL);
	//BEGIN modified for debug
	UUSetOption(UUOPT_OVERWRITE, overWrite , NULL);
	//END modified for debug
	UUSetOption(UUOPT_DESPERATE, 1, NULL);
	UUSetOption(UUOPT_SAVEPATH, 0, postItem->getSavePath());
	UUSetOption(UUOPT_REMOVE, 0, NULL);
	QMap<int, Part *>::iterator pit;
	bool errorFlag=false;
	
	
	for (pit=postItem->parts.begin(); pit != postItem->parts.end() ; ++pit) {
		QString file=postItem->getFName() + '.' + QString::number(pit.key());
// 		kdDebug() << "Loaded " << postItem->getFName() << '.' << pit.key() << endl;
// 		if ((res=UULoadFileWithPartNo( (char*)((const char *) file) , NULL, 0, pit.key())) != UURET_OK)
		if ((res=UULoadFile( (char*)((const char *) file) , NULL, 0)) != UURET_OK)
		{
			qDebug("Error loading part %d", pit.key());
		}
	}
	int i;
	for (i = 0; (item=UUGetFileListItem(i)) != NULL; i++) {
		
		if ((item->state & UUFILE_OK) == 0) {
			qDebug("Error decoding post");
			dte=new DecodeThreadEvent(false, postItem);
			QString error="Error(s): ";
			if ((item->state & UUFILE_MISPART)==0)
				error+="Missing part; ";
			if ((item->state & UUFILE_NODATA)==0)
				error+="No data; ";
			dte->setError(error);
			errorFlag=true;
		}
		
			
		//Try to decode anyway...
		res = UUDecodeFile(item, NULL);
		
		end = QTime::currentTime();
		kdDebug() << "Seconds used with UULib decoder: " << start.secsTo(end) << endl;
		
		
		int j = 1;
		QString origName=item->filename;
		while (res == UURET_EXISTS) {
			//new name!
			QString newName = origName + '.' + QString::number(j);
			j++;
			UURenameFile(item, (char*) newName.latin1());
			res=UUDecodeFile(item, NULL);
			
		}
		if ( res != UURET_OK) {
			
			
			if (res == UURET_IOERR) {
				//Write error...disk full?
				qDebug("Write error during decode");
				//Forgot to put "diskerr" to "yes"
				dte=new DecodeThreadEvent(false, postItem, true);
				dte->setFileName(item->filename);
				dte->setError("Write error!");
				QApplication::postEvent(parent, dte);
				return false;
				
			} else if (!errorFlag) {
				dte=new DecodeThreadEvent(false, postItem);
				dte->setError(UUstrerror(res));
				dte->setFileName(item->filename);
			}

			
		} else {
			if (!errorFlag) {
// 				qDebug("Successfully decoded %s", item->filename);
				dte=new DecodeThreadEvent(true, postItem);
				dte->setFileName(item->filename);
				
			}
			
			
		}
		
	}
	if ( i==0 ) {
		//No file do decode (rare, but it happens)
// 		qDebug("No data");
		dte=new DecodeThreadEvent(false, postItem);
		dte->setError("No data to decode");
		dte->setFileName("");
	}
	
	
	
	
	
	
	
	UUCleanUp();
	QApplication::postEvent(parent, dte);
	return true;
	
}


void Thread::threadCancel( )
{
	
	nt->tCancel();
	retryCount=0;
	
}


void Thread::canceled( )
{
	if (nt->running()) {
// 		qDebug("Thread::stop(): Thread %d,%d running...", serverId, threadId);
		nt->wait();
// 		qDebug("Thread::stop(): ok, thread %d,%d stopped ", serverId, threadId);
	} // else qDebug("Thread::stop(): thread %d,%d stopped", serverId, threadId);
	speedTimer->stop();
	//The thread is now disconnected...I don't need a timeout timer...
// 	idleTimer->start(timeout, true);
// 	status=NntpThreadSocket::Ready;
// 	qDebug("Thread %d,%d Canceled", serverId, threadId);
	
// 	nt->setStatus(NntpThreadSocket::Ready);
// 	*cancel=false;
	//*control=
	
}

void Thread::start( )
{
// 	idleTimer->stop();
// 	qDebug("%d,%d: Stopping retry Timer inside Thread::start()", serverId, threadId);
// 	retryTimer->stop();
	
// 	retryCount=0;
	nt->tStart();
	
// 	speedTimer->start(1000, false);
			
	
	
		

	
// 	status=NntpThreadSocket::Working;
}

void Thread::pause() {

	nt->tPause();

	
}



void Thread::resume() {
	
	idleTimer->stop();
// 	speedTimer->start(1000, false);
	nt->tResume();
	
// 	speedTimer->start();
	
}

void QPostItem::decodeFinished( )
{
	listItem->setText(2, "Decoded");
}

int QUpdItem::error( int partId, QString & error )
{
	
	parts[partId]->status=QItem::Failed_Part;
	parts[partId]->job->status=Job::Failed_Job;
	partsToDo--;
	failedParts++;
	workingThreads--;
	parts[partId]->listItem->setText(2, "Failed");
	parts[partId]->listItem->setText(3, error);
	parts[partId]->job->ng->stopUpdating();
	if (partsToDo == 0) {
		listItem->setText(2, "Finished!");
		status=QItem::Finished_Item;
		return QItem::Finished;
	} else {
		listItem->setText(2, "Queued");
		return QItem::Continue;
	}
		
	
	
	
}
int QListItem::error( int partId, QString & error )
{
	qDebug("QListItem::error");
	parts[partId]->status=QItem::Failed_Part;
// 	parts[partId]->job->status=Job::Failed_Job;
	partsToDo--;
	failedParts++;
	workingThreads--;
	parts[partId]->listItem->setText(2, "Failed");
	parts[partId]->listItem->setText(3, error);
// 	parts[partId]->job->ag->stopUpdating();
	if (partsToDo == 0) {
		listItem->setText(2, "Finished");
		status=QItem::Finished_Item;
		return QItem::Finished;
	} else {
		listItem->setText(2, "Queued");
		return QItem::Continue;
	}
}

void QPostItem::comError( int partId )
{
	parts[partId]->status=QItem::Queued_Part;
	workingThreads--;
	parts[partId]->listItem->setText(2, "Queued");
	parts[partId]->listItem->setText(3, "");
	if (workingThreads == 0)   {
		listItem->setText(2, "Queued");
		etaTimer->stop();
	}
	else listItem->setText(2, "Processing (" + QString::number(workingThreads) + ")");
}



int QPostItem::error( int partId, QString & error )
{
	parts[partId]->status=QItem::Failed_Part;
// 	parts[partId]->job->status=Job::Failed_Job;
	
	//Check if there is another server for the part.
	//Yes->tell the qManager to reque
	//No-> if this was the last part, send
	
	//Delete the server from the part
	post->partNum[partId].remove(parts[partId]->qId);
	//check if there are other parts
	workingThreads--;
	if (workingThreads == 0)   {
			listItem->setText(2, "Queued");
			etaTimer->stop();
		}
		else listItem->setText(2, "Processing (" + QString::number(workingThreads) + ")");
	if (post->partNum[partId].count() != 0) {
		//Yes, requeue me
		return QItem::RequeMe;
	} else {
		partsToDo--;
		failedParts++;
		parts[partId]->listItem->setText(2, "Failed");
		parts[partId]->listItem->setText(3, error);
		//No, check if this was the last part...
		if (partsToDo == 0) {
			//last part, remove from queue
			status=QItem::Finished_Item;
			listItem->setText(2, "Decoding");
			listItem->setText(3, "");
			etaTimer->stop();
			delete etaTimer;
			etaTimer=NULL;
			emit decodeMe(this);
			return QItem::Finished;
			
		} else {
			//there are other parts, continue
// 			listItem->setText(3, QString::number(partsToDo) + " parts left");
			listItem->setText(3, QString::number(totalParts - partsToDo) + '/' + QString::number(failedParts) + '/' + QString::number(totalParts) );
			return QItem::Continue;
			
		}
	}
	
	
	
	return -1;

}


QPostItem::~ QPostItem( )
{
	if (etaTimer)
		delete etaTimer;	
	delete listItem;
	delete post;
	
}

QUpdItem::~ QUpdItem( )
{
	listItem->setSelected(false);
	delete listItem;
}

void QItem::start( int partId)
{
	parts[partId]->listItem->setText(2, "Downloading");
	parts[partId]->listItem->setText(3, "0%");
	workingThreads++;
	listItem->setText(2, "Processing ("+ QString::number(workingThreads) + ")");
	
}

Thread::~ Thread( )
{
	
	
	delete speedTimer;
	delete idleTimer;
	delete retryTimer;
	
	delete nt;
	delete threadBytes;
	
	
	
}

void Thread::kill( )
{
	if (nt->running()) {
		nt->terminate();
		nt->wait();
	}
}

void QItem::paused( int partId )
{
	status=QItem::Paused_Item;
	parts[partId]->status=QItem::Paused_Part;
	parts[partId]->listItem->setText(2, "Paused");
}

void QItem::resumed( int partId )
{
	status=QItem::Queued_Item;
	parts[partId]->status=QItem::Queued_Part;
	parts[partId]->listItem->setText(2, "Queued");
}

void Thread::slotIdleTimeout( )
{
	if (nt->running()) {
		qDebug("Thread::slotIdleTimeout(): quitting a running thread??");
		return;
	}
	
	nt->closeConnection();
	qDebug("Quit idle thread");
	emit sigThreadDisconnected(serverId, threadId);
	
	
}

void QUpdItem::startExpiring( int partId )
{

	parts[partId]->listItem->setText(2, "Expiring");
	parts[partId]->listItem->setText(3, "0%");
}

void QUpdItem::stopExpiring(int partId)
{

	parts[partId]->listItem->setText(2, "Idle");
}


void QListItem::update( int , int , int,int )
{
}

QListItem::~QListItem()
{
	delete listItem;
}

void QUpdItem::startUpdateDb( int partId )
{
	parts[partId]->listItem->setText(2, "Updating DB");
	parts[partId]->listItem->setText(3, "0%");
	
}

void QUpdItem::stopUpdateDb( int partId )
{
	parts[partId]->listItem->setText(2, "Done");
}

void QUpdItem::downloadFinished( int partId )
{
	parts[partId]->listItem->setText(2, "Waiting for db update");
	parts[partId]->listItem->setText(3, "");
}

void QPostItem::start( int partId)
{
	parts[partId]->listItem->setText(2, "Downloading");
	parts[partId]->listItem->setText(3, "0%");
	if (etaTimer == 0) {
		etaTimer=new QTimer(this);
		connect(etaTimer, SIGNAL(timeout()), this, SLOT(slotEtaTimeout()));
		prevTime=QTime::currentTime();
		intervalPostLines=curPostLines;
		etaTimer->start(etaTimeout*1000);
	} else if (workingThreads==0) {
		prevTime=QTime::currentTime();
		etaTimer->start(etaTimeout*1000);
		intervalPostLines=curPostLines;
	}
	workingThreads++;
	listItem->setText(2, "Processing ("+ QString::number(workingThreads) + ") " + QString::number(uint(float(curPostLines)/float(totalPostLines)*100)) + '%');
	
	
}

void QPostItem::slotEtaTimeout( )
{
	curTime=QTime::currentTime();
	uint interval=prevTime.msecsTo(curTime);
	uint intervalLines=curPostLines-intervalPostLines;
	
	float speed=( (float(intervalLines)/float(interval)) *float(1000));
	if (speed == 0)
		return;
	uint eta= uint (float(totalPostLines - curPostLines)/float(speed));
	//Maybe a mean can "stabilize" the result
// 	uint eta=prevEta+currEta/2;
// 	prevEta=currEta;
	

	
	//Now convert to HH::MM::SECS
// 	qDebug("eta: %d", eta);
	uint hours=(uint)(eta/3600);
	
	eta%=3600;
	
	uint minutes=eta/60;
	eta%=60;
	//now eta = seconds.
	QString etaString = QString::number(hours).rightJustify(2,'0') + ':' +\
			QString::number(minutes).rightJustify(2,'0') + ':' + QString::number(eta).rightJustify(2,'0');
	
	listItem->setText(4, etaString);
	
	
}

void QPostItem::canceled( int partId )
{
	status=QItem::Canceled_Item;
	parts[partId]->status=QItem::Canceled_Part;
	partsToDo--;
// 	workingThreads--;
	if (etaTimer)
		delete etaTimer;
	etaTimer=NULL;
	//Not useful anymore ?
	if (partsToDo == 0) {
		listItem->setText(2, "Canceled");
		status=QItem::Canceled_Item;
	}
	parts[partId]->listItem->setText(2, "Canceled");
	parts[partId]->listItem->setText(3, "");
	
}

void QItem::requeue( int partId )
{
	parts[partId]->status=QItem::Queued_Part;
	workingThreads--;
	parts[partId]->listItem->setText(2, "Queued");
	parts[partId]->listItem->setText(3, "");
}




void Thread::setQueue(QValueList<int> *tq, QMap<int, QItem*> *q, QMutex *qLock, int *po) {
	nt->setQueue(tq, q, qLock,po);
}

void Thread::resetRetryCounter( )
{
	retryCount=0;
}

void Thread::started( )
{
	speedTimer->start(1000);
	idleTimer->stop();
}

/*
Decoder * SelfDecodeThread::getDecoderForPost( QStringList posts )
{
	Decoder *decoder = new yyDecoder(posts,destDir);
	if (decoder->isDecodable()) {
		return decoder;
	}
	else { 
		delete decoder;
		decoder = new uuDecoder(posts,destDir);
		if (decoder->isDecodable()) {
			return decoder;
		}
		else {
			delete decoder;
			kdDebug()<<"Downloadmanager: Unrecognised post format - not y/uencoded\n";
			return NULL;
		}
	}
}*/

Decoder * SelfDecodeThread::getDecoderForPost(QStringList posts) {
	int linesToCheck=100;
	QStringList::Iterator partIt = posts.begin();
	while (partIt != posts.end()) {
		QFile partFile(*partIt);
		++partIt;
		if (partFile.open(IO_ReadOnly)) {
			//Find the begin tag
			QString line;
			while ( (linesToCheck-- > 0) && (partFile.readLine(line,1024)!=-1) ) {
				if (line.left(5)=="begin") {
					kdDebug() << "UUencoded post found\n";
// 					kdDebug() << "UUencoded file found!\n";
					partFile.close();
					//We want everything after "begin 644 "
					QString fName = line.stripWhiteSpace().mid(10);
					kdDebug() << "Checking existance of " << destDir+fName << endl;
					if (!overWrite && QFile::exists(destDir + fName)) {
						kdDebug() << "File exists!\n";
						//rename the file
						int i = 1;
						while (QFile::exists(destDir + fName + '.' + QString::number(i)) ) {
							i++;
						}
						fName += '.';
						fName += QString::number(i);
					}
					kdDebug() << "Fname: " << fName << endl;
					return new uuDecoder(posts, destDir, fName, parts );
					
					
					
					
				} else if (line.left(7) == "=ybegin") {
					//ok, found a yyencoded post
					line=line.stripWhiteSpace();
					kdDebug() << "yyenc post found\n";
					int namePos = line.find("name=");
					QString fName = line.right(line.length()-namePos-5);
					if (!overWrite && QFile::exists(destDir + fName)) {
						int i = 1;
						while (QFile::exists(destDir + fName + '.' + QString::number(i)) )
							i++;
						fName += '.';
						fName += QString::number(i);
					}
					kdDebug() << "Filename: " << fName << endl;
					int sizePos = line.find("size=");
					int expectedSize=line.mid(sizePos+5, line.find(" ", sizePos+5) - sizePos - 5).toLong();
					partFile.close();
					return new yyDecoder(posts, destDir , fName, expectedSize);
					
				}
				
				
			}
		}
		partFile.close();
	}
	
	return NULL;
	
	
	
}


void SelfDecodeThread::run( )
{
// 	kdDebug() << "Starting decode thread...\n";
	while(!items->isEmpty()) {
		item=items->first();
		if ( item &&  decode(item )) {
			listLock->lock();
			items->remove(items->first());
			listLock->unlock();
			item=0;
		} else break;

	}
// 	kdDebug() << "Exiting decode thread...\n";
	
}

bool SelfDecodeThread::decode( QPostItem *postItem )
{
	
	DecodeThreadEvent *dte=0;;
	QTime start, end;
	start=QTime::currentTime();
	QStringList partList;
	bool errorFlag=false;
	bool diskError=false;
	QString errorString="error(s):";
	QMap<int, Part *>::iterator pit;
	parts = 0;
	
	//Build a QStringList of filenames (with path)
	for (pit=postItem->parts.begin(); pit != postItem->parts.end(); ++pit) {
		partList.append(postItem->getFName() + '.' + QString::number(pit.key()));
		if (pit.key() > parts)
			parts=pit.key();
	}
	destDir=postItem->getSavePath();
	
 	decoder=getDecoderForPost(partList);
	
	if (decoder!=NULL) {
		while (!diskError && !decoder->decodingComplete()) {
			switch (decoder->decodeNextPart()) {
				case Decoder::Err_BadCRC:
					//bad crc in part
					errorFlag=true;
					errorString += "Bad part crc;";
					break;
				case Decoder::Err_MissingPart:
					//Missing part...right now only activated if cannot read from input
					errorFlag=true;
					errorString += "Missing part";
					break;
				case Decoder::Err_No:
					//No error
					break;
				case Decoder::Err_SizeMismatch:
					//Size mismatch between expected size and written bytes
					errorFlag=true;
					errorString += "Part size mismatch;";
					break;
				case Decoder::Err_Write:
					//Disk error...disk full?
					errorFlag=true;
					diskError=true;
					errorString = "I/O error!";
					break;
				
// 				
			}
				
		}
		if (!decoder->isSizeCorrect()) {
			//Error: size is wrong.
			//This can happen because there are some missing parts in the post.
			errorFlag=true;
			errorString += "Wrong size";
			kdDebug() << "Wrong total size" << endl;
		}
		
		
	} else {
		kdDebug() << "Decoder is null!" << endl;
		kdDebug() << "Post is not uu/yyencoded\n";
		errorFlag=true;
		errorString = "Post is not uu/yyencoded";
	}
	
	
	
	//TODO: Handle rename if file exists (nope...it has to be done inside the decoder class
	/*
	int j = 1;
	while (res == UURET_EXISTS) {
		//new name!
		QString newName=item->filename;
			newName+= '.' + QString::number(j);
			j++;
			UURenameFile(item, (char*) newName.latin1());
			res=UUDecodeFile(item, NULL);
			
	}*/
	end = QTime::currentTime();
	kdDebug() << "Seconds used for decoding with knzb decoder: " << start.secsTo(end) << endl;
	
	if (errorFlag && !diskError) {
		kdDebug() << "Error (but not a diskError)\n";
		dte=new DecodeThreadEvent(false, postItem);
		if (decoder)
			dte->setFileName(decoder->encodedFilename() );
		dte->setError(errorString);
	} else if (diskError) {
		dte = new DecodeThreadEvent(false, postItem, true);
		dte->setFileName(decoder->encodedFilename());
		dte->setError(errorString);
		
	} else {
		kdDebug() << "Else :)\n";
		dte = new DecodeThreadEvent(true, postItem);
		dte->setFileName(decoder->encodedFilename());
	}
	if (decoder)
		delete decoder;
	QApplication::postEvent(parent, dte);
	if (diskError)
		return false;
	else return true;
	
	
}


DecoderThread::DecoderThread(QWidget *p, QMutex *mutex, QValueList<QPostItem*> *decodeList) : QThread()
{
	parent=p;
	items=decodeList;
	listLock=mutex;
}

/*
SelfDecodeThread::SelfDecodeThread( QWidget *p, QMutex *mutex, QValueList< QPostItem * > *decodeList ) : QThread()
{
	parent=p;
	items=decodeList;
	listLock=mutex;

	
}*/

SelfDecodeThread::SelfDecodeThread( QWidget *p, QMutex *mutex, QValueList< QPostItem * > *decodeList ) : DecoderThread(p, mutex, decodeList) {}

void QUpdItem::comError(int partId) {
	parts[partId]->status=QItem::Requeue_Part;
// 	workingThreads--;
	parts[partId]->listItem->setText(2, "Waiting for db update");
	parts[partId]->listItem->setText(3, "");
	
	
}










