/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "serverslist.h"
#include "hlistviewitem.h"

ServersList::ServersList(QString dbName, DbEnv *_dbEnv, Servers *_servers, QWidget* parent, const char* name, WFlags fl)
: serversWidget(parent,name,fl), servers(_servers), dbEnv(_dbEnv),serversDbName(dbName)
{
	setIcon(KGlobal::iconLoader()->loadIcon("icon_server",KIcon::Small , KIcon::SizeSmall, false));
	m_loadServers(); //this populates the serverlist
	addServers(); //this populates the listview
	connect(m_serversList, SIGNAL(contextMenuRequested(QListViewItem*, const QPoint&,int)), this, SLOT(slotServersPopup(QListViewItem*, const QPoint& )));
	connect(m_serversList, SIGNAL(selectionChanged()), this, SLOT(slotSelectionChanged()));
	
}


ServersList::ServersList(Servers *_servers, QWidget * parent, const char * name, WFlags fl )
:  serversWidget(parent, name, fl), servers(_servers)

{
	setIcon(KGlobal::iconLoader()->loadIcon("icon_server",KIcon::Small , KIcon::SizeSmall, false));
	serversDbName="servers";
	dbEnv=0;
	serverDb=0;
	connect(m_serversList, SIGNAL(contextMenuRequested(QListViewItem*, const QPoint&,int)), this, SLOT(slotServersPopup(QListViewItem*, const QPoint& )));
	connect(m_serversList, SIGNAL(selectionChanged()), this, SLOT(slotSelectionChanged()));
	
}



ServersList::~ServersList()
{
// 	Servers::iterator it;
// 	for (it=servers->begin(); it!=servers->end(); ++it) {
// 		delete it.data();
// 	}
	if (serverDb) {
		serverDb->close(0);
		delete serverDb;
// 		qDebug("Server db closed");
	}
	
}

void ServersList::addServers( )
{
		
	Servers::iterator it;
	for (it =servers->begin(); it != servers->end(); ++it) {
		m_addServer(it.data());
	}
	m_serversList->setRootIsDecorated(true);
// 	for (it=servers.begin; 
	
}

void ServersList::slotSpeedChanged( int serverId, int threadId, int speed )
{
	//alternate way...
	SpeedThread *sp=serverThreads[serverId][threadId];
	
	sp->speed=(sp->speed + speed) /2;
	sp->item->setText(SpeedCol, QString::number( sp->speed ) + " KB/s");
	
	
	/*	
	(sp->speed)+=speed;
	sp->item->setText(SpeedCol, QString::number((sp->speed)/(sp->count)) + " KB/s");
	(sp->count)++;
	*/
// 	serverThreads[serverId][threadId]->setText(SpeedCol, QString::number(speed) + " KB/s");
	
}

void ServersList::slotThreadStart( int serverId, int threadId)
{
	SpeedThread *sp=serverThreads[serverId][threadId];
	sp->item->setText(StatusCol, "Working...");
	sp->item->setText(SpeedCol, "0 KB/s");
	sp->status=Running;
	(*servers)[serverId]->workingThreads++;

	
// 	serverThreads[serverId][threadId]->setText(StatusCol, "Working...");
// 	serverThreads[serverId][threadId]->setText(SpeedCol, "0 KB/s");
}

void ServersList::slotThreadStop( int serverId, int threadId)
{
	SpeedThread *sp=serverThreads[serverId][threadId];
	sp->item->setText(StatusCol, "Idle");
	sp->item->setText(SpeedCol, "");
	sp->count=1;
	sp->speed=0;
	sp->status=Stopped;
	
// 	serverThreads[serverId][threadId]->setText(StatusCol, "Idle");
// 	serverThreads[serverId][threadId]->setText(SpeedCol, "");
}

void ServersList::slotThreadPaused( int serverId, int threadId , int seconds)
{
	SpeedThread *sp=serverThreads[serverId][threadId];
	if (seconds == 0)
		sp->item->setText(StatusCol, "Paused");
	else sp->item->setText(StatusCol, "Paused " + QString::number(seconds) + " s");
 	sp->item->setText(SpeedCol, "");
	sp->count=1;
	sp->speed=0;
	sp->status=Paused;
	
}

void ServersList::slotCountDown( int serverId, int threadId, int seconds)
{
	SpeedThread *sp=serverThreads[serverId][threadId];
	sp->item->setText(SpeedCol, QString::number(seconds) + " s");
}

void ServersList::slotCanceling( int serverId, int threadId)
{
	SpeedThread *sp=serverThreads[serverId][threadId];
	sp->item->setText(StatusCol, "Canceling...");
	sp->item->setText(SpeedCol, "");
	sp->count=1;
	sp->speed=0;
// 	serverThreads[serverId][threadId]->setText(StatusCol, "Canceling...");
// 	serverThreads[serverId][threadId]->setText(SpeedCol, "");
}

void ServersList::slotThreadDisconnect( int serverId , int threadId)
{
	SpeedThread *sp=serverThreads[serverId][threadId];
	sp->item->setText(StatusCol, "Disconnected");
	sp->item->setText(SpeedCol, "");
	sp->count=1;
	sp->speed=0;
	sp->status=Canceling;
// 	serverThreads[serverId][threadId]->setText(StatusCol, "Disconnected");
// 	serverThreads[serverId][threadId]->setText(SpeedCol, "");
}


void ServersList::slotNewServer( )
{
	addServer *as=new addServer(this);
	connect(as, SIGNAL(newServer(NntpHost* )), this, SLOT(slotAddServer(NntpHost* )));
	as->exec();
}

void ServersList::slotAddServer( NntpHost *nh )
{
	//First, find a free id...
	
	int id=0;
	while (servers->contains(++id));
	nh->id=id;
	qDebug("slotAddServer(): Id: %d", id);
	(*servers)[id]=nh;
	m_saveServer(nh);
	m_addServer((*servers)[id]);
	emit sigServerAdded(nh);
	emit sigHaveServers(true);
	
	
	
}

void ServersList::m_addServer( NntpHost *nh )
{
	
	KListViewItem *parent=new KListViewItem(m_serversList, nh->name);
	nh->item=parent;
	
	parent->setPixmap(0, KGlobal::iconLoader()->loadIcon("icon_server",KIcon::Small , KIcon::SizeSmall, false));
		for (int i =1 ; i <= nh->maxThreads; i++) {
			serverThreads[nh->id].insert(i, new SpeedThread);
// 			serverThreads[nh->id][i]->item=new KListViewItem(parent, "Thread #" + QString::number(i), "Disconnected");
			serverThreads[nh->id][i]->item=new TListViewItem(nh->id, i, parent);
			serverThreads[nh->id][i]->speed=0;
			serverThreads[nh->id][i]->count=1;
			serverThreads[nh->id][i]->status=Stopped;
// 			serverThreads[nh->id].insert(i, new KListViewItem(parent, "Thread #" + QString::number(i), "Disconnected"));
		}
		

}

/*
char * ServersList::saveHost( NntpHost *nh )
{
	char *p=new char[size(nh)];
	char *i=&p[0];
	i=insert(nh->hostName, i);
	i=insert(nh->name,i);
	i=insert(nh->userName,i);
	i=insert(nh->pass,i);
	int szInt=sizeof(int);
	
	memcpy(i,&(nh->timeout),szInt);
	i+=szInt;
	memcpy(i,&(nh->id),szInt);
	i+=szInt;
	memcpy(i,&(nh->priority),szInt);
	i+=szInt;
	memcpy(i,&(nh->threadTimeout),szInt);
	i+=szInt;
	memcpy(i, &(nh->retries), szInt);
	i+=szInt;
	memcpy(i,&(nh->maxThreads),szInt);
	i+=szInt;
	memcpy(i,&(nh->port), szInt);
	
	
	
	
	return p;
	
	
	
}*/

/*
NntpHost * ServersList::loadHost( char *p, int version )
{
	char *i=&p[0];
	NntpHost *nh=new NntpHost;
	i=retrieve(i,nh->hostName);
	i=retrieve(i,nh->name);
	i=retrieve(i,nh->userName);
	i=retrieve(i,nh->pass);
	int szInt=sizeof(int);
	
	memcpy(&(nh->timeout),i,szInt);
	i+=szInt;
	memcpy(&(nh->id),i,szInt);
	i+=szInt;
	memcpy(&(nh->priority), i, szInt);
	i+=szInt;
	memcpy(&(nh->threadTimeout),i,szInt);
	i+=szInt;
	if (version >= 1) {
		memcpy(&(nh->retries), i, szInt);
		i+=szInt;
	}
	
	memcpy(&(nh->maxThreads),i,szInt);
	i+=szInt;
	memcpy(&(nh->port), i, szInt);
	nh->workingThreads=0;
	nh->item=0;
	nh->size=0;
	return nh;
}*/

/*
char* ServersList::insert(QString s, char* p) {
    int strlen=s.length();
    int suint = sizeof(strlen);
    memcpy(p, &strlen, suint);

    p+=suint;
    memcpy(p, (const char *)s, strlen);
    p+=strlen;
    return p;



}*/

/*
char* ServersList::retrieve(char* i,QString &s) {


    int strlen;
    int ssize=sizeof(strlen);

    char *temp;
    memcpy(&strlen, i, ssize);

    i+=ssize;
    temp=new char[strlen+1];
    memcpy(temp, i, strlen);
    temp[strlen]='\0';
    s=temp;
    delete temp;
    i+=strlen;
    return i;



}*/

/*
int ServersList::size( NntpHost *nh )
{
	return nh->hostName.length()+nh->name.length()+nh->pass.length()+nh->userName.length()+11*sizeof(int);
}*/

void ServersList::m_loadServers( )
{
	serverDb = new Db(dbEnv, 0);
	if (serverDb->open(NULL, serversDbName.latin1() , NULL, DB_BTREE, DB_CREATE | DB_THREAD , 0644) != 0)
		qDebug("Error opening servers db");
	
	char datamem[10000];
	char keymem[10000];
	
	Dbt key, data;
	key.set_flags(DB_DBT_USERMEM);
	key.set_ulen(10000);
	key.set_data(keymem);
	
	data.set_flags(DB_DBT_USERMEM);
	data.set_ulen(10000);
	data.set_data(datamem);
// 	groups.clear();
	
	Dbc *cursor;
	serverDb->cursor(0, &cursor, 0);
	
	while((cursor->get(&key, &data, DB_NEXT))==0) {
		
		NntpHost *nh=loadHost(datamem);
		(*servers)[nh->id]=nh;
		nh->enabled=true;
		
	}
	cursor->close();
}

void ServersList::m_saveServer( NntpHost* nh)
{
	char datamem[10000];
	char keymem[10000];
	
	Dbt key, data;
	key.set_flags(DB_DBT_USERMEM);
	key.set_ulen(10000);
	key.set_data(keymem);
	
	data.set_flags(DB_DBT_USERMEM);
	data.set_ulen(10000);
	data.set_data(datamem);
	char *p=saveHost(nh);
	memcpy(datamem, p, ::size(nh));
	delete p;
	data.set_size(::size(nh));
	memcpy(keymem, &(nh->id), sizeof(int));
	key.set_size(sizeof(int));
	int ret=serverDb->put(0, &key,&data, 0);
	if (ret != 0)
		qDebug("Error saving server: %d", ret);
	else qDebug("server id %d saved", nh->id);
	serverDb->sync(0);
		
	
}

void ServersList::slotDeleteServer( )
{
	qDebug("Delete server");
	KListViewItem* selected=(KListViewItem*)m_serversList->selectedItem();
	if (!selected)
		return;
	if (selected->depth() != 0)
		selected=(KListViewItem*)selected->parent();
	Servers::iterator sit;
	for (sit=servers->begin(); sit != servers->end(); ++sit) {
		if (sit.data()->name == selected->text(0))
			break;
	}
	int serverId=sit.key();
	//Various steps:
	//1) Delete the server's articles from ALL the newsgroups
	//2) Delete the server's queue in the queue manager
	//3) Delete the server from the availablegroups
	//4) Delete the server from the serverslist and from the db.
	//THIS CAN BE VERY LONG!!!
	
	//1, 2, 3
	emit deleteServer(serverId);
	
	//4)
	//Delete the server from the 
	// - servers' list, container and db.
	
	delete selected;
	delete (*servers)[serverId];
	servers->remove(serverId);
	Dbt key;
	memset(&key, 0, sizeof(key));
	key.set_data(&serverId);
	key.set_size(sizeof(serverId));
	if ((serverDb->del(NULL, &key, 0)) != 0)
		qDebug("Error deleting server!");
	else qDebug("Server id %d deleted", serverId);
	if (servers->isEmpty())
		emit sigHaveServers(false);
	
	
	
	
	
}

void ServersList::slotServerProperties( )
{
	KListViewItem* selected=(KListViewItem*)m_serversList->selectedItem();
	if (!selected)
		return;
	if (selected->depth() != 0)
		selected=(KListViewItem*)selected->parent();
	Servers::iterator sit;
	for (sit=servers->begin(); sit != servers->end(); ++sit) {
		if (sit.data()->name == selected->text(0))
			break;
	}
	m_serversList->setEnabled(false);
	
	addServer *as=new addServer(sit.data(), this);
	connect(as, SIGNAL(newServer(NntpHost* )), this, SLOT(slotModifyServer(NntpHost* )));
	as->exec();
	m_serversList->setEnabled(true);
	
}

void ServersList::slotModifyServer( NntpHost * nh)
{
	
	KListViewItem* selected=(KListViewItem*)m_serversList->selectedItem();
	if (!selected)
		return;
	if (selected->depth() != 0)
		selected=(KListViewItem*)selected->parent();
	Servers::iterator sit;
	for (sit=servers->begin(); sit != servers->end(); ++sit) {
		if (sit.data()->name == selected->text(0))
			break;
	}
	//do not substitute the old NNtphost*, since this may crash threads...
	//TODO: put a mutex in the list!
			  
	sit.data()->hostName=nh->hostName;
	sit.data()->name=nh->name;
	sit.data()->port=nh->port;
	sit.data()->userName=nh->userName;
	sit.data()->pass=nh->pass;
	sit.data()->timeout=nh->timeout;
	sit.data()->priority=nh->priority;
	sit.data()->threadTimeout=nh->threadTimeout;
	sit.data()->retries=nh->retries;
	
	//Add or remove threads...not done for now...
	int i = sit.data()->maxThreads - nh->maxThreads;
	if ( i > 0 ) {
		//delete i threads
		for (int j = 0; j < i ; j++) {
			deleteThread(sit.key());
		}
		
		
	} else if ( i < 0 ) {
		for (int j = 0; j > i; j--) {
			addThread(selected, sit.key());
			
		}
		
	}
		
	
	sit.data()->maxThreads=nh->maxThreads;
	
	selected->setText(0, nh->name);
	
	//CRAP!!!
	
// 	ThreadView::iterator it;
// 	for (it=serverThreads[nh->id].begin(); it!=serverThreads[nh->id].end(); ++it) {
// 		serverThreads[nh->id].remove(it);
// 	}
// 	delete selected;
// 	
	m_saveServer(sit.data());
	
// 	m_addServer(sit.data());
	delete nh;
	
	
}

void ServersList::slotDisableServer( )
{
	
	QListViewItem *selected=m_serversList->selectedItem();
	if (!selected)
		return;
	if (selected->depth() != 0)
		selected = selected->parent();
	Servers::iterator it;
	for (it=servers->begin(); it != servers->end(); ++it)
		if (selected->text(0) == it.data()->name)
			break;
	//Toggle
	if (it.data()->enabled==false) {
		selected->setEnabled(true);
		it.data()->enabled=true;
		
	} else {
		selected->setOpen(false);
		selected->setEnabled(false);
		it.data()->enabled=false;
	}
		
	
	
}

void ServersList::slotServersPopup( QListViewItem *item, const QPoint &p )
{
	if (!item)
		return;
	if (item->rtti() == TITEM) {
		//consider the status of the thread...
		TListViewItem *tItem = (TListViewItem*)item;
		emit sigThreadPopup(serverThreads[tItem->qId][tItem->threadId]->status, p );
	} else emit sigServerPopup(p);
	
	
}

void ServersList::slotSelectionChanged( )
{
	QPtrList<QListViewItem> selection=m_serversList->selectedItems();
	if (selection.isEmpty())
		emit serverSelected(false);
	else emit serverSelected(true);
}

void ServersList::slotAddThread( )
{
	QListViewItem *selected=m_serversList->selectedItem();
	if (!selected)
		return;
	
// 	if (selected->depth() != 0)
// 		selected = selected->parent();
	Servers::iterator it;
	for (it=servers->begin(); it != servers->end(); ++it)
		if (selected->text(0) == it.data()->name)
			break;
	//Add the thread to the list...
	//Find a free thread...
	addThread(selected, it.key());
	
	//Save?
	
	
	
	
}

void ServersList::slotDeleteThread( )
{
	QListViewItem *selected=m_serversList->selectedItem();
	if (!selected)
		return;
	if (selected->depth() != 0)
		selected = selected->parent();
	Servers::iterator it;
	for (it=servers->begin(); it != servers->end(); ++it)
		if (selected->text(0) == it.data()->name)
			break;
	
	if (it.data()->maxThreads == 1) {
		//Only one thread left, don't delete
		KMessageBox::error(this, i18n("Only one thread left, cannot delete it"), i18n("Error"));
		return;
	}
	//else...
	
	deleteThread( it.key() );
	
	
		
		
	
	
	
}

void ServersList::slotThreadDeleted( int serverId , int threadId)
{
	delete serverThreads[serverId][threadId]->item;
	delete serverThreads[serverId][threadId];
	serverThreads[serverId].remove(threadId);
	
	//Now reorder the queue...not anymore
	//This happens while other threads are running, but since
	//SIGNAL and slots are synchronous, it should be safe...
	
	int i = 1;
	ThreadView::iterator it;
	for (it = serverThreads[serverId].begin(); it != serverThreads[serverId].end() ; ++it) {
		it.data()->item->setText(0, "Thread #" + QString::number(i));
		++i;
	}
	
	
	
	
}

void ServersList::enable( bool b)
{
	if (b) {
		m_serversList->setCursor(KCursor::arrowCursor());
		setCursor(KCursor::arrowCursor());
	} else {
		m_serversList->setCursor(KCursor::waitCursor());
		setCursor(KCursor::waitCursor());
	}
// 	m_serversList->setEnabled(b);
// 	setEnabled(b);
	
	
	//if this was the last server, 
	
}

void ServersList::addThread( QListViewItem* selected,  int serverId)
{
	ThreadView::iterator tit;
	int threadId=1; //threads starts at one
	
	for (tit=serverThreads[serverId].begin() ; tit!= serverThreads[serverId].end(); ++tit) {
		if (tit.key() != threadId) 
			break;
		else ++threadId;
	}
	//Now threadId holds the first "free place" in the threadList...it's our threadId!
	qDebug("New threadId: %d", threadId);
	
	//Now find the last child...BORING!!!!
	//This will probably go away!
	QListViewItem *item=selected->firstChild();
	QListViewItem *lastChild=0;
	while ((item=item->nextSibling()))
		lastChild=item;
	
	
		
	SpeedThread *newSt=new SpeedThread;
	newSt->count=1;
	newSt->speed=0;
// 	KListViewItem *newThreadView = new KListViewItem(selected, lastChild );
// 	newSt->item=new KListViewItem(selected, lastChild);
	newSt->item=new TListViewItem(serverId, serverThreads[serverId].count()+1, selected, lastChild);
// 	newThreadView->setText(0, "Thread #" + QString::number(serverThreads[serverId].count()+1));
// 	newSt->item->setText(0, "Thread #" + QString::number(serverThreads[serverId].count()+1));
// 	newThreadView->setText(1, "Disconnected");
// 	newSt->item->setText(1, "Disconnected");
// 	serverThreads[serverId].insert(threadId, newThreadView);
	serverThreads[serverId].insert(threadId, newSt);
	
	//Add to the queueThreads
	emit sigAddThread(serverId, threadId);
	(*servers)[serverId]->maxThreads++;
	
}

void ServersList::deleteThread( int serverId)
{
	(*servers)[serverId]->maxThreads--;
	

emit sigDeleteThread(serverId);
}

void ServersList::slotPauseThread( )
{
	//Tell the Q manager to pause the thread
	TListViewItem *item=(TListViewItem*)m_serversList->selectedItem();
	emit sigPauseThread(item->qId, item->threadId);
}

void ServersList::slotResumeThread( )
{
	//Tell the Q Manager to resume the thread
	TListViewItem *item=(TListViewItem*)m_serversList->selectedItem();
	emit sigResumeThread(item->qId, item->threadId);
	
}

void ServersList::checkServers( )
{
	if (servers->isEmpty())
		emit sigHaveServers(false);
	else emit sigHaveServers(true);
}






/*$SPECIALIZATION$*/


#include "serverslist.moc"

