/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVERSLIST_H
#define SERVERSLIST_H

#include <kiconloader.h>
#include "serversWidget.h"
#include <qmap.h>
#include <globals.h>
#include <klistview.h>
#include "addserver.h"
#include <kmessagebox.h>
#include <kaction.h>

class TListViewItem;

enum ServersColums {ServerCol=0, StatusCol=1, SpeedCol=2};
enum ThreadStatus {Stopped, Running, Paused, Canceling};

struct SpeedThread {
	TListViewItem* item;
	int count;
	int speed;
	ThreadStatus status;
	
			
};


// typedef QMap<int, KListViewItem*> ThreadView;
typedef QMap<int, SpeedThread*> ThreadView;
typedef QMap<int, ThreadView> ServerThreads;

class ServersList : public serversWidget
{
  Q_OBJECT
  void addServers();
  Servers *servers;
  ServerThreads serverThreads;
  Db* serverDb;
  DbEnv *dbEnv;
  
  QString serversDbName;
  
  void m_addServer(NntpHost*);
  void m_loadServers();
  void m_saveServer(NntpHost*);
//   char *saveHost(NntpHost *);
//   NntpHost *loadHost(char* , int version=SERVERDB_VERSION);
//   char* insert(QString s, char* p);
//   char* retrieve(char* i,QString &s);
//   int size(NntpHost*);
  void addThread(QListViewItem*, int);
  void deleteThread(int);
  
  
  

public:
  ServersList(QString, DbEnv *_dbEnv, Servers *_servers, QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ServersList(Servers *_servers, QWidget *parent=0, const char *name=0, WFlags fl=0);
  ~ServersList();
  Db* getDb() {return serverDb;};
  void enable(bool);
  void checkServers();
  
  /*$PUBLIC_FUNCTIONS$*/

public slots:
  /*$PUBLIC_SLOTS$*/
	void slotSpeedChanged(int , int , int );
	void slotThreadStart(int, int);
	void slotThreadStop(int,int);
	void slotThreadDisconnect(int,int);
	void slotCanceling(int,int);
	void slotNewServer();
	void slotAddServer(NntpHost*);
	void slotDeleteServer();
	void slotServerProperties();
	void slotModifyServer(NntpHost*);
	void slotDisableServer();
	void slotServersPopup(QListViewItem *, const QPoint&);
	void slotThreadDeleted(int, int);
	void slotThreadPaused(int, int, int);
	void slotCountDown(int, int, int);
	
	
protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
	void slotSelectionChanged();
	void slotAddThread();
	void slotDeleteThread();
	void slotPauseThread();
	void slotResumeThread();
	
signals:
	void sigServerAdded(NntpHost*);
	void sigServerDeleted(NntpHost*);
	void sigHaveServers(bool);
	void sigAddThread(int, int);
	void sigDeleteThread(int);
	void sigServerPopup(const QPoint &);
	void sigThreadPopup(ThreadStatus, const QPoint &);
	void serverSelected(bool);
	void deleteServer(int);
	void sigPauseThread(int, int);
	void sigResumeThread(int, int);
	
	
		

};

#endif

