/***************************************************************************
                          uudecoder.cpp  -  description
                             -------------------
    begin                : Sat Jul 3 2004
    copyright            : (C) 2004 by David Pye
    email                : dmp@davidmpye.dyndns.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "uudecoder.h"

#include <qfileinfo.h>

uuDecoder::uuDecoder(QStringList fileParts, QString outDirectory, QString outFilename, int size):
		Decoder(fileParts, outDirectory, outFilename) {
		
	m_fileParts = fileParts;
	fileIterator = m_fileParts.begin();

	if (outFilename!=QString::null) {
		m_outputFile.setName(outDirectory+"/"+outFilename);
	}
	else {
		QString encodedFilename = this->encodedFilename();
		if (encodedFilename != QString::null) {
			m_outputFile.setName(outDirectory+"/"+encodedFilename);
		}
		else {
			kdDebug()<<"uuEncoder:: Unable to obtain filename for decoded file\n";
			return;
		}
	}
	m_decodingComplete=false;
	decodedParts=0;
	totalParts=size;
	started=false;
	ended=false;
	
	
}

uuDecoder::~uuDecoder(){
	//An explicit close is almost certainly unnecessary, but to be safe.
	m_outputFile.close();
}	

bool uuDecoder::isDecodable() {
// 	bool retval=false;
	//The first part alone contains the output filename
	QStringList::Iterator partIt = m_fileParts.begin();
	while (partIt != m_fileParts.end()) {
	
		QFile partFile(*(partIt));
		++partIt;
		if (partFile.open(IO_ReadOnly)) {
			//Find the begin tag
			QString line;
			while (partFile.readLine(line,1024)!=-1) {
				//Remove leading and trailing whitespace - we're looking for the begin line
				line = line.stripWhiteSpace();
				if (line.left(5)=="begin") {
// 					kdDebug() << "UUencoded file found!\n";
					return true;
				}
			}
		}
	}
	return false;
}

QString uuDecoder::encodedFilename() {
	QFileInfo fi(m_outputFile);
	return fi.fileName();
	
	//The first part alone contains the output filename
	
	/*
	QStringList::Iterator partIt = m_fileParts.begin();
	while (partIt != m_fileParts.end()) {
		QFile partFile(*partIt);
		++partIt;
		if (partFile.open(IO_ReadOnly)) {
			//Find the begin tag
			QString line;
			while (partFile.readLine(line,1024)!=-1) {
				//Remove leading and trailing whitespace - we're looking for the begin line
				line = line.stripWhiteSpace();
				if (line.left(5)=="begin") {
					//We want everything after "begin 644 "
// 					kdDebug()<<"uuDecoder: Filename is "<< line.mid(10) << endl;
					return line.mid(10);
					
					
				}
			}
			partFile.close();
		}
		else {
			kdDebug()<<"Unable to open file "<<partFile.name()<<"\n";
		}
	}
	return QString::null;*/
	
	
}

int uuDecoder::decodeNextPart() {
	if (m_decodingComplete) return true;
	
	
	
	if (!m_outputFile.isOpen()) {
		//If the output file is not open, open it now. 
		//It remains open until the object is destroyed.
		if (!m_outputFile.open(IO_ReadWrite)) {
			kdDebug()<<"Unable to open output file "<<m_outputFile.name()<<" - aborting\n";
			return Err_Write;
		}
	}
	
	
	
	QFile partFile(*fileIterator);
	if (started && partFile.size() == 0) {
		//Wrong size...a 423/430 error
		fileIterator++;
		if (fileIterator == m_fileParts.end())
			m_decodingComplete=true;
		return Decoder::Err_MissingPart;
		
	} else if (!partFile.open(IO_ReadOnly)) {
		kdDebug()<<"uuDecoder: Unable to open file part "+ partFile.name()+"\n";
		fileIterator++;
		decodedParts++;
		if (fileIterator==m_fileParts.end())
			m_decodingComplete=true;
		return Decoder::Err_MissingPart;
	}
	else {
		
		bufferIndex=0;
		
		QString line;
		while (partFile.readLine(line,1024)!=-1) {
			
			if (!started && ( ( line.left(5)=="begin")) ) {
				
				started = true;
				

// 				kdDebug() << "Begin line: " << line << endl;
				
			} else if ( started && line.left(3) == "end") {
				ended=true;
				break;
			} else if (started) {
				
				//Strip the CRLF from the end of the line	
				line.remove(line.length()-2,2);
			
				const char *ascii_rep = line.ascii();
				unsigned int output_bytes = ascii_rep[0]-' ';
				unsigned int line_length = line.length();
				//kdDebug()<<"The output bytes count is "<<output_bytes<<"\n";
				//kdDebug()<<"The input bytes count is "<<line_length-1<<"\n";
				for (unsigned int i=1; i<line_length; i+=4) {
					//Blocks of four characters.
					char data[4];
					memcpy(data, &ascii_rep[i],4);
					for (int j=0; j<4; j++) {
						data[j] = (data[j]-' ')&0x3F;
					}
					
					bufferLine[bufferIndex++]= ( (data[0] << 2) | ((data[1] >> 4) & 0x03) );
					if (output_bytes > 1) {
						bufferLine[bufferIndex++] = (((data[1]&0x0f) << 4) | ((data[2] >> 2) &0x0f));
						if (output_bytes > 2) {
							bufferLine[bufferIndex++] = (((data[2]& 0x03) << 6) | ((data[3]) &0x3f));
						}
					}
					
/*					m_outputFile.putch((data[0]<<2) | ((data[1]>>4)&0x03));
					
					if (output_bytes>1) {
						m_outputFile.putch(((data[1]&0x0F)<<4) | ((data[2]>>2) &0x0F));
						if (output_bytes>2) {
							m_outputFile.putch(((data[2]&0x03)<<6) | ((data[3]) &0x3F));
						}
					}*/
					output_bytes-=3;
				}
				if (bufferIndex > 4095) {
					if (m_outputFile.writeBlock((const char *) bufferLine, bufferIndex) != bufferIndex) {
						kdDebug() << "Disk error!!!\n";
						partFile.close();
						return Decoder::Err_Write;
					}
						
					bufferIndex=0;
				}


			}
			

			
				
		}
		if (bufferIndex > 0) {
			if (m_outputFile.writeBlock((const char *) bufferLine, bufferIndex) != bufferIndex) {
				kdDebug() << "Disk error!!!\n";
				partFile.close();
				return Decoder::Err_Write;
			
			}
		}
		partFile.close();
		decodedParts++;
		
		
		
	}

	fileIterator++;
	if (fileIterator==m_fileParts.end()) {
		m_decodingComplete=true;
	}
	return Decoder::Err_No;
}
	
bool uuDecoder::decodingComplete() {
	return m_decodingComplete;
}

bool uuDecoder::isSizeCorrect( )
{
	//How?
	kdDebug() << "TotalParts: " << totalParts << " DecodedParts: " << decodedParts << endl;
	return ( ended && started && (decodedParts >= totalParts));
}
