/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "binheader.h"

BinHeader::BinHeader() {
    size=0;
    lines=0;
	status=BinHeader::bh_new;
	
}

//Puts the size and the data of string s into array p;
//moves p to the next free element;
//returns p

uchar* BinHeader::insert(QString s, uchar* p) {
    int strlen=s.length();
//     int suint = sizeof(strlen);
    memcpy(p, &strlen, szInt);

	p+=szInt;
    memcpy(p, (const char *)s, strlen);
    p+=strlen;
    return p;



}


// Retrieves the string at current position in array i into the QString s
// updates and returns i;

uchar* BinHeader::retrieve(uchar* i,QString &s) 
{

    int strlen;
//     int ssize=sizeof(strlen);

    char *temp;
    memcpy(&strlen, i, szInt);

    i+=szInt;
    temp=new char[strlen+1];
    memcpy(temp, i, strlen);
    temp[strlen]='\0';
	//double memcopy...save strings with NULL termination and do a "s=i"?
    s=temp;
    delete [] temp;
    i+=strlen;
    return i;



}

// Marshall the binHeader

uchar *BinHeader::data() 
{



    uchar *p=new uchar[getRecordSize()];
    uchar *i=&p[0];
	//Couples serverid-article number (at least 1)
	int part, serverNumItems, serverId, artNum;
// 	int szInt=sizeof(uint);
	serverNumItems=serverLowest.count();
	memcpy(i, &serverNumItems, szInt);
	i+=szInt;
	
	for (spmit=serverLowest.begin(); spmit != serverLowest.end(); ++spmit) {
		serverId=spmit.key();
		artNum=spmit.data();
		memcpy(i, &serverId, szInt);
		i+=szInt;
		memcpy(i, &artNum, szInt);
		i+=szInt;
	}
	
	
    i=insert(subj, i);
    i=insert(from,i);
    i=insert(date,i);

    //copy fixed length fields...no big deal
    

    //numparts field

    memcpy(i, &numParts, szInt);
    i+=szInt;

    // missingparts field;
    memcpy(i, &missingParts, szInt);
    ;
    i+=szInt;

    //status field

    memcpy(i, &status, szInt);
    i+=szInt;

    //lines field
    memcpy(i, &lines, szInt);
    i+=szInt;

    //size field
    memcpy(i, &size, szInt);
    i+=szInt;
	
	//INSERTED SERVERPARTITEMS BETWENN SIZE AND PARTNUMITEMS
	
	int serverPartItems=serverPart.count();

	memcpy(i, &serverPartItems, szInt);
	i+=szInt;
	for (spmit=serverPart.begin() ; spmit != serverPart.end(); ++spmit) {
		serverId=spmit.key();
		artNum=spmit.data();
		memcpy(i, &serverId, szInt);
		i+=szInt;
		memcpy(i, &artNum, szInt);
		i+=szInt;
	}
	
	
    //how many items in the map?
    int partNumItems=partNum.count();
    memcpy(i, &partNumItems , szInt);
    i+=szInt;

    
    for (pnmit=partNum.begin(); pnmit != partNum.end(); ++pnmit) {
        //save part number - number of items in server nummap, then the couples
        // serverid-artNum
        part=pnmit.key();
        memcpy(i, &part, szInt);
        i+=szInt;
        serverNumItems=pnmit.data().count();
        memcpy(i, &serverNumItems, szInt);
        i+=szInt;
        for (snmit=pnmit.data().begin(); snmit != pnmit.data().end(); ++snmit) {
            serverId=snmit.key();
            artNum=snmit.data();
            memcpy(i, &serverId, szInt);
            i+=szInt;
            memcpy(i, &artNum, szInt);
            i+=szInt;
        }



    }
	//BEGIN NEW MID
	int partMidItems = partMid.count();
	memcpy(i, &partMidItems, szInt);
	i+=szInt;
	PartMid::Iterator partMidIt;
	
	for (partMidIt=partMid.begin(); partMidIt != partMid.end(); ++partMidIt) {
		part=partMidIt.key();
		memcpy(i, &part, szInt);
		i+=szInt;
		
		i=insert(partMidIt.data(), i);
		
	}
		
		
	
	//END NEW MID
    
    
	
	//Using serverPartitems for partSize
	serverPartItems=partSize.count();
	
	memcpy(i, &serverPartItems, szInt);
	i+=szInt;
	QMap<uint, uint>::iterator psit;
	//Using serverId, artNum to limit autovariables allocation
	for (psit=partSize.begin(); psit !=partSize.end(); ++psit) {
		serverId=psit.key();
		artNum=psit.data();
		memcpy(i, &serverId, szInt);
		i+=szInt;
		memcpy(i, &artNum, szInt);
		i+=szInt;
		
	}
	
	//Save the length...
	serverPartItems = i-p+szInt;
// 	qDebug("binheader size: %d", serverPartItems);
	
	memcpy(i,&serverPartItems , szInt);

    return p;
}

//create binheader, unmarshalling DB data

BinHeader::BinHeader(uchar *p, int version) 
{


    uchar *pi =&p[0];
// 	int szInt=sizeof(int);
	uint  part, serverNumItems, serverId, artNum;
	//BEGIN serverLowest code
	if (version >= 3) {
		//Reload serverId, <lowest article number>
		int serverLowestItems;
		memcpy(&serverLowestItems, pi, szInt);
		pi+=szInt;
		for (int i = 0; i < serverLowestItems; i++) {
			memcpy(&serverId, pi, szInt);
			pi+=szInt;
			memcpy(&part, pi, szInt);
			pi+=szInt;
			serverLowest.insert(serverId, part);
		}
		
	}

    // Variable-lenght fields

    pi=retrieve(pi,subj);
    pi=retrieve(pi,from);
    pi=retrieve(pi,date);


    // Fixed-size fields:

    memcpy(&numParts, pi, szInt);
    pi+=szInt;
    memcpy(&missingParts, pi, szInt);
    pi+=szInt;
    memcpy(&status, pi, szInt);
    pi+=szInt;
    //status
    memcpy(&lines, pi, szInt);
    pi+=szInt;
    memcpy(&size, pi, szInt);
    pi+=szInt;
	
	uint serverPartItems, partNumItems;
	if (version >= 4) {
		memcpy(&serverPartItems, pi, szInt);
		pi+=szInt;
		for (uint i =0; i< serverPartItems; i++) {
	
			memcpy(&serverId, pi, szInt);
			pi+=szInt;
			memcpy(&artNum, pi, szInt);
			pi+=szInt;
			serverPart[serverId]=artNum;
	
		}
	}
		
	memcpy(&partNumItems, pi, szInt);
	pi+=szInt;


	
	// mapItems
	//     memcpy(&mapItems, pi, szInt);
	//     pi+=szInt;

	for (uint i = 0; i < partNumItems; i++) {
		// get the partid;
		memcpy(&part, pi, szInt);
		pi+=szInt;
		//get the number of items in the servernum map
		memcpy(&serverNumItems, pi, szInt);
		pi+=szInt;
		// now rebuild the servernum map
		// 		partNum.insert(part);
		for (uint j = 0; j < serverNumItems; j++) {
			memcpy(&serverId, pi, szInt);
			pi+=szInt;
			memcpy(&artNum, pi, szInt);
			pi+=szInt;
			partNum[part].insert(serverId, artNum);
		}
	}
	
	
		//BEGIN partMid code
		
	if (version >= 2) {
		uint partMidItems;
		memcpy(&partMidItems, pi, szInt);
		pi+=szInt;
		QString mid;
		for (uint i = 0; i < partMidItems; i++) {
			memcpy(&part, pi, szInt);
			pi+=szInt;
			pi = retrieve(pi, mid);
			partMid[part]=mid;
			
		}
	
	}
	//END partMid code
	
	if (version < 4) {
	
		memcpy(&serverPartItems, pi, szInt);
		pi+=szInt;
		for (uint i =0; i< serverPartItems; i++) {
	
			memcpy(&serverId, pi, szInt);
			pi+=szInt;
			memcpy(&artNum, pi, szInt);
			pi+=szInt;
			serverPart[serverId]=artNum;
	
		}
	}
	
	//ok, if version >= 1 we have the size of the single parts to consider...
	//Using serverPartItems, serverId, artnum to limit autovariables allocation...


	if (version >= 1) {
// 		qDebug("Loading size into bh");
		memcpy(&serverPartItems, pi, szInt);
		pi+=szInt;
		for (uint i = 0; i < serverPartItems; i++) {
			memcpy(&serverId, pi, szInt);
			pi+=szInt;
			memcpy(&artNum, pi, szInt);
			pi+=szInt;
			partSize[serverId]=artNum;
		}
		
	}
	
}

BinHeader::BinHeader(uchar *p) 
{
	uchar *pi =&p[0];
	uint  part, serverNumItems, serverId, artNum;

	//Reload serverId, <lowest article number>
	int serverLowestItems;
	memcpy(&serverLowestItems, pi, szInt);
	pi+=szInt;
	for (int i = 0; i < serverLowestItems; i++) {
		memcpy(&serverId, pi, szInt);
		pi+=szInt;
		memcpy(&part, pi, szInt);
		pi+=szInt;
		serverLowest.insert(serverId, part);
	}

    // Variable-lenght fields

	pi=retrieve(pi,subj);
	pi=retrieve(pi,from);
	pi=retrieve(pi,date);

    // Fixed-size fields:

	memcpy(&numParts, pi, szInt);
	pi+=szInt;
	memcpy(&missingParts, pi, szInt);
	pi+=szInt;
	memcpy(&status, pi, szInt);
	pi+=szInt;
    //status
	memcpy(&lines, pi, szInt);
	pi+=szInt;
	memcpy(&size, pi, szInt);
	pi+=szInt;
	
	uint serverPartItems, partNumItems;

	memcpy(&serverPartItems, pi, szInt);
	pi+=szInt;
	for (uint i =0; i< serverPartItems; i++) {

		memcpy(&serverId, pi, szInt);
		pi+=szInt;
		memcpy(&artNum, pi, szInt);
		pi+=szInt;
		serverPart[serverId]=artNum;

	}
		
	memcpy(&partNumItems, pi, szInt);
	pi+=szInt;


	for (uint i = 0; i < partNumItems; i++) {
		// get the partid;
		memcpy(&part, pi, szInt);
		pi+=szInt;
		//get the number of items in the servernum map
		memcpy(&serverNumItems, pi, szInt);
		pi+=szInt;
		// now rebuild the servernum map
		// 		partNum.insert(part);
		for (uint j = 0; j < serverNumItems; j++) {
			memcpy(&serverId, pi, szInt);
			pi+=szInt;
			memcpy(&artNum, pi, szInt);
			pi+=szInt;
			partNum[part].insert(serverId, artNum);
		}
	}
		
	
	uint partMidItems;
	memcpy(&partMidItems, pi, szInt);
	pi+=szInt;
	QString mid;
	for (uint i = 0; i < partMidItems; i++) {
		memcpy(&part, pi, szInt);
		pi+=szInt;
		pi = retrieve(pi, mid);
		partMid[part]=mid;
		
	}

	
// 		qDebug("Loading size into bh");
	memcpy(&serverPartItems, pi, szInt);
	pi+=szInt;
	for (uint i = 0; i < serverPartItems; i++) {
		memcpy(&serverId, pi, szInt);
		pi+=szInt;
		memcpy(&artNum, pi, szInt);
		pi+=szInt;
		partSize[serverId]=artNum;
	}

}



//Updated to accomodate part sizes...

uint BinHeader::getRecordSize( ) {
    uint partNumSize=0;
    for (pnmit=partNum.begin(); pnmit != partNum.end(); ++pnmit) {
		//every element is a couple of int. So I need space 
		//for the count (number of couples in the part) and the couple itself
		partNumSize+=(pnmit.data().count()*2*szInt)+szInt; 
		// space for the part #
        partNumSize+=szInt;
    }
	//space for the number of parts
    partNumSize+=szInt;

	/* For every part-mid couple, we have:
		- A int which holds the number of parts
		- A int which holds the length of the string (mid)
		- the length of the string.
		- The first two depends on the number of parts only (i.e.: they can be calculated 
		  with 2*sizeof(int)*partMid.count() + sizeof(int); (including the int that holds the number of
		  parts
		- To know the latter, we have to scan ALL the parts :-\
		
	*/
	PartMid::Iterator partMidIt;
	uint partMidSize = 2*szInt*partMid.count()+szInt;
	for (partMidIt = partMid.begin(); partMidIt != partMid.end(); ++partMidIt) {
		
		
		partMidSize+=partMidIt.data().length();
		
	}
	
	
			
			
    return 12*szInt+subj.length()+from.length()+date.length()+serverPart.count()*(2*szInt)+partNumSize \
			+ 2*(szInt*partSize.count()) + partMidSize + 2*szInt*serverLowest.count();
}

bool BinHeader::addPart(int part, Header *h) {

    if (!partNum.contains(part)) {
        partNum[part]=h->serverNum;
        // 		partNum[part]=h->serverNum;


        size+=h->m_bytes.toInt();
        lines+=h->m_lines.toInt();
        //         hi->setText(1,QString::number(size));
        //         hi->setText(2,QString::number(lines));

        //         new KListViewItem(hi, h.m_subj,h.m_bytes, h.m_lines, h.m_from, h.m_mid);
        missingParts--;
        /*if (isCompleted())
            hi->setPixmap(0,BarIcon("button_ok", KIcon::SizeSmall));
        *///         else
        //             hi->setPixmap(0,BarIcon("button_cancel", KIcon::SizeSmall));
        return true;

    } else
        return false;



}
bool BinHeader::isCompleted() {
    return (missingParts == 0);
}

#ifndef NDEBUG
void BinHeader::printServerPart( ) {
    for (pnmit=partNum.begin() ; pnmit != partNum.end() ; ++pnmit) {
        qDebug("Part: %d", pnmit.key());
        for (snmit=pnmit.data().begin(); snmit != pnmit.data().end(); snmit++) {
            qDebug("\tserverid: %d; articlenum: %d", snmit.key(), snmit.data());
        }
    }
}
#endif

bool BinHeader::addPart( int part, Header *h, NntpHost *nh ) {
    if (!partNum.contains(part)) { //new part
        partNum[part].insert(nh->id, h->m_num);
        // 		partNum[part]=h->serverNum;
        if (serverPart.contains(nh->id))
            (serverPart[nh->id])++;
        else
            serverPart[nh->id]=1;
		
		//Ok, every time I add a part that was missing, the article becomes new
		status=BinHeader::bh_new;

		partSize[part]=h->m_bytes.toInt();
// 		qDebug("part Size: %d", h->m_bytes.toInt());
        size+=h->m_bytes.toInt();
        lines+=h->m_lines.toInt();
        //         hi->setText(1,QString::number(size));
        //         hi->setText(2,QString::number(lines));

        //         new KListViewItem(hi, h.m_subj,h.m_bytes, h.m_lines, h.m_from, h.m_mid);
		if (part==0) 
			numParts++;
		else missingParts--;
		
        /*if (isCompleted())
            hi->setPixmap(0,BarIcon("button_ok", KIcon::SizeSmall));
        *///         else
        //             hi->setPixmap(0,BarIcon("button_cancel", KIcon::SizeSmall));
        return true;

    } else if (!partNum[part].contains(nh->id))  {// already have this part, but on another server
        partNum[part].insert(nh->id, h->m_num);
        if (serverPart.contains(nh->id))
            (serverPart[nh->id])++;
        else
            serverPart[nh->id]=1;

        return true;
    } else if (partNum[part][nh->id]< h->m_num) { // replace part with new...
        partNum[part][nh->id]=h->m_num;
        return true;
    } else
        return false; //duplicate?

}





void BinHeader::addNzbPart(int part, int bytes, QString mid )
{
	partSize[part]=bytes;
	partMid[part]=mid;
	size+=bytes;
	missingParts--;
	
	
}

BinHeader::Add_Code BinHeader::addPart( int part, Header *h, int hostId ) {
    if (!partNum.contains(part)) { //new part
        partNum[part].insert(hostId, h->m_num);
		partSize[part]=h->m_bytes.toInt();
// 		qDebug("Part size: %d", partSize[part]);
// 		qDebug("Part number: %d", h->m_num);
        // 		partNum[part]=h->serverNum;
        if (serverPart.contains(hostId))
            (serverPart[hostId])++;
        else
            serverPart[hostId]=1;
		
		if (serverLowest.contains(hostId)) {
			if (serverLowest[hostId] > h->m_num)
				serverLowest[hostId] = h->m_num;
		} else serverLowest[hostId] = h->m_num;
		
		//Ok, every time I add a part that was missing, the article becomes new
		

// 		qDebug("part Size: %d", h->m_bytes.toInt());
        size+=h->m_bytes.toInt();
        lines+=h->m_lines.toInt();
        //         hi->setText(1,QString::number(size));
        //         hi->setText(2,QString::number(lines));

        //         new KListViewItem(hi, h.m_subj,h.m_bytes, h.m_lines, h.m_from, h.m_mid);
		if (part==0) 
			numParts++;
		else missingParts--;
		
//        if (isCompleted())
//             hi->setPixmap(0,BarIcon("button_ok", KIcon::SizeSmall));
	//         else
        //             hi->setPixmap(0,BarIcon("button_cancel", KIcon::SizeSmall));
		if (status != bh_new) {
			status=bh_new;
			return Unread_Status;
		} else return New_Part;

    } else if (!partNum[part].contains(hostId))  {// already have this part, but on another server
        partNum[part].insert(hostId, h->m_num);
        if (serverPart.contains(hostId))
            (serverPart[hostId])++;
        else
            serverPart[hostId]=1;
		
		if (serverLowest.contains(hostId)) {
			if (serverLowest[hostId] > h->m_num)
				serverLowest[hostId] = h->m_num;
		} else serverLowest[hostId] = h->m_num;

        return New_Part;
    } else if (partNum[part][hostId]< h->m_num) { // replace part with new...
		//Am I replacing the lowest? If yes, rescan to find a new lowest..
		if (serverLowest[hostId] == partNum[part][hostId] ) {
			
			//Replace article number
			partNum[part][hostId]=h->m_num;
			//Rescan to find a new lowest
			int lowest=INT_MAX;
			for (pnmit = partNum.begin(); pnmit != partNum.end(); ++ pnmit) {
				if (pnmit.data().contains(hostId) ) {
					if (pnmit.data()[hostId] < lowest)
						lowest = pnmit.data()[hostId];
				}
			}
			serverLowest[hostId] = lowest;
		} else partNum[part][hostId]=h->m_num;
		
		
		
        return New_Part;
    } else
        return Duplicate_Part; //duplicate?

}

#if INDEXDB_VERSION != 0
BinHeader::Expire_Code BinHeader::expirePart( int hostId, int partId )
{
	partNum[partId].remove(hostId);
	(serverPart[hostId])--;
	if (partNum[partId].isEmpty()) {
		partNum.remove(partId);
		partSize.remove(partId);
	}
	if (partNum.isEmpty()) {
         //delete the post
// 		qDebug("Post deleted");
		
		if (status == bh_new)
			return Delete_Unread;
		else return Delete_Read;
	} else {
// 		qDebug("Elements still in partNum?");
		return No_Delete;//re-save the post...
	}
}
#endif

BinHeader::Expire_Code BinHeader::expire( int hostId, int lw ) {
// 	qDebug("Expiring: %s", (const char *) subj);
	int lowest = INT_MAX;
	int part;
	pnmit = partNum.begin();
	while (pnmit != partNum.end() ) {
		part=pnmit.key();
		pnmit++;
// 		kdDebug() << "Part to expire: " << part << endl;
		
		if (partNum[part].contains(hostId)) { //if the server has the part...
            //check the article number...
			//BEGIN debug code
// 			if (partNum[part][hostId] == 28829962) {
// 				kdDebug() << "Expiring 28829962?" << endl;
// 			}
			if (partNum[part][hostId] < lw) { //if the artnum < lowWatermark...
                //remove the part...
				
// 				if (partNum[part][hostId] == 28829962) {
// 					kdDebug() << "Expired!" << endl;
// 				}

				
				(serverPart[hostId])--;
				partNum[part].remove(hostId);
				
				if (partNum[part].isEmpty()) {
					size-=partSize[part];
					partSize.remove(part);
					partNum.remove(part);
					missingParts++;
				} 

			} else if (partNum[part][hostId] < lowest) {
				//Our new ServerLowest?
				lowest=partNum[part][hostId];
				
				
			} 
		} 
	}
	/*
    for (pnmit=partNum.begin(); pnmit != partNum.end() ; pnmit++) { //for every part...
		kdDebug() << "Part to expire: " << pnmit.key() << endl;
		
        if (pnmit.data().contains(hostId)) { //if the server has the part...
            //check the article number...
			//BEGIN debug code
			if (pnmit.data()[hostId] == 28829962) {
				kdDebug() << "Expiring 28829962?" << endl;
			}
            if (pnmit.data()[hostId] < lw) { //if the artnum < lowWatermark...
                //remove the part...
// 				qDebug("Expiring part: ", pnmit.data()[hostId]);
				if (pnmit.data()[hostId] == 28829962) {
					kdDebug() << "Expired!" << endl;
				}
                
				
				(serverPart[hostId])--;
				pnmit.data().remove(hostId);
				
				if (pnmit.data().isEmpty()) {
					int key=pnmit.key();
					size-=partSize[key];
					partSize.remove(key);
					partNum.remove(key);
					missingParts++;
				}

			} else if (pnmit.data()[hostId] < lowest) {
				//Our new ServerLowest?
				lowest=pnmit.data()[hostId];
				
			}
		}
}*/
    //now if the partList is empty, remove the post
	//To keep track of new articles I have to return 3 codes:
	// a) Don't delete (nothing changes)
	// b) Delete, but the article is not new
	// c) Delete a "new" article (unlikely, but...)
	
    if (partNum.isEmpty()) {
         //delete the post
// 		qDebug("Post deleted");
		
		if (status == bh_new)
			return Delete_Unread;
		else return Delete_Read;
    } else {
// 		qDebug("Elements still in partNum?");
		if (lowest == INT_MAX) {
			//I have deleted all the articles of the server...
			serverLowest.remove(hostId);
		}else serverLowest[hostId] = lowest;
		
		return No_Delete; //re-save the post...
	}








}

void BinHeader::addHost( int part, int hostId )
{
	//Fake hosts, for chooseserver et al.
	partNum[part].insert(hostId, 0);
}


/*
BinHeader::~BinHeader( )
{
	kdDebug() << "Deleting BinHeader\n";
}
*/

