/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef HLISTVIEWITEM_H
#define HLISTVIEWITEM_H

#include "binheader.h"
#include <klistview.h>

// #include "qmgr.h"
#include <qdatetime.h>
#include <kiconloader.h>


#define TITEM 1001
#define GITEM 1002


//3 mandatory columns
#define MAN_COL 3 


class BinHeader;
class QUpdItem;
class QItem;
class NewsGroup;

/// @author Alessandro Bonometti

// enum {Subj_Col=0, Parts_Col=1, Bytes_Col=2, Lines_Col=3, From_Col=5, Date_Col=4, Num_Col=6};
enum {Subj_Col=0, Parts_Col=1, Bytes_Col=2,  Date_Col=3, From_Col=4, Num_Col=5};

//Column masks!!



class BHListViewItem : public KListViewItem {
	private:
		QString subject;
		QString from;
	
		Db* db;
		QColor lineColor;
		bool ok;
		uint status;
		QDateTime *qdt;

		QMap<int, NntpHost*> *servers;
		
		char colCount; //Number of FIXED column...
		bool haveFrom;
		bool haveDate;
		
	public: 
	BHListViewItem(KListView*, BinHeader*, Db*, QMap<int, NntpHost*> *_servers);
	BHListViewItem(KListView*, BinHeader*, Db*, bool, bool, QMap<int, NntpHost*>*);
	BHListViewItem(KListView*, SmallBinHeader*, Db*, bool, bool, QMap<int, NntpHost*>*);
	BHListViewItem(KListView*, BinHeader*);
	QString getDate() {return qdt->toString();};
	bool isComplete() {return ok;};
	bool isNew() {return (status == BinHeader::bh_new); };
	void setStatus(int s) {status=s;};
	int getStatus() { return status; }
	QString getSubject() {return subject;};
	QString getFrom() {return from;};
	
	
	virtual void paintCell( QPainter *p, const QColorGroup &cg, int column, int width, int alignment );
	virtual void setOpen(bool o);
	virtual int compare(QListViewItem *i, int col, bool ascending) const;
	Db * getDb() { return db;};
	~BHListViewItem();
};

	

class NGListViewItem: public KListViewItem {
	private:
		NewsGroup *ng;
	public:
		virtual void paintCell( QPainter *p, const QColorGroup &cg, int column, int width ,int alignment);
		NGListViewItem(KListView *, NewsGroup *);
		NGListViewItem(KListViewItem *, NewsGroup *);
		virtual int rtti() const;
		NewsGroup* getNg() {return ng;};
		
		
};


class TListViewItem : public KListViewItem {
	private:
		friend class ServersList;
		int qId;
		int threadId;

	public:
		virtual int rtti() const;
		TListViewItem(int q, int t, QListViewItem *p, QListViewItem *last=0);
};





#endif
