/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "klibido.h"


#include <qlabel.h>

#include <kmainwindow.h>
#include <klocale.h>
#include "availablegroups.h"
#include <netdb.h>
#include <qregexp.h>
#include "fileviewer.h"
#include <kwallet.h>
#include <assert.h>
#include <kkeydialog.h>
#include <kdeversion.h>
#include <qfile.h>

#include <kdeversion.h>

#include <kglobal.h>





klibido::klibido()
	: KMdiMainFrm( 0, "KLibido"  ,KMdi::IDEAlMode )
{

    // set the shell's ui resource file
    setXMLFile("klibidoui.rc");

	setCaption("KLibido 0.2.4.1");
	dbenv=0;
	fViewer=0;
	qMgr=0;


  if (!Config().configured || !dirCreated()) {
    if(!slotSettingsConfigure()) {
		KMessageBox::error(this, i18n("Configuration aborted. KLibido will now exit"), i18n("Configuration error")); 	
      	exit(-1);
    }
  }
  setupDbEnv(Config().dbDir);
  if (!dbsExists(Config().dbDir)) {
    int result=KMessageBox::warningYesNo(this, i18n("Can't find all the files of your database in %1. Do you want to recreate it ?").arg(Config().dbDir), i18n("question"));
    switch (result) {
      case KMessageBox::Yes:
        createDbs();
        break;
      case KMessageBox::No:
        exit(-1);
        break;

    }
  }
  else  migrateDbs();
	
	
	setAutoSaveSettings();
// 	setupServers();
	
	
	accel = new KAccel(this);
	groupList=new GroupList("newsgroups", dbenv,  &servers, this);
// 	groupList=new GroupList(this);
	groupList->setDbPath(Config().dbDir);
	groupToolWindow=addToolWindow(groupList, KDockWidget::DockLeft, getMainDockWidget());
	
	connect(groupList, SIGNAL(openNewsGroup(NewsGroup* )), this, SLOT(slotOpenNewsGroup(NewsGroup* )));
	connect(groupList, SIGNAL(isSelected(bool )), this, SLOT(slotGroupSelection(bool )));
	connect(groupList, SIGNAL(activateNewsGroup(KMdiChildView*)), this, SLOT(slotActivateNewsGroup(KMdiChildView* )));
	serversList=new ServersList("servers", dbenv, &servers, this);
// 	serversList=new ServersList(&servers, this);
	serverToolWindow=addToolWindow(serversList, KDockWidget::DockLeft, getMainDockWidget());
	connect(serversList, SIGNAL(sigServerPopup(const QPoint& )), this, SLOT(slotPopupServerMenu(const QPoint& )));
	connect(serversList, SIGNAL(sigThreadPopup(ThreadStatus, const QPoint& )), this, SLOT(slotPopupThreadMenu(ThreadStatus, const QPoint&)));
	connect(serversList, SIGNAL(serverSelected(bool )), this, SLOT(slotServerSelection(bool )));
	connect(serversList, SIGNAL(sigHaveServers(bool )), this, SLOT(slotHaveServers(bool)));
	
	//tabWidget = tabWidget();
	connect(tabWidget(), SIGNAL(contextMenu(QWidget*, const QPoint& )), this, SLOT(slotPopupTabMenu(QWidget*, const QPoint &)));
	
	
	
// 	KMdiChildView *QView=new KMdiChildView("Q Manager", this);
	groupDb=groupList->getGroupDb();
	qMgr=new QMgr(&servers, groupDb, "Q Manager", this);
	qMgr->setDbEnv(Config().dbDir, dbenv, groupList);

#if KDE_VERSION >= KDE_MAKE_VERSION(3,3,0)
	addWindow(qMgr, KMdi::StandardAdd, 0);
#else
	addWindow(qMgr, KMdi::StandardAdd);
#endif
	qMgr->setDecodeOverwrite(Config().overwriteExisting);
	
	aGroups = new AvailableGroups(dbenv, &servers, this);
	setupActions();
// 	addWindow(aGroups->view());
// 	connect(aGroups, SIGNAL(subscribe(Group* )), groupList, SLOT(slotNewGroup(Group*)));
	connect(aGroups, SIGNAL(subscribe(Group*)), groupList, SLOT(slotAddGroup(Group*)));
	connect(groupList, SIGNAL(subscribed(Group* )), aGroups, SLOT(slotSubscribed(Group* )));
	connect(groupList, SIGNAL(unsubscribe(QString )), aGroups, SLOT(slotUnsubscribe(QString )));
	connect(groupList, SIGNAL(updateNewsGroup(NewsGroup*,int )), qMgr, SLOT(slotAddUpdItem(NewsGroup*, int )));
	connect(groupList, SIGNAL(updateNewsGroup(NewsGroup*,int )), this, SLOT(slotUpdateNewsGroup(NewsGroup*,int )));
	connect(groupList, SIGNAL(popupMenu(const QPoint& )), this, SLOT(slotPopupGroupMenu(const QPoint& )));
	connect(groupList, SIGNAL(popupCatMenu(const QPoint& )), this, SLOT(slotPopupCatMenu(const QPoint& )));
	connect(groupList, SIGNAL(sigCloseView(KMdiChildView*)), this, SLOT(closeView(KMdiChildView*)));
	connect(this, SIGNAL(sigCompact()), groupList, SLOT(slotCompactDbs()));
	
	
	connect(qMgr, SIGNAL(sigUpdateFinished(NewsGroup* )), this, SLOT(slotUpdateFinished(NewsGroup* )));
	connect(qMgr, SIGNAL(sigUpdateFinished(NewsGroup* )), groupList, SLOT(slotUpdateFinished(NewsGroup*)));
	connect(groupList, SIGNAL(sigHaveGroups(bool )), this, SLOT(slotHaveGroups(bool )));
	
	connect(qMgr, SIGNAL(sigSpeedChanged(int, int, int )), serversList, SLOT(slotSpeedChanged(int, int, int )));
	connect(qMgr, SIGNAL(sigThreadDisconnected(int, int )), serversList, SLOT(slotThreadDisconnect(int, int )));
	connect(qMgr, SIGNAL(sigThreadCanceling(int, int )), serversList, SLOT(slotCanceling(int, int )));
	connect(qMgr, SIGNAL(sigThreadError(int, int )), serversList, SLOT(slotThreadStop(int, int )));
	connect(qMgr, SIGNAL(sigThreadFinished(int, int )), serversList, SLOT(slotThreadStop(int, int )));
	connect(qMgr, SIGNAL(sigThreadStart(int, int )), serversList, SLOT(slotThreadStart(int, int )));
	connect(qMgr, SIGNAL(sigShowQueueMenu(const QPoint& )), this, SLOT(slotPopupQueueMenu(const QPoint& )));
	connect(qMgr, SIGNAL(sigShowFailedMenu(const QPoint& )), this, SLOT(slotPopupFailedMenu(const QPoint& )));
	connect(qMgr, SIGNAL(sigShowFinishedMenu(const QPoint& )), this, SLOT(slotPopupFinishedMenu(const QPoint& )));
	connect(qMgr, SIGNAL(sigItemsSelected(bool )), this, SLOT(slotQueueItemsSelected(bool )));
	connect(qMgr, SIGNAL(sigQPaused(bool )), this,SLOT(slotQPaused(bool )));
	connect(serversList, SIGNAL(sigServerAdded(NntpHost* )), qMgr, SLOT(slotAddServer(NntpHost* )));
	connect(serversList, SIGNAL(sigServerAdded(NntpHost*)), this, SLOT(slotAddServerWidget(NntpHost*)));
	connect(this, SIGNAL(getGroups(AvailableGroups* )), qMgr, SLOT(slotAddListItem(AvailableGroups* )));
// 	addWindow(qMgr);
	connect(serversList, SIGNAL(sigAddThread(int, int )), qMgr, SLOT(slotAddThread(int, int )));
	connect(serversList, SIGNAL(sigDeleteThread(int )), qMgr, SLOT(slotDeleteThread(int )));
	connect(qMgr, SIGNAL(sigThreadDeleted(int, int )), serversList, SLOT(slotThreadDeleted(int, int )));
	connect(this, SIGNAL(viewActivated(KMdiChildView* )), this, SLOT(slotViewActivated(KMdiChildView* )));
// 	connect(this, SIGNAL(viewDeactivated(KMdiChildView* )), this, SLOT(slotGroupDeactivated(KMdiChildView* )));
	connect(this, SIGNAL(sigOkToDeleteServer()), serversList, SLOT(slotDeleteServer()));
	connect(serversList, SIGNAL(deleteServer(int )), groupList, SLOT(slotDeleteAllArticles(int )));
	connect(serversList, SIGNAL(deleteServer(int )), aGroups, SLOT(slotDeleteServer(int )));
	connect(serversList, SIGNAL(deleteServer(int)), this, SLOT(slotDeleteServerWidget(int)));
	connect(serversList, SIGNAL(deleteServer(int)), qMgr, SLOT(slotDeleteServerQueue(int )));
	connect(serversList, SIGNAL(sigServerSpeed(int, int )), this, SLOT(slotUpdateSpeed(int, int )));
	connect(qMgr, SIGNAL(viewItem(KURL )), this, SLOT(slotViewFile(KURL )));
	connect(qMgr, SIGNAL(sigThreadPaused(int, int, int )), serversList, SLOT(slotThreadPaused(int, int, int )));
	connect(serversList, SIGNAL(sigPauseThread(int, int )), qMgr, SLOT(slotPauseThread(int, int )));
	connect(serversList, SIGNAL(sigResumeThread(int, int )), qMgr, SLOT(slotResumeThread(int, int )));
	
	statusBar()->show();
	statusBar()->message(i18n("Ready"));
	
	
	if ( Config().singleViewTab && !fViewer) {
		fViewer=new FileViewer(KURL::KURL(QString::null), this);
		addWindow(fViewer);
		activateView(qMgr);
	}
	
	//servers widget
	Servers::iterator it;
	for (it = servers.begin() ; it != servers.end(); ++it) {
		sWidgets[it.key()] = new QStatusServerWidget(it.data()->name, this);
		statusBar()->addWidget(sWidgets[it.key()], 0, true);
		
	}

	//Statusbar widget
	qTWidget= new QToolbarWidget(this);
	statusBar()->addWidget(qTWidget, 0, true);
	connect(qMgr, SIGNAL(queueInfo(unsigned long long, unsigned long long)), qTWidget, SLOT(slotQueueInfo(unsigned long long,  unsigned long long)));
// 	statusBar()->addWidget(*tIcon, 0, true);
	
	
/*	if (!isFakingSDIApplication()) {
    menuBar()->insertItem( tr("&Window"), windowMenu());
	}*/
	hideViewTaskBar();
	createGUI(0);
	
	
	groupList->checkGroups();

	stateChanged("no_group_selected");
	stateChanged("no_article_window");
	stateChanged("no_server_selected");
	stateChanged("no_items_selected");
	serversList->checkServers();
	/*
	//Initial kwallet implementation
	//Easy to use, but is it supported on all versions of kde? Don't think so...
	

	QStringList wallets=KWallet::Wallet::walletList();
	for (QStringList::iterator it = wallets.begin(); it != wallets.end(); ++it)
		qDebug("Wallet name: %s", (const char *) *it);
	KWallet::Wallet* wallet=KWallet::Wallet::openWallet("kdewallet");
	QStringList folders=wallet->folderList();
	for (QStringList::iterator it = folders.begin(); it != folders.end(); ++it)
		qDebug("Folders: %s", (const char *) *it);
	wallet->createFolder("klibido");
	wallet->setFolder("klibido");
	wallet->writePassword("bauno", "bauno");
	*/
#if KDE_VERSION >= KDE_MAKE_VERSION(3,3,0)	
	tabWidget()->setTabCloseActivatePrevious(true);
#endif
	wMenu = (KPopupMenu*) factory()->container("window", this);
// 	wMenu = new KPopupMenu(0, "window");
// 	menuBar()->insertItem("&Window", -1, 5);
// 	menuBar()->setItemEnabled(10000, true);
	/// @todo manage window menu for fViewer
	connect(wMenu, SIGNAL(activated(int)), this, SLOT(slotWMenuActivated(int)));
	connect(wMenu, SIGNAL(aboutToShow()), this, SLOT(slotAboutToShow()));
	qMgr->checkQueue();
	
}

klibido::~klibido()
{
	qDebug("KLibido::~klibido()");
	if (qMgr)
		closeWindow(qMgr);
// 		
// 	if (fViewer)
// 		KMdiMainFrm::closeWindow(fViewer);
	
	while( m_pCurrentWindow ) {
		KMdiMainFrm::closeWindow(m_pCurrentWindow);
    }
	delete groupList;
	delete serversList;
	delete aGroups;
	dbenv->close(0);
// 	delete dbenv;
	
}

void klibido::openNewWindow( )
{
	qDebug("Open new Window");
}




void klibido::setupDbEnv(QString dir )
{
	dbenv=new DbEnv(DB_CXX_NO_EXCEPTIONS);
	dbenv->set_cachesize(0, 4000000, 0);
/*
  struct stat statBuffer;
  if (stat(dir, &statBuffer) != 0) {
    KMessageBox::error(this, i18n("Can open database directory : %1").arg(dir), i18n("Error!"));
    exit(-1);
  }*/
 // printf("%d\n",stat(dir, &statBuffer));
  
// 	dbenv->set_flags(DB_CDB_ALLDB,1);
//     if ((ret=dbenv->open((const char *) dir, DB_CREATE | DB_THREAD | DB_INIT_CDB |DB_INIT_MPOOL | DB_PRIVATE, 0644))!= 0)
	const char *d=dir.latin1();
	if ((ret=dbenv->open(d, DB_CREATE | DB_THREAD | DB_INIT_CDB |DB_INIT_MPOOL | DB_PRIVATE, 0644))!= 0)
        qDebug("Error opening non-transactional environment: %s", dbenv->strerror(ret));
// 	qDebug("error: %s", dbenv->strerror(9));
	
	
}

void klibido::setupActions( )
{
	//Application SLOT
	KStdAction::quit(this, SLOT(quit()), actionCollection());
    KStdAction::showStatusbar(this, SLOT(optionsShowStatusbar()), actionCollection());
	KStdAction::preferences(this, SLOT(slotSettingsConfigure()), actionCollection() );
	KStdAction::keyBindings(this, SLOT(slotShortcutsConfigure()), actionCollection());
// 	actionToggleQ=new KToggleAction(i18n("Show Queue"), 0, this, SLOT(slotShowQueue()), actionCollection(), "show_queue");
	
	//Server actions
	
	
	(void)new KAction(i18n("Get list of groups"), 0 , this, SLOT(slotGetGroups()), actionCollection(), "get_groups");
	(void)new KAction(i18n("New Server..."), 0, serversList, SLOT(slotNewServer()), actionCollection(), "new_server");
	(void)new KAction(i18n("Server properties..."), 0, serversList, SLOT(slotServerProperties()), actionCollection(), "server_properties");
	(void)new KAction(i18n("Delete server"), 0, this, SLOT(slotDeleteServer()), actionCollection(),"delete_server");
// 	(void)new KToggleAction(i18n("Disable server"),0, serversList, SLOT(slotDisableServer()),actionCollection(), "disable_server");
	(void)new KAction(i18n("Add thread"), 0, serversList, SLOT(slotAddThread()), actionCollection(), "add_thread");
	(void)new KAction(i18n("Remove thread"), 0, serversList, SLOT(slotDeleteThread()), actionCollection(), "delete_thread");
	(void)new KAction(i18n("Pause thread"), 0, serversList, SLOT(slotPauseThread()), actionCollection(), "pause_thread");
	(void)new KAction(i18n("Resume thread"), 0, serversList, SLOT(slotResumeThread()), actionCollection(), "resume_thread");
	
	//Newsgroup actions
// 	(void)new KAction(i18n("Subscribe to newsgroup..."), 0, groupList, SLOT(slotNewGroup() ), actionCollection(), "new_newsgroup");
	(void)new KAction(i18n("Subscribe to newsgroup..."), 0, this, SLOT(slotShowGroups() ), actionCollection(), "new_newsgroup");
	(void)new KAction(i18n("Update current newsgroup"), 0, this, SLOT(slotUpdateCurrent()), actionCollection(), "update_current");
	(void) new KAction(i18n("Update selected with options..."), 0, groupList, SLOT(slotUpdateWOptions()), actionCollection(), "update_w_options");
#ifndef NDEBUG
	(void) new KAction(i18n("Validate Newsgroup"), 0, groupList, SLOT(slotValidateGroup()), actionCollection(), "validate_group");
#endif
	
	(void)new KAction(i18n("Update selected NewsGroups"), 0, groupList, SLOT(slotUpdateSelected() ), actionCollection(), "update_selected");
	(void)new KAction(i18n("Compact databases"), 0, this, SLOT(slotCompactDbs()), actionCollection(), "compact_dbs");
	(void)new KAction(i18n("Download .nzb"), 0, qMgr, SLOT(slotOpenNzb()), actionCollection(), "open_nzb");
	(void)new KAction(i18n("Update subscribed NewsGroups"), CTRL+Key_U, groupList, SLOT(slotUpdateSubscribed() ), actionCollection(), "update_subscribed");
	(void)new KAction(i18n("Unsubscribe..."), 0, groupList, SLOT(slotDeleteSelected()), actionCollection(),"delete_selected");
	(void) new KAction(i18n("Reset selected..."), 0, groupList, SLOT(slotZeroSelected()),actionCollection(),
			"zero_selected");
	(void) new KAction(i18n("Group properties..."), 0, groupList, SLOT(slotGroupProperties()), actionCollection(), "group_properties");
	(void) new KAction(i18n("Remove category"), 0, groupList, SLOT(slotRemoveCategory()), actionCollection(), "remove_category");
	//Headerlist actions...bound at runtime
	viewArticle=new KAction(i18n("View article"), CTRL + Key_V, 0, 0, actionCollection(), "view_article");
	dSelected=new KAction(i18n("Download selected"), CTRL + Key_D , 0, 0,actionCollection(), "download_selected");
	dSelectedFirst=new KAction(i18n("Download selected first"), 0, 0, 0,actionCollection(), "download_selected_first");
	dSelectedTo=new KAction(i18n("Download to dir..."), 0, 0, 0, actionCollection(), "download_to_dir");
	
	showOnlyComplete=new KToggleAction(i18n("Show only complete articles"), Key_C, 0, 0,actionCollection(), "show_only_complete");
	showOnlyNew=new KToggleAction(i18n("Show only unread articles"), Key_U, 0, 0,actionCollection(), "show_only_new");
	markAsRead=new KAction(i18n("Mark as read"), 0,0,actionCollection(), "mark_as_read");
	markAsUnread=new KAction(i18n("Mark as unread"), 0, 0, actionCollection(), "mark_as_unread");
	delHeader = new KAction(i18n("Delete"), 0, 0, actionCollection(), "delete_header");
	
	//Q actions
	
	(void)new KToggleAction(i18n("Pause Queue"), 0, this, SLOT(slotPauseQ()), actionCollection(), "pause_queue");
	(void)new KAction(i18n("Empty Finished List"), 0, qMgr, SLOT(slotEmptyFinishedQ()), actionCollection(), "empty_finished_queue");
	(void)new KAction(i18n("Empty Failed List"), 0, qMgr, SLOT(slotEmptyFailedQ()), actionCollection(), "empty_failed_queue");
	(void)new KAction(i18n("Pause"), 0, qMgr, SLOT(slotPauseSelected()), actionCollection(), "pause_selected");
	(void)new KAction(i18n("Resume"), 0, qMgr, SLOT(slotResumeSelected()), actionCollection(), "resume_selected");
	(void)new KAction(i18n("Cancel"), 0, qMgr, SLOT(slotCancelSelected()), actionCollection(), "cancel_selected");
	(void)new KAction(i18n("Move to top"), 0, qMgr, SLOT(slotMoveSelectedToTop()), actionCollection(), "move_to_top");
// 	(void)new KAction(i18n("Close active view"), CTRL + Key_W, this, SLOT(()), actionCollection(), "close_active_view");
	
// 	accel->insert("close_view", i18n("Close Active view"), i18n("Closes the active view"), CTRL + Key_W, this, 
// 			SLOT(slotCloseActiveView()));
	closeAction = new KAction(i18n("Close window"), CTRL + Key_W, this, SLOT(slotCloseWindow()), actionCollection(), "close_window");
// 	(void)new KAction(i18n("Close and mark as read"), 0, this, SLOT(slotCloseAndMark()), actionCollection(), "close_mark");
// 	(void)new KAction(i18n("Close and don't mark as read"), 0, this, SLOT(slotCloseAndNoMark()), actionCollection(), "close_nomark");
	
// 	assert(wMenu);
// 	wMenu->insertItem("Queue manager");
	
}

void klibido::optionsShowToolbar( )
{
	if (toolBar()->isVisible())
        toolBar()->hide();
    else
        toolBar()->show();
}
	


void klibido::optionsShowStatusbar( )
{
	 if (statusBar()->isVisible())
        statusBar()->hide();
    else
        statusBar()->show();
}

void klibido::slotOpenNewsGroup( NewsGroup * ng )
{
	statusBar()->message("Loading " + ng->getName() + "...");
	enable(false);
	
	
	NewHeaderList * view=new NewHeaderList(ng, &servers, ng->getName(), this);
	ng->setView( view );
	groupList->saveGroup(ng);
	connect(view, SIGNAL(articlePopup(const QPoint &)), this, SLOT(slotPopupArticleMenu(const QPoint& )));
	
	connect(view, SIGNAL(activated(KMdiChildView*)), this, SLOT(slotGroupActivated(KMdiChildView* )));
// 	connect(view, SIGNAL(lostFocus(KMdiChildView* )), this, SLOT(slotGroupDeactivated(KMdiChildView* )));
// 	connect(view, SIGNAL(deactivated(KMdiChildView* )), this, SLOT(slotGroupDeactivated(KMdiChildView* )));
	connect(view, SIGNAL(downloadPost(BinHeader*, NewsGroup*, bool, bool,  QString )), qMgr, SLOT(slotAddPostItem(BinHeader*, NewsGroup*, bool , bool, QString )));
	connect(view, SIGNAL(viewPost(BinHeader*, NewsGroup* )), qMgr, SLOT(slotViewArticle(BinHeader*, NewsGroup* )));
	connect(view, SIGNAL(updateFinished(NewsGroup* )), groupList, SLOT(slotUpdateFinished(NewsGroup* )));
	connect(view, SIGNAL(sigSaveSettings(NewsGroup*, bool, bool )), groupList, SLOT(slotSaveSettings(NewsGroup*, bool, bool )));
	
	
	enable(true);
	statusBar()->message(ng->getName() + " loaded");
	
	addWindow(view);
	activateView(view);
// 	int index = tabWidget()->indexOf(view);
// 	wMenu->insertItem(QString::number(index) + ' ' + view->caption(), index, -1);
// 	wMenu->setItemParameter(index, 99);
	
	stateChanged("no_article_window", StateReverse);
	
	

	
}





void klibido::quit()
{
    /// @todo implement me
// 	return;
// 	this->close();
	if (close() )
		kapp->quit();
}

void klibido::slotGroupSelection( bool b )
{
	if (b)
		stateChanged("no_group_selected", StateReverse);
	else stateChanged("no_group_selected");
}

void klibido::slotPopupGroupMenu( const QPoint &p )
{
	QPopupMenu *pop = (QPopupMenu *) factory()->container("newsgroup_popup", this);
	pop->popup(p);
	
}

void klibido::slotPopupCatMenu( const QPoint &p )
{
	
	QPopupMenu *pop = (QPopupMenu *) factory()->container("category_popup", this);
	assert(pop);
	pop->popup(p);
}

void klibido::slotPopupWindowMenu(const QPoint &p, KMdiChildView *v)
{
	WPopupMenu *pop = new WPopupMenu(this, v->caption() , v);
	pop->popup(p);
}

void klibido::slotPopupArticleMenu( const QPoint &p )
{
	
	QPopupMenu *pop = (QPopupMenu *) factory()->container("articles", this);
	pop->popup(p);
	
}

void klibido::slotPopupServerMenu( const QPoint &p )
{
	QPopupMenu *pop = (QPopupMenu *) factory()->container("server_popup", this);
	pop->popup(p);
	
}

void klibido::slotPopupThreadMenu(ThreadStatus status, const QPoint &p) {
	switch (status) {
		case Running:
			stateChanged("thread_running");
			break;
		case Paused:
			stateChanged("thread_running", StateReverse);
			break;
		default:
			stateChanged("thread_stopped");
			break;
		}
	QPopupMenu *pop = (QPopupMenu *) factory()->container("thread_popup", this);
	pop->popup(p);
	
}


//For some reason, the deactivated signal isn't emitted...bug?

void klibido::slotGroupDeactivated( KMdiChildView *view )
{
	qDebug("Deactivated %s", (const char*) view->caption() );
	stateChanged("no_article_window");
	
}



void klibido::slotGroupActivated( KMdiChildView * view)
{
	
// 	qDebug("Activated %s", (const char*) view->caption() );
	disconnect(dSelectedFirst, SIGNAL(activated()), 0, 0);
	disconnect(dSelectedTo, SIGNAL(activated()), 0, 0);
	disconnect(viewArticle, SIGNAL(activated()), 0, 0);
	disconnect(dSelected, SIGNAL(activated()), 0, 0);
	disconnect(markAsRead, SIGNAL(activated()),0,0);
	disconnect(markAsUnread, SIGNAL(activated()), 0,0);
	disconnect(delHeader, SIGNAL(activated()), 0, 0);
	disconnect(showOnlyNew, SIGNAL(activated()), 0,0);
	disconnect(showOnlyComplete, SIGNAL(activated()), 0, 0);
	
	
	
	connect(viewArticle, SIGNAL(activated()), view, SLOT(slotViewArticle()));
	connect(dSelected, SIGNAL(activated()), view, SLOT(slotDownloadSelected()));
	connect(dSelectedFirst, SIGNAL(activated()), view, SLOT(slotDownloadSelectedFirst()));
	connect(dSelectedTo, SIGNAL(activated()), view, SLOT(slotDownloadToDir()));
	connect(markAsRead, SIGNAL(activated()), view, SLOT(slotMarkSelectedAsRead()));
	connect(markAsUnread, SIGNAL(activated()), view, SLOT(slotMarkSelectedAsUnread()));
	connect(delHeader, SIGNAL(activated()), view, SLOT(slotDelSelected()));
	connect(showOnlyNew, SIGNAL(activated()), view, SLOT(slotShowOnlyNew()));
	connect(showOnlyComplete, SIGNAL(activated()), view, SLOT(slotShowOnlyComplete()));
	
	
	
	//set the status of the filter action...
	stateChanged("no_article_window", StateReverse);
	showOnlyNew->setChecked( ((NewHeaderList*)view)->onlyNew());
	showOnlyComplete->setChecked(((NewHeaderList*)view)->onlyComplete());
	
	
}

void klibido::slotShowQueue( )
{
	
	if (actionToggleQ->isChecked()) {
// 		qDebug("Hide queue");
		removeWindowFromMdi(qMgr);
	} else {
// 		qDebug("Show queue");
		addWindow(qMgr);
	}
	

}

bool klibido::slotSettingsConfigure( )
{
	PrefDialog* pf=new PrefDialog(this, i18n("Preferences"));
	QSize qs(530, 410);
// 	qs.setHeight(420);
// 	qs.setWidth(530);
	pf->setInitialSize(qs);
	if (pf->exec() == QDialog::Accepted) {
		Config().write();
		
		//check if I changed the view mode...
		if (Config().singleViewTab) {
			if (!fViewer) {
				//Didn't have the file viewer, create it...
				fViewer=new FileViewer(KURL::KURL(QString::null), this);
				KMdiChildView *prevActiveWindow=activeWindow();
#if KDE_VERSION >= KDE_MAKE_VERSION(3,3,0)				
				addWindow(fViewer,KMdi::StandardAdd, 1);
#else
				addWindow(fViewer, KMdi::StandardAdd);
#endif
				if (prevActiveWindow)
					activateView(prevActiveWindow);
				else if (qMgr)
					activateView(qMgr);
				
				//Delete the other views? Hmmm...
			}
		} else {
			//Not in single view tab, delete the file viewer if 
			//it exists
			if (fViewer) {
				KMdiMainFrm::closeWindow(fViewer);
				fViewer=0;
			}
				
		}
		
		if (qMgr)
			qMgr->setDecodeOverwrite(Config().overwriteExisting);
		

    if (!dbsExists(Config().dbDir))
      createDbs();
		
		
	  return true;	
	}
    return false;
}

void klibido::closeWindow( KMdiChildView * pWnd, bool layoutTaskBar  )
{
	qDebug("Closing window %s", (const char *) pWnd->caption());
// 	if (pWnd == qMgr)
// 		return;
/*	if (pWnd == fViewer && Config().singleViewTab) {
		
		return;
	}*/
	
	if (pWnd == aGroups->view()) {
		aGroups->prepareToClose();
		KMdiMainFrm::closeWindow(pWnd, layoutTaskBar);
	} else KMdiMainFrm::closeWindow(pWnd, layoutTaskBar);
	
	
	/*
	if (pWnd == aGroups->view()) {
		aGroups->prepareToClose();
		KMdiMainFrm::closeWindow(pWnd, layoutTaskBar);
	}
	else if (((NewHeaderList*)pWnd)->prepareToClose())
		KMdiMainFrm::closeWindow(pWnd, layoutTaskBar);
	*/	
}

void klibido::slotPauseQ( )
{
	KToggleAction *actionQ=(KToggleAction*)actionCollection()->action("pause_queue");
	if (actionQ->isChecked()) { //Pause the queue
		actionQ->setText("Pause Queue");
		actionQ->setIconSet(KGlobal::iconLoader()->loadIcon("connect_no",KIcon::Toolbar, 0, false));
		//now pause the qcreateIterator
		qMgr->pauseQ(true);
		statusBar()->message(i18n("Queue Paused"));
		
	} else { //resume the queue
		actionQ->setText("Resume Queue");
		actionQ->setIconSet(KGlobal::iconLoader()->loadIcon("connect_established",KIcon::Toolbar, 0, false));
		//now resume the queue
		qMgr->pauseQ(false);
		statusBar()->message(i18n("Queue resumed"));
		
	}
}

void klibido::slotUpdateNewsGroup( NewsGroup * ng, int )
{
	
	NewHeaderList *view;
	Q_ASSERT(ng);
	if ((view=ng->getView())) {
		view->setEnabled(false);
		
		//How to disble the tab???
	}
		
}

void klibido::slotUpdateFinished( NewsGroup * ng )
{
	NewHeaderList *view;
	assert(ng);
	view=ng->getView();
// 	assert(view);
	
	if (view) {
		qDebug("Re-enabling %s", (const char *) ng->name());
		view->reload();
		view->setEnabled(true);
	}
}

void klibido::slotServerSelection( bool b)
{
	if (b)
		stateChanged("no_server_selected", StateReverse);
	else stateChanged("no_server_selected");
	
}

void klibido::slotPopupQueueMenu( const QPoint &p )
{
	QPopupMenu *pop = (QPopupMenu *) factory()->container("queue_popup", this);
	pop->popup(p);
	
}

void klibido::slotPopupFailedMenu( const QPoint &p )
{
	QPopupMenu *pop = (QPopupMenu *) factory()->container("failed_popup", this);
	pop->popup(p);
}

void klibido::slotPopupFinishedMenu( const QPoint &p )
{
	QPopupMenu *pop = (QPopupMenu *) factory()->container("finished_popup", this);
	pop->popup(p);
}

void klibido::slotQueueItemsSelected( bool selected)
{
	if (selected)
		stateChanged("no_items_selected", StateReverse);
	else stateChanged("no_items_selected");
}

void klibido::slotGetGroups( )
{
	emit getGroups(aGroups);
}

void klibido::slotShowGroups( )
{
	Q_ASSERT(aGroups);
	if (!aGroups->view())
	{
		enable(false);
		aGroups->loadGroups();
		addWindow(aGroups->view());
		enable(true);
	} else {
			activateView(aGroups->view());
	}

}

void klibido::slotHaveGroups( bool b)
{
	
	if (b)
		stateChanged("no_subscribed_groups", StateReverse);
	else stateChanged("no_subscribed_groups");
}

void klibido::slotViewActivated( KMdiChildView *view )
{
	if ( (view == qMgr) || (view == aGroups->view()) )
		stateChanged("no_article_window");
	
}

void klibido::enable( bool b)
{
	if (b) {
		setCursor(KCursor::arrowCursor());
		toolBar()->setCursor(KCursor::arrowCursor());
		menuBar()->setCursor(KCursor::arrowCursor());
		if (activeWindow())
			activeWindow()->setCursor(KCursor::arrowCursor());
			
	} else {
		setCursor(KCursor::waitCursor());
		toolBar()->setCursor(KCursor::waitCursor());
		menuBar()->setCursor(KCursor::waitCursor());
		if (activeWindow())
			activeWindow()->setCursor(KCursor::waitCursor());
	}
// 	setEnabled(b);
	groupList->enable(b);
	serversList->enable(b);
// 	menuBar()->setEnabled(b);
	toolBar()->setEnabled(b);
	qMgr->enable(b);
	
// 	tabWidget()->setEnabled(b);
	
	
	
	
	
}

void klibido::slotDeleteServer( )
{
	if (!qMgr->empty())
		KMessageBox::error(this, i18n("Can delete a server only if the download queue is empty"), i18n("Error"));
	else {
		//close ALL views, but first mark all groups as updating, so 
		//we don't ask to mark articles...
		
		groupList->markAllGroupAsUpdating();
		closeAllViews();
		enable(false);
		emit sigOkToDeleteServer();
		enable(true);
		
	}
		
}

void klibido::slotViewFile( KURL url)
{
	
	if (Config().singleViewTab ) {
		//In single tab view mode...
		kdDebug() << "Single tab view" << endl;
		
		assert(fViewer);
		fViewer->reload(url);
		if (Config().activateTab)
			activateView(fViewer);
// 		delete fViewer;
// 		fViewer=0;
		
	} else {
	
		KMdiChildView *multiFViewer = new FileViewer(url, this);
		if (!Config().activateTab) {
			KMdiChildView *currentWindow=m_pCurrentWindow;
			this->addWindow(multiFViewer, KMdi::StandardAdd);
			activateView(currentWindow);
		
		} else addWindow(multiFViewer, KMdi::StandardAdd);
//		int index = tabWidget()->indexOf(multiFViewer);
// 		wMenu->insertItem(QString::number(index) + ' ' + multiFViewer->caption(), index, -1);
	}
// 	
	statusBar()->message(url.fileName() + " displayed");
}

void klibido::migrateDbs( )
{
	//First, open the version db...
	
	Db *versionDb=new Db(dbenv, 0);
	
	
	if (versionDb->open(NULL, "versiondb" , NULL, DB_BTREE, DB_CREATE | DB_THREAD , 0644) != 0)
		qDebug("Error opening versiondb");
	//Keys, data have fixed size:
	//DATA is a uint
	//KEY is one of GROUPDB, AVAILABLEGROUPSDB, HEADERDB
	Dbt key,data;
	key.set_flags(DB_DBT_MALLOC);
	data.set_flags(DB_DBT_MALLOC);
	uint groupDbVersion;
			//,availableGroupsDbVersion, headersDbVersion;
	int ret;
	//Check & migrate the groupdb...
	const char *groupDbKey="GROUPDB";
	key.set_data((char *)groupDbKey);
	key.set_size(strlen(groupDbKey));
	ret=versionDb->get(0, &key, &data, 0);
	
	if (ret == DB_NOTFOUND) {
		//Key not found -> db version is 0
		groupDbVersion=0;
	} else if (ret == 0) {
		//key found, set version...
		memcpy(&groupDbVersion, data.get_data(), sizeof(uint));
		free(data.get_data());
	} else {
		//Error!
		qDebug("Error retrieving version: %d", ret);
		return;
	}
// 	free(data.get_data());
// 	free(key.get_data());
// 	qDebug("groupDbVersion: %d", groupDbVersion);
	
	if (groupDbVersion != GROUPDB_VERSION) {
		
		//Migrate the db!
		
		qDebug("Need migration %d->%d", groupDbVersion, GROUPDB_VERSION);
// 		free(key.get_data());
// 		free(data.get_data());
		Db* groupDb=new Db(dbenv,0);
		
		
// 		Db groupDb;
		
// 		qDebug("About to open newsgroup");
		
		if (groupDb->open(NULL, "newsgroups", NULL, DB_BTREE, DB_THREAD, 0644!=0)) {
			qDebug("Error opening groupdb!");
			return;
		} else qDebug("group db opened");
		//Now, for all the groups...
		Dbc *cursor;
		
		
		groupDb->cursor(0, &cursor, DB_WRITECURSOR);
// 		key.set_flags(DB_DBT_MALLOC);
		
// 		qDebug("Starting...");
		while((cursor->get(&key, &data, DB_NEXT))==0) {
			
			//Load the old group...
// 			qDebug("read %d bytes", data.get_size());
			NewsGroup *tempg=new NewsGroup(dbenv, (char*)data.get_data(), groupDbVersion);
			free(data.get_data());
			//For every newsgroup...
// 			qDebug("Counting unread articles in %s", (const char *) tempg->getName());
			Dbt groupKey, groupData;
			groupKey.set_flags(DB_DBT_MALLOC);
			groupData.set_flags(DB_DBT_MALLOC);
			BinHeader *bh;
			Dbc *dbCursor;

			switch (groupDbVersion) {
				case 0:
					tempg->setUnread(0);
					
					
					//now count the unread articles (sic)
					
					tempg->getDb()->cursor(0, &dbCursor, 0);
					while (dbCursor->get(&groupKey,&groupData,DB_NEXT) == 0) {
						
						bh=new BinHeader((uchar*)groupData.get_data());
						if (bh->getStatus() == BinHeader::bh_new)
							tempg->incUnread();
						free(groupKey.get_data());
						free(groupData.get_data());
						delete bh;
						
					}
					
					dbCursor->close();
					//Don't break, since a need both the migrations...
				case 1:
					//I need to set the alias and the category...
					
					tempg->setAlias(tempg->getName());
					tempg->setCategory("None");
				case 2:
// 					qDebug("Migrating to version 3 of groupDb");
					tempg->resetSettings();
					
				case 3:
					qDebug("Version 4 of groupDb");
					tempg->setDeleteOlder(0);
					break;
				default:
					qDebug("Something very very wrong happend with Db versions!");
			 
			
			}
			
			
			//Now save the group...
// 			char* tempData=tempg->data();
// 			tempg->setUnread(25245);
			data.set_data(tempg->data());
			data.set_size(tempg->getRecordSize());
			qDebug("About to save group");
// 			qDebug("New group size: %d", tempg->getRecordSize());
			ret=cursor->put(&key,&data,DB_CURRENT);
			if (ret != 0)
				qDebug("Return from cursor put: %s", dbenv->strerror(ret));
			
// 			delete tempData;
			free(key.get_data());
			free(data.get_data());			
			delete tempg;
// 			qDebug("Group saved");
// 			qDebug("Exiting cycle");
			memset(&key, 0, sizeof(key));
			key.set_flags(DB_DBT_MALLOC);
			memset(&data, 0, sizeof(data));
			data.set_flags(DB_DBT_MALLOC);
			qDebug("End of cycle");
			
			
		}
		
		cursor->close();
		groupDb->close(0);
		delete groupDb;
		

		
	} 
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	
	data.set_flags(DB_DBT_MALLOC);
	
	uint headerDbVersion;
	const char *headerDbKey="HEADERDB";
	key.set_data((char*)headerDbKey);
	key.set_size(strlen(headerDbKey));
	ret=versionDb->get(0, &key, &data, 0);
	
	if (ret == DB_NOTFOUND) {
		//Key not found -> db version is 0
		headerDbVersion=0;
	} else if (ret == 0) {
		//key found, set version...
		memcpy(&headerDbVersion, data.get_data(), sizeof(uint));
		free(data.get_data());
	} else {
		//Error!
		qDebug("Error retrieving version: %d", ret);
		return;
	}
	
	if (headerDbVersion != HEADERDB_VERSION) {
		if (KMessageBox::questionYesNo(0, i18n("This version of KLibido uses a different format for the header databases. The operation can be lengthy. Do you want to continue?"), i18n("DB Migration needed")) == KMessageBox::No)
			exit(-1);
		
		Db* groupDb=new Db(dbenv,0);
// 		Db* headerDb=new Db(dbenv, 0);
		
		//new db, to rename
		
		Dbc *groupCursor;
		Dbc *headerCursor;
		
// 		Db groupDb;
		
// 		qDebug("About to open newsgroup");
		
		if (groupDb->open(NULL, "newsgroups", NULL, DB_BTREE, DB_THREAD, 0644) !=0) {
			qDebug("Error opening groupdb!");
			return;
		} else qDebug("group db opened");
		//Now, for all the groups...
		groupDb->cursor(0, &groupCursor, 0); //No write cursor...
		
		memset(&key, 0, sizeof(key));
		memset(&data, 0, sizeof(data));
		key.set_flags(DB_DBT_MALLOC);
		data.set_flags(DB_DBT_MALLOC);
		NewsGroup *ng;
		while ( groupCursor->get(&key, &data, DB_NEXT) == 0 ) {
			Db* newDb=new Db(dbenv, 0);
			ng=new NewsGroup(dbenv, (char*)data.get_data());
			free(data.get_data());
			free(key.get_data());
			Db * oldDb=ng->getDb();
			QString tempName=ng->getName() + ".new";
			if (newDb->open(NULL, tempName.latin1(), NULL, DB_BTREE, DB_THREAD | DB_CREATE, 0644) != 0) 
				qDebug("Error opening temp newsgroup");
			else qDebug("Migrating %s in %s", ng->getName().latin1(), tempName.latin1());
			oldDb->cursor(0, &headerCursor, 0); //No write cursor, read-only
			BinHeader *bh;
			memset(&key, 0, sizeof(key));
			memset(&data, 0, sizeof(data));
			key.set_flags(DB_DBT_MALLOC);
			data.set_flags(DB_DBT_MALLOC);
			int count =0;
			while (headerCursor->get(&key, &data, DB_NEXT ) == 0) {
				//Modify the item and put it into the new db...
				bh=new BinHeader((uchar*)data.get_data(), headerDbVersion);
				switch (headerDbVersion) {
					case 0:
						//Modify the binheader, adding part size
						for (bh->pnmit = bh->partNum.begin(); bh->pnmit != bh->partNum.end() ; ++(bh->pnmit)) {
							bh->partSize[bh->pnmit.key()] = 0;
						}
					case 1:
						//Do nothing, just save the articles with empty mid...
						
					case 2:
						//fill lowest for every server...
						for (bh->pnmit = bh->partNum.begin(); bh->pnmit != bh->partNum.end() ; ++(bh->pnmit)) {
							//for every part...
							for (bh->snmit = bh->pnmit.data().begin(); bh->snmit != bh->pnmit.data().end(); 	  ++(bh->snmit)) {
								//for every server in the part...
								if (bh->serverLowest.contains(bh->snmit.key()) ) {
									if ( bh->snmit.data() < bh->serverLowest[bh->snmit.key()] )
										bh->serverLowest[bh->snmit.key()] = bh->snmit.data();
								} else bh->serverLowest[bh->snmit.key()] = bh->snmit.data();
								
								
							}
						}
					case 3:
						//Do nothing, just save the articles with fields rearranged...
					case 4:
						//do nothing, save with size
						break;
				}
					
				
				
				//save in the new db
				free(data.get_data()); //Keep the key, it doesn't change...
				memset(&data, 0, sizeof(data));
				uchar *p=bh->data();
				data.set_data(p);
				data.set_size(bh->getRecordSize());
				newDb->put(0, &key, &data, 0);
				//Free memory and reset the key...
				delete p;
				delete bh;
				
				//Forgot to free key??
				free(key.get_data());
				memset(&key, 0, sizeof(key));
				key.set_flags(DB_DBT_MALLOC);
				memset(&data, 0, sizeof(data));
				data.set_flags(DB_DBT_MALLOC);
				count ++;
				//Now rename the new db...
				
				
				
			}
			headerCursor->close();
			qDebug("Migrated %d record(s)", count);
			//DO NOT DELETE newDb
			//Instructions for deleting/renaming Dbs are somewhat confusing...
			//Use this handle, tempdb, only for this purpose. Hope it works
			Db *tempDb;
			
			QString newName=ng->getName();
			delete ng; //should close and delete oldDb;
			tempDb=new Db(dbenv, 0);
			tempDb->remove(newName.latin1(), 0, 0);
			delete tempDb;
			tempDb = new Db(dbenv, 0);
			newDb->close(0);
			tempDb->rename(tempName.latin1(), 0, newName.latin1(), 0);
			delete tempDb;
			delete newDb;
			
			
			
			
		}

		groupCursor->close();
		groupDb->close(0);
		delete groupDb;
		
	}
	
#if INDEXDB_VERSION != 0	
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	data.set_flags(DB_DBT_MALLOC);
	
	uint indexDbVersion;
	const char *indexDbKey="INDEXDB";
	key.set_data((char*)indexDbKey);
	key.set_size(strlen(indexDbKey));
	ret=versionDb->get(0, &key, &data, 0);
	if (ret == DB_NOTFOUND)
		indexDbVersion=0;
	else if (ret == 0) {
		memcpy(&indexDbVersion, data.get_data(), sizeof(uint));
		free(data.get_data());
	} else {
		qDebug("Error retrieving index db version: %d", ret);
		return;
	}
	
	if (indexDbVersion != INDEXDB_VERSION) {
		kdDebug() << "Need indexdb migration/creation\n";
		Dbt key, data;
		Dbc *groupCursor, *headerCursor;
		Db *groupDb= new Db (dbenv, 0);
		if (groupDb->open(NULL, "newsgroups", NULL, DB_BTREE, DB_THREAD, 0644) !=0) {
			qDebug("Error opening groupdb!");
			return;
		} else qDebug("group db opened");
		//Now, for all the groups...
		groupDb->cursor(0, &groupCursor, 0); //No write cursor...
		
		memset(&key, 0, sizeof(key));
		memset(&data, 0, sizeof(data));
		key.set_flags(DB_DBT_MALLOC);
		data.set_flags(DB_DBT_MALLOC);
		NewsGroup *ng;
		while ( groupCursor->get(&key, &data, DB_NEXT) == 0 ) {
			BinHeader *bh;
			ng= new NewsGroup(dbenv, (char*)data.get_data());
			kdDebug() << "Creating index for " << ng->getName() << endl;
			free(data.get_data());
			free(key.get_data());
			memset(&key, 0, sizeof(key));
			memset(&data, 0, sizeof(data));
			key.set_flags(DB_DBT_MALLOC);
			data.set_flags(DB_DBT_MALLOC);
			ng->getDb()->cursor(0, &headerCursor, 0); //READ ONLY
			SIndex *si;
			//For every record in the group...
			char *p=NULL;
			while ( (ret=headerCursor->get(&key, &data, DB_NEXT )) == 0) {
				
				bh=new BinHeader((uchar*)data.get_data());
				free(key.get_data());
				free(data.get_data());
				//For every part...
				for (bh->pnmit = bh->partNum.begin(); bh->pnmit != bh->partNum.end() ; ++(bh->pnmit)) {
					//For every server in the part...
					for (bh->snmit=bh->pnmit.data().begin(); bh->snmit != bh->pnmit.data().end(); ++(bh->snmit)) {
						//key() is serverId, data() is article number
						//Build a SIndex...
						si = new SIndex;
						si->index=bh->getSubj()+bh->getFrom();
						si->partId=bh->pnmit.key();
						//Marshall it...
						p= new char[si->index.length() + 2*sizeof(int)];
						char *i = &p[0];
						i=insert(si->index, i);
						memcpy(&i, &(si->partId), sizeof(int));
						int artNum=bh->snmit.data();
						memset(&key, 0, sizeof(key));
						memset(&data, 0, sizeof(data));
						key.set_data(&artNum);
						key.set_size(sizeof(artNum));
						data.set_data(p);
						data.set_size(si->index.length() + 2 * sizeof(int));
						delete si;
						
						ret = ng->getSDb(bh->snmit.key())->put(0, &key, &data, 0);
						if (ret != 0)
							qDebug("Error putting record into index db: %s", dbenv->strerror(ret));
						
						delete p;

					}
				}
				memset(&key, 0, sizeof(key));
				key.set_flags(DB_DBT_MALLOC);
				memset(&data, 0, sizeof(data));
				data.set_flags(DB_DBT_MALLOC);
				delete bh;
				
				
				
			} if (ret != DB_NOTFOUND) {
				kdDebug() << "Failed to get BinHeader: " << dbenv->strerror(ret) << endl;
				exit(-1);
			}else kdDebug() << "Index created\n";
			//Finished scanning db...kdDebug() <<  
			headerCursor->close();
			delete ng;
			
		}
		groupCursor->close();
		groupDb->close(0);
		delete groupDb;
		
	}
	
#endif

	//Migration of the availablegroups db...
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	
	data.set_flags(DB_DBT_MALLOC);
	
	uint availableGroupsDbVersion;
	const char *availableGroupsDbKey="AVAILABLEGROUPSDB";
	key.set_data((char*) availableGroupsDbKey);
	key.set_size(strlen(availableGroupsDbKey));
	ret = versionDb->get(0, &key, &data, 0);
	if (ret == DB_NOTFOUND) {
		availableGroupsDbVersion = 0;
	} else if (ret == 0) {
		memcpy(&availableGroupsDbVersion, data.get_data(), sizeof(uint));
		free(data.get_data());
	} else {
		kdDebug() << "Error retrieving availabegroups version: " << ret << endl;
		exit(-1);
	}
	if (availableGroupsDbVersion != AVAILABLEGROUPSDB_VERSION) {
		//migrate!
		kdDebug() << "Need grouplist migration from version " << availableGroupsDbVersion << endl;
		Dbt aGroupsKey, aGroupsData;
		
		Group *g=0;
		Dbc *aGroupsCursor;
		Db *aGroupsDb = new Db(dbenv, 0);
		if (aGroupsDb->open(NULL, "availableGroups", NULL, DB_BTREE, DB_CREATE | DB_THREAD, 0644) != 0) {
			kdDebug() << "Error opening available groups db\n";
			exit(-1);
		}
		
		aGroupsDb->cursor(0, &aGroupsCursor, DB_WRITECURSOR);
		memset(&aGroupsKey, 0, sizeof(aGroupsKey));
		aGroupsKey.set_flags(DB_DBT_MALLOC);
		memset(&aGroupsData, 0, sizeof(aGroupsData));
		aGroupsData.set_flags(DB_DBT_MALLOC);
		QMap<int, bool>::iterator it;
		
		while (aGroupsCursor->get(&aGroupsKey, &aGroupsData, DB_NEXT) == 0) {
			switch (availableGroupsDbVersion) {
				case 0:
					g = new Group((char*)aGroupsData.get_data(), availableGroupsDbVersion);
					free(aGroupsData.get_data());
					for (it = g->serverPresence.begin(); it != g->serverPresence.end(); ++it) {
						g->setArticles(it.key(), 0);
					}
				default:
					break;
					
			}
			//Save the group.
			char *p = g->data();
			memset(&aGroupsData, 0, sizeof(aGroupsData));
			aGroupsData.set_data(p);
			aGroupsData.set_size(g->size());
			ret = aGroupsCursor->put(&aGroupsKey, &aGroupsData, DB_CURRENT);
			if (ret != 0)
				kdDebug() << "Error putting group:" << ret << endl;
			delete [] p;
			delete g;
			free(data.get_data());
			free(aGroupsKey.get_data());
			memset(&aGroupsKey, 0, sizeof(aGroupsKey));
			aGroupsKey.set_flags(DB_DBT_MALLOC);
			memset(&aGroupsData, 0, sizeof(aGroupsData));
			aGroupsData.set_flags(DB_DBT_MALLOC);
				
			
		}
		aGroupsCursor->close();
		aGroupsDb->close(0);
		delete aGroupsDb;
		
	}




	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	
	data.set_flags(DB_DBT_MALLOC);
	
	uint serverDbVersion;
	const char *serverDbKey="SERVERDB";
	key.set_data((char*)serverDbKey);
	key.set_size(strlen(serverDbKey));
	ret=versionDb->get(0, &key, &data, 0);
	
	if (ret == DB_NOTFOUND) {
		//Key not found -> db version is 0
		serverDbVersion=0;
	} else if (ret == 0) {
		//key found, set version...
		memcpy(&serverDbVersion, data.get_data(), sizeof(uint));
		free(data.get_data());
	} else {
		//Error!
		qDebug("Error retrieving version: %d", ret);
		return;
	}
	
	
	
	
	
	if (serverDbVersion != SERVERDB_VERSION) {
		kdDebug() << "Need serverDb migration: " << serverDbVersion << " -> " << SERVERDB_VERSION << endl;
		Dbt serverKey, serverData;
		NntpHost *nh;
		Dbc *serverCursor;
		Db *serverDb = new Db(dbenv, 0);
		if (serverDb->open(NULL, "servers" , NULL, DB_BTREE, DB_CREATE | DB_THREAD , 0644) != 0)
			qDebug("Error opening servers db");
		serverDb->cursor(0, &serverCursor, DB_WRITECURSOR);
		memset(&serverKey, 0, sizeof(serverKey));
		serverKey.set_flags(DB_DBT_MALLOC);
		memset(&serverData, 0, sizeof(serverData));
		serverData.set_flags(DB_DBT_MALLOC);
		char *p=NULL;
		while (serverCursor->get(&serverKey, &serverData, DB_NEXT) == 0 ) {
			switch (serverDbVersion) {
				case 0:
					//Add tries!
					//LOAD
					nh=loadHost((char*)serverData.get_data(), serverDbVersion);
					free(serverData.get_data());
					memset(&serverData, 0, sizeof(serverData));
						
						//Modify
					nh->retries=3;
						//SAVE
					p=saveHost(nh);
					serverData.set_data(p);
					serverData.set_size(::size(nh));
					serverCursor->put(&serverKey, &serverData, DB_CURRENT);
					free(p);
					free(serverKey.get_data());
					memset(&serverKey, 0, sizeof(serverKey));
					serverKey.set_flags(DB_DBT_MALLOC);
					memset(&serverData, 0, sizeof(serverData));
					serverData.set_flags(DB_DBT_MALLOC);
				default:
					break;
			}
		}
		serverCursor->close();
		serverDb->close(0);
		delete serverDb;
	}
	
	
	
	
	
	//Save the version Db...
	
	//For groupdb...
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	key.set_data((char *)groupDbKey);
	key.set_size(strlen(groupDbKey));
	int version=GROUPDB_VERSION;
	data.set_data(&version);
	data.set_size(sizeof(version));
	ret=versionDb->put(0, &key,&data, 0);
	if (ret != 0)
		qDebug("Error writing version db: %d", ret);
	
	//for headersdb...
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	key.set_data((char*) headerDbKey);
	key.set_size(strlen(headerDbKey));
	version=HEADERDB_VERSION;
	data.set_data(&version);
	data.set_size(sizeof(version));
	ret=versionDb->put(0, &key,&data, 0);
	if (ret != 0)
		qDebug("Error writing version db: %d", ret);


#if INDEXDB_VERSION != 0
		
	//For indexDb...
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	key.set_data((char*)indexDbKey);
	key.set_size(strlen(indexDbKey));
	version=INDEXDB_VERSION;
	data.set_data(&version);
	data.set_size(sizeof(version));
	ret=versionDb->put(0, &key, &data, 0);
	if (ret != 0)
		qDebug("Error writing version db: %d", ret);
#endif
	//for availablegroupsdb...
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	key.set_data((char*) availableGroupsDbKey);
	key.set_size(strlen(availableGroupsDbKey));
	version = AVAILABLEGROUPSDB_VERSION;
	data.set_data(&version);
	data.set_size(sizeof(version));
	ret = versionDb->put(0, &key, &data, 0);
	if (ret != 0)
		kdDebug() << "Error writing version db: " << ret << endl;
	
	//for serversDb...
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	key.set_data((char*) serverDbKey);
	key.set_size(strlen(serverDbKey));
	version=SERVERDB_VERSION;
	data.set_data(&version);
	data.set_size(sizeof(version));
	ret=versionDb->put(0, &key, &data, 0);
	if (ret != 0)
		kdDebug() << "Error writing version db: " << ret << endl;
	
	
	versionDb->close(0);
	delete versionDb;

}
QStatusServerWidget::QStatusServerWidget( QString serverName, QWidget * parent, const char * name, WFlags fl ) : QWidget(parent, name, fl)
{
	m_sName = serverName;
	QHBoxLayout *layout = new QHBoxLayout(this);
	layout->setSpacing(3);
	iLabel = new QLabel(this);
	icon = new QPixmap(KGlobal::iconLoader()->loadIcon("icon_server", KIcon::Small, 0, false));
	iLabel->setPixmap(*icon);
	
	sLabel = new QLabel(this);
	sLabel->setText(m_sName + ": Disconnected");
	layout->addWidget(iLabel);
	layout->addWidget(sLabel);
	
}


void QStatusServerWidget::updateSpeed( int speed )
{
	if (speed == -1) {
		//Idle
		sLabel->setText(m_sName + ": Idle");
	} else if (speed == -2) {
		//Disconnected
		sLabel->setText(m_sName + ": Disconnected");
	} else {
		sLabel->setText(m_sName + ':' + QString::number(speed) + " KB/s");
		
	}
}


QToolbarWidget::QToolbarWidget( QWidget * parent, const char * name, WFlags fl ) : QWidget (parent, name, fl)
{
	QHBoxLayout *layout = new QHBoxLayout(this);
	layout->setSpacing(3);
	tLabel=new QLabel(this);
	pLabel=new QLabel(this);
	tIcon=new QPixmap(KGlobal::iconLoader()->loadIcon("queue",KIcon::Small , 0, false));
	
	pLabel->setPixmap(*tIcon);
	tLabel->setText(" 0 items, 0 KB");
	layout->addWidget(pLabel);
	layout->addWidget(tLabel);
	
	
}

void QToolbarWidget::slotQueueInfo( unsigned long long  count, unsigned long long size )
{
	QString sSize=QString::number((unsigned long long)(double(size)/1024));
	uint i = 1;
	uint l = sSize.length();
// 	qDebug("Size length: %d", l);
	//format the number
	while ( l > 3*i ) {
		sSize.insert(sSize.length() - ((3*i) + i - 1), '.');
		++i;
		
	}
	
	tLabel->setText(QString::number(count) + " items, " + sSize + " KB");
}


void klibido::slotShortcutsConfigure( )
{
	KKeyDialog::configure(actionCollection(), this);
}

void klibido::closeEvent( QCloseEvent * e )
{
	if (qMgr->empty())
		e->accept();
	else {
		int result=KMessageBox::questionYesNo(this, i18n("The download queue is not empty. Are you sure you want to quit?"), i18n("question"));
		switch (result) {
			case KMessageBox::Yes:
				e->accept();
				break;
			case KMessageBox::No:
				break;
		}
	}
}

void klibido::slotQPaused( bool paused)
{
	KToggleAction *actionQ=(KToggleAction*)actionCollection()->action("pause_queue");
	if (paused) {
		//Check the item, and show a statusbar message
		actionQ->setChecked(true);
		actionQ->setText("Resume Queue");
		actionQ->setIconSet(KGlobal::iconLoader()->loadIcon("connect_no",KIcon::Toolbar, 0, false));
		statusBar()->message(i18n("Queue Paused"));
	} else {
		actionQ->setChecked(false);
		actionQ->setText("Resume Queue");
		actionQ->setIconSet(KGlobal::iconLoader()->loadIcon("connect_established",KIcon::Toolbar, 0, false));
		//now resume the queue
		qMgr->pauseQ(false);
		statusBar()->message(i18n("Queue resumed"));
	}
	
	
}

void klibido::slotHaveServers( bool haveServers)
{
	
	if (haveServers)
		stateChanged("no_server", StateReverse);
	else stateChanged("no_server");
	
				
}

void klibido::closeView( KMdiChildView *v )
{
	closeWindow(v);
}

void klibido::slotCompactDbs( )
{
	switch(KMessageBox::questionYesNo(this, i18n("Compacting the newsgroups databases can be very lenghty.\nAll the views will be closed. Are you sure you want to continue?"), i18n("Do you want to compact the databases?"))) {
		case KMessageBox::No:
			return;
			break;
	}
	if (!qMgr->empty()) {
		KMessageBox::error(this, i18n("Can compact databases only when the download queue is empty"), i18n("Error!"));
		return;
	}
	
	//Close all the Windows (Except the qmgr, of course)
	groupList->markAllGroupAsUpdating();
	closeAllViews();
	enable(false);
	

emit sigCompact();
	enable(true);
}

void klibido::slotUpdateCurrent( )
{
	NewHeaderList *activeGroup=(NewHeaderList *)activeWindow();
	groupList->updateCurrent(activeGroup->getNg());
	
	
}


bool klibido::dbsExists(QString dbDir)
{
  QString dir = QDir::cleanDirPath(dbDir);

  if (!QFile::exists(QString("%1/availableGroups").arg(dir)) ||
      !QFile::exists(QString("%1/newsgroups").arg(dir)) ||
      !QFile::exists(QString("%1/nzb").arg(dir)) ||
      !QFile::exists(QString("%1/queue").arg(dir)) ||
      !QFile::exists(QString("%1/servers").arg(dir)) ||
      !QFile::exists(QString("%1/versiondb").arg(dir)))
    return false;


  return true;
}

void klibido::createDbs()
{
    qDebug("Create dbs...");
    //Create the version Db...probably not needed with the new exec path provided by Gonéri, but
	//it shouldn't do any harm :)
		if (!dbenv)
			setupDbEnv(Config().dbDir);
		else kdDebug() << "slotSettingsConfigure(): Dbenv already opened\n";
		Db *versionDb=new Db(dbenv, 0);
		if (versionDb->open(NULL, "versiondb" , NULL, DB_BTREE, DB_CREATE | DB_THREAD , 0644) != 0)
			qDebug("Error opening versiondb");
	//Keys, data have fixed size:
	//DATA is a uint
	//KEY is one of GROUPDB, AVAILABLEGROUPSDB, HEADERDB
		Dbt key,data;
		
		
		uint groupDbVersion;
		groupDbVersion=GROUPDB_VERSION;
		data.set_data(&groupDbVersion);
		data.set_size(sizeof(uint));
			//,availableGroupsDbVersion, headersDbVersion;
		int ret;
		
		//Put groupDb version in versionDb
		const char *groupDbKey="GROUPDB";
		key.set_data((char *)groupDbKey);
		key.set_size(strlen(groupDbKey));
		ret=versionDb->put(0, &key, &data, 0);
		if (ret != 0) {

			qDebug("Error putting groupdb version: %s", dbenv->strerror(ret));
		
		}
		
		//put headerDb version in versionDb
		memset(&key, 0, sizeof(key));
// 		key.set_flags(DB_DBT_MALLOC);
		memset(&data, 0, sizeof(data));
// 		data.set_flags(DB_DBT_MALLOC);
		//I could use groupDbVersion, but it's better to create a properly named local
		//variable to avoid confusion...
		uint headerDbVersion;
		headerDbVersion=HEADERDB_VERSION;
		data.set_data(&headerDbVersion);
		data.set_size(sizeof(uint));
	
		const char *headerDbKey="HEADERDB";
		key.set_data((char*)headerDbKey);
		key.set_size(strlen(headerDbKey));
		ret=versionDb->put(0, &key, &data, 0);
		if (ret != 0) {
			qDebug("Error putting headerdb version: %s", dbenv->strerror(ret));
		}
		
		//availablegroupsdbkey...
		memset(&data, 0, sizeof(data));
		uint availableGroupsDbVersion = AVAILABLEGROUPSDB_VERSION;
		data.set_data(&availableGroupsDbVersion);
		data.set_size(sizeof(uint));
		const char *aGroupsDbKey="AVAILABLEGROUPSDB";
		key.set_data((char*)aGroupsDbKey);
		key.set_size(strlen(aGroupsDbKey));
		ret=versionDb->put(0, &key, &data, 0);
		if (ret != 0)
			kdDebug() << "Error putting agroupsdb version: " << ret << endl;
		
		
		//serverdb key...
		memset(&key, 0, sizeof(key));
		memset(&data, 0, sizeof(data));
		uint serverDbVersion = SERVERDB_VERSION;
		data.set_data(&serverDbVersion);
		data.set_size(sizeof(uint));
		const char *serverDbKey="SERVERDB";
		key.set_data((char*)serverDbKey);
		key.set_size(strlen(serverDbKey));
		ret=versionDb->put(0, &key, &data, 0);
		if (ret != 0)
			kdDebug() << "Error putting serverdb version: " << ret << endl;
		
		
		
		
		
		versionDb->close(0);
		delete versionDb;
		versionDb=0;

}

void klibido::slotPopupTabMenu( QWidget *w, const QPoint &p )
{
//  	qDebug("Widget: %s", (const char *) tabWidget()->label(w));
// 	KMdiChildView *v = w;
	int i = tabWidget()->indexOf(w);
	qDebug("Index: %d", i);
	KMdiChildView *v = dynamic_cast<KMdiChildView*>(tabWidget()->page(i));
	if (v)
		slotPopupWindowMenu(p, v);
}

void klibido::slotCloseWindow()
{
	if (activeWindow()) {
		activeWindow()->close();
		
	}

}

void klibido::slotCloseAndMark(KMdiChildView *v )
{
	FileViewer *fv = dynamic_cast<FileViewer*>(v);
	NewHeaderList *hl = dynamic_cast<NewHeaderList*>(v);
	if (fv)
		fv->closeAndDelete();
	else if (hl)
		hl->closeAndMark();
		
	
}



void klibido::slotCloseAndNoMark(KMdiChildView *v )
{
	FileViewer *fv = dynamic_cast<FileViewer*>(v);
	NewHeaderList *hl = dynamic_cast<NewHeaderList*>(v);
	if (fv)
		fv->closeNoDelete();
	else if (hl)
		hl->closeAndNoMark();
	
	
}




void klibido::slotCloseAll( )
{
}

WPopupMenu::WPopupMenu( QWidget *p, QString title, KMdiChildView * hl ) :  KPopupMenu(p), m_hList(hl), m_title(title)
{
	insertTitle(m_title);
	
	NewHeaderList *hList = dynamic_cast<NewHeaderList*>(m_hList);
	FileViewer *fViewer = dynamic_cast<FileViewer*>(m_hList);
	if (hList) {
		insertItem("Close", this, SLOT(slotCloseWindow()));
		connect(this, SIGNAL(sigCloseWindow(KMdiChildView* )), p, SLOT(slotCloseWindow(KMdiChildView*)));
		insertItem(i18n("Close and mark as read"), this, SLOT(slotCloseAndMark()));
		connect(this, SIGNAL(sigCloseAndMark(KMdiChildView*)), p, SLOT(slotCloseAndMark(KMdiChildView*)));
		insertItem(i18n("Close and don't mark as read"), this, SLOT(slotCloseAndNoMark()));
		connect(this, SIGNAL(sigCloseAndNoMark(KMdiChildView*)), p, SLOT(slotCloseAndNoMark(KMdiChildView*)));
		
	}  else if (fViewer) {
		if (!Config().singleViewTab) {
			insertItem("Close", this, SLOT(slotCloseWindow()));
			connect(this, SIGNAL(sigCloseWindow(KMdiChildView* )), p, SLOT(slotCloseWindow(KMdiChildView*)));
			insertItem(i18n("Close and delete"), this, SLOT(slotCloseAndMark()));
			connect(this, SIGNAL(sigCloseAndMark(KMdiChildView*)), p, SLOT(slotCloseAndMark(KMdiChildView*)));
			insertItem(i18n("Close and don't delete"), this, SLOT(slotCloseAndNoMark()));
			connect(this, SIGNAL(sigCloseAndNoMark(KMdiChildView*)), p, SLOT(slotCloseAndNoMark(KMdiChildView*)));
		}
	}
	
	
}

void klibido::slotCloseWindow( KMdiChildView *v )
{
	if (v)
		v->close();
}

void WPopupMenu::slotCloseWindow( )
{
	emit sigCloseWindow(m_hList);
}


void WPopupMenu::slotCloseAndMark( )
{
	emit sigCloseAndMark(m_hList);
}

void WPopupMenu::slotCloseAndNoMark( )
{
	emit sigCloseAndNoMark(m_hList);
}


void klibido::slotWMenuActivated( int id )
{
	qDebug("Activated: %d", id);
	
	if (wMenu->idAt(0) != id) {
		switch (id) {
			case 1000:
				slotCloseWindow(activeWindow());
				break;
			case 1001:
				slotCloseAndMark(activeWindow());
				break;
			case 1002:
				slotCloseAndNoMark(activeWindow());
				break;
			default:
				activateView(id);
				break;
		}
	}
	
}

/*
void klibido::childWindowCloseRequest( KMdiChildView * pWnd )
{
// 	int index = tabWidget()->indexOf(pWnd);
// 	wMenu->removeItem(index);
	KMdiMainFrm::childWindowCloseRequest(pWnd);
}*/

void klibido::slotAboutToShow( )
{
// 	qDebug("About to show");
// 	for (int i = 1; i < wMenu->count(); i++)
// 		wMenu->removeItemAt(i);
	wMenu->clear();
	closeAction->plug(wMenu);
	
	KMdiChildView *view=activeWindow();
	FileViewer *fv = dynamic_cast<FileViewer*>(view);
	NewHeaderList *hl = dynamic_cast<NewHeaderList*>(view);
// 	wMenu->insertItem(KGlobal::iconLoader()->loadIcon("fileclose",KIcon::Toolbar, 0, false), i18n("Close"), 
// 					  1000, -1);
// 	wMenu->setAccel(CTRL + Key_W, 1000);
	if (activeWindow() == qMgr) {
// 		wMenu->setItemEnabled(1000, false);
		wMenu->setItemEnabled(wMenu->idAt(0), false);
		wMenu->insertSeparator();
	} else if (hl) {
		
// 		qDebug("HeaderList active: %s", (const char *) hl->caption());
		wMenu->insertItem(i18n("Close and mark as read"), 1001, -1);
		wMenu->insertItem(i18n("Close and don't mark as read"),1002, -1);
		wMenu->insertSeparator();
		wMenu->setItemEnabled(wMenu->idAt(0), true);
	} else if (fv ) {
// 		qDebug("FileViewer active?");
		if (!Config().singleViewTab) {
			wMenu->insertItem(i18n("Close and delete"), 1001, -1);
			wMenu->insertItem(i18n("Close and don't delete"), 1002, -1);
			wMenu->setItemEnabled(wMenu->idAt(0), true);
		} else wMenu->setItemEnabled(wMenu->idAt(0), false);
		wMenu->insertSeparator();
	} else {
		wMenu->setItemEnabled(wMenu->idAt(0), true);
	}
// 	wMenu->insertItem("0 Queue manager", 0, -1);
	KMdiIterator< KMdiChildView * > *wIt =  createIterator ();
	for (wIt->first(); !wIt->isDone(); wIt->next()) {
// 		qDebug("Caption: %s", (const char *) wIt->currentItem()->caption());
		int index = tabWidget()->indexOf(wIt->currentItem());
		wMenu->insertItem(QString::number(index) + ' ' + wIt->currentItem()->caption(), index, -1);
		
	}
	
}

void klibido::slotCloseActiveView( )
{


	if (activeWindow())
		closeWindow(activeWindow());
}

void klibido::slotUpdateSpeed( int serverId, int speed)
{
	sWidgets[serverId]->updateSpeed(speed);
}

void klibido::slotDeleteServerWidget( int serverId)
{
	delete(sWidgets[serverId]);
	sWidgets.remove(serverId);
}

void klibido::slotAddServerWidget( NntpHost *nh )
{
	//I want the queue widget to be the at the far right...
	statusBar()->removeWidget(qTWidget);
	sWidgets[nh->id] = new QStatusServerWidget(nh->name, this);
	statusBar()->addWidget(sWidgets[nh->id], 0, true);
	statusBar()->addWidget(qTWidget, 0, true);
	
}


#include "klibido.moc"
