/***************************************************************************
                          klineakpreferences.cpp  -  description
                             -------------------
    begin                : Fri Jul 26 2002
    copyright            : (C) 2002 by Sheldon Lee Wen
    email                : leewsb@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qlayout.h>

#include <klocale.h>
#include <kglobal.h>
#include <kmessagebox.h>
#include <qmessagebox.h>
#include <kprocess.h>
#include <qlayout.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qcstring.h>
#include <qvariant.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <kgenericfactory.h>
#include <iostream>
#include <dcopclient.h>
#include <klineakpreferencesui.h>
#include "klprefs.h"
#include "klineakpreferences.h"
#include <lineak/lineak_core_functions.h>

using namespace std;

KlineakPreferences::KlineakPreferences(QWidget *parent, const char *name ) : KlineakPreferencesUI(parent,name) {
	if (KLPrefs::instance()->mLEDs) {
    	chkLeds->setChecked(true);
        startLeds();
	}
    if (KLPrefs::instance()->mLineakAtExit == "Yes")
		chkRunLineakAtExit->setChecked(true);
	else
		chkRunLineakAtExit->setChecked(false);
		
    if (KLPrefs::instance()->mKkeyledAtExit == "Yes")
		chkRunKkeyledAtExit->setChecked(true);
	else
		chkRunKkeyledAtExit->setChecked(false);

	txtContributeEmail->setText(KLPrefs::instance()->mContribEmail);
}

KlineakPreferences::~KlineakPreferences(){
}
/** Triggered when the user clicks the LED's check box. */
void KlineakPreferences::slotchkLeds(){
        if (chkLeds->isChecked()) {
                 KLPrefs::instance()->mLEDs = true;
                 startLeds();
        }
        else {
                 KLPrefs::instance()->mLEDs = false;
                 stopLeds();
        }
         KLPrefs::instance()->writeConfig();
}
/** Triggered when the user enters text into the Contribute Email box */
void KlineakPreferences::slotContributeEmail(const QString &email){
	KLPrefs::instance()->mContribEmail = email;
}
/** Triggered when the user clicks the OK button */
void KlineakPreferences::slotBtnOK(){
         KLPrefs::instance()->writeConfig();
         if (isVisible())
         	hide();
}
/** Triggered when the user clicks the OK button */
void KlineakPreferences::slotBtnDefaults(){
    	KLPrefs::instance()->setDefaults();
        KLPrefs::instance()->usrSetDefaults();
        chkLeds->setChecked(KLPrefs::instance()->mLEDs);
        txtContributeEmail->setText(KLPrefs::instance()->mContribEmail);
}
/** Starts kkeyled */
void KlineakPreferences::startLeds(){
        leds.clearArguments();
        leds << "kkeyled";
        leds.start(KProcess::DontCare);
        if (!leds.isRunning())
        {
                        QMessageBox::information(0, "KlineakControl", i18n(
                        "WARNING: KlineakControl could not start the keyboard led display (kkeyled)!\n"));
                        cout << "Failed to start kkeyled" << endl;
        }

}
/** Stops kkeyled */
void KlineakPreferences::stopLeds(){
	// Use pcontrol to kill the process. kkeyled forks itself into the background do KProcess contains the wrong PID.
	if (lineak_core_functions::is_running("kkeyled")) {
		cout << "Should kill kkeyled here!" << endl;
		DCOPClient *dcop = new DCOPClient();
		dcop->registerAs("klineakconfig");
		dcop->attach();
		QByteArray data;
		dcop->send("kkeyled", "MainApplication-Interface", "quit()", data);
		//leds.normalExit();
	}
	
}

/** User toggled Run Lineakd after exit checkbox. */
void KlineakPreferences::slotRunLineakd(){
        if (chkRunLineakAtExit->isChecked())
                 KLPrefs::instance()->mLineakAtExit = "Yes";
        else 
                 KLPrefs::instance()->mLineakAtExit = "No";

         KLPrefs::instance()->writeConfig();
}
/** User toggled Run kkeyled after exit button. */
void KlineakPreferences::slotRunKkeyled(){
        if (chkRunKkeyledAtExit->isChecked())
                 KLPrefs::instance()->mKkeyledAtExit = "Yes";
        else 
                 KLPrefs::instance()->mKkeyledAtExit = "No";

         KLPrefs::instance()->writeConfig();
}
