/***************************************************************************
                          adif.cpp  -  description
                             -------------------
    begin                : vie mar 7 2003
    copyright            : (C) 2003 by Jaime Robles
    email                : jaime@kde.org
 ***************************************************************************/

/******************************************************************************
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
*  it under the terms of the GNU General Public License as published by     *
*  the Free Software Foundation; either version 2 of the License, or        *
*  (at your option) any later version.                                      *
 *                                                                            *
*  This program is distributed in the hope that it will be useful,          *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the            *
*  GNU General Public License for more details.                             *
 *                                                                            *
*  You should have received a copy of the GNU General Public License        *
*  along with this program; if not, write to the Free Software              *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*
 *****************************************************************************/

#include <klocale.h>
//#include <kdebug.h>
//#include <ostream.h>
#include "adif.h"


Adif::Adif(){

};

Adif::~Adif(){};


int Adif::band2Int(const QString& tband){
  sAux = tband;
   if (tband == "2M"){
     return 0;
  }else if (tband == "6M"){
    return 1;
  }else if (tband == "10M"){
    return 2;
  }else if (tband == "12M"){
    return 3;
  }else if (tband == "15M"){
    return 4;
  }else if (tband == "17M"){
    return 5;
  }else if (tband == "20M"){
    return 6;
  }else if (tband == "30M"){
    return 7;
  }else if (tband == "40M"){
    return 8;
  }else if (tband == "80M"){
    return 9;
  }else if (tband == "160M"){
    return 10;
  }else if (tband == "2190M"){
    return 11;
  }else if (tband == "70CM"){
    return 12;
  }else if (tband == "23CM"){
    return 13;
  }else if (tband == "13CM"){
    return 14;
  }else{
    return -1;
    // If Band is not in this "list" it is still not supported
  }
};

int Adif::mode2Int(const QString& tmode){
  sAux = tmode;
    if (sAux == "SSB"){
    return 0;
  }else if (sAux == "CW"){
    return 1;
  }else if (sAux == "FM"){
    return 2;
  }else if (sAux == "PSK31"){
    return 3;
  }else if (sAux == "SSTV"){
    return 4;
  }else if (sAux == "RTTY"){
    return 5;
  }else if (sAux == "MTTY"){
    return 6;
  }else if (sAux == "PKT"){
    return 7;
  }else if (sAux == "AM"){
    return 8;
  }else if (sAux == "FAX"){
    return 9;
  }else if (sAux == "HELL"){
    return 10;
  }else if (sAux == "JT44"){
    return 11;
  }else if (sAux == "MT63"){
    return 12;
  }else if (sAux == "CLO"){
    return 13;
  }else if (sAux == "TOR"){
    return 14;
  }else if (sAux == "GTOR"){
    return 15;
  }else if (sAux == "FSK"){
    return 16;
  }else if (sAux == "MFSK8"){
    return 17;
  }else if (sAux == "MFSK16"){
    return 18;
  }else if (sAux == "HFSK"){
    return 19;
  }else if (sAux == "ATV"){
    return 20;
  }else if (sAux == "PAC"){
    return 21;
  }else if (sAux == "PAC2"){
    return 22;
  }else if (sAux == "PAC3"){
    return 23;
  }else if (sAux == "PCW"){
    return 24;
  }else if (sAux == "PSK63"){
    return 25;
  }else if (sAux == "PSK125"){
    return 26;
  }else if (sAux == "Q15"){
    return 27;
  }else if (sAux == "THRB"){
    return 28;
  }else if (sAux == "ASCI"){
    return 29;
  }else{return -1;}
};

int Adif::freq2Int (const QString& tfreq){
   sAux = tfreq;
   sAux.remove((sAux.length())-5,5);
   if (sAux == "144"){
     return 0;
  }else if (sAux == "145"){
     return 0;
  }else if (sAux == "50"){
    return 1;
  }else if (sAux == "51"){
    return 1;
  }else if (sAux == "52"){
    return 1;
  }else if (sAux == "28"){
    return 2;
  }else if (sAux == "29"){
    return 2;
  }else if (sAux == "24"){
    return 3;
  }else if (sAux == "21"){
    return 4;
  }else if (sAux == "18"){
    return 5;
  }else if (sAux == "14"){
    return 6;
  }else if (sAux == "10"){
    return 7;
  }else if (sAux == "7"){
    return 8;
  }else if (sAux == "3"){
    return 9;
  }else if (sAux == "1"){
    return 10;
  }else if (sAux == "2190"){
    return 11;
  }else if (sAux == "70"){
    return 12;
  }else if (sAux == "23"){
    return 13;
  }else if (sAux == "13"){
    return 14;
  }else{
    return -1;
    // If Band is not in this "list" it is still not supported
  }   

};

QString Adif::freq2Band (const QString& tfreq){
  return int2Band(freq2Int(tfreq.left(tfreq.find("."))));
};

QString Adif::int2Band(int tband){
   if (tband == 0){
     return "2M";
  }else if (tband == 1){
    return "6M";
  }else if (tband == 2 ){
    return "10M";
  }else if (tband == 3){
    return "12M";
  }else if (tband == 4){
    return "15M";
  }else if (tband == 5){
    return "17M";
  }else if (tband == 6){
    return "20M";
  }else if (tband == 7){
    return "30M";
  }else if (tband == 8){
    return "40M";
  }else if (tband == 9){
    return "80M";
  }else if (tband == 10){
    return "160M";
  }else if (tband == 11){
    return "2190M";
  }else if (tband == 12){
    return "70CM";
  }else if (tband == 13){
    return "23CM";
  }else if (tband == 14){
    return "13CM";
  }else{
    return "";
    // If Band is not in this "list" it is still not supported
  }

};

bool Adif::isHF(const QString& tfreq){
  // If i don't recognice if true/false i set FALSE (To help DX-Cluster SH/DX commands)
  if (freq2Int(tfreq) == 0){ //2m
     return false;
  }else if (freq2Int(tfreq) == 1){ //6m
    return false;
  }else if (freq2Int(tfreq) == 2 ){//10m
    return true;
  }else if (freq2Int(tfreq) == 3){ //12m
    return true;
  }else if (freq2Int(tfreq) == 4){//15m
    return true;
  }else if (freq2Int(tfreq) == 5){ //17m
    return true;
  }else if (freq2Int(tfreq) == 6){ //20m
    return true;
  }else if (freq2Int(tfreq) == 7){ //30m
    return true;
  }else if (freq2Int(tfreq) == 8){ //40m
    return true;
  }else if (freq2Int(tfreq) == 9){//80m
    return true;
  }else if (freq2Int(tfreq) == 10){//160m
    return true;
  }else if (freq2Int(tfreq) == 11){//2190m
    return true;
  }else if (freq2Int(tfreq) == 12){//70cm
    return false;
  }else if (freq2Int(tfreq) == 13){ //23cm
    return false;
  }else if (freq2Int(tfreq) == 14){ //13cm
    return false;
  }else{
    return false;
  }  
};

bool Adif::isVHF(const QString& tfreq){
  // I return FALSE as a default
  if (freq2Int(tfreq) == 0){ //2m
     return true;
  }else if (freq2Int(tfreq) == 1){ //6m
    return true;
  }else if (freq2Int(tfreq) == 2 ){//10m
    return false;
  }else if (freq2Int(tfreq) == 3){ //12m
    return false;
  }else if (freq2Int(tfreq) == 4){//15m
    return false;
  }else if (freq2Int(tfreq) == 5){ //17m
    return false;
  }else if (freq2Int(tfreq) == 6){ //20m
    return false;
  }else if (freq2Int(tfreq) == 7){ //30m
    return false;
  }else if (freq2Int(tfreq) == 8){ //40m
    return false;
  }else if (freq2Int(tfreq) == 9){//80m
    return false;
  }else if (freq2Int(tfreq) == 10){//160m
    return false;
  }else if (freq2Int(tfreq) == 11){//2190m
    return false;
  }else if (freq2Int(tfreq) == 12){//70cm
    return true;
  }else if (freq2Int(tfreq) == 13){ //23cm
    return true;
  }else if (freq2Int(tfreq) == 14){ //13cm
    return true;
  }else{
    return false;
  }

};
