#ifndef __CLIENTWCLASS
#define __CLIENTWCLASS

class QToolBar;
class QFrame;
class QKeyEvent;
class QPaintEvent;
class QScrollBar;
class QRect;
class MainWidget;
class NetWidget;
class QMainWindow;

//************ class *************
class ClientW : public QFrame
{	Q_OBJECT
public:
	ClientW(MainWidget *, const char *file);
	ClientW(MainWidget *, XDeviceNet *);
	ClientW(QFrame *, int);
	~ClientW();

	NetWidget *net();
	void show();
	void closeEvent(QCloseEvent *);

public slots:
	void hScroll(int);
	void vScroll(int);
	void up();
	void netChange(int);

signals:
	void visibleChanged(QRect);

private:
	void commonConstruct();
	void keyPressEvent(QKeyEvent *);
	void paintEvent(QPaintEvent *);
	void setWidgets();

	bool main_client;

	QScrollBar *hscroll;
	QScrollBar *vscroll;

	QFrame *netframe;
	NetWidget *netwidget;
	MainWidget *mainwidget;
	QToolBar *toolbar;
	QRect logicBase;
	QRect logicPos;
	XDeviceNet *m_devnet;
};
#endif
