#ifndef __GRID_H
#define __GRID_H

//*************************************************************************
//* singleton grid object                                                 *
//*************************************************************************
class Grid
{
	//=====================================================================
	//== constructor/destructor/initializing                             ==
	//=====================================================================
	public: 					Grid();

	//-- creates the grid in an image buffer
	private:	static 	void	init();

	//=====================================================================
	//== grid alignment                                                  ==
	//=====================================================================
	public:		static 	QPoint 	getAligned(	QPoint );
	public:		static 	QRect  	getAligned(	QRect  );

	//=====================================================================
	//== painting                                                        ==
	//=====================================================================
	//-- paints background and grid for entire virtual screen
	public:		static	void 	draw( QPainter* );

	//-- paints the grid for the former position of an object
	public:		static	void 	draw( QPainter*, QRect );

	//=====================================================================
	//== class constants                                                 ==
	//=====================================================================
	//-- prevent shadows in conjunction with klogic.h
	#undef GRID
	#undef GRIDHALF
	#undef GRIDDOUBLE
	public:		static 	const int GRID			= 10;
	public:		static 	const int GRIDHALF		= GRID / 2;
	public:		static 	const int GRIDDOUBLE	= GRID * 2;

	//=====================================================================
	//== class variables                                                 ==
	//=====================================================================
	//-- saves the background and grid of entire virtual screen
	private:	static 	QImage	m_oGrid;
};

#endif
