/*************************************************/
/* old methods for classes XDeviceNet XDevice,   */
/* Device and XWire                              */
/*************************************************/
#include <qfile.h>
#include <qtextstream.h>
#include <qregexp.h>
#include <qstring.h>
#include <qpoint.h>
#include <qpaintdevice.h>

#include "klogic.h"
#include "klogicIO.h"
#include "netw.h"
#include "xnet.h"
#include "xwire.h"
#include "deviceTypes.h"
#include "deviceOsc.h"

/***************************************************/
/* import/export operations on a net-widget        */
/***************************************************/

QString XDeviceNet::exportInstance()
{	QString buf;

	QString s = device2string(0, 0);

	// very new version, magic id ;-|
	buf.sprintf("%c%d", DLM, 1300);
	s += buf;
 
	return s;
}

// export all wires of this net
// to export only the selected objects, call with selonly=1
QString XDeviceNet::exportWires(int selonly, int dx, int dy)
{
	KlogicList<XWire> *lw = netwire.First();
	QString s, ws;

	while(lw) {
		if ((selonly && lw->Get()->isSelected()) || (!selonly)) {
			if (!s.isEmpty()) s += "\n";
			// name of wire
			ws.sprintf("\t%d%c", lw->Get()->getID(), DLM);
			s += ws;
			// nodes of wire
			lw->Get()->setExportSelected(selonly);
			lw->Get()->setExportDelta(dx, dy);
			*(lw->Get()) >> s;
		}
		lw = lw->Next();
	}
	return s;
}

// to export only the selected objects, call with selonly=1
QString XDeviceNet::exportDevices(int selonly, int dx, int dy)
{
	KlogicList<XDevice> *ld = netdev.First();
	XDevice *d;
	QString s="";

	while(ld) {
		d = ld->Get();
		if ((selonly && d->isSelected()) || (!selonly)) {
			if (!s.isEmpty()) s.append("\n");
			s =  s + d->device2string(dx, dy);
		}
		ld = ld->Next();
	}
	return s;
}

// to export only the selected objects, call with selonly=1
QString XDeviceNet::exportWireConn(int selonly, int dx, int dy)
{
	KlogicList<XWire> *lw = netwire.First();
	XWire *w;
	QPoint pi, po;
	QString s="";
	QString ws;

	while(lw) {
		w = lw->Get();
		if ((selonly && w->isSelected()) || (!selonly)) {
			pi = w->getIOPosition(1, selonly);
			po = w->getIOPosition(0, selonly);
			if ((!pi.isNull()) || (!po.isNull())) {
				if (!s.isEmpty()) s += "\n";
				s += "\t";
				ws.sprintf("%d", w->getID());
				s += ws;
				if (!pi.isNull()) {
					ws.sprintf("%c%d%c%d%c%d",
						DLM,
						w->ioWire(1)->getID(),
						DLM,
						pi.x() - dx,
						DLM,
						pi.y() - dy);
					s = s + ws;
				}
				if (!po.isNull()) {
					if (!pi.isNull()) {
						s += "\n\t";
						ws.sprintf("%d", w->getID());
						s += ws;
					}
					ws.sprintf("%c%d%c%d%c%d",
						DLM,
						w->ioWire(0)->getID(),
						DLM,
						po.x() - dx,
						DLM,
						po.y() - dy);
					s = s + ws;
				}
			}
		}
		lw = lw->Next();
	}
	return s;
}

// to export only the selected objects, call with selonly=1
QString XDeviceNet::exportDevConn(int selonly, int dx, int dy)
{
	KlogicList<XWire> *lw = netwire.First();
	XDevice *d;
	XWire *w;
	QString s="", ds="";
	QPoint pi1, pi2, po1, po2;

	while(lw) {
		w = lw->Get();
		if ((selonly && w->isSelected()) || (!selonly)) {
			pi1 = w->getInputPosition(0, selonly);
			pi2 = w->getInputPosition(1, selonly);
			po1 = w->getOutputPosition(0, selonly);
			po2 = w->getOutputPosition(1, selonly);
			// maximum of 2 points
			if (!pi1.isNull() || !pi2.isNull() || !po1.isNull() || !po2.isNull()) {
				if (!s.isEmpty()) s = s + "\n";
				s += "\t";
				ds.sprintf("%d", w->getID());
				s += ds;

				if (!pi1.isNull()) {
					d = w->inputDevice(0);
					ds.sprintf("%c%d%c%d%c%d%c%d",
							DLM,
							d->getID(),
							DLM,
							w->inputIsInverted(d),
							DLM,
							pi1.x() - dx,
							DLM,
							pi1.y() - dy);
					s = s + ds;
				}
				if (!pi2.isNull()) {
					d = w->inputDevice(1);
					ds.sprintf("%c%d%c%d%c%d%c%d",
							DLM,
							d->getID(),
							DLM,
							w->inputIsInverted(d),
							DLM,
							pi2.x() - dx,
							DLM,
							pi2.y() - dy);
					s = s + ds;
				}
				if (!po1.isNull()) {
					d = w->outputDevice(0);
					ds.sprintf("%c%d%c%d%c%d%c%d",
							DLM,
							d->getID(),
							DLM,
							w->outputIsInverted(d),
							DLM,
							po1.x() - dx,
							DLM,
							po1.y() - dy);
					s = s + ds;
				}
				if (!po2.isNull()) {
					d = w->outputDevice(1);
					ds.sprintf("%c%d%c%d%c%d%c%d",
							DLM,
							d->getID(),
							DLM,
							w->outputIsInverted(d),
							DLM,
							po2.x() - dx,
							DLM,
							po2.y() - dy);
					s = s + ds;
				}
			}
		}
		lw = lw->Next();
	}
	return s;
}

void XDeviceNet::initImport()
{
	wiremap.init();
	devmap.init();
}

// reading a sub circuit from file: create a new sub circuit device and initialize it
bool XDeviceNet::importInstance(QString s, int dx, int dy)
{
	// newer files have some kind of version number ..
	if (!XDeviceNet::magic_version) {
		int posa = s.findRev(DLM);
		if (posa != -1) {	// of course not!
			XDeviceNet::magic_version = s.right(s.length() - posa - 1).toInt();
		}
	}

	importDevice(s, 0, dx, dy);

	return true;
}

bool XDeviceNet::importWire(QString s, int select, int dx, int dy)
{
	int epos;
	QString sid;
	XWire *w;

	epos = s.find(DLM, 0);
	if (epos == -1) return false;
	sid = s.mid(1, epos - 1);
	s = s.right(s.length() - epos - 1);

	if (!(w = new XWire())) return false;
	w->setExportDelta(dx, dy);
	bool ret = *w << s;
	if (!ret) {
		delete w;
		return false;
	}

	netwire.Append(w, w->getID());

	wiremap.fileID(sid, w->getID());

	// select wire?
	if (select) w->select(1);

	return true;
}

bool XDeviceNet::importDevice(QString s, int select, int dx, int dy)
{
	int apos, epos;
	int func;
	QString sid;
	QString devext;
	XDevice *d;
	bool ret = true;

	apos = 1;
	epos = s.find(DLM, 0);
	if (epos == -1) return false;
	sid = s.mid(apos, epos - apos);

	apos = epos + 1;
	epos = s.find(DLM, apos);
	if (epos == -1) return false;
	func = s.mid(apos, epos - apos).toInt();

	// create the new device (size of 4 will be overwritten in next step!)
	d = newDevice(func, 0, 0, 4);
	if (!d) fatal("XDeviceNet::importDevice(): unable to create device ..\n");

	// call member method to import device parameter
	ret = d->string2device(s, dx, dy);

	devmap.fileID(sid, d->getID());

	// add device to a selection?
	if (select) d->select(1);

	if (d->type() == DeviceType::fIN || d->type() == DeviceType::fOUT) {
		// the text of the i/o-device is currently the old id ... (or -1 if it is an old format)
		KlogicList<Value> *lv = NULL;
		KlogicList<opStack> *lop = NULL;
		if (d->type() == DeviceType::fIN) {
			lv = named_input.With(sid);			// access with the old id string
			if (lv) lv->setID1(d->getID());			// exchange the old id with the new one
		}
		if (d->type() == DeviceType::fOUT) {
			lop = named_output.With(sid);			// access with the old id string
			if (lop) lop->setID1(d->getID());		// exchange the old id with the new one
		}

		// now set the correct text
		setText(d->getID(), d->getText());
		setImage();
	}

	return ret;
}

bool XDeviceNet::importWireConn(QString s, int, int dx, int dy)
{
	int apos, epos;
	XWire *w1, *w2;
	QPoint pt;
	QString refWire, conWire;
	int refWireID, conWireID;

	epos = s.find(DLM, 0);
	if (epos == -1) return false;
	refWire = s.mid(1, epos - 1);

	refWireID = wiremap.mapID(refWire);

	apos = epos + 1;
	epos = s.find(DLM, apos);
	if (apos == -1 || epos == -1) return false;
	conWire = s.mid(apos, epos - apos);

	conWireID = wiremap.mapID(conWire);

	apos = epos + 1;
	epos = s.find(DLM, apos);
	if (apos == -1 || epos == -1) return false;
	pt.setX(s.mid(apos, epos - apos).toInt() + dx);

	apos = epos + 1;
	epos = s.length();
	if (apos == -1) return false;
	pt.setY(s.mid(apos, epos - apos).toInt() + dy);

	w1 = netwire.Get(refWireID);
	w2 = netwire.Get(conWireID);
	if (!w1 || !w2) return false;
	if (Wire::NODE_NOLOCK == w1->lockNode(pt)) {
		if (Wire::NODE_NOLOCK == w2->lockNode(pt))
			return false;
		else
			w1->checkConnection(w2);
	}
	else
		w2->checkConnection(w1);

	return true;
}

bool XDeviceNet::importDevConn(QString s, int, int dx, int dy)
{
	int apos, epos;
	QString sid;
	QString dev1, dev2;
	int wire_id;
	int dev1_id = 0, dev2_id = 0;
	int inverted1 = 0, inverted2 = 0;
	QPoint p1, p2;
	XWire *w;

	epos = s.find(DLM, 0);
	if (epos == -1) return false;
	sid = s.mid(1, epos - 1);

	wire_id = wiremap.mapID(sid);

	apos = epos + 1;
	epos = s.find(DLM, apos);
	if (apos == -1 || epos == -1) return false;
	dev1 = s.mid(apos, epos - apos);
	dev1_id = devmap.mapID(dev1);

	apos = epos + 1;
	epos = s.find(DLM, apos);
	if (apos == -1 || epos == -1) return false;
	inverted1 = s.mid(apos, epos - apos).toInt();
	if (inverted1 == 0) inverted1 = -1;

	apos = epos + 1;
	epos = s.find(DLM, apos);
	if (apos == -1 || epos == -1) return false;
	p1.setX(s.mid(apos, epos - apos).toInt() + dx);

	apos = epos + 1;
	epos = s.find(DLM, apos);
	if (epos == -1)
		epos = s.length();
	if (apos == -1) return false;
	p1.setY(s.mid(apos, epos - apos).toInt() + dy);

	apos = epos + 1;
	epos = s.find(DLM, apos);
	if (apos != -1 && epos != -1) {
		dev2 = s.mid(apos, epos - apos);
		dev2_id = devmap.mapID(dev2);

		apos = epos + 1;
		epos = s.find(DLM, apos);
		if (apos == -1 || epos == -1) return false;
		inverted2 = s.mid(apos, epos - apos).toInt();
		if (inverted2 == 0) inverted2 = -1;

		apos = epos + 1;
		epos = s.find(DLM, apos);
		if (apos == -1 || epos == -1) return false;
		p2.setX(s.mid(apos, epos - apos).toInt() + dx);

		apos = epos + 1;
		epos = s.length();
		if (apos == -1) return false;
		p2.setY(s.mid(apos, epos - apos).toInt() + dy);
	}
	else {
		p2.setX(0);
		p2.setY(0);
	}
	// connect wire with devices
	w = netwire.Get(wire_id);
	if (!w) return false;
	if (!w->contains(p1)) return false;
	if (DCONN != checkConnection(dev1_id, inverted1, w)) return false;
	if (!p2.isNull()) {
		if (!w->contains(p2)) return false;
		if (!checkConnection(dev2_id, inverted2, w)) return false;
	}
	return true;
}

QString XDevice::device2string(int dx, int dy)
{       QString ret;
        QString buf;
 
        // add device parameters
        ret = "\t";
        ret += Device::device2string();
 
        // set mark to the beginning of xdevice parameters
        ret += DLM;
        ret += (char)2;
 
        // add xdevice parameters
        buf.sprintf("%c%d%c%d%c%d",
                DLM,
                size(), DLM,
                getPos().x() - dx, DLM,
                getPos().y() + getVOffset() - dy);
        ret += buf;
 
 
        if (type() != DeviceType::fRAM && type() != DeviceType::fTRI && hasNamedOutput()) {
                // saving the device id's here ... the text comes with the device itself!
                KlogicList<opStack> *lo = named_output.First()->Next();       // the first output in the list is an universal unnamed output
                if (lo) {
                        buf.sprintf("%c%c%d", DLM, 3, lo->counter() - 1);       //CRTL-C
                        ret += buf;
                }
                while(lo) {
                        if (type() != DeviceType::fEQU) buf.sprintf("%c%d%c%d%c%d%c", DLM, lo->getID1(), DLM, lo->Get()->getPosition(), DLM, lo->Get()->isInternal(), DLM);
                        else buf.sprintf("%c%s%c%d%c%d%c", DLM, lo->getText(), DLM, lo->Get()->getPosition(), DLM, lo->Get()->isInternal(), DLM);
                        ret += buf;
                        if (getEquation(lo->getID1())) ret += getEquation(lo->getID1());
                        lo = lo->Next();
                }
        }
        if (type() != DeviceType::fRAM && type() != DeviceType::fTRI && hasNamedInput()) {
                KlogicList<Value> *li = named_input.First();
                if (li) {
                        buf.sprintf("%c%c%d", DLM, 4, li->counter());           //CRTL-D
                        ret += buf;
                }
                while(li) {
                        if (type() !=  DeviceType::fEQU) buf.sprintf("%c%d%c%d%c%d", DLM, li->getID1(), DLM, li->Get()->getPosition(), DLM, li->Get()->isInternal());
                        else buf.sprintf("%c%s%c%d%c%d", DLM, li->getText(), DLM, li->Get()->getPosition(), DLM, li->Get()->isInternal());
                        ret += buf;
                        li = li->Next();
                }
        }
 
        buf.sprintf("%c%d", DLM, textDisplayed());
        ret += buf;
 
        if (type() == DeviceType::fRAM) {
		char *myram = getRAMStorageCopy();
                buf.sprintf("%c%d", DLM, RAMSize());
                ret += buf;
                for (int i = 0; i < RAMSize(); i++) {
                        buf.sprintf("%c%d", DLM, myram[i]);
                        ret += buf;
                }
		delete[] myram;
        }
 
        buf.sprintf("%c%d", DLM, isTristate());
        ret += buf;
        if (isTristate()) {
                KlogicList<Value> *li = named_input.With("EN");
                if (li) {
                        if (type() !=  DeviceType::fEQU) buf.sprintf("%c%d%c%d%c%d", DLM, li->getID1(), DLM, li->Get()->getPosition(), DLM, li->Get()->isInternal());
                        else buf.sprintf("%c%s%c%d", DLM, li->getText(), DLM, li->Get()->getPosition());
                        ret += buf;
                }
        }

        return ret;
}
 
bool XDevice::string2device(QString s, int dx, int dy)
{
	bool ret = true;
        QString xs;
        QString buf;
        int apos, epos, cnt, i;
        int pos;
        QPoint pt;
        char *equation;
        int internal;
        int redraw = 0;
        int finished = 0;
        QString dev_id_string;
        bool id_flag;
        int dev_id;

        ret = Device::string2device(s);
        if (!ret) return ret;
 
        cnt = s.length() - s.find((char)2);
        xs = s.right(cnt);
 
        epos = xs.find(DLM, 0);
        if (epos == -1) return false;
 
        // size
        apos = epos + 1;
        epos = xs.find(DLM, apos);
        if (epos == -1) return false;
        redraw = setSize(xs.mid(apos, epos - apos).toInt());
 
        // position
        apos = epos + 1;
        epos = xs.find(DLM, apos);
        if (epos == -1) return false;
        pt.setX(xs.mid(apos, epos - apos).toInt() + dx);
        apos = epos + 1;
        epos = xs.find(DLM, apos);
        if (epos == -1) {
                finished = 1;
                epos = xs.length();
        }
        pt.setY(xs.mid(apos, epos - apos).toInt() + dy);
	// the image of switch has changed (only relevant for this import)
	if (XDeviceNet::magic_version != 1300 && type() == DeviceType::fSWI) {
		pt.setX(pt.x() + 10);
	}
 
        initPos(pt.x(), pt.y());
        setPos(pt);
 
        // named output
        apos = epos + 1;
        if (!finished && -1 != (epos = xs.find((char)3, apos))) {
                apos = epos + 1;
                epos = xs.find(DLM, apos);
                if (epos == -1) {
                        ret = false;
                        finished = 1;
                }
                cnt = xs.mid(apos, epos - apos).toInt();
                for(i=0; i < cnt; i++) {
                        apos = epos + 1;
                        epos = xs.find(DLM, apos);
                        if (epos == -1) {
                                ret = true;        // hist. programming error: ignore!
                                finished = 1;
                                continue;
                        }
                        buf = xs.mid(apos, epos - apos);
                        dev_id_string = buf;
                        dev_id = dev_id_string.toInt(&id_flag);
                        if (id_flag == FALSE) dev_id = 0;
 
 
                        apos = epos + 1;
                        epos = xs.find(DLM, apos);
                        if (epos == -1) {
                                ret = false;
                                finished = 1;
                                continue;
                        }
                        pos = xs.mid(apos, epos - apos).toInt();
 
                        apos = epos + 1;
                        epos = xs.find(DLM, apos);
                        if (epos == -1) {
                                ret = false;
                                finished = 1;
                                continue;
                        }
                        internal = xs.mid(apos, epos - apos).toInt();
 
                        apos = epos + 1;
                        epos = xs.find(DLM, apos);
                        if (epos == -1) {
                                finished = 1;
                                epos = xs.length();
                        }
                        buf = xs.mid(apos, epos - apos);
                        equation = (char *)(const char *)buf;
 
                        if (!internal) dev_id = addOutputName(dev_id_string, pos, dev_id);
                        else dev_id = addInternalName(dev_id_string);
                        Device::setEquation(equation, dev_id);
                }
        }
 
        // named input
        if (epos != -1) apos = epos + 1;
        if (!finished && -1 != (epos = xs.find((char)4, apos))) {
                apos = epos + 1;
                epos = xs.find(DLM, apos);
                if (epos == -1) {
                        ret = false;
                        finished = 1;
                }
                cnt = xs.mid(apos, epos - apos).toInt();
                for(i=0; i < cnt; i++) {
                        apos = epos + 1;
                        epos = xs.find(DLM, apos);
                        if (epos == -1) {
                                ret = false;
                                finished = 1;
                                continue;
                        }
                        buf = xs.mid(apos, epos - apos);
                        dev_id_string = buf;
                        dev_id = dev_id_string.toInt(&id_flag);
                        if (id_flag == FALSE) dev_id = 0;
 
                        apos = epos + 1;
                        epos = xs.find(DLM, apos);
                        if (epos == -1) {
                                finished = 1;
                                epos = xs.length();
                        }
                        pos = xs.mid(apos, epos - apos).toInt();
 
                        apos = epos + 1;
                        epos = xs.find(DLM, apos);
                        if (epos == -1) {
                                finished = 1;
                                epos = xs.length();
                        }
                        internal = xs.mid(apos, epos - apos).toInt();
 
                        if (!internal) dev_id = addInputName(dev_id_string, pos, dev_id);
                        else addInternalName(dev_id_string);
                }
        }
 
        if (!finished) {
                if (epos != -1) apos = epos + 1;
                epos = xs.find(DLM, apos);
                if (epos == -1) {
                        finished = 1;
                        epos = xs.length();
                }
                displayText(xs.mid(apos, epos - apos).toInt());
        }
 
        if (!finished && type() == DeviceType::fRAM) {
                if (epos != -1) apos = epos + 1;
                epos = xs.find(DLM, apos);
                setRAMSize(xs.mid(apos, epos - apos).toInt());
                char *newram = getRAMStorageCopy();
                for(i = 0; i < RAMSize(); i++) {
                        apos = epos + 1;
                        epos = xs.find(DLM, apos);
                        if (epos == -1) {
                                finished = 1;
                                epos = xs.length();
                        }
                        newram[i] = xs.mid(apos, epos - apos).toInt();
                }
                setRAMStorage(newram);
                delete [] newram;
        }
 
        if (!finished) {
                if (epos != -1) apos = epos + 1;
                epos = xs.find(DLM, apos);
                if (epos == -1) {
                        finished = 1;
                        epos = xs.length();
                }
                if (xs.mid(apos, epos - apos).toInt()) {                // isTristate!
                        // retrieve the "EN" input properties
                        apos = epos + 1;
                        epos = xs.find(DLM, apos);
                        if (epos == -1) {
                                fatal("XDevice::string2device: what?");
                        }
                        buf = xs.mid(apos, epos - apos);
                        dev_id_string = buf;
                        dev_id = dev_id_string.toInt(&id_flag);
                        if (id_flag == FALSE) dev_id = 0;
 
                        apos = epos + 1;
                        epos = xs.find(DLM, apos);
                        if (epos == -1) {
                                finished = 1;
                                epos = xs.length();
                        }
                        pos = xs.mid(apos, epos - apos).toInt();
 
                        // create the "EN" input at the appropriate position, or use the existing one
			setTristateControlPos(pos);
			setTristateInputImport();
                }
        }
 
        // change some inputs/outputs?
        if ((clock() < 4) && (type() == DeviceType::fRS)) {
                // remove all named inputs...
                while(named_input.First())
                        removeInputName(named_input.First()->getID1());
                // ... and add the new ones
                addInputName("1S", 0);
                addInputName("C1", 2);
                addInputName("1R", 4);
        }
        if (clock() == OscillatorDevice::CLK_MONO && type() == DeviceType::fOSC) {
                deviceMaxInput = 1;
        }
        setText(getText());
 
        if (redraw ||
            type() == DeviceType::fRS || type() == DeviceType::fJK ||
            type() == DeviceType::fDFF || type() == DeviceType::fNET ||
            type() == DeviceType::fEQU || type() == DeviceType::fSS || type() == DeviceType::fOSC)
                setImage();
 
        parseEquation();
 
        setColor();
 
        return ret;
}

// device import/export
QString Device::device2string()
{       QString ret;
        QString buf;
 
        ret.truncate(0);
 
        // all other devices
	int osz_on_cnt = 0, osz_off_cnt = 0, osz_curr_step = 0;
	if (type() == DeviceType::fOSC) {
		OscillatorDevice *odev = (OscillatorDevice *)getInstance();
		osz_on_cnt = odev->oszOn();
		osz_off_cnt = odev->oszOff();
		osz_curr_step = odev->getCurrOszStep();
	}
        ret.sprintf("%d%c%d%c%d%c%d%c%d%c%d%c%d%c%d%c%d%c%d%c",
                id, DLM,
                function, DLM,
                delay(), DLM,
                undef(), DLM,
                clock_type, DLM,
                master, DLM,
                osz_on_cnt, DLM,
                osz_off_cnt, DLM,
                named_output.Get()->getResult(), DLM,
                osz_curr_step, DLM);
        if (text) ret += text;
 
        return ret;
}
 
bool Device::string2device(QString s)
{       int apos, epos;
        QString original_text;
        QString alternate_text;
 
	OscillatorDevice *odev = (OscillatorDevice *)NULL;
	if (type() == DeviceType::fOSC) {
		odev = (OscillatorDevice *)getInstance();
	}

        // name
        apos = 1;
        epos = s.find(DLM, 0);
        if (epos == -1) return false;
        alternate_text = s.mid(apos, epos - apos);
 
        // function
        apos = epos + 1;
        epos = s.find(DLM, apos);
        if (epos == -1) return false;
 
        // delay
        apos = epos + 1;
        epos = s.find(DLM, apos);
        if (epos == -1) return false;
        setDelay(s.mid(apos, epos - apos).toInt());
 
        // undefined value
        apos = epos + 1;
        epos = s.find(DLM, apos);
        if (epos == -1) return false;
        setUndef(s.mid(apos, epos - apos).toInt());
 
        // clock type
        apos = epos + 1;
        epos = s.find(DLM, apos);
        if (epos == -1) return false;
        setClock(s.mid(apos, epos - apos).toInt());
 
        // master ff flag
        apos = epos + 1;
        epos = s.find(DLM, apos);
        if (epos == -1) return false;
        setMaster(s.mid(apos, epos - apos).toInt());
 
        // oscillator on time
        apos = epos + 1;
        epos = s.find(DLM, apos);
        if (epos == -1) return false;
        if (odev) odev->setOszOn(s.mid(apos, epos - apos).toInt());
 
        // oscillator off time
        apos = epos + 1;
        epos = s.find(DLM, apos);
        if (epos == -1) return false;
        if (odev) odev->setOszOff(s.mid(apos, epos - apos).toInt());
 
        // output value
        apos = epos + 1;
        epos = s.find(DLM, apos);
        if (epos == -1) return false;
        flush(s.mid(apos, epos - apos).toInt());
        setStaticInput(s.mid(apos, epos - apos).toInt());
 
        // osz_curr_step
        apos = epos + 1;
        epos = s.find(DLM, apos);
        if (epos == -1) return false;
        if (odev) odev->setCurrOszStep(s.mid(apos, epos - apos).toInt());

        // text label
        apos = epos + 1;
        epos = s.find(DLM, apos);
        if (epos == -1) return false;
        original_text = s.mid(apos, epos - apos);
        if (original_text.length() > 0) setText((char *)(const char *)original_text);
        else setText((char *)(const char *)alternate_text);
 
        return true;
}

