/* buffer.h definitions for administration  *
 *	of  filebuffers (always stereo)     */

#ifndef __BUFFER_H__
#define __BUFFER_H__

#include <pthread.h>
#include <stdio.h>
#include <sndfile.h>
#include "speciallist.h"
/*#include <glib.h>*/

/* how many frames will we read at once */
#define TBS = 32768

#define BUFFER_STATUS_NEW 	1
#define BUFFER_STATUS_TOLOAD	2
#define BUFFER_STATUS_LOADING 	3
#define BUFFER_STATUS_READY	4
#define BUFFER_STATUS_DEAD	5

#define BUFFER_ERROR_UNKNOWN	-1
#define BUFFER_ERROR_ALLOC	-2
#define BUFFER_ERROR_NOSF	-3

/* not in use
typedef struct _stereo_sample {
	float L;
	float R;
} stereo_sample_t;
*/

/*
typedef struct _buffer_list {
        GList   *ptr;
        GMutex  *mutex;
} buffer_list_t;
*/

typedef struct _buffer_info{
	int 		id;
	int		status;
	int		pending;
	int 		error;
/*	GMutex 		*buffermutex;*/
	pthread_mutex_t buffermutex;
	int		channels;
	char* 		filename; /* only if data comes from file */
	char*		shortname;
	double		percent_filled;
	int		normalized;
	float*		L; 	/* Left channel data*/
	float*		R;	/* Right --"-- */
	long		size; 	/* in samples */
	int 		is_ds; /* disc stream ? */
	long		ds_lastpost;
	long		ds_bufstart;
	long		ds_bufsize;
	
} buffer_info_t;

typedef struct _buffer_save_data{
	buffer_info_t 	*buf;
	long		start;
	long		end;
} buffer_save_data_t;

buffer_info_t* 	buffer_new();
void 		buffer_lock(buffer_info_t* buf);
void 		buffer_unlock(buffer_info_t* buf);
void	 	buffer_loadfile(buffer_info_t* buf, char* fname,long srate);
int		buffer_save (buffer_info_t* buf, char* fname, long srate, long start, long end);
void 		buffer_set_filename(buffer_info_t* buf, char* name);
void 		buffer_set_shortname(buffer_info_t* buf, char* name);
void 		buffer_set_channels(buffer_info_t* buf, int channels);
void		buffer_set_ds(buffer_info_t* buf, int is_ds);
void		buffer_resize(buffer_info_t* buf, long new_size);
int 		buffer_delete(buffer_info_t* b);
float 		buffer_analyze(buffer_info_t* buf, long start, long end);
void		buffer_normalize(buffer_info_t* buf, float factor,long start, long end);
/*speciallist_t*  buffer_list_new();*/
void		buffer_loadthread_launch(speciallist_t *buffer_list);
float		buffer_readsample(buffer_info_t* buf, int channel, long index);
void		buffer_writesample(buffer_info_t* buf, int channel, long index, float sample);
#endif
