#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "interpol.h"

float inter4pol (float* buf, float index, long size){
	float frac,  a,  b,  c,  d, cminusb;
	float *fp;
	long lindex = (long)index;

	/* 4 point interpolation taken from tabread4~ of pd (pure-data.org) */

	if (lindex < 1){
            	lindex = 1, frac = .0;
        }else if (lindex > (size - 3)){
            	lindex = size - 3;
		frac = 1.;
	}else{
		frac = index - lindex;
	}

	fp = buf + lindex;
	a = fp[-1];
        b = fp[0];
        c = fp[1];
        d = fp[2];

	cminusb = c-b;
	return (b + frac * (cminusb - 0.5f * (frac - 1.) * 
		 ((a - d + 3.0f * cminusb) * frac + (b - a - cminusb))));
}

float inter4pol_stereo(float* buf, float index, long size){
        float frac,  a,  b,  c,  d, cminusb;
        float *fp;
        long lindex = (long)index;

        /* version for (stereo-)interleaved buffers */

        if (lindex < 1){
                lindex = 1, frac = .0;
        }else if (lindex > (size - 6)){
                lindex = size - 6;
                frac = 1.;
        }else{
                frac = index - lindex;
        }

        fp = buf + lindex;
        a = fp[-2];
        b = fp[0];
        c = fp[2];
        d = fp[4];

        cminusb = c-b;
        return (b + frac * (cminusb - 0.5f * (frac - 1.) *
                 ((a - d + 3.0f * cminusb) * frac + (b - a - cminusb))));
}

