#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/soundcard.h>
#include <errno.h>
#include <unistd.h>
#include <math.h>
#include <sys/sysinfo.h>
#include "../../common/buffer.h"
#include "../../common/jackmixer.h"
#include "../../common/looperdata.h"
#include "../../common/shuttle.h"
#include "../../common/serialio.h"
#include "../../common/speciallist.h"

#ifndef SOUND_MIXER_READ
# define SOUND_MIXER_READ(x) MIXER_READ(x)
#endif
#ifndef SOUND_MIXER_WRITE
# define SOUND_MIXER_WRITE(x) MIXER_WRITE(x)
#endif

int 	startup_linelevel;
int 	last_foot = 0;
double 	last_tap = 0;

const float initial_length = 0.05; /* in seconds (was 0.05)*/
const float initial_speed = 1;
const float initial_ngrains = 15;
const float initial_volume  = 0.9;
const int initial_graindensity = 100;
const double mintimediff = 20000.;
const double semitone = 1.059463094359;

int ossmixer_getlevel (){
	int fd = -1;
	int vol = 0;

	fd = open("/dev/mixer", O_RDONLY);
	if (fd > 0){
		if (ioctl(fd, SOUND_MIXER_READ(SOUND_MIXER_LINE), &vol) == -1){
			close (fd);
			return -2;
		} else {
			close (fd);
			return vol;
		}
	} 
	return -1;
}

void ossmixer_setlevel (int vol){
	int fd = -1;
	int svol = vol | (vol << 8);
	fd = open("/dev/mixer", O_WRONLY);
	ioctl(fd, SOUND_MIXER_WRITE(SOUND_MIXER_LINE), &svol);
	close (fd);
}

#if 0
void  check_buffer_list(speciallist_t *buffer_list){
	buffer_info_t *buf;
	buffer_info_t *tbuf;
	
	buf = speciallist_get_first(buffer_list);
	while (buf){

		if (buf->pending == BUFFER_STATUS_READY){
			
		}

		if (buf->pending && (buf->pending != buf->status)){
			buffer_lock(buf);
			buf->status = buf->pending;
			buf->pending = 0;
			buffer_unlock(buf);
		}
	
		if (buf->status == BUFFER_STATUS_DEAD){
			/* this should only happen when loading fails*/
			tbuf =  speciallist_get_next(buffer_list,buf);
			speciallist_delete(buffer_list,buf);
			buf = tbuf;
			/* LATER: clean up buf */
		} else {
/*			if (!(buf->status == BUFFER_STATUS_READY)) not_ready++;*/
			buf = speciallist_get_next(buffer_list,buf);
		}
	}
}

#endif 

void reset_looperdata(looper_data_t *looper_data, jack_info_t *jack_info){
        looper_data->isplaying = 1;
        looper_data->isrecording = 1;
        looperdata_set_ngrains(looper_data, initial_ngrains);
        looperdata_set_graindensity(looper_data, initial_graindensity);
	looperdata_set_mingrainspeed(looper_data, initial_speed);
	looperdata_set_maxgrainspeed(looper_data, initial_speed);
        looperdata_set_speed(looper_data, initial_speed);
        looperdata_set_vol(looper_data, initial_volume);
	looperdata_set_recmix(looper_data, 1);
        looperdata_set_loopend(looper_data, jack_info->samplerate * initial_length); /* .1 sec */
        looperdata_set_recend(looper_data, jack_info->samplerate  * initial_length);
        looperdata_set_mingrainlength(looper_data, jack_info->samplerate  * initial_length);
        looperdata_set_maxgrainlength(looper_data, jack_info->samplerate  * initial_length);
	looperdata_set_playpos (looper_data, 0);
	looperdata_set_recpos (looper_data, 0);
} 

void serialio_pollall (serialio_data_t  *serialio, speciallist_t *looperdatalist){
	looper_data_t *wld;
	int i;

	wld = speciallist_get_first(looperdatalist);	

	/* check footswitch */
	if ((i = serialio_get_foot(serialio)) && !last_foot){
		if (wld->isrecording){
			while (wld){
				wld->isrecording = 0;
				wld = speciallist_get_next(looperdatalist,wld);
			}
		}else{
			while (wld){
				wld->isrecording = 1;
				wld = speciallist_get_next(looperdatalist,wld);
			}
		}
	}
/*	printf ("last_foot:%d, i:%d\n",last_foot,i);*/
	last_foot = i;
}

void shuttle_pollall (shuttle_data_t  *shuttle, speciallist_t *looperdatalist, jack_info_t *jack_info){
	looper_data_t *wld;

	wld = speciallist_get_first(looperdatalist);

	if (shuttle->fd < 1) {shuttle_open(shuttle);}

	while (shuttle_poll (shuttle) > 0){
		switch (shuttle->code){
			case SHUTTLE_LEFTMOST :/* play */
				if ((!shuttle->value) && (shuttle->lastcode == shuttle->code)){
					if (wld->isplaying){
						while (wld){
							wld->isplaying = 0;
							wld = speciallist_get_next(looperdatalist,wld);
						}
						ossmixer_setlevel(startup_linelevel);
					}else{
						while (wld){
							wld->isplaying = 1;
							wld = speciallist_get_next(looperdatalist,wld);
						}
						ossmixer_setlevel(0);
					}
				}
				break;
			case SHUTTLE_LEFT :
				if ((!shuttle->value) && (shuttle->lastcode == shuttle->code)){
					while (wld){
                                        	looperdata_lock(wld);
						looperdata_set_mingrainspeed(wld,
							looperdata_get_mingrainspeed(wld) * -1.);
                                        	looperdata_set_maxgrainspeed(wld,
							looperdata_get_maxgrainspeed(wld) * -1.);
						looperdata_unlock(wld);
						wld = speciallist_get_next(looperdatalist,wld);
					} 
				}
				break;
			case SHUTTLE_MIDDLE : /* reset */
				if ((!shuttle->value) && (shuttle->lastcode == shuttle->code)){
					if (shuttle->buttonstates & SHUTTLE_LEFTMOST){
						while (wld){
							looperdata_lock(wld);
							looperdata_set_loopend (wld, 
								jack_info->samplerate * initial_length);
                                                	looperdata_set_recend (wld, 
								jack_info->samplerate * initial_length);
                                                	looperdata_set_maxgrainlength (wld, 
								jack_info->samplerate * initial_length);
                                                        looperdata_set_mingrainlength(wld, 
								jack_info->samplerate * initial_length);
							looperdata_unlock(wld);
							wld = speciallist_get_next(looperdatalist,wld);
						}
					} else if (shuttle->buttonstates & SHUTTLE_LEFT){
						while (wld){
                                                	looperdata_lock(wld);
                                                	looperdata_set_mingrainspeed(wld,1.);
                                                	looperdata_set_maxgrainspeed(wld,1.);
                                                	looperdata_unlock(wld);
                                                	wld = speciallist_get_next(looperdatalist,wld);
                                        	}       
					} else if (shuttle->buttonstates & SHUTTLE_RIGHTMOST){
						while (wld){
							looperdata_lock(wld);
							looperdata_set_recpos(wld,
								looperdata_get_recstart(wld));
							looperdata_unlock(wld);
							wld = speciallist_get_next(looperdatalist,wld);
						}
					} else if (shuttle->buttonstates & SHUTTLE_RIGHT){
					} else {
						while (wld){
							looperdata_lock(wld);
							reset_looperdata (wld, jack_info);
							looperdata_unlock(wld);
                                                        wld = speciallist_get_next(looperdatalist,wld);
						}
					}
				}
				break;
			case SHUTTLE_RIGHT : /* distortion */
				if ((!shuttle->value) && (shuttle->lastcode == shuttle->code)){
					if (looperdata_get_vol(wld) < 1.){
						while (wld){
							looperdata_lock(wld);
							looperdata_set_vol(wld, 3);
							looperdata_set_limknee (wld, .1);
							looperdata_set_limit (wld, .4);
							looperdata_set_recmix(wld, .6);
							looperdata_unlock(wld);
							wld = speciallist_get_next(looperdatalist,wld);	
						}
					} else {
						while (wld){
							looperdata_lock(wld);
							looperdata_set_vol(wld, .9);
							looperdata_set_limknee (wld, .6);
							looperdata_set_limit (wld, 1.);
							looperdata_set_recmix(wld, 1.);
							looperdata_unlock(wld);
							wld = speciallist_get_next(looperdatalist,wld);
						}
					}
				}
				break;
			case SHUTTLE_RIGHTMOST : 
				if ((!shuttle->value) && (shuttle->lastcode == shuttle->code)){
					struct timeval tv;
					double now;
					long diff; /* milliseconds between last two events */
					long since; /* milliseconds since event */

					gettimeofday(&tv,NULL);		
					since = (tv.tv_sec - shuttle->lastevent.tv_sec)	 * 1000;
					since += (long)((tv.tv_usec - shuttle->lastevent.tv_usec) / 1000.);

					now = (double)shuttle->lastevent.tv_sec * 1000. + (double)shuttle->lastevent.tv_usec / 1000.;
					diff = (long)(now - last_tap);
					if (diff < 3000){
						while (wld){
							looperdata_lock(wld);
							looperdata_set_playpos(wld, since * jack_info->samplerate / 1000);
							looperdata_set_recpos(wld, since * jack_info->samplerate / 1000);

							looperdata_set_loopend(wld, diff * jack_info->samplerate / 1000);
							looperdata_set_recend(wld, diff * jack_info->samplerate / 1000);
							looperdata_unlock(wld);
							wld = speciallist_get_next(looperdatalist,wld);
						}
					}
/*					printf ("now:%lf, last:%lf, since:%ld, diff:%ld\n",now, last_tap, since, diff);*/
					last_tap = now;
					
				}
#if 0
				/* record */
				if ((!shuttle->value) && (shuttle->lastcode == shuttle->code)){
					if (wld->isrecording){
						while (wld){
							wld->isrecording = 0;
							wld = speciallist_get_next(looperdatalist,wld);
						}
					}else{
						while (wld){
							wld->isrecording = 1;
							wld = speciallist_get_next(looperdatalist,wld);
						}
					}
				}
#endif
				break;
			case SHUTTLE_SHUTTLE :
				if (!shuttle->buttonstates){
					while (wld){
						int d = looperdata_get_ngrains(wld);
						int diff = d + (shuttle->shuttledelta / 4);
						if (diff < 1) diff = 1;
						if (diff > 15) diff = 15;
						if ((diff > 0) && (diff < 16)){
							looperdata_lock(wld);
/*							printf ("ngrains:%d\n", diff);*/
							looperdata_set_ngrains(wld, diff);
							looperdata_unlock(wld);
						}
						wld = speciallist_get_next(looperdatalist,wld);	
					}
				} else if (shuttle->buttonstates & SHUTTLE_LEFT){
					while (wld){            
                                		/* grain speed */
                                		float f = looperdata_get_mingrainspeed(wld);
/*                                		f = f + f * .0002 * (double)(shuttle->jogstate * shuttle->jogstate * shuttle->jogstate);*/
						f *= pow(semitone,(double)shuttle->shuttledelta);
/*						printf ("factor:%lf, f:%lf\n",pow(semitone,(double)shuttle->shuttledelta),f);*/
                                		if ((f > 0) && (f < 100)){
                                        		looperdata_lock(wld);
                                        		looperdata_set_mingrainspeed(wld,f);
                                        		looperdata_set_maxgrainspeed(wld,f);
                                        		looperdata_unlock(wld);
                                		}
                                		wld = speciallist_get_next(looperdatalist,wld);
                        		}
				} else if (shuttle->buttonstates & SHUTTLE_LEFTMOST){
					while (wld){
						long d = looperdata_get_mingrainlength (wld) + shuttle->shuttledelta;
 	                                	if (d > wld->buf->size) d = wld->buf->size;
                                		if (d < 3) d = 3;
						looperdata_lock(wld);
                                		looperdata_set_loopend (wld, d);
                                		looperdata_set_recend (wld, d);
	                        		looperdata_set_maxgrainlength (wld, d);
                                        	looperdata_set_mingrainlength(wld,(long)(d));
                                		looperdata_unlock(wld);
                                		wld = speciallist_get_next(looperdatalist,wld);
					}
				}
				break;
		}
	}

	if (shuttle->jogstate){
		if (!shuttle->buttonstates){
			while (wld){
				/* grain density */
				int d = looperdata_get_graindensity(wld);
				if ((d + shuttle->jogstate > 1) && ((d + (int)( shuttle->jogstate / 4)) <= 100)){
					looperdata_lock(wld);
					looperdata_set_graindensity(wld, d + (int)(shuttle->jogstate / 4));
					looperdata_unlock(wld);
				} /* this will most likely not go down to 1. */
				wld = speciallist_get_next(looperdatalist,wld);
			}
		} else if (shuttle->buttonstates & SHUTTLE_LEFTMOST){
			while (wld){
				/* grain length */
				looperdata_lock(wld);
				long d;
/*
				float f  = (float)looperdata_get_mingrainlength(wld)
                                        / (float)looperdata_get_maxgrainlength(wld);
*/

				if (looperdata_get_mingrainlength(wld) > 20){
					double f = (double)looperdata_get_mingrainlength(wld) * .0002 *
                                                        (double)(shuttle->jogstate * shuttle->jogstate * shuttle->jogstate);
					if (f > 0.0) f += 0.999;
					else  f -= 0.999;
					d = looperdata_get_mingrainlength(wld) + (long)f;
				} else d = looperdata_get_mingrainlength(wld) + shuttle->jogstate;

				if (d > wld->buf->size) d = wld->buf->size;
				if (d < 3) d = 3;
				looperdata_set_maxgrainlength (wld, d);
                                looperdata_set_loopend (wld, d);
                                looperdata_set_recend (wld, d);
/*				if ((long)(d) > 5)*/
					looperdata_set_mingrainlength(wld,(long)(d));
				looperdata_unlock(wld);
/*
				printf ("2:size:%ld, min:%ld, max:%ld\n",
					d,looperdata_get_mingrainlength(wld),looperdata_get_maxgrainlength(wld));
*/
				wld = speciallist_get_next(looperdatalist,wld);
                        }
		} else if (shuttle->buttonstates & SHUTTLE_LEFT){
                        while (wld){
				/* grain speed */
				float f = looperdata_get_mingrainspeed(wld);
				f = f + f * .0002 * (double)(shuttle->jogstate * shuttle->jogstate * shuttle->jogstate);
				if ((f > 0) && (f < 100)){
                                	looperdata_lock(wld);
/*                                	looperdata_set_speed(wld,f);*/
                                	looperdata_set_mingrainspeed(wld,f);
                                	looperdata_set_maxgrainspeed(wld,f);
                                	looperdata_unlock(wld);
				}
/*                              printf ("speed:%f\n",looperdata_get_speed(wld));*/
                                wld = speciallist_get_next(looperdatalist,wld);
                        }
                } else if (shuttle->buttonstates & SHUTTLE_RIGHTMOST){
			while (wld){
				/* just the minimum grain length */
				float f = (float)looperdata_get_mingrainlength(wld) 
					/ (float)looperdata_get_maxgrainlength(wld);
				f = f + f * .0005 * (float)(shuttle->jogstate * shuttle->jogstate * shuttle->jogstate);
				if (f > 1.) f = 1.;
				if (f <= .1) f = .1;
				if ((long)(looperdata_get_maxgrainlength(wld) * f) > 10){
					looperdata_lock(wld);
					looperdata_set_mingrainlength(wld,(long)(looperdata_get_maxgrainlength(wld) * f));
					looperdata_unlock(wld);
				}
/*				printf ("mingrain:%ld, maxgrain:%ld, f:%f\n",
					looperdata_get_mingrainlength(wld),looperdata_get_maxgrainlength(wld),f);*/
				wld = speciallist_get_next(looperdatalist,wld);
			}
		}
	}
	return;
}

/*--------MAIN--------*/
int main(int argc, char *argv[]){
	int 		i;
	buffer_info_t 	*buf;
	looper_data_t 	*looper_data;
	struct timeval 	tv;
	speciallist_t   *looperdatalist;
	speciallist_t   *buffer_list;
/*	int	     	looperindexcounter = 0;*/
	int	     	bufferindexcounter = 0;
	jack_info_t     *jack_info;
	int	     	alive = 1;
	long	    	lastxruns = 0;
	shuttle_data_t  *shuttle;
	serialio_data_t *serialio;
/*	int 		rounds = 0;*/
#if 0
	struct timeval ts;
	double ta; 
	double tb = 0;
#endif

/*	printf ("zwzw: %.12lf\n",pow (2, 1./12.));*/
	startup_linelevel = ossmixer_getlevel();
	if (startup_linelevel < 1) startup_linelevel = 80;
/*	printf ("line:%d\n",startup_linelevel);*/

	shuttle = shuttle_new();
	if (shuttle_open(shuttle) < 1){
		fprintf(stderr,"could not open shuttle device!\n");
/*		exit (0); */
	}

	serialio = serialio_new();
	if (serialio_open(serialio) < 1){
		fprintf(stderr,"could not open serial device!");
	}

	/* global data initialisation */
	buffer_list = speciallist_new();
	looperdatalist = speciallist_new();

	/* start the loadbuffer thread */
	buffer_loadthread_launch(buffer_list);
	
	/* start the jack threads */
	jack_info = mixer_launch(looperdatalist);


	if (!jack_info->samplerate){
		fprintf(stderr,"could not connect to jack!\n no playback/recording possible.");	   
		sleep (2);
		exit (0);
	}
	
	/* create 3 players of 10sec each: */
	for (i = 0;i < 1; i++){
		buf = buffer_new(bufferindexcounter++);
		buffer_set_channels(buf,2);
		buffer_lock(buf);	
		buffer_resize (buf, jack_info->samplerate  * 60 ); /* one minute size */
		buf->status = BUFFER_STATUS_READY;
		buffer_unlock(buf);
		speciallist_append(buffer_list,buf);

		looper_data = looperdata_new(buf, jack_info->samplerate, bufferindexcounter);
		reset_looperdata (looper_data, jack_info);

		speciallist_append(looperdatalist,(void*)looper_data);
	}

	ossmixer_setlevel(0);

	while(1){
/*		check_buffer_list(buffer_list);*/
#if 0
		gettimeofday(&ts, NULL);
		ta = (double)ts.tv_sec * 1000000.0 + (double)ts.tv_usec;
		if (ta  > tb + mintimediff){
			shuttle_pollall(shuttle, looperdatalist, jack_info);
			tb = ta;
		}
#endif 
		shuttle_pollall(shuttle, looperdatalist, jack_info);
		serialio_pollall(serialio, looperdatalist);

		if (alive && !jack_info->alive){
			alive = jack_info->alive;
			fprintf(stderr,"jack kicked us out.\n restarting.\n");
			ossmixer_setlevel(startup_linelevel);
			exit (0);
		}
		
		if (jack_info->xruns != lastxruns){
			lastxruns = jack_info->xruns;
			fprintf(stderr,"XRUN! [%ld xruns total]\n",lastxruns);
		}

		tv.tv_sec = 0; 
		tv.tv_usec = 30000; /*was 30000 */
		select(0, NULL, NULL, NULL, &tv);
	}

	mixer_close(jack_info);
	ossmixer_setlevel(startup_linelevel);
	printf ("bye\n");
  	return 0;
}
