#ifndef __CONFIGFILE_H__
#define __CONFIGFILE_H__

#include <libxml/parser.h>
#include <libxml/tree.h>
#include "../../common/buffer.h"
#include "looper.h"

typedef struct _configfile_handler {
	xmlDocPtr doc;
	xmlNodePtr kluppe;
	xmlNodePtr looperptr;
	xmlNodePtr bufferptr;
	long samplerate;
} configfile_handler_t;

int save_config (GList *looperlist, speciallist_t *bufferlist, char* spath, char* cpath, char *filename);
char* config_check_filename (char *filename);
configfile_handler_t* open_config_reader (char *filename, long samplerate);
void close_config_reader (configfile_handler_t* handler);
int config_next_looper (configfile_handler_t* handler);
int config_read_looper (configfile_handler_t* handler, looper_gui_t *looper);
int config_next_buffer (configfile_handler_t* handler);
int config_read_buffer (configfile_handler_t* handler, buffer_info_t* buf);

#endif

