#include <stdio.h>
#include <math.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include "griddialog.h"
#include "gtkloopview.h"

static void bpm_callback(GtkWidget* bpmspin, gpointer data){
	GtkLoopview *loopview = GTK_LOOPVIEW(data);

	gtk_loopview_set_bpm(loopview,(double)gtk_spin_button_get_value ((GtkSpinButton*)bpmspin));
}

static void bpb_callback(GtkWidget* bpbspin, gpointer data){
        GtkLoopview *loopview = GTK_LOOPVIEW(data);

        gtk_loopview_set_bpb(loopview,(double)gtk_spin_button_get_value ((GtkSpinButton*)bpbspin));
}

void griddialog_new(GtkWidget* parent, GtkLoopview *loopview){
	GtkAdjustment 	*adj;
	GtkTooltips     *tooltips;
        GtkWidget       *dialog;
        GtkWidget       *bpmlabel;
        GtkWidget       *bpblabel;
/*	GtkWidget	*lengthlabel;*/

	GtkWidget	*bpmbox;
	GtkWidget	*bpbbox;
	GtkWidget	*mainbox;

        GtkWidget       *bpmspin;       /* spinbutton */
        GtkWidget       *bpbspin;      	/* spinbutton */
	gint result;

	tooltips = gtk_tooltips_new ();

	
	bpmlabel = gtk_label_new ("beats per minute");
	bpblabel = gtk_label_new ("beats per bar");
/*	gtk_tooltips_set_tip(tooltips,bpmlabel,"beats per minute",NULL);*/


        adj = (GtkAdjustment *) gtk_adjustment_new (gtk_loopview_get_bpm(GTK_LOOPVIEW(loopview)),
				 0.01, 1720.0, .1, 1, 4);
        bpmspin = gtk_spin_button_new (adj, 1, 2);

	adj = (GtkAdjustment *) gtk_adjustment_new (gtk_loopview_get_bpb(GTK_LOOPVIEW(loopview)),
				 0.0, 64, 1, 1, 2);
	bpbspin = gtk_spin_button_new (adj, 1, 0);

/*	lengthlabel = gtk_label_new ("length per beat");*/

	g_object_set_data (G_OBJECT (bpbspin),"bpmspin",bpmspin);
	g_object_set_data (G_OBJECT (bpmspin),"bpbspin",bpbspin);
/*	g_object_set_data (G_OBJECT (bpbspin),"lengthlabel",lengthlabel);*/
/*	g_object_set_data (G_OBJECT (bpmspin),"lengthlabel",lengthlabel);*/
	g_signal_connect (G_OBJECT (bpmspin), "value_changed",
                        G_CALLBACK (bpm_callback), (gpointer) loopview);
        g_signal_connect (G_OBJECT (bpbspin), "value_changed",
                        G_CALLBACK (bpb_callback), (gpointer) loopview);


	bpmbox = gtk_hbox_new(TRUE,10);
	bpbbox = gtk_hbox_new(TRUE,10);

	gtk_box_pack_start (GTK_BOX (bpmbox),bpmlabel, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (bpmbox),bpmspin, TRUE, TRUE, 0);

	gtk_box_pack_start (GTK_BOX (bpbbox),bpblabel, TRUE, TRUE, 0);
        gtk_box_pack_start (GTK_BOX (bpbbox),bpbspin, TRUE, TRUE, 0);

	mainbox = gtk_vbox_new (FALSE,5);
	gtk_box_pack_start (GTK_BOX(mainbox), bpmbox, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX(mainbox), bpbbox, FALSE, FALSE, 0);
/*	gtk_box_pack_start (GTK_BOX(mainbox), lengthlabel, FALSE, FALSE, 0);*/

	
	dialog = gtk_dialog_new_with_buttons ("settings for beat grid",
                        (GtkWindow*)parent,
                        /*GTK_DIALOG_MODAL |*/ GTK_DIALOG_DESTROY_WITH_PARENT,
                        GTK_STOCK_OK,
                        GTK_RESPONSE_ACCEPT,
                        NULL);

	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),mainbox);
	gtk_widget_show_all (dialog);

	result = gtk_dialog_run (GTK_DIALOG (dialog));
        gtk_widget_destroy (dialog);
}

