
#include <math.h>
#include <qapplication.h>
#include <qmainwindow.h>
#include <qmotifplusstyle.h>
#include <qprinter.h>
#include <stdlib.h>

/** see ../widgets dir */
#include "qsmatrix.h"
#include "qsplotview.h"
#include "qsaxes3d.h"
#include "qssurface.h"
#include "qsfigure.h"

// implementation of QSMatrix interface
class Surface1 : public QSMatrix {
     
 public:
    Surface1() {}
    ~Surface1() {}
    
    int cols() const { return 100; }
    int rows() const { return 100; }
    
    double value( int row, int col ) { return sin( sqrt((row/8-50)*(row/8-50)+(col/8-20)*(col/8-20)) ); }
    };



int main( int argc, char ** argv ) {
    QApplication a( argc, argv );
    QApplication::setStyle( new QMotifPlusStyle() );

    QMainWindow *mw = new QMainWindow();

    // create workbook with a one empty page
    QSWorkbook *doc = new QSWorkbook( mw );
    doc->clear();
    doc->pageAdd( new QSPage() );

    // printer is used for paper size and displaying printing margins
    doc->setPrinter( new QPrinter() );

    // create the view
    QSPlotView *view = new QSPlotView( mw );
    view->setWorkbook( doc );
    mw->setCentralWidget( view );

    // create axes object and add it to the workbook
    QSAxes3D *axes  = new QSAxes3D();
    doc->page(0)->objects()->add( axes->shadowObject() );
    
    // only selected axes displayed when full page is off
    view->selection()->set( axes->shadowObject() );
    view->setFullPage( false );

    // funny sliders should change the viewpoint
    view->bindSlider( QSPlotView::HorizontalSlider, "azimuth", 0, 359 );
    view->bindSlider( QSPlotView::VerticalSlider,   "elevation", -90, 90  );

    // create dataset
    QSSurface *s1 = new QSSurface( axes ); axes->plotAdd( s1 );
    s1->setMatrix( QSSurface::ZData, new Surface1() );

    // this is how we can see to which axis this dataset is bound to
    // ( there can be many X Axes in QSAxes3D ).
    s1->defaultAxis(QSAxis::XAxisType)->setRange(10.0,100.0);

    mw->setCaption( "surface demo" );
    mw->show();
    a.connect( &a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()) );
    return a.exec();
}
