/***************************************************************************
                                  ksattrpanel.cpp
                             -------------------
    begin                : Tue Oct 10 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksattrpanel.h"
#include "../widgets/qsdrvqt.h"

#include <qcolordialog.h>
#include <qfontdialog.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qlistbox.h>
#include <qspinbox.h>
#include <qlabel.h>

//--------------------------------------------------------------//

KSAttrPanel::KSAttrPanel(QWidget *parent, const char *name )
: KSAttrPanelInterf(parent,name,TRUE)
 {
  //m_result = false;
  m_subpanel_1 = NULL;
  m_subpanel_2 = NULL;
  //connect( buttonApply,  SIGNAL(clicked()), this, SLOT(apply_clicked()) );
  //connect( buttonCancel, SIGNAL(clicked()), this, SLOT(cancel_clicked()) );
 }

//--------------------------------------------------------------//

KSAttrPanel::~KSAttrPanel()
 {
  delete m_subpanel_1;
  delete m_subpanel_2;
 }

//--------------------------------------------------------------//

void KSAttrPanel::setSubPanel1( QWidget *panel )
 {
  delete m_subpanel_1;
  m_subpanel_1 = panel;
  m_subpanel_1->resize( placePanel1->size() );
  placePanel1->setColumnLayout( 1, Horizontal );
  m_subpanel_1->show();
 }

//--------------------------------------------------------------//

void KSAttrPanel::setSubPanel2( QWidget *panel )
 {
  delete m_subpanel_2;
  m_subpanel_2 = panel;
  m_subpanel_2->resize( placePanel2->size() );
  placePanel2->setColumnLayout( 1, Horizontal );
  m_subpanel_2->show();
 }

//--------------------------------------------------------------//

QWidget *KSAttrPanel::subPanel1() const
 {
  return m_subpanel_1;
 }

//--------------------------------------------------------------//

QWidget *KSAttrPanel::subPanel2() const
 {
  return m_subpanel_2;
 }

//--------------------------------------------------------------

QWidget *KSAttrPanel::subPanelPlace1() const
 {
  return placePanel1;
 }

//--------------------------------------------------------------

QWidget *KSAttrPanel::subPanelPlace2() const
 {
  return placePanel2;
 }

//--------------------------------------------------------------//

/*
void KSAttrPanel::apply_clicked()
 {
  m_result = true;
  //emit acceptValue();
 }

//--------------------------------------------------------------//

void KSAttrPanel::cancel_clicked()
 {
  m_result = false;
  //emit acceptValue();
 }
*/
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//



class KSListBoxArrow : public QListBoxItem
 {
  public:
	KSListBoxArrow( QListBox *parent, const QSGArrow &p, const QString& name );
  	virtual ~KSListBoxArrow();
	virtual int height ( const QListBox * ) const;
	virtual int width ( const QListBox * ) const;
	QSGArrow arrow;
 protected:
	virtual void paint ( QPainter * );
 };

//-------------------------------------------------------------//

//
// List item which consist of a dart shape and a label.
//

#define ARROWBOX_SIZE_W  20
#define ARROWBOX_SIZE_H  15
#define ARROWBOX_KSPACING_W  5
#define ARROWBOX_KSPACING_H  5

KSListBoxArrow::KSListBoxArrow( QListBox *parent, const QSGArrow &init_a, const QString& name )
:QListBoxItem(parent), arrow(init_a)
 {
  setText( name );
 }

//-------------------------------------------------------------//

KSListBoxArrow::~KSListBoxArrow()
 {
 }

//-------------------------------------------------------------//

int KSListBoxArrow::height( const QListBox *lb ) const
 {
  return QMAX( ARROWBOX_SIZE_H+2*ARROWBOX_KSPACING_H, lb->fontMetrics().lineSpacing()+1 );
 }

//-------------------------------------------------------------//

int KSListBoxArrow::width( const QListBox *lb ) const
 {
  return lb->fontMetrics().width(text()) + ARROWBOX_SIZE_W + ARROWBOX_KSPACING_W*3;
 }

//-------------------------------------------------------------//

void KSListBoxArrow::paint( QPainter *p )
 {
  int w = p->fontMetrics().width(text()) + ARROWBOX_SIZE_W + 3*ARROWBOX_KSPACING_W;
  int h = QMAX( ARROWBOX_SIZE_H+2*ARROWBOX_KSPACING_H, p->fontMetrics().lineSpacing()+1 );

  QRect r( ARROWBOX_KSPACING_W,
           (h-ARROWBOX_SIZE_H)/2,
           ARROWBOX_SIZE_W,
           ARROWBOX_SIZE_H );

  QSDrvQt drv;
  QSGLine l;
  l.color = QSDrvQt::toQSGColor(p->pen().color());
  QSGArrow temp_a = arrow;
  temp_a.size = 5;
  drv.setDC(p,72,false);
  drv.startDrawing();
  drv.setLine(l);
  drv.drawDart(QSPt2f(r.center().x(),r.center().y()),0,temp_a);
  drv.stopDrawing();
  p->drawText( ARROWBOX_SIZE_W+2*ARROWBOX_KSPACING_W,
               0, w, h, Qt::AlignLeft | Qt::AlignVCenter, text() );
 }

//--------------------------------------------------------------//
//--------------------------------------------------------------//
//--------------------------------------------------------------//
//--------------------------------------------------------------//
//--------------------------------------------------------------//


KSSelectArrow::KSSelectArrow( QWidget *parent )
: QWidget( parent )
 {
  m_layout = new QGridLayout( this, 2, 2, 2 );
  m_list  = new QListBox( this );
  m_label = new QLabel( tr("Size (points):"), this );
  m_size  = new QSpinBox( 0, 999, 1, this );
  m_layout->addMultiCellWidget( m_list, 0, 0, 0, 1 );
  m_layout->addWidget( m_label, 1, 0 );
  m_layout->addWidget( m_size, 1, 1 );

  QSGArrow a; a.style = QSGArrow::None; m_arrow = a;
  a.style = QSGArrow::None;    new KSListBoxArrow( m_list, a, tr("None") );
  a.style = QSGArrow::Arrow;   new KSListBoxArrow( m_list, a, tr("Arrow") );
  a.style = QSGArrow::FArrow;  new KSListBoxArrow( m_list, a, tr("Filled Arrow") );
  a.style = QSGArrow::NArrow;  new KSListBoxArrow( m_list, a, tr("Narrow Arrow") );
  a.style = QSGArrow::RArrow;  new KSListBoxArrow( m_list, a, tr("Arrow") );
  a.style = QSGArrow::RFArrow; new KSListBoxArrow( m_list, a, tr("Filled Arrow") );
  a.style = QSGArrow::RNArrow; new KSListBoxArrow( m_list, a, tr("Narrow Arrow") );

  a.style = QSGArrow::Rect;    new KSListBoxArrow( m_list, a, tr("Rectangle") );
  a.style = QSGArrow::Diamond; new KSListBoxArrow( m_list, a, tr("Diamond") );
  a.style = QSGArrow::Circle;  new KSListBoxArrow( m_list, a, tr("Circle") );
  a.style = QSGArrow::Line;    new KSListBoxArrow( m_list, a, tr("Line") );
  a.style = QSGArrow::FDiagLine; new KSListBoxArrow( m_list, a, tr("FDiag Line") );
  a.style = QSGArrow::BDiagLine; new KSListBoxArrow( m_list, a, tr("BDiag Line") );

  m_list->setCurrentItem(0);
  connect( m_list, SIGNAL(highlighted(int)), this, SLOT(changePanelArrow(int)) );
  connect( m_size, SIGNAL(valueChanged(int)), this, SLOT(changePanelArrow(int)) );
 }

//-------------------------------------------------------------//

KSSelectArrow::~KSSelectArrow()
 {
 }

//-------------------------------------------------------------//

void KSSelectArrow::setPanelArrow( const QSGArrow& new_arrow )
 {
  if ( m_arrow != new_arrow ) {
         m_arrow = new_arrow;
         disconnect( m_list, SIGNAL(highlighted(int)), this, SLOT(changePanelArrow(int)) );
         disconnect( m_size, SIGNAL(valueChanged(int)), this, SLOT(changePanelArrow(int)) );
         m_size->setValue( m_arrow.size );
         for ( int i=0; i<(int )m_list->count(); i++ ) {
                KSListBoxArrow *item = dynamic_cast<KSListBoxArrow*>( m_list->item(i) );
                if ( item && item->arrow.style == m_arrow.style ) { m_list->setCurrentItem(i); break; }
               }
         connect( m_list, SIGNAL(highlighted(int)),  this, SLOT(changePanelArrow(int)) );
         connect( m_size, SIGNAL(valueChanged(int)), this, SLOT(changePanelArrow(int)) );
        }
 }

//-------------------------------------------------------------//

void KSSelectArrow::changePanelArrow(int)	
 {
  KSListBoxArrow *item = dynamic_cast<KSListBoxArrow*>( m_list->item( m_list->currentItem() ) );
  if ( item ) {
         QSGArrow new_arrow = m_arrow;
         new_arrow.style = item->arrow.style;
         new_arrow.size  = m_size->value();
         setPanelArrow( new_arrow );
        }
 }



//-----------------------------------------------------------------//
//-----------------------------------------------------------------//
//-----------------------------------------------------------------//
//-----------------------------------------------------------------//
//-----------------------------------------------------------------//
//-----------------------------------------------------------------//
//-----------------------------------------------------------------//


class KSListBoxColor : public QListBoxItem
 {
  public:
	KSListBoxColor( QListBox *parent, const QColor &c, const QString& name );
	virtual ~KSListBoxColor();
	virtual int height ( const QListBox * ) const;
	virtual int width ( const QListBox * ) const;
	QColor color;
  protected:
	virtual void paint ( QPainter * );
 };

#define COLORBOX_SIZE_W  15
#define COLORBOX_SIZE_H  10
#define COLORBOX_SPACING_W  5
#define COLORBOX_SPACING_H  5

KSListBoxColor::KSListBoxColor( QListBox *parent, const QColor &init_color, const QString& name )
:QListBoxItem(parent), color(init_color)
 {
  setText( name );
 }

//-------------------------------------------------------------//

KSListBoxColor::~KSListBoxColor()
 {
 }

//-------------------------------------------------------------//

int KSListBoxColor::height( const QListBox *lb ) const
 {
  QFontMetrics fm = lb->fontMetrics();
  return QMAX( COLORBOX_SIZE_H+2*COLORBOX_SPACING_H, fm.lineSpacing()+1 );
 }

//-------------------------------------------------------------//

int KSListBoxColor::width( const QListBox *lb ) const
 {
  QFontMetrics fm = lb->fontMetrics();
  return fm.width(text()) + COLORBOX_SIZE_W + COLORBOX_SPACING_W*3;
 }

//-------------------------------------------------------------//

void KSListBoxColor::paint( QPainter *p )
 {
  QFontMetrics fm = p->fontMetrics();
  int w = fm.width(text()) + COLORBOX_SIZE_W + 3*COLORBOX_SPACING_W;
  int h = QMAX( COLORBOX_SIZE_H+2*COLORBOX_SPACING_H, fm.lineSpacing()+1 );

  QRect r( COLORBOX_SPACING_W,
           (h-COLORBOX_SIZE_H)/2,
           COLORBOX_SIZE_W,
           COLORBOX_SIZE_H );

  p->fillRect( r, color );
  p->drawText( COLORBOX_SIZE_W+2*COLORBOX_SPACING_W,
               0,
               w,
               h,
               Qt::AlignLeft | Qt::AlignVCenter,
               text() );
 }


//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//--------------------------------------------------------------//


KSSelectColor::KSSelectColor( QWidget *parent )
: QWidget( parent )
 {
  m_layout = new QGridLayout( this, 3, 2, 2 );
  m_list  = new QListBox( this );
  m_label = new QLabel( tr("Alpha:"), this );
  m_alpha  = new QSpinBox( 0, 255, 1, this );
  m_custom = new QPushButton( tr("Custom ..."), this );
  m_layout->addMultiCellWidget( m_list, 0, 0, 0, 1 );
  m_layout->addWidget( m_label, 1, 0 );
  m_layout->addWidget( m_alpha, 1, 1 );
  m_layout->addMultiCellWidget( m_custom, 2, 2, 0, 1 );

  new KSListBoxColor( m_list, white, tr("Custom") );
  new KSListBoxColor( m_list, black, tr("Black")  );
  new KSListBoxColor( m_list, white, tr("White") );
  new KSListBoxColor( m_list, darkGray,  tr("Dark Gray") );
  new KSListBoxColor( m_list, gray,      tr("Gray") );
  new KSListBoxColor( m_list, lightGray, tr("Light Gray") );
  new KSListBoxColor( m_list, red,   tr("Red") );
  new KSListBoxColor( m_list, green, tr("Green") );
  new KSListBoxColor( m_list, blue,  tr("Blue") );
  new KSListBoxColor( m_list, cyan,  tr("Cyan") );
  new KSListBoxColor( m_list, magenta, tr("Magenta") );
  new KSListBoxColor( m_list, yellow, tr("Yellow") );
  new KSListBoxColor( m_list, darkRed, tr("Dark Red") );
  new KSListBoxColor( m_list, darkGreen, tr("DarkGren") );
  new KSListBoxColor( m_list, darkBlue, tr("Dark Blue") );
  new KSListBoxColor( m_list, darkCyan, tr("Dark Cyan") );
  new KSListBoxColor( m_list, darkMagenta, tr("Dark Magenta") );
  new KSListBoxColor( m_list, darkYellow, tr("Dark Yellow") );

  m_color = black;
  m_list->setCurrentItem(1);
  m_list->setHScrollBarMode( QScrollView::AlwaysOff );
  m_color_alpha = 255;
  m_alpha->setValue( m_color_alpha );
  connect( m_custom, SIGNAL(clicked()), this, SLOT(showColorDialog()) );
  connect( m_list,   SIGNAL(highlighted(int)), this, SLOT(changePanelColor(int)) );
  connect( m_alpha,  SIGNAL(valueChanged(int)), this, SLOT(changePanelAlpha(int)) );
 }

//--------------------------------------------------------------//

KSSelectColor::~KSSelectColor()
 {
 }


//-------------------------------------------------------------//

void KSSelectColor::setPanelColor( const QSGColor& new_color )
 {
  QColor color( new_color.r, new_color.g, new_color.b );
  if ( m_color != color ) {
         int i;
         for ( i=1; i<(int )m_list->count(); i++ ) {
                KSListBoxColor *item = dynamic_cast<KSListBoxColor*>(m_list->item(i));
                if ( item && item->color == color ) { m_color = color; m_list->setCurrentItem(i); break; }
               }
         // not ont the list
         if ( i == (int )m_list->count() ) {
                dynamic_cast<KSListBoxColor*>(m_list->item(0))->color = m_color = color;
                m_list->setCurrentItem( 0 );
                m_list->triggerUpdate(TRUE);
              }
        }

  unsigned char alpha = new_color.a;
  if ( alpha != m_color_alpha ) {
         m_color_alpha = alpha;
         m_alpha->setValue( m_color_alpha );
        }
 }

//-------------------------------------------------------------//

QSGColor KSSelectColor::panelColor() const
 {
  return QSGColor( m_color.red(), m_color.green(), m_color.blue(), m_color_alpha );
 }

//-------------------------------------------------------------//

void KSSelectColor::showColorDialog()
 {
  QColor color = QColorDialog::getColor( m_color, this );
  if ( color.isValid() ) setPanelColor( QSGColor(color.red(),color.green(),color.blue(),m_color_alpha) );
 }

//-------------------------------------------------------------//

void KSSelectColor::changePanelColor( int )
 {
  KSListBoxColor *item = dynamic_cast<KSListBoxColor*>(m_list->item(m_list->currentItem()));
  if ( item ) m_color = item->color;
 }

//-------------------------------------------------------------//

void KSSelectColor::changePanelAlpha( int value )
 {
  if ( m_alpha->text().length() > 0 )  m_color_alpha = (unsigned char )value;
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

class KSListBoxFill : public QListBoxItem
 {
  public:
	KSListBoxFill( QListBox *parent, const QBrush &b, const QString& name );
	virtual ~KSListBoxFill();
	virtual int height( const QListBox * ) const;
	virtual int width ( const QListBox * ) const;
	QBrush brush;

  protected:
	virtual void paint ( QPainter * );
 };

//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//

#define FILLBOX_SIZE_W  20
#define FILLBOX_SIZE_H  15
#define FILLBOX_KSACING_W  5
#define FILLBOX_KSACING_H  5

KSListBoxFill::KSListBoxFill( QListBox *parent, const QBrush &init_brush, const QString& name )
:QListBoxItem(parent), brush(init_brush)
 {
  setText( name );
 }

//-------------------------------------------------------------//

KSListBoxFill::~KSListBoxFill()
 {
 }

//-------------------------------------------------------------//

int KSListBoxFill::height( const QListBox *lb ) const
 {
  return QMAX( FILLBOX_SIZE_H+2*FILLBOX_KSACING_H, lb->fontMetrics().lineSpacing()+1 );
 }

//-------------------------------------------------------------//

int KSListBoxFill::width( const QListBox *lb ) const
 {
  return lb->fontMetrics().width(text()) + FILLBOX_SIZE_W + FILLBOX_KSACING_W*3;
 }

//-------------------------------------------------------------//

void KSListBoxFill::paint( QPainter *p )
 {
  int w = p->fontMetrics().width(text()) + FILLBOX_SIZE_W + 3*FILLBOX_KSACING_W;
  int h = QMAX( FILLBOX_SIZE_H+2*FILLBOX_KSACING_H, p->fontMetrics().lineSpacing()+1 );

  p->setBrushOrigin( 0, listBox()->itemRect(this).y() );

  QRect r( FILLBOX_KSACING_W,
           (h-FILLBOX_SIZE_H)/2,
           FILLBOX_SIZE_W,
           FILLBOX_SIZE_H );

  QBrush br = QBrush( p->pen().color(), brush.style() );
  p->fillRect( r, brush );
  p->drawRect( r );
  p->drawText( FILLBOX_SIZE_W+2*FILLBOX_KSACING_W,
               0,
               w,
               h,
               Qt::AlignLeft | Qt::AlignVCenter,
               text() );
 }

//-----------------------------------------------------------//
//-----------------------------------------------------------//

KSSelectFill::KSSelectFill( QWidget *parent )
: QWidget( parent )
 {
  m_layout = new QGridLayout( this, 1, 2, 2 );
  m_list  = new QListBox( this );
  m_layout->addMultiCellWidget( m_list, 0, 0, 0, 1 );
  new KSListBoxFill( m_list, QBrush( black, Qt::SolidPattern ), tr("Solid") );
  new KSListBoxFill( m_list, QBrush( white, Qt::NoBrush ),  tr("Transparent") ) ;
  new KSListBoxFill( m_list, QBrush( black, Qt::HorPattern ), tr("Horizontal Lines") );
  new KSListBoxFill( m_list, QBrush( black, Qt::VerPattern ), tr("Vertical Lines") );
  new KSListBoxFill( m_list, QBrush( black, Qt::CrossPattern ), tr("Cross Lines") );
  new KSListBoxFill( m_list, QBrush( black, Qt::BDiagPattern ), tr("BDiag Lines") );
  new KSListBoxFill( m_list, QBrush( black, Qt::FDiagPattern ), tr("FDiag Lines") );
  new KSListBoxFill( m_list, QBrush( black, Qt::DiagCrossPattern ), tr("Diag Cross Lines") );
  new KSListBoxFill( m_list, QBrush( black, Qt::Dense4Pattern ), tr("Half Pattern") );

  m_brush = QBrush( black, Qt::SolidPattern );
  m_list->setCurrentItem( 0 );
  m_list->setHScrollBarMode( QScrollView::AlwaysOff );
  connect( m_list, SIGNAL(highlighted(int)), this, SLOT(changePanelBrush(int)) );
 }

//-----------------------------------------------------------//

KSSelectFill::~KSSelectFill()
 {
 }

//-----------------------------------------------------------//

void KSSelectFill::setPanelBrush( const QBrush& new_brush )
 {
  QBrush brush = new_brush; brush.setColor( black );
  if ( m_brush.style() != brush.style() ) {
         int i;
         for ( i=0; i<(int )m_list->count(); i++ ) {
                KSListBoxFill *item = dynamic_cast<KSListBoxFill*>(m_list->item(i));
                if ( item && item->brush.style() == brush.style() ) { m_brush = brush; m_list->setCurrentItem(i); break; }
               }
         // not on the list
         if ( i == (int )m_list->count() ) {
                KSListBoxFill *item = dynamic_cast<KSListBoxFill*>(m_list->item(0));
                if ( item ) m_brush = item->brush;
                m_list->setCurrentItem(0);
                m_list->triggerUpdate(TRUE);
               }
        }
 }

//-----------------------------------------------------------//

void KSSelectFill::changePanelBrush(int)
 {
  KSListBoxFill *item = dynamic_cast<KSListBoxFill*>(m_list->item(m_list->currentItem()));
  if ( item ) setPanelBrush( item->brush );
 }

//-----------------------------------------------------------//

void KSSelectFill::setPanelFill( const QSGFill& fill )
 {
  setPanelBrush( QSDrvQt::toQBrush( fill ) );
 }

//-----------------------------------------------------------//

QSGFill KSSelectFill::panelFill() const
 {
  QSGFill result = QSDrvQt::toQSGFill( m_brush );
  return result;
 }

//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//

class KSListBoxFont : public QListBoxItem
 {
  public:
	KSListBoxFont( QListBox *parent, const QFont &f, const QString& name );
	virtual ~KSListBoxFont();
	virtual int height ( const QListBox * ) const;
	virtual int width ( const QListBox * ) const;
	QFont font;
  protected:
	virtual void paint ( QPainter * );
 };

#define FONTBOX_KSACING_W 5

KSListBoxFont::KSListBoxFont( QListBox *parent, const QFont &init_font, const QString& name )
:QListBoxItem(parent), font(init_font)
 {
  setText( name );
 }

//-------------------------------------------------------------//

KSListBoxFont::~KSListBoxFont()
 {
 }

//-------------------------------------------------------------//

int KSListBoxFont::height( const QListBox * ) const
 {
  return QFontMetrics(font).lineSpacing()+1;
 }

//-------------------------------------------------------------//

int KSListBoxFont::width( const QListBox * ) const
 {
  return QFontMetrics(font).width(text()) + FONTBOX_KSACING_W*2;
 }

//-------------------------------------------------------------//

void KSListBoxFont::paint( QPainter *paint )
 {
  int w = QFontMetrics(font).width(text()) + FONTBOX_KSACING_W*2;
  int h = QFontMetrics(font).lineSpacing()+1;
  paint->setFont( font );
  paint->drawText( FONTBOX_KSACING_W,
                   0,
                   w,
                   h,
                   Qt::AlignLeft | Qt::AlignVCenter,
                   text() );

 }

//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//

KSSelectFont::KSSelectFont( QWidget *parent )
: QWidget( parent )
 {
  m_layout = new QGridLayout( this, 2, 2, 2 );
  m_list  = new QListBox( this );
  m_custom = new QPushButton( tr("Custom ..."), this );
  m_layout->addMultiCellWidget( m_list, 0, 0, 0, 1 );
  m_layout->addMultiCellWidget( m_custom, 1, 1, 0, 1 );

  QFont font( "helvetica", 10 );
  new KSListBoxFont( m_list, font, tr("Custom Style ...") );
  new KSListBoxFont( m_list, font, "Helvetica" );
  m_font = font; m_list->setCurrentItem(1);
  font.setItalic( TRUE );
  new KSListBoxFont( m_list, font, "Helvetica Italic" );
  font.setItalic( FALSE );
  font.setPointSize( 8 );
  new KSListBoxFont( m_list, font, "Helvetica Small" );
  font.setBold( TRUE );
  font.setPointSize(12);
  new KSListBoxFont( m_list, font, "Helvetica Large" );
  font.setFamily("Times");
  font.setPointSize(10);
  font.setBold( FALSE );
  new KSListBoxFont( m_list, font, "Times" );
  font.setItalic( TRUE );
  new KSListBoxFont( m_list, font, "Times Italic" );
  font.setItalic( FALSE );
  font.setPointSize( 8 );
  new KSListBoxFont( m_list, font, "Times Small" );
  font.setFamily("Courier");
  font.setPointSize(10);
  font.setBold( FALSE );
  new KSListBoxFont( m_list, font, "Courier" );

  m_list->setHScrollBarMode( QScrollView::AlwaysOff );
  connect( m_custom, SIGNAL(clicked()), this, SLOT(showFontDialog()) );
  connect( m_list, SIGNAL(highlighted(int)), this, SLOT(changePanelQFont(int)) );
 }

//-------------------------------------------------------------//

KSSelectFont::~KSSelectFont()
 {
 }

//-------------------------------------------------------------//

void KSSelectFont::setPanelQFont( const QFont& font )
 {
   if ( m_font != font ) {
         int i;
         for ( i=1; i<(int )m_list->count(); i++ ) {
                KSListBoxFont *item = dynamic_cast<KSListBoxFont*>(m_list->item(i));
                if ( item && item->font == font ) { m_font = font; m_list->setCurrentItem(i); break; }
               }
         // not on the list
         if ( i == (int )m_list->count() ) {
                dynamic_cast<KSListBoxFont*>(m_list->item(0))->font = m_font = font;
                m_list->setCurrentItem(0);
                m_list->triggerUpdate(TRUE);
               }

         m_font = font;
        }
 }

//-------------------------------------------------------------//

void KSSelectFont::showFontDialog()
 {
  bool ok;
  QFont font = QFontDialog::getFont( &ok, m_font );
  if ( ok ) setPanelQFont( font );
 }

//-------------------------------------------------------------//

void KSSelectFont::changePanelQFont(int)	
 {
  KSListBoxFont *item = dynamic_cast<KSListBoxFont*>(m_list->item(m_list->currentItem()));
  if ( item ) setPanelQFont( item->font );
 }

//-----------------------------------------------------------//

void KSSelectFont::setPanelFont( const QSGFont &f )
 {
  setPanelQFont( QSDrvQt::toQFont(f) );
 }

//-----------------------------------------------------------//

QSGFont KSSelectFont::panelFont() const
 {
  QSGFont result;
  result = QSDrvQt::toQSGFont( panelQFont(), black );
  return result;
 }

//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//


//-------------------------------------------------------------//

class KSListBoxLine : public QListBoxItem
 {
  public:
	KSListBoxLine( QListBox *parent, const QPen &c, const QString& name );
	virtual ~KSListBoxLine();
	virtual int height ( const QListBox * ) const;
	virtual int width ( const QListBox * ) const;
	QPen pen;

  protected:
	virtual void paint ( QPainter * );
 };

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

#define LINEBOX_SIZE_W    40
#define LINEBOX_SIZE_H    15
#define LINEBOX_KSACING_W  5
#define LINEBOX_KSACING_H  5

KSListBoxLine::KSListBoxLine( QListBox *parent, const QPen &init_pen, const QString& name )
:QListBoxItem(parent), pen(init_pen)
 {
  setText( name );
 }

//-------------------------------------------------------------//

KSListBoxLine::~KSListBoxLine()
 {
 }

//-------------------------------------------------------------//

int KSListBoxLine::height( const QListBox *lb ) const
 {
  return QMAX( LINEBOX_SIZE_H+2*LINEBOX_KSACING_H, lb->fontMetrics().lineSpacing()+1 );
 }

//-------------------------------------------------------------//

int KSListBoxLine::width( const QListBox *lb ) const
 {
  return lb->fontMetrics().width(text()) + LINEBOX_SIZE_W + LINEBOX_KSACING_W*3;
 }

//-------------------------------------------------------------//

void KSListBoxLine::paint( QPainter *paint )
 {
  int w = paint->fontMetrics().width(text()) + LINEBOX_SIZE_W + 3*LINEBOX_KSACING_W;
  int h = QMAX( LINEBOX_SIZE_H+2*LINEBOX_KSACING_H, paint->fontMetrics().lineSpacing()+1 );

  QRect r( LINEBOX_KSACING_W,
           (h-LINEBOX_SIZE_H)/2,
           LINEBOX_SIZE_W,
           LINEBOX_SIZE_H );

  QPen curr_pen = pen;
  if ( listBox() && selected() ) curr_pen.setColor( listBox()->colorGroup().highlightedText() );
  paint->drawText( LINEBOX_SIZE_W+2*LINEBOX_KSACING_W,
                   0,
                   w,
                   h,
                   Qt::AlignLeft | Qt::AlignVCenter,
                   text() );
  paint->setPen( curr_pen );
  paint->drawLine( r.left(), r.top()+(r.bottom()-r.top())/2, r.right(), r.top()+(r.bottom()-r.top())/2 );
 }


//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

KSSelectLine::KSSelectLine( QWidget *parent )
: QWidget( parent )
 {
  m_layout = new QGridLayout( this, 2, 2, 2 );
  m_list  = new QListBox( this );
  m_label = new QLabel( tr("Width:"), this );
  m_width  = new QSpinBox( 0, 999, 1, this );
  m_layout->addMultiCellWidget( m_list, 0, 0, 0, 1 );
  m_layout->addWidget( m_label, 1, 0 );
  m_layout->addWidget( m_width, 1, 1 );

  m_pen_width = 0;
  QSGLine l; l.style = QSGLine::Invisible; m_pen = QSDrvQt::toQPen(l);
  l.style = QSGLine::Invisible; new KSListBoxLine( m_list, QSDrvQt::toQPen(l), tr("Invisible") );
  l.style = QSGLine::Solid;      new KSListBoxLine( m_list, QSDrvQt::toQPen(l), tr("Solid") );
  l.style = QSGLine::Dash;       new KSListBoxLine( m_list, QSDrvQt::toQPen(l), tr("Dashed") );
  l.style = QSGLine::DashDot;    new KSListBoxLine( m_list, QSDrvQt::toQPen(l), tr("Dashed-Dotted") );
  l.style = QSGLine::Dot;        new KSListBoxLine( m_list, QSDrvQt::toQPen(l), tr("Dotted") );
  l.style = QSGLine::DashDotDot; new KSListBoxLine( m_list, QSDrvQt::toQPen(l), tr("Dashed-2Dotted") );
  m_list->setHScrollBarMode( QScrollView::AlwaysOff );
  m_list->setCurrentItem(0);
  connect( m_list, SIGNAL(highlighted(int)), this, SLOT(changePanelQPen(int)) );
  connect( m_width, SIGNAL(valueChanged(int)), this, SLOT(changePanelLineWidth(int)) );
 }

//-------------------------------------------------------------//

KSSelectLine::~KSSelectLine()
 {
 }

//-------------------------------------------------------------//

void KSSelectLine::setPanelQPen( const QPen& new_pen )
 {
  QPen pen = new_pen; pen.setColor( black ); pen.setWidth( 0 );
  if ( m_pen != pen ) {
         int i;
         for ( i=0; i<(int )m_list->count(); i++ ) {
		cout << " checking " << i << endl;
                KSListBoxLine *item = dynamic_cast<KSListBoxLine*>(m_list->item(i));
                if ( item && item->pen == pen ) { m_pen = pen; m_list->setCurrentItem(i); break; }
               }
         if ( i == (int )m_list->count() ) {
                KSListBoxLine *item = dynamic_cast<KSListBoxLine*>(m_list->item(0));
                if ( item ) m_pen = item->pen;
                m_list->setCurrentItem(0);
                m_list->triggerUpdate(TRUE);
               }
        }
 }

//-------------------------------------------------------------//

void KSSelectLine::setPanelLineWidth( int width )
 {
  if ( m_pen_width != width ) { m_pen_width = width; m_width->setValue(width); }
 }

//-------------------------------------------------------------//

void KSSelectLine::changePanelQPen(int)	
 {
  KSListBoxLine *item = dynamic_cast<KSListBoxLine*>(m_list->item(m_list->currentItem()));
  if ( item ) setPanelQPen( item->pen );
 }

//-------------------------------------------------------------//

void KSSelectLine::changePanelLineWidth( int value )	
 {
  setPanelLineWidth( value );
 }

//-----------------------------------------------------------//

void KSSelectLine::setPanelLine( const QSGLine &l )
 {
  QPen pen = QSDrvQt::toQPen( l );
  setPanelQPen( pen );
  setPanelLineWidth( l.width );
 }

//-----------------------------------------------------------//

QSGLine KSSelectLine::panelLine() const
 {
  QSGLine result;
  result = QSDrvQt::toQSGLine( panelQPen() );
  result.width = panelLineWidth();
  return result;
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

class KSListBoxPoint : public QListBoxItem
 {
  public:
	KSListBoxPoint( QListBox *parent, const QSGPoint &p, const QString& name );
	virtual ~KSListBoxPoint();
	virtual int height ( const QListBox * ) const;
	virtual int width ( const QListBox * ) const;
	QSGPoint point;

  protected:
	virtual void paint ( QPainter * );

 };

#define POINTBOX_SIZE_W  20
#define POINTBOX_SIZE_H  15
#define POINTBOX_KSACING_W  5
#define POINTBOX_KSACING_H  5

KSListBoxPoint::KSListBoxPoint( QListBox *parent, const QSGPoint &init_point, const QString& name )
:QListBoxItem(parent), point(init_point)
 {
  setText( name );
 }

//-------------------------------------------------------------//

KSListBoxPoint::~KSListBoxPoint()
 {
 }

//-------------------------------------------------------------//

int KSListBoxPoint::height( const QListBox *lb ) const
 {
  return QMAX( POINTBOX_SIZE_H+2*POINTBOX_KSACING_H, lb->fontMetrics().lineSpacing()+1 );
 }

//-------------------------------------------------------------//

int KSListBoxPoint::width( const QListBox *lb ) const
 {
  return lb->fontMetrics().width(text()) + POINTBOX_SIZE_W + POINTBOX_KSACING_W*3;
 }

//-------------------------------------------------------------//

void KSListBoxPoint::paint( QPainter *p )
 {
  int w = p->fontMetrics().width(text()) + POINTBOX_SIZE_W + 3*POINTBOX_KSACING_W;
  int h = QMAX( POINTBOX_SIZE_H+2*POINTBOX_KSACING_H, p->fontMetrics().lineSpacing()+1 );

  QRect r( POINTBOX_KSACING_W,
           (h-POINTBOX_SIZE_H)/2,
           POINTBOX_SIZE_W,
           POINTBOX_SIZE_H );

  QSGPoint pts = point; pts.size = 9; pts.color = QSDrvQt::toQSGColor( p->pen().color() );

  QSDrvQt drv;
  drv.setDC(p,72,false);
  drv.startDrawing();
  drv.drawPoint( QSPt2f(r.center().x(), r.center().y()), pts );
  drv.stopDrawing();
  p->drawText( POINTBOX_SIZE_W+2*POINTBOX_KSACING_W,
               0,
               w,
               h,
               Qt::AlignLeft | Qt::AlignVCenter,
               text() );
 }


//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

KSSelectPoint::KSSelectPoint( QWidget *parent )
: QWidget( parent )
 {
  m_layout = new QGridLayout( this, 2, 2, 2 );
  m_list  = new QListBox( this );
  m_label = new QLabel( tr("Size (points):"), this );
  m_size  = new QSpinBox( 0, 999, 1, this );
  m_layout->addMultiCellWidget( m_list, 0, 0, 0, 1 );
  m_layout->addWidget( m_label, 1, 0 );
  m_layout->addWidget( m_size, 1, 1 );

  QSGPoint p; p.fill  = QSGPoint::Transparent;
  p.style = QSGPoint::Invisible;   new KSListBoxPoint( m_list, p, tr("Invisible") );
  p.style = QSGPoint::Circle;      new KSListBoxPoint( m_list, p, tr("Circle") );
  p.style = QSGPoint::Rect;        new KSListBoxPoint( m_list, p, tr("Rectangle") );
  p.style = QSGPoint::Triangle;    new KSListBoxPoint( m_list, p, tr("Triangle") );
  p.style = QSGPoint::Diamond;     new KSListBoxPoint( m_list, p, tr("Diamond") );
  p.style = QSGPoint::Cross;       new KSListBoxPoint( m_list, p, tr("Cross") );
  p.style = QSGPoint::Plus;        new KSListBoxPoint( m_list, p, tr("Plus") );
  p.style = QSGPoint::HLine;       new KSListBoxPoint( m_list, p, tr("HLine") );
  p.style = QSGPoint::VLine;       new KSListBoxPoint( m_list, p, tr("VLine") );
  p.fill  = QSGPoint::Filled;
  p.style = QSGPoint::Circle;     new KSListBoxPoint( m_list, p, tr("Filled Circle") );
  p.style = QSGPoint::Rect;       new KSListBoxPoint( m_list, p, tr("Filled Rectangle") );
  p.style = QSGPoint::Triangle;   new KSListBoxPoint( m_list, p, tr("Filled Triangle") );
  p.style = QSGPoint::Diamond;    new KSListBoxPoint( m_list, p, tr("Filled Diamond") );
  p.fill  = QSGPoint::Opaque;
  p.style = QSGPoint::Circle;     new KSListBoxPoint( m_list, p, tr("Opaque Circle") );
  p.style = QSGPoint::Rect;       new KSListBoxPoint( m_list, p, tr("Opaque Rectangle") );
  p.style = QSGPoint::Triangle;   new KSListBoxPoint( m_list, p, tr("Opaque Triangle") );
  p.style = QSGPoint::Diamond;    new KSListBoxPoint( m_list, p, tr("Opaque Diamond") );

  m_list->setHScrollBarMode( QScrollView::AlwaysOff );
  m_list->setCurrentItem(0);
  m_size->setValue(9);
  connect( m_list, SIGNAL(highlighted(int)),  this, SLOT(changePanelPointShape(int)) );
  connect( m_size, SIGNAL(valueChanged(int)), this, SLOT(changePanelPointShape(int)) );
 }

//-------------------------------------------------------------//

KSSelectPoint::~KSSelectPoint()
 {
 }

//-------------------------------------------------------------//

void KSSelectPoint::setPanelPointShape( const QSGPoint& new_point )
 {
  if ( m_point != new_point ) {
         m_point = new_point;
         disconnect( m_list, SIGNAL(highlighted(int)),  this, SLOT(changePanelPointShape(int)) );
         disconnect( m_size, SIGNAL(valueChanged(int)), this, SLOT(changePanelPointShape(int)) );
         m_size->setValue( m_point.size );
         for ( int i=0; i<(int )m_list->count(); i++ ) {
                KSListBoxPoint *item = dynamic_cast<KSListBoxPoint*>(m_list->item(i));
                if ( item && item->point.style == m_point.style && item->point.fill == m_point.fill ) {
                         m_list->setCurrentItem(i);
                         break;
                        }
               }
         connect( m_list, SIGNAL(highlighted(int)),  this, SLOT(changePanelPointShape(int)) );
         connect( m_size, SIGNAL(valueChanged(int)), this, SLOT(changePanelPointShape(int)) );
        }
 }
//-------------------------------------------------------------//

void KSSelectPoint::changePanelPointShape(int)	
 {
  KSListBoxPoint *item = dynamic_cast<KSListBoxPoint*>(m_list->item(m_list->currentItem()));
  if ( item ) {
         QSGPoint new_p = m_point;
         new_p.style = item->point.style;
         new_p.fill  = item->point.fill;
         new_p.size  = m_size->value();
         setPanelPointShape( new_p );
        }
 }

//-----------------------------------------------------------//

void KSSelectPoint::setPanelPoint( const QSGPoint &p )
 {
  setPanelPointShape( p );
 }

//-----------------------------------------------------------//

QSGPoint KSSelectPoint::panelPoint() const
 {
  QSGPoint result;
  result = panelPointShape();
  return result;
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
