/***************************************************************************
                                  ksgriddlg.cpp
                             -------------------
    begin                : Sat Apr 7 2001
    copyright            : (C) 2001 by Kamil Dobkowski
    email                : kamildobk@poczta.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksgriddlg.h"
#include "../widgets/qsplotview.h"
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qpushbutton.h>

KSGridDlg::KSGridDlg( QSPlotView *view, QWidget *parent, const char *name)
 : KSGridDlgInterf(parent,name,true)
  {
   m_view = view;
   gridx->setValue( m_view->gridSpacingX() );
   gridy->setValue( m_view->gridSpacingY() );
   visible->setChecked( m_view->gridVisible() );
   page_margins->setChecked( m_view->pageMarginsVisible() );
   setCaption( tr("Grid") );
   connect( bok, SIGNAL(clicked()), this, SLOT(accept()) );
   connect( bcancel, SIGNAL(clicked()), this, SLOT(reject()) );
   }

//-----------------------------------------------------------//

KSGridDlg::~KSGridDlg()
  {
  }

//-----------------------------------------------------------//

void KSGridDlg::accept()
  {
   m_view->setGridSpacing( gridx->value(), gridy->value() );
   m_view->setGridVisible( visible->isChecked() );
   m_view->setPageMarginsVisible( page_margins->isChecked() );
   QDialog::accept();
  }

//-----------------------------------------------------------//
