/***************************************************************************
                                 ksmmatrixpanel.cpp
                             -------------------
    begin
    copyright            : (C) 2001 by Kamil Dobkowski
    email                : kamildbk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksmpanels.h"

#include "kschannellist.h"
#include "../ksworkbook.h"
#include "../ksglobalmatrixlist.h"
#include "../kscommands.h"
#include "../ksmatrix.h"
#include "../ksdatasymbolfactory.h"
#include "../widgets/qsdata.h"
#include "../widgets/qsconsole.h"
#include "../formula/mpformula.h"

#include <qpushbutton.h>
#include <qlineedit.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qevent.h>
#include <qapplication.h>
#include <qmultilineedit.h>
#include <qmessagebox.h>
#include <iostream>

// All constructors should take QSData and channel instead just KSMatrix*
KSMPanelMatrix::KSMPanelMatrix( KSWorkbook *workbook, KSMatrix *matrix, QWidget *parent )
:KSMPanelMatrixInterf( parent )
 {
  m_workbook = workbook;
  m_matrix = matrix;
  m_data_object = matrix->dataObject();
  m_channel = matrix->channel();
  connect( buttonApply, SIGNAL(clicked()), this, SLOT(apply()) );
  updateContents();
 }

//----------------------------------------------------------------------------------------//

KSMPanelMatrix::~KSMPanelMatrix()
 {
 }

//----------------------------------------------------------------------------------------//

void KSMPanelMatrix::apply()
 {
  EType new_type = EDouble;
  switch( matrixType->currentItem() ) {
	case 0:	new_type = EUChar;  break;
	case 1: new_type = EShort;  break;
	case 2: new_type = EUShort; break;
	case 3:	new_type = ELong;   break;
	case 4: new_type = EFloat;  break;
	case 5: new_type = EDouble; break;
	}

  int new_rows = matrixRows->value();
  int new_cols = matrixCols->value();

  if ( isModified() ) {
	KSMatrix *new_matrix = KSMatrix::create(new_type);
        new_matrix->resize(new_rows,new_cols);
        for( int row=0; row<new_matrix->rows(); row++ )
		for( int col=0; col<new_matrix->cols(); col++ ) {
			if ( row < m_matrix->rows() &&
			     col < m_matrix->cols()  ) {
				new_matrix->setValue( row, col, m_matrix->value(row,col) );
				}
			}
        m_matrix = new_matrix;
        m_workbook->execute( new KSCmdSetData(m_data_object,m_channel,new_matrix) );	
	}
 }



//----------------------------------------------------------------------------------------//

bool KSMPanelMatrix::isModified()
 {
  EType new_type = EDouble;
  switch( matrixType->currentItem() ) {
	case 0:	new_type = EUChar;  break;
	case 1: new_type = EShort;  break;
	case 2: new_type = EUShort; break;
	case 3:	new_type = ELong;   break;
	case 4: new_type = EFloat;  break;
	case 5: new_type = EDouble; break;
	}
  int new_rows = matrixRows->value();
  int new_cols = matrixCols->value();

  if ( m_matrix &&
       new_rows != m_matrix->rows() ||
       new_cols != m_matrix->cols() ||
       new_type != m_matrix->type()  ) return true;

  return false;
 }

//----------------------------------------------------------------------------------------//

void KSMPanelMatrix::updateContents()
 {
  matrixRows->setValue( m_matrix->rows() );
  matrixCols->setValue( m_matrix->cols() );
  switch( m_matrix->type() ) {
	case EUChar: matrixType->setCurrentItem( 0 ); break;
	case EShort: matrixType->setCurrentItem( 1 ); break;
	case EUShort:matrixType->setCurrentItem( 2 ); break;
	case ELong:  matrixType->setCurrentItem( 3 ); break;
	case EFloat: matrixType->setCurrentItem( 4 ); break;
	case EDouble:matrixType->setCurrentItem( 5 ); break;
	}
 }

//----------------------------------------------------------------------------------------//

QSMatrix *KSMPanelMatrix::editedMatrix()
 {
  return m_matrix;
 }


//----------------------------------------------------------------------------------------//
//----------------------------------------------------------------------------------------//
//----------------------------------------------------------------------------------------//
//----------------------------------------------------------------------------------------//
//----------------------------------------------------------------------------------------//




KSMPanelRef::KSMPanelRef( KSWorkbook *workbook, KSMatrixWorksheetCellRange *matrix, QWidget *parent )
:KSMPanelRefInterf( parent )
 {
  m_workbook = workbook;
  m_matrix = matrix;
  m_data_object = matrix->dataObject();
  m_channel = matrix->channel();
  m_chan_list = NULL;
  connect( buttonApply, SIGNAL(clicked()), this, SLOT(apply()) );
  QApplication::postEvent( this, new QCustomEvent(QEvent::User) );
 }

//----------------------------------------------------------------------------------------//

KSMPanelRef::~KSMPanelRef()
 {
 }

//----------------------------------------------------------------------------------------//

void KSMPanelRef::customEvent( QCustomEvent *e )
// I couldn't create m_chan_list in the constructor because the constructor is
// called in signal KSSheetList::sigDataChanged and m_chan_list connects
// to the same signal from the same object during its initialization - it seems as a little bit
// confusing to the QT.
 {
  KSMPanelRefInterf::customEvent(e);
  m_chan_list = new KSChannelList( channelListPlace );
  m_chan_list->setGeometry( channelListPlace->rect() );
  m_chan_list->addColumn( tr("Name"), 90 );
  m_chan_list->addColumn( tr(""),  80 );
  m_chan_list->addColumn( tr(""),  50 );
  m_chan_list->setDataObject( m_workbook->sheets(), false, 0, false );
  m_chan_list->setRootIsDecorated( false );
  m_chan_list->show();
  updateContents();
 }

//----------------------------------------------------------------------------------------//

void KSMPanelRef::apply()
 {
  if ( !m_chan_list ) return;

  KSChannelListItem *citem = m_chan_list->selected();
  QSData *new_object = citem ? citem->dataObject() : NULL;
  int new_channel = citem ? citem->channel() : NULL;
  int new_col_from = matrixColFrom->text().toInt();
  int new_col_to   = matrixColTo->text().toInt();
  int new_row_from = matrixRowFrom->text().toInt();
  int new_row_to   = matrixRowTo->text().toInt();
  int new_col_step = matrixColStep->text().toInt();
  int new_row_step = matrixRowStep->text().toInt();
  bool new_transposition = matrixTransposition->isChecked();
  //QString new_name = matrixName->text();

  if ( new_channel < 0 ) new_object = NULL;

  if ( isModified() ) {
	KSMatrixWorksheetCellRange *new_matrix = new KSMatrixWorksheetCellRange(m_workbook);
	new_matrix->setWorksheet( m_workbook->sheets()->childIndex(new_object) );
	new_matrix->setRowFrom( new_row_from );
	new_matrix->setRowStep( new_row_step );
	new_matrix->setRowTo( new_row_to );
	new_matrix->setColFrom( new_col_from );
	new_matrix->setColStep( new_col_step );
	new_matrix->setColTo( new_col_to );
	new_matrix->setTransposition( new_transposition );	
        m_matrix = new_matrix;
        m_workbook->execute( new KSCmdSetData(m_data_object,m_channel,new_matrix) );
       }
 }

//----------------------------------------------------------------------------------------//

bool KSMPanelRef::isModified()
 {
  if ( !m_chan_list ) return false;

  KSChannelListItem *citem = m_chan_list->selected();
  QSData *new_object = citem ? citem->dataObject() : NULL;
  int new_channel = citem ? citem->channel() : NULL;
  int new_col_from = matrixColFrom->text().toInt();
  int new_col_to   = matrixColTo->text().toInt();
  int new_row_from = matrixRowFrom->text().toInt();
  int new_row_to   = matrixRowTo->text().toInt();
  int new_col_step = matrixColStep->text().toInt();
  int new_row_step = matrixRowStep->text().toInt();
  bool new_transposition = matrixTransposition->isChecked();

  if ( new_channel < 0 ) new_object = NULL;

  if ( m_matrix->refObject() != new_object ||
       m_matrix->refChannel() != new_channel ||
       m_matrix->transposition() != new_transposition ||
       new_row_from != m_matrix->refRowFrom() ||
       new_row_to   != m_matrix->refRowTo() ||
       new_col_from != m_matrix->refColFrom() ||
       new_col_to   != m_matrix->refColTo() ||
       new_row_step != m_matrix->refRowStep() ||
       new_col_step != m_matrix->refColStep() ) return true;

  return false;
 }

//----------------------------------------------------------------------------------------//

void KSMPanelRef::updateContents()
 {
  matrixColFrom->setText( QString::number(m_matrix->refColFrom()) );
  matrixColTo->setText( QString::number(m_matrix->refColTo()) );
  matrixRowFrom->setText( QString::number(m_matrix->refRowFrom()) );
  matrixRowTo->setText( QString::number(m_matrix->refRowTo()) );
  matrixColStep->setText( QString::number(m_matrix->refColStep()) );
  matrixRowStep->setText( QString::number(m_matrix->refRowStep()) );
  matrixTransposition->setChecked( m_matrix->transposition() );
  m_chan_list->select( m_matrix->refObject(), m_matrix->refChannel() );
 }

//----------------------------------------------------------------------------------------//

QSMatrix *KSMPanelRef::editedMatrix()
 {
  return m_matrix;
 }



//----------------------------------------------------------------------------------------//
//----------------------------------------------------------------------------------------//
//----------------------------------------------------------------------------------------//
//----------------------------------------------------------------------------------------//
//----------------------------------------------------------------------------------------//
//----------------------------------------------------------------------------------------//










KSMPanelString::KSMPanelString( KSWorkbook *workbook, KSMatrixString *matrix, QWidget *parent )
:KSMPanelStringInterf( parent )
 {
  m_workbook = workbook;
  m_matrix = matrix;
  m_data_object = matrix->dataObject();
  m_channel = matrix->channel();
  connect( buttonApply, SIGNAL(clicked()), this, SLOT(apply()) );
  updateContents();
 }

//----------------------------------------------------------------------------------------//

KSMPanelString::~KSMPanelString()
 {
 }

//----------------------------------------------------------------------------------------//

void KSMPanelString::apply()
 {
  int new_rows = matrixRows->value();
  int new_cols = matrixCols->value();

  if ( isModified() ) {
        KSMatrixString *new_matrix = new KSMatrixString();
	new_matrix->resize(new_rows,new_cols);
        for( int row=0; row<new_matrix->rows(); row++ )
		for( int col=0; col<new_matrix->cols(); col++ ) {
			if ( row < m_matrix->rows() &&
			     col < m_matrix->cols()  ) {
				new_matrix->setString( row, col, m_matrix->string(row,col) );
				}
			}
	m_matrix = new_matrix;
	m_workbook->execute( new KSCmdSetData(m_data_object,m_channel,new_matrix) );	
	}
	
 }

//----------------------------------------------------------------------------------------//

QSMatrix *KSMPanelString::editedMatrix()
 {
  return m_matrix;
 }

//----------------------------------------------------------------------------------------//

bool KSMPanelString::isModified()
 {
  int new_rows = matrixRows->value();
  int new_cols = matrixCols->value();

  if ( new_rows != m_matrix->rows() ||
       new_cols != m_matrix->cols()  ) return true;

  return false;
 }

//----------------------------------------------------------------------------------------//

void KSMPanelString::updateContents()
 {
  matrixRows->setValue( m_matrix->rows() );
  matrixCols->setValue( m_matrix->cols() );
 }






//----------------------------------------------------------------------------------------//
//----------------------------------------------------------------------------------------//
//----------------------------------------------------------------------------------------//
//----------------------------------------------------------------------------------------//
//----------------------------------------------------------------------------------------//
//----------------------------------------------------------------------------------------//










KSMPanelFormula::KSMPanelFormula( KSWorkbook *workbook, KSMatrixFormula *matrix, QWidget *parent )
:KSMPanelFormulaInterf( parent )
 {
  m_workbook = workbook;
  m_matrix = matrix;
  m_data_object = matrix->dataObject();
  m_channel = matrix->channel();
  connect( buttonApply, SIGNAL(clicked()), this, SLOT(apply()) );
  updateContents();
 }

//----------------------------------------------------------------------------------------//

KSMPanelFormula::~KSMPanelFormula()
 {
 }

//----------------------------------------------------------------------------------------//

void KSMPanelFormula::apply()
 {
  KSMatrixFormula *new_matrix = new KSMatrixFormula();
  new_matrix->setFormula( matrixFormula->text() );
  new_matrix->setTransposition( m_matrix->transposition() );
  MPFactoryList factory( new KSDataSymbolFactory( m_workbook, m_matrix->dataObject() ) );
  MPFormulaError error;
  if ( !new_matrix->init( error, &factory ) ) {
	QMessageBox::critical( NULL, tr("Error"), error.message(), QMessageBox::Ok, 0 );
	QSConsole::write( tr("Error parsing formula:" )+error.message() );
	}
  m_matrix = new_matrix;
  m_workbook->execute( new KSCmdSetData(m_data_object,m_channel,new_matrix) );		
 }

//----------------------------------------------------------------------------------------//

QSMatrix *KSMPanelFormula::editedMatrix()
 {
  return m_matrix;
 }

//----------------------------------------------------------------------------------------//

bool KSMPanelFormula::isModified()
 {
  if ( m_matrix->formula() != matrixFormula->text() ) return true;
  return false;
 }

//----------------------------------------------------------------------------------------//

void KSMPanelFormula::updateContents()
 {
  matrixFormula->setText( m_matrix->formula() );
 }

