/***************************************************************************
                                 kspanels.h
                             -------------------
    begin                : Fri Jan 4 2002
    copyright            : (C) 2002 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSPANELS_H
#define KSPANELS_H

#include "kspanel.h"
#include "../widgets/qscobject.h"
#include "../widgets/qsgattr.h"
#include "../widgets/qsaxes.h"
#include "../widgets/qsaxes3d.h"
#include "../widgets/qsaxes2d.h"
#include <qcstring.h>
#include <qstring.h>

class KSFillBtn;
class KSFontBtn;
class KSLineBtn;
class KSArrowBtn;
class KSPointBtn;

//-----------------------------------------------------------------------------------------------//
//-----------------------------------------------------------------------------------------------//
//-----------------------------------------------------------------------------------------------//
//-----------------------------------------------------------------------------------------------//

#include "kspanelrangeinterf.h"

class KSPanelButtonRange : public KSPanelButton {
	Q_OBJECT
  public:
     KSPanelButtonRange( QWidget *parent, KSWorkbook *workbook, QSAxes *axes );
     virtual ~KSPanelButtonRange();
     virtual KSPanel *createPanel( QWidget *panelParent );
     virtual bool isButtonFor( QSCObject *object, int category, int element );
  private:
     QSAxes *m_axes;
  };

//------------------------------------------------------------------------------------------------------//

class QSAxes3D;

class KSPanelRange : public KSPanelRangeInterf  {
   Q_OBJECT
public:
	KSPanelRange(QWidget *parent, KSWorkbook *workbook, QSAxes *axes, const char *name=0);
	~KSPanelRange();
	virtual void readProperties();
	virtual void applyProperties();
private:
	QSAxes *m_axes;
        QSAxes3D *m_axes3;
	KSWorkbook *m_workbook;
	void shift_range( int axis_type, double shift );

private slots:
	void x_plus();
	void y_plus();
	void z_plus();
	void v_plus();

	void x_minus();
	void y_minus();
	void z_minus();
	void v_minus();

	void view_up();
	void view_down();
	void view_left();
	void view_right();

        void set_view_1();
        void set_view_2();
        void set_view_3();
        void remember_view();
};

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

#include"kspanelcarrowinterf.h"

class KSPanelButtonCArrow : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonCArrow( QWidget *parent, KSWorkbook *workbook, QSCObject *o );
     virtual ~KSPanelButtonCArrow();
     virtual KSPanel *createPanel( QWidget *panelParent );
  private:
     QSCObject *m_object;
  };

//------------------------------------------------------------------------------------------------------//

class KSPanelCArrow : public KSPanelCArrowInterf  {
   Q_OBJECT
public:
	KSPanelCArrow(QWidget *parent, KSWorkbook *workbook, QSCObject *o, const char *name=0);
	~KSPanelCArrow();

	void readProperties();
	void applyProperties();
private:
	KSWorkbook *m_workbook;
	QSCObject *o;
};

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

#include"kspanelaxisinterf.h"

class KSPanelButtonAxis : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonAxis( QWidget *parent, KSWorkbook *workbook, QSAxis *axis );
     virtual ~KSPanelButtonAxis();
     virtual KSPanel *createPanel( QWidget *panelParent );
     virtual bool isButtonFor( QSCObject *object, int category, int element );
  private:
     QSAxis *m_axis;
  };

//------------------------------------------------------------------------------------------------------//

class KSPanelAxis : public KSPanelAxisInterf  {
   Q_OBJECT
public:
	KSPanelAxis(QWidget *parent, KSWorkbook *workbook, QSAxis *axis, const char *name=0);
	~KSPanelAxis();
	void readProperties();
	void applyProperties();

private:
	KSWorkbook *m_workbook;
       QSAxis    *m_axis;

};

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

#include"kspanelclabelinterf.h"

class KSPanelButtonCLabel : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonCLabel( QWidget *parent, KSWorkbook *workbook, QSCObject *o );
     virtual ~KSPanelButtonCLabel();
     virtual KSPanel *createPanel( QWidget *panelParent );
  private:
     QSCObject *m_object;
  };

//------------------------------------------------------------------------------------------------------//

class KSPanelCLabel : public KSPanelCLabelInterf  {
   Q_OBJECT
public:
	KSPanelCLabel(QWidget *parent, KSWorkbook *workbook, QSCObject *o, const char *name=0);
	~KSPanelCLabel();
	void readProperties();
	void applyProperties();
        void setPosAlign( int align );
        int  posAlign();

private:
        KSWorkbook *m_workbook;
	QSCObject *o;	
};

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

#include"kspanelclegendcinterf.h"

class KSPanelButtonCLegend : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonCLegend( QWidget *parent, KSWorkbook *workbook, QSCObject *o );
     virtual ~KSPanelButtonCLegend();
     virtual KSPanel *createPanel( QWidget *panelParent );
  private:
     QSCObject *m_object;
     int *m_columns;
  };

//------------------------------------------------------------------------------------------------------//

class KSPanelCLegendC : public KSPanelCLegendCInterf  {
   Q_OBJECT
public:
	KSPanelCLegendC(QWidget *parent, KSWorkbook *workbook, QSCObject *o, const char *name=0 );
	~KSPanelCLegendC();
	void readProperties();
	void applyProperties();

 private:
	KSWorkbook *m_workbook;
	QSCObject *o;
};

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

#include"kspanelcontourinterf.h"
class QSContour;

//------------------------------------------------------------------------------------------------------//

class KSPanelButtonContour : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonContour( QWidget *parent, KSWorkbook *workbook, QSContour *contour );
     virtual ~KSPanelButtonContour();
     virtual KSPanel *createPanel( QWidget *panelParent );
     virtual bool isButtonFor( QSCObject *object, int category, int element );
  private:
     QSContour *m_contour;
  };

//------------------------------------------------------------------------------------------------------//


class KSPanelContour : public KSPanelContourInterf  {
   Q_OBJECT
 public:
	KSPanelContour(QWidget *parent, KSWorkbook *workbook, QSContour *contour, const char *name=0);
	~KSPanelContour();
	void readProperties();
	void applyProperties();

private:
	KSWorkbook *m_workbook;
	QSContour *contour;
	KSAxisSelect *m_x_select;
	KSAxisSelect *m_y_select;
	KSAxisSelect *m_v_select;
};

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

#include"kspanelcposinterf.h"

//------------------------------------------------------------------------------------------------------//

class KSPanelButtonCPos : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonCPos( QWidget *parent,
			KSWorkbook *workbook, QSCObject *o,
			const QCString& posX, const QCString& posY, const QCString& posZ,
			const QCString& coordX, const QCString& coordY, const QCString& coordZ );
     virtual ~KSPanelButtonCPos();
     virtual KSPanel *createPanel( QWidget *panelParent );
  private:
     QSCObject *m_object;
     QCString m_pos_x;
     QCString m_pos_y;
     QCString m_pos_z;
     QCString m_coord_x;
     QCString m_coord_y;
     QCString m_coord_z;
  };

//------------------------------------------------------------------------------------------------------//

class KSPanelCPos : public KSPanelCPosInterf {
   Q_OBJECT
public:
	KSPanelCPos(QWidget *parent, KSWorkbook *workbook, QSCObject *o,
			const QCString& posX, const QCString& posY, const QCString& posZ,
			const QCString& coordX, const QCString& coordY, const QCString& coordZ,
			const char *name=0 );
	~KSPanelCPos();
	void readProperties();
	void applyProperties();

protected:
	QSCObject *o;
	KSWorkbook *m_workbook;
	KSAxisSelect *m_x_select;
	KSAxisSelect *m_y_select;
	KSAxisSelect *m_z_select;
	QCString m_pos_x;
	QCString m_pos_y;
	QCString m_pos_z;
	QCString m_coord_x;
	QCString m_coord_y;
	QCString m_coord_z;
};

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
 //------------------------------------------------------------------------------------------------------//

#include"kspanelcrectinterf.h"

//------------------------------------------------------------------------------------------------------//

class KSPanelButtonCRect : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonCRect( QWidget *parent, KSWorkbook *workbook, QSCObject *o );
     virtual ~KSPanelButtonCRect();
     virtual KSPanel *createPanel( QWidget *panelParent );
  private:
     QSCObject *m_object;
  };

//------------------------------------------------------------------------------------------------------//


class KSPanelCRect : public KSPanelCRectInterf  {
   Q_OBJECT
public:
	KSPanelCRect(QWidget *parent, KSWorkbook *workbook, QSCObject *o, const char *name=0);
	~KSPanelCRect();
	void readProperties();
	void applyProperties();

protected:
	KSWorkbook *m_workbook;
	QSCObject *o;
};

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

#include"kspanelcubeinterf.h"

class KSPanelButtonCube : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonCube( QWidget *parent, KSWorkbook *workbook, QSAxes3D *axes );
     virtual ~KSPanelButtonCube();
     virtual KSPanel *createPanel( QWidget *panelParent );
     virtual bool isButtonFor( QSCObject *object, int category, int element );
  private:
     QSAxes3D *m_axes;
  };

//------------------------------------------------------------------------------------------------------//

class KSPanelCube : public KSPanelCubeInterf
 {
   Q_OBJECT
  public:
	KSPanelCube(QWidget *parent, KSWorkbook *workbook, QSAxes3D *plot,  const char *name=0);
	~KSPanelCube();
	void readProperties();
	void applyProperties();

  protected:
	QSAxes3D *p3;
	KSWorkbook *m_workbook;
};

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

#include"kspanelfigureinterf.h"
class QSFigure;

//------------------------------------------------------------------------------------------------------//

class KSPanelButtonFigure : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonFigure( QWidget *parent, KSWorkbook *workbook, QSFigure *figure );
     virtual ~KSPanelButtonFigure();
     virtual KSPanel *createPanel( QWidget *panelParent );
     virtual bool isButtonFor( QSCObject *object, int category, int element );
  private:
    QSFigure *m_figure;
  };

//------------------------------------------------------------------------------------------------------//


class KSPanelFigure : public KSPanelFigureInterf  {
   Q_OBJECT
 public:
	 KSPanelFigure(QWidget *parent, KSWorkbook *workbook, QSFigure *figure, const char *name=0);
	~KSPanelFigure();
	void readProperties();
	void applyProperties();

 protected:
	KSWorkbook *m_workbook;
	QSFigure *figure;
	KSAxisSelect *m_x_select;
	KSAxisSelect *m_y_select;
	KSAxisSelect *m_z_select;
	KSAxisSelect *m_v_select;
};

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

#include"kspanelframeinterf.h"

class KSPanelButtonFrame : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonFrame( QWidget *parent, KSWorkbook *workbook, QSAxes2D *axes );
     virtual ~KSPanelButtonFrame();
     virtual KSPanel *createPanel( QWidget *panelParent );
     virtual bool isButtonFor( QSCObject *object, int category, int element );
  private:
     QSAxes2D *m_axes;
  };

//------------------------------------------------------------------------------------------------------//

class KSPanelFrame : public KSPanelFrameInterf  {
    Q_OBJECT
 public:
	KSPanelFrame(QWidget *parent, KSWorkbook *workbook, QSAxes2D *plot, const char *name=0);
	~KSPanelFrame();
	void readProperties();
	void applyProperties();
	
 protected:
	KSFillBtn *pcol;
	KSFillBtn *fcol;
	QSAxes2D *p2;
	KSWorkbook *m_workbook;
 };

 //------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

#include"kspanelgeneralinterf.h"

//------------------------------------------------------------------------------------------------------//

class KSPanelButtonGeneral : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonGeneral( QWidget *parent, KSWorkbook *workbook, QSAxes *axes );
     virtual ~KSPanelButtonGeneral();
     virtual KSPanel *createPanel( QWidget *panelParent );
     virtual bool isButtonFor( QSCObject *object, int category, int element );
  private:
     QSAxes *m_axes;
  };

//------------------------------------------------------------------------------------------------------//

class KSPanelGeneral : public KSPanelGeneralInterf
 {
   Q_OBJECT
public:
	KSPanelGeneral(QWidget *parent, KSWorkbook *workbook, QSAxes *plot, const char *name=0);
	~KSPanelGeneral();
	void readProperties();
	void applyProperties();

protected:
	QSAxes    *p;
	KSFontBtn *font;
	KSFillBtn *bcol;
	KSWorkbook *m_workbook;

};

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

#include"kspanelglinterf.h"

//------------------------------------------------------------------------------------------------------//

class KSPanelButtonGL : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonGL( QWidget *parent, KSWorkbook *workbook, QSAxes3D *axes );
     virtual ~KSPanelButtonGL();
     virtual KSPanel *createPanel( QWidget *panelParent );
  private:
     QSAxes3D *m_axes;
  };

//------------------------------------------------------------------------------------------------------//

class KSPanelGL : public KSPanelGLInterf  {
   Q_OBJECT
 public:
	KSPanelGL(QWidget *parent, KSWorkbook *workbook, QSAxes3D *plot, const char *name=0);
       ~KSPanelGL();
        void readProperties();
        void applyProperties();
 protected:
	KSWorkbook *m_workbook;
        QSAxes3D *p3;
};

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

#include"kspanelimageinterf.h"
class QSImage;

//------------------------------------------------------------------------------------------------------//

class KSPanelButtonImage : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonImage( QWidget *parent, KSWorkbook *workbook, QSImage *image );
     virtual ~KSPanelButtonImage();
     virtual KSPanel *createPanel( QWidget *panelParent );
     virtual bool isButtonFor( QSCObject *object, int category, int element );
  private:
     QSImage *m_image;
  };

//------------------------------------------------------------------------------------------------------//

class KSPanelImage : public KSPanelImageInterf
 {
   Q_OBJECT
 public:
	 KSPanelImage(QWidget *parent, KSWorkbook *workbook, QSImage *image, const char *name=0);
	~KSPanelImage();
	void readProperties();
	void applyProperties();

 protected:
	QSImage *image;
	KSAxisSelect *m_x_select;
	KSAxisSelect *m_y_select;
	KSAxisSelect *m_v_select;
	KSWorkbook *m_workbook;
};

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

#include"kspanellightinterf.h"

//------------------------------------------------------------------------------------------------------//

class KSPanelButtonLight : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonLight( QWidget *parent, KSWorkbook *workbook, QSAxes3D *axes );
     virtual ~KSPanelButtonLight();
     virtual KSPanel *createPanel( QWidget *panelParent );
  private:
     QSAxes3D *m_axes;
  };

//------------------------------------------------------------------------------------------------------//

class KSPanelLight : public KSPanelLightInterf
{
   Q_OBJECT
 public:
	KSPanelLight(QWidget *parent, KSWorkbook *workbook, QSAxes3D *plot,  const char *name=0);
	~KSPanelLight();
        void readProperties();
	void applyProperties();

 protected:
	QSAxes3D *p3;
	KSWorkbook *m_workbook;
};

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

#include"kspanelmeshinterf.h"
class QSPlot3D;

//------------------------------------------------------------------------------------------------------//

class KSPanelButtonMesh : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonMesh( QWidget *parent, KSWorkbook *workbook, QSPlot3D *plot );
     virtual ~KSPanelButtonMesh();
     virtual KSPanel *createPanel( QWidget *panelParent );
  private:
     QSPlot3D *m_plot;
  };

//------------------------------------------------------------------------------------------------------//

class KSPanelMesh : public KSPanelMeshInterf  {
   Q_OBJECT
public:
	KSPanelMesh(QWidget *parent, KSWorkbook *workbook, QSPlot3D *plot, const char *name=0);
	~KSPanelMesh();
	void readProperties();
	void applyProperties();
        bool eventFilter( QObject *o, QEvent *e );

protected:
        QSPlot3D  *p3;
	KSWorkbook *m_workbook;

 protected slots:

        void preview();
        void gradient_type_changed(int);
};

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

#include"kspanelcurveinterf.h"
class QSCurve;

//------------------------------------------------------------------------------------------------------//

class KSPanelButtonCurve : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonCurve( QWidget *parent, KSWorkbook *workbook, QSCurve *curve );
     virtual ~KSPanelButtonCurve();
     virtual KSPanel *createPanel( QWidget *panelParent );
     virtual bool isButtonFor( QSCObject *object, int category, int element );
  private:
     QSCurve *m_curve;
  };

//------------------------------------------------------------------------------------------------------//

class KSPanelCurve : public KSPanelCurveInterf  {
   Q_OBJECT
 public:

	 KSPanelCurve(QWidget *parent, KSWorkbook *workbook, QSCurve *plot, const char *name=0);
	~KSPanelCurve();

	void selectSeries( int num );
        void readProperties();
	void applyProperties();

 protected:
        QSCurve    *curve;

	KSAxisSelect *m_x_select;
	KSAxisSelect *m_y_select;
  	KSWorkbook *m_workbook;
   };

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

#include"kspanelsurfaceinterf.h"
class QSSurface;

//------------------------------------------------------------------------------------------------------//

class KSPanelButtonSurface : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonSurface( QWidget *parent, KSWorkbook *workbook, QSSurface *m_surface );
     virtual ~KSPanelButtonSurface();
     virtual KSPanel *createPanel( QWidget *panelParent );
     virtual bool isButtonFor( QSCObject *object, int category, int element );
  private:
     QSSurface *m_surface;
  };

//------------------------------------------------------------------------------------------------------//

class KSPanelSurface : public KSPanelSurfaceInterf  {
   Q_OBJECT
public:
	KSPanelSurface(QWidget *parent, KSWorkbook *workbook, QSSurface *surface, const char *name=0);
	~KSPanelSurface();
	void readProperties();
	void applyProperties();
		
protected:
	KSWorkbook *m_workbook;
	QSSurface *surface;
	KSAxisSelect *m_x_select;
	KSAxisSelect *m_y_select;
	KSAxisSelect *m_z_select;
	KSAxisSelect *m_v_select;
};

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

#include"kspanelgridinterf.h"

//------------------------------------------------------------------------------------------------------//

class KSPanelButtonGrid : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonGrid( QWidget *parent, KSWorkbook *workbook, QSAxis *axis );
     virtual ~KSPanelButtonGrid();
     virtual KSPanel *createPanel( QWidget *panelParent );
     virtual bool isButtonFor( QSCObject *object, int category, int element );
  private:
     QSAxis *m_axis;
  };

//------------------------------------------------------------------------------------------------------//

class KSPanelGrid : public KSPanelGridInterf  {
   Q_OBJECT
public:
 	KSPanelGrid(QWidget *parent, KSWorkbook *workbook, QSAxis *axis, const char *name=0);
	~KSPanelGrid();
        void readProperties();
	void applyProperties();
	bool eventFilter( QObject *o, QEvent *e );

private:
        enum FormatCode {
                Value,
                Factor,
                Base,
                Exponent
               };
        QSAxis      *m_axis;
        QPopupMenu  *codes;
	KSWorkbook *m_workbook;
};

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

#include"kspanelviewinterf.h"

//------------------------------------------------------------------------------------------------------//

class KSPanelButtonView : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonView( QWidget *parent, KSWorkbook *workbook, QSAxes3D *axes );
     virtual ~KSPanelButtonView();
     virtual KSPanel *createPanel( QWidget *panelParent );
  private:
     QSAxes3D *m_axes;
  };

//------------------------------------------------------------------------------------------------------//

class KSPanelView : public KSPanelViewInterf
 {
   Q_OBJECT
 public:
	KSPanelView(QWidget *parent, KSWorkbook *workbook, QSAxes3D *plot, const char *name=0);
	~KSPanelView();
        void readProperties();
	void applyProperties();

 protected:
	QSAxes3D *p3;
	KSWorkbook *m_workbook;
};

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

#include"kspanelgradientinterf.h"

class QSPlot;

class KSPanelButtonGradient : public KSPanelButton {
 Q_OBJECT
  public:
     KSPanelButtonGradient( QWidget *parent, KSWorkbook *workbook, QSPlot *plot );
     virtual ~KSPanelButtonGradient();
     virtual KSPanel *createPanel( QWidget *panelParent );
  private:
     QSPlot *m_plot;
  };

//------------------------------------------------------------------------------------------------------//

class KSPanelGradient : public KSPanelGradientInterf  {
   Q_OBJECT
public:
	 KSPanelGradient(QWidget *parent, KSWorkbook *workbook, QSPlot *plot, const char *name=0);
	 ~KSPanelGradient();
	void readProperties();
	void applyProperties();
        bool eventFilter( QObject *o, QEvent *e );

protected:
	QSPlot   *m_plot;
	KSWorkbook *m_workbook;

 protected slots:

        void preview();
	void gradient_type_changed(int);
};

#endif
