/***************************************************************************
                          	mpsymbols.h
                             -------------------
    begin                : Sun Nov 25 2001
    copyright            : (C) 2001 by Kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MPSYMBOLS_H
#define MPSYMBOLS_H

#include"mpsymbol.h"
#include<qasciidict.h>

//--------------------------------------------------------------------------//

/**
  * Factory which provides common symbols and constants from the standard C math library.
  */
class MPCommonSymFactory : public MPSymbolFactory {
  public:
	MPCommonSymFactory();
	virtual ~MPCommonSymFactory();
	virtual MPSymbol *create( const char *identifier, MPSymbolList *args, int colFrom, int colTo );
	virtual	int symbolCount() const;
	virtual const char *symbolIdentifier( int symbolNumber );
	virtual const char *symbolDescription( int symbolNumber );
	virtual const char *name() const;
  protected:
	enum ItemType { CONST, FUNC1, FUNC2, DELUNAY };
	struct item {
		int m_type;
		int m_function;
		const char *m_description;
		item( int type, int function, const char *description ) {
			m_type = type;
			m_function = function;
			m_description = description;
			}
		};
	 bool m_initialized;
	 QAsciiDict<item> m_list;
		
  };

//--------------------------------------------------------------------------//

class MPSymColon : public MPSymbol {
   public:
	MPSymColon( int columnFrom, int columnTo, const char *id );
	virtual ~MPSymColon() {}
	virtual void checkArgs( MPError& ) {}
	virtual double value( int row, int col );
  };

//--------------------------------------------------------------------------//

class MPSymColonExpr : public MPSymbol {
   public:
	MPSymColonExpr( MPSymbolList *args, int columnFrom, int columnTo, const char *id );
	virtual ~MPSymColonExpr();
	virtual void checkArgs( MPError& error );
	virtual double value( int row, int col );
   private:
	double m_start;
	double m_step;
	double m_stop;
	
  };

//--------------------------------------------------------------------------//

class MPSymValue : public MPSymbol {
   public:
	MPSymValue( double value, int columnFrom, int columnTo, const char *id );
	virtual ~MPSymValue();
	virtual void checkArgs( MPError& error );
	virtual double value( int row, int col );
   protected:
	double m_value;
  };

//--------------------------------------------------------------------------//

class MPSymConstant : public MPSymbol {
   public:
	static const double pi;
	static const double e;
	enum Constant { E, PI };
	MPSymConstant( Constant c, int columnFrom, int columnTo, const char *id );
	MPSymConstant( Constant c, MPSymbolList *args, int columnFrom, int columnTo, const char *id );
	virtual ~MPSymConstant();
	virtual void checkArgs( MPError& error );
	virtual double value( int row, int col );
	virtual bool isVariable() const { return true; }
   protected:
	Constant m_c;
  };

//--------------------------------------------------------------------------//

class MPSymFunction1 : public MPSymbol  {
  public:
	enum Function { FLOOR, CEIL, SIGN, ABS, COS, COSH, SIN, SINH, TAN, TANH, ACOS, ACOSH, ASIN, ASINH, ATAN, ATANH, LN, LOG2, LOG10, SQRT, NEG };
	MPSymFunction1( Function f, MPSymbolList *args, int columnFrom, int columnTo, const char *id );
	virtual ~MPSymFunction1();
	virtual void checkArgs( MPError& error );
	virtual double value( int row, int col );
  protected:
	Function m_f;
  };

//--------------------------------------------------------------------------//

class MPSymFunction2 : public MPSymbol  {
  public:
	enum Function { ADD, SUB, MUL, DIV, MOD, MIN, MAX, LOG, POW, ATAN2 };
	MPSymFunction2( Function f, MPSymbolList *args, int columnFrom, int columnTo, const char *id );
	virtual ~MPSymFunction2();
	virtual void checkArgs( MPError& error );
	virtual double value( int row, int col );
  protected:
	Function m_f;
  };

//--------------------------------------------------------------------------//

class MPSymMatrixIndexer : public MPSymbol {
  public:
	MPSymMatrixIndexer( MPSymbol *sym, MPSymbolList *args, int columnFrom, int columnTo, const char *id );
	virtual ~MPSymMatrixIndexer();
	virtual void checkArgs( MPError& error );
	virtual double value( int row, int col );
  protected:
	MPSymbol *m_symbol;
	int index_size( MPSymbol *index );
	int index_value( MPSymbol *index, int pos );	
  };

//--------------------------------------------------------------------------//

class MPSymVectorIndexer : public MPSymbol {
  public:
	MPSymVectorIndexer( MPSymbol *sym, MPSymbolList *args, int columnFrom, int columnTo, const char *id );
	virtual ~MPSymVectorIndexer();
	virtual void checkArgs( MPError& error );
	virtual double value( int row, int col );
  protected:
	MPSymbol *m_symbol;
	int index_size();
	int index_value( int pos );	
  };

//--------------------------------------------------------------------------//

class MPSymTranspose : public MPSymbol {
  public:
	MPSymTranspose( MPSymbolList *args, int columnFrom, int columnTo, const char *id );
	virtual ~MPSymTranspose();
	virtual void checkArgs( MPError& error );
	virtual double value( int row, int col );
  };

//--------------------------------------------------------------------------//

class MPSymVector : public MPSymbol {
  public:
	MPSymVector( MPSymbolList *args, int columnFrom, int columnTo, const char *id );
	virtual ~MPSymVector();
	virtual void checkArgs( MPError& error );
	virtual double value( int row, int col );
  private:
	double *m_vector;
  };

//--------------------------------------------------------------------------//

class MPSymMatrix : public MPSymbol {
  public:
	MPSymMatrix( MPSymbolList *args, int columnFrom, int columnTo, const char *id );
	virtual ~MPSymMatrix();
	virtual void checkArgs( MPError& error );
	virtual double value( int row, int col );
  };

//--------------------------------------------------------------------------//

#endif
