/***************************************************************************
                                  common.h
                             -------------------
    begin                : Sun Jun 18 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __COMMON_H
#define __COMMON_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "etype.h"
#include "msg.h"

#ifdef __cplusplus
extern "C" {
#endif

/*--------------------------------------------------------------------------------*/

typedef enum { OpError = -1 } ReturnCode;

/*--------------------------------------------------------------------------------*/

/**
  * Connects to the plot application. Returns a file descriptor of a communication socket or
  * -1 if an error occured. New application is executed if currently there is no one with
  * a requested number running.
  * app_number = 0 -> create a new app and return its number in 'return_app_number'
  * app_number = NULL
  * socket_fd  = NULL
  */
int plot_connect( int app_number, int *return_app_number, int *return_socket_fd );

/*--------------------------------------------------------------------------------*/

/**
  * Adds new axes and returns axes ID or <0 if error occured.
  * type == 0 for 2d axes or != 0 for 3d axes
  */
int plot_add_axes( int socket_fd, int axes_type );

/*--------------------------------------------------------------------------------*/

/**
  */
int plot_remove_axes( int socket_fd, int axes_id );

/*--------------------------------------------------------------------------------*/

/**
  * Adds a new dataset to the given axes.
  * Returns a dataset number or <0 if ended with an error.
  */
int plot_add_dataset( int socket_fd, int axes_id, PlotType type );

/*--------------------------------------------------------------------------------*/

/**
  */
int plot_remove_dataset( int socket_fd, int axes_id, int number );

/*--------------------------------------------------------------------------------*/

/**
  *
  */
int plot_remove_all_datasets( int socket_fd, int axes_id );

/*--------------------------------------------------------------------------------*/

/**
  * data - pointer to data memory ordered so:
  *  value(row,col) = *((etype *)((char *)data+lineo*rows+pixelo*cols))
  *
  * dlen - length of data in bytes. Default value is rows*cols*sizeof(etype).
  * pixelo - pixel offset in bytes. Default value is sizeof(etype).
  * lineo - line offset in bytes. Default value is cols*pixelo
  */
int plot_set_channel( int socket_fd,
			int axes_id, int dataset, int channel,
			EType etype,
			int rows, int cols,
			const void *data, int dlen,
			int pixelo, int lineo );

/*--------------------------------------------------------------------------------*/

/**
  * Not implemented
  */
int plot_set_property( int socket_fd, int axes_id, const char *property, const char *value  );

/*--------------------------------------------------------------------------------*/

/**
  * Close socket.
  */
void plot_disconnect( int socket_fd );

#ifdef __cplusplus
 }
#endif

#endif
