/***************************************************************************
                                  msg.h
                             -------------------
    begin                : Wed Jun 21 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __MSG_H
#define __MSG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include"etype.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum { 	MsgChannel,
		MsgProperty,
		MsgAddAxes,
		MsgRemoveAxes,
		MsgAddDataset,
		MsgRemoveDataset,
		MsgRemoveAllDatasets
	     } MsgType;


typedef struct {
		 MsgType type;   // message type
		 int dlen;       // data length ( excluding header )
		 int plot;       // axes number ( 1 - inf )
		} generic_hdr_t;

//--------------------------------------------------------------------------------//

typedef struct {
    MsgType type; // must be MsgAddAxes, MsgRemoveAxes
    int dlen;     // always 0
    int plot;	  // axes number
    int axes;   // add 3d axes if != 0
 } axes_hdr_t;

//--------------------------------------------------------------------------------//

typedef struct {
    MsgType type; // must be MsgAddDataset, MsgRemoveDataset, MsgRemoveAllDatasets
    int dlen;     // always 0
    int plot;
    int dnum;   // dataset number - valid only for MsgRemoveDataset
    PlotType ptype;
 } ptype_hdr_t;

//--------------------------------------------------------------------------------//

typedef struct {
    MsgType type;// must be MsgChannel
    int dlen;
    int plot;
    int dnum;
    int chan;	
    int rows;
    int cols;
    int etype;	 // type of element
    int lineo;   // line offset
    int pixelo;  // pixel offset
 } channel_hdr_t;

//--------------------------------------------------------------------------------//

typedef struct {
    MsgType type; // must be MsgProperty
    int dlen;
    int plot;
    int plen;
    int vlen;
 } property_hdr_t;

//--------------------------------------------------------------------------------//

typedef union {
    generic_hdr_t  h;
    axes_hdr_t     a;
    ptype_hdr_t    t;
    channel_hdr_t  c;
    property_hdr_t p;
  } hdr_t;

#ifdef __cplusplus
 }
#endif

#endif

